/* zeitgeist-engine.vapi generated by valac 0.16.0, do not modify. */

namespace Zeitgeist {
	namespace Events {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.GenericArray<Zeitgeist.Event> from_variant (GLib.Variant vevents) throws Zeitgeist.EngineError;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.Variant to_variant (GLib.GenericArray<Zeitgeist.Event?> events);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.Variant to_variant_with_limit (GLib.GenericArray<Zeitgeist.Event?> events, size_t limit = Utils.MAX_DBUS_RESULT_SIZE) throws Zeitgeist.EngineError;
	}
	namespace Logging {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static void setup_logging (string? log_level, string? log_file = null);
	}
	namespace NCAL {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ALARM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ATTACHMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CALENDAR;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CALENDAR_DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string FREEBUSY;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string JOURNAL;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string TIMEZONE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string TODO;
	}
	namespace NCO {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CONTACT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CONTACT_GROUP;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CONTACT_LIST;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CONTACT_LIST_DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ORGANIZATION_CONTACT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string PERSON_CONTACT;
	}
	namespace NFO {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string APPLICATION;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ARCHIVE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ARCHIVE_ITEM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ATTACHMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string AUDIO;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string BOOKMARK;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string BOOKMARK_FOLDER;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CURSOR;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DATA_CONTAINER;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DELETED_RESOURCE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DOCUMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EMBEDDED_FILE_DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EXECUTABLE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string FILESYSTEM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string FILESYSTEM_IMAGE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string FILE_DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string FOLDER;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string FONT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string HARD_DISK_PARTITION;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string HTML_DOCUMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ICON;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string IMAGE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MEDIA;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MEDIA_LIST;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MEDIA_STREAM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MIND_MAP;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string OPERATING_SYSTEM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string PAGINATED_TEXT_DOCUMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string PLAIN_TEXT_DOCUMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string PRESENTATION;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string RASTER_IMAGE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string REMOTE_DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string REMOTE_PORT_ADDRESS;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SOFTWARE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SOFTWARE_ITEM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SOFTWARE_SERVICE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SOURCE_CODE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SPREADSHEET;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string TEXT_DOCUMENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string TRASH;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string VECTOR_IMAGE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string VIDEO;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string VISUAL;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string WEBSITE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string WEB_DATA_OBJECT;
	}
	namespace NIE {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string INFORMATION_ELEMENT;
	}
	namespace NMM {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MOVIE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MUSIC_ALBUM;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MUSIC_PIECE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string TVSERIES;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string TVSHOW;
	}
	namespace NMO {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EMAIL;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string IMMESSAGE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MAILBOX;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MAILBOX_DATA_OBJECT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MESSAGE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MIME_ENTITY;
	}
	namespace SQLite {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public class Database : GLib.Object {
			public Sqlite.Database database;
			public Sqlite.Statement event_insertion_stmt;
			public Sqlite.Statement id_retrieval_stmt;
			public Sqlite.Statement move_handling_stmt;
			public Sqlite.Statement payload_insertion_stmt;
			public Database () throws Zeitgeist.EngineError;
			public void abort_transaction () throws Zeitgeist.EngineError;
			public void assert_not_corrupt (int rc) throws Zeitgeist.EngineError;
			[Diagnostics]
			public void assert_query_success (int rc, string msg, int success_code = Sqlite.OK) throws Zeitgeist.EngineError;
			public void begin_transaction () throws Zeitgeist.EngineError;
			public void close ();
			public void end_transaction () throws Zeitgeist.EngineError;
			public uint32 get_last_id () throws Zeitgeist.EngineError;
			public string get_sql_string_from_event_ids (uint32[] event_ids);
			public Zeitgeist.TimeRange? get_time_range_for_event_ids (uint32[] event_ids) throws Zeitgeist.EngineError;
			public void insert_or_ignore_into_table (string table_name, GLib.GenericArray<string> values) throws Zeitgeist.EngineError;
			public Database.read_only () throws Zeitgeist.EngineError;
			public void set_deletion_callback (owned Zeitgeist.SQLite.DeletionCallback? callback);
			protected void update_callback (Sqlite.Action action, string dbname, string table, int64 rowid);
		}
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public class DatabaseSchema : GLib.Object {
			public const string CORE_SCHEMA;
			public const int CORE_SCHEMA_VERSION;
			public DatabaseSchema ();
			public static void create_basic_indices (Sqlite.Database database) throws Zeitgeist.EngineError;
			public static void create_event_indices (Sqlite.Database database) throws Zeitgeist.EngineError;
			public static void create_schema (Sqlite.Database database) throws Zeitgeist.EngineError;
			public static void drop_event_indices (Sqlite.Database database) throws Zeitgeist.EngineError;
			public static void ensure_schema (Sqlite.Database database) throws Zeitgeist.EngineError;
			public static int64 get_creation_date (Sqlite.Database database);
			public static int get_schema_version (Sqlite.Database database) throws Zeitgeist.EngineError;
			public static void set_corruption_flag (Sqlite.Database database) throws Zeitgeist.EngineError;
		}
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public class TableLookup : GLib.Object {
			public TableLookup (Zeitgeist.SQLite.Database database, string table_name) throws Zeitgeist.EngineError;
			public unowned string get_value (int id) throws Zeitgeist.EngineError;
			public int id_for_string (string name) throws Zeitgeist.EngineError;
			public int id_try_string (string name);
			public void remove (int id);
		}
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public enum EventViewRows {
			ID,
			TIMESTAMP,
			INTERPRETATION,
			MANIFESTATION,
			ACTOR,
			PAYLOAD,
			SUBJECT_URI,
			SUBJECT_ID,
			SUBJECT_INTERPRETATION,
			SUBJECT_MANIFESTATION,
			SUBJECT_ORIGIN,
			SUBJECT_ORIGIN_URI,
			SUBJECT_MIMETYPE,
			SUBJECT_TEXT,
			SUBJECT_STORAGE,
			SUBJECT_STORAGE_STATE,
			ORIGIN,
			EVENT_ORIGIN_URI,
			SUBJECT_CURRENT_URI,
			SUBJECT_ID_CURRENT
		}
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public delegate void DeletionCallback (string table, int64 rowid);
	}
	namespace Symbol {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.List<weak string> get_all_children (string symbol_uri);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.List<weak string> get_all_parents (string symbol_uri);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.List<weak string> get_children (string symbol_uri);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static unowned string get_description (string symbol_uri);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static unowned string get_display_name (string symbol_uri);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static GLib.List<weak string> get_parents (string symbol_uri);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static bool is_a (string symbol_uri, string parent_uri);
	}
	namespace Timestamp {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static int64 from_timeval (GLib.TimeVal tv);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static int64 now ();
	}
	namespace Utils {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const uint CACHE_SIZE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DATABASE_BASENAME;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DATA_FOLDER;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DBUS_INTERFACE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const size_t MAX_DBUS_RESULT_SIZE;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SIG_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string USER_EXTENSION_PATH;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static void backup_database () throws GLib.Error;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static unowned string get_data_path ();
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static unowned string get_database_file_backup_path ();
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static unowned string get_database_file_path ();
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static string get_database_file_retire_name ();
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static string get_default_data_path ();
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static unowned string get_local_extensions_path ();
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static bool is_empty_string (string? s);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static bool parse_negation (ref string val);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static bool parse_noexpand (ref string val);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static bool parse_wildcard (ref string val);
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static void retire_database () throws Zeitgeist.EngineError;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public static bool using_in_memory_database ();
	}
	namespace ZG {
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ACCEPT_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string ACCESS_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string CREATE_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DELETE_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string DENY_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EVENT_INTERPRETATION;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EVENT_MANIFESTATION;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string EXPIRE_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string HEURISTIC_ACTIVITY;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string LEAVE_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MODIFY_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string MOVE_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string RECEIVE_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SCHEDULED_ACTIVITY;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SEND_EVENT;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string SYSTEM_NOTIFICATION;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string USER_ACTIVITY;
		[CCode (cheader_filename = "zeitgeist-engine.h")]
		public const string WORLD_ACTIVITY;
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class BuiltinExtension : Zeitgeist.ExtensionLoader {
		public BuiltinExtension (Zeitgeist.RegisterExtensionFunc func);
		protected override bool load ();
		protected override void unload ();
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class Daemon : GLib.Object, Zeitgeist.RemoteLog {
		public Daemon () throws Zeitgeist.EngineError;
		public void register_dbus_object (GLib.DBusConnection conn) throws GLib.IOError;
		public void unregister_dbus_object ();
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class DbReader : GLib.Object {
		protected Zeitgeist.SQLite.TableLookup actors_table;
		protected weak Sqlite.Database db;
		protected Zeitgeist.SQLite.TableLookup interpretations_table;
		protected Zeitgeist.SQLite.TableLookup manifestations_table;
		protected Zeitgeist.SQLite.TableLookup mimetypes_table;
		public DbReader () throws Zeitgeist.EngineError;
		protected void assert_no_negation (string field, string val) throws Zeitgeist.EngineError;
		protected void assert_no_noexpand (string field, string val) throws Zeitgeist.EngineError;
		protected void assert_no_wildcard (string field, string val) throws Zeitgeist.EngineError;
		public virtual void close ();
		public uint32[] find_event_ids (Zeitgeist.TimeRange time_range, GLib.GenericArray<Zeitgeist.Event> event_templates, uint storage_state, uint max_events, uint result_type, GLib.BusName? sender = null) throws Zeitgeist.EngineError;
		public uint32[] find_event_ids_for_clause (Zeitgeist.WhereClause where, uint max_events, uint result_type) throws Zeitgeist.EngineError;
		public GLib.GenericArray<Zeitgeist.Event?> find_events (Zeitgeist.TimeRange time_range, GLib.GenericArray<Zeitgeist.Event> event_templates, uint storage_state, uint max_events, uint result_type, GLib.BusName? sender = null) throws Zeitgeist.EngineError;
		public string[] find_related_uris (Zeitgeist.TimeRange time_range, GLib.GenericArray<Zeitgeist.Event> event_templates, GLib.GenericArray<Zeitgeist.Event> result_event_templates, uint storage_state, uint max_results, uint result_type, GLib.BusName? sender = null) throws Zeitgeist.EngineError;
		protected Zeitgeist.Event get_event_from_row (Sqlite.Statement stmt, uint32 event_id) throws Zeitgeist.EngineError;
		public GLib.GenericArray<Zeitgeist.Event?> get_events (uint32[] event_ids, GLib.BusName? sender = null) throws Zeitgeist.EngineError;
		protected Zeitgeist.Subject get_subject_from_row (Sqlite.Statement stmt) throws Zeitgeist.EngineError;
		public Zeitgeist.WhereClause get_where_clause_for_query (Zeitgeist.TimeRange time_range, GLib.GenericArray<Zeitgeist.Event> event_templates, uint storage_state) throws Zeitgeist.EngineError;
		protected Zeitgeist.WhereClause get_where_clause_for_symbol (string table_name, string symbol, Zeitgeist.SQLite.TableLookup lookup_table) throws Zeitgeist.EngineError;
		public Zeitgeist.WhereClause get_where_clause_from_event_templates (GLib.GenericArray<Zeitgeist.Event> templates) throws Zeitgeist.EngineError;
		public Zeitgeist.SQLite.Database database { get; construct; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class Engine : Zeitgeist.DbReader {
		public Zeitgeist.ExtensionStore extension_store;
		public Engine () throws Zeitgeist.EngineError;
		public override void close ();
		public Zeitgeist.TimeRange? delete_events (uint32[] event_ids, GLib.BusName? sender) throws Zeitgeist.EngineError;
		public string[] get_extension_names ();
		public uint32[] insert_events (GLib.GenericArray<Zeitgeist.Event> events, GLib.BusName? sender = null) throws Zeitgeist.EngineError;
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class Event : GLib.Object {
		public Event ();
		public void add_subject (Zeitgeist.Subject subject);
		public void debug_print ();
		public Event.from_variant (GLib.Variant event_variant) throws Zeitgeist.EngineError;
		public Event.full (string? interpretation = null, string? manifestation = null, string? actor = null, string? origin = null, ...);
		public bool matches_template (Zeitgeist.Event template_event);
		public int num_subjects ();
		public void take_subject (owned Zeitgeist.Subject subject);
		public GLib.Variant to_variant ();
		public string? actor { get; set; }
		public uint32 id { get; set; }
		public string? interpretation { get; set; }
		public string? manifestation { get; set; }
		public string? origin { get; set; }
		public GLib.ByteArray? payload { get; set; }
		public GLib.GenericArray<Zeitgeist.Subject> subjects { get; set; }
		public int64 timestamp { get; set; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public abstract class Extension : GLib.Object {
		public Extension ();
		public virtual void post_delete_events (uint32[] ids, GLib.BusName? sender);
		public virtual void post_insert_events (GLib.GenericArray<Zeitgeist.Event?> events, GLib.BusName? sender);
		public virtual uint32[]? pre_delete_events (uint32[] ids, GLib.BusName? sender);
		public virtual void pre_insert_events (GLib.GenericArray<Zeitgeist.Event?> events, GLib.BusName? sender);
		protected GLib.Variant? retrieve_config (string key, string format);
		protected void store_config (string key, GLib.Variant data);
		public virtual void unload ();
		public Zeitgeist.Engine engine { get; set construct; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class ExtensionCollection : GLib.Object {
		public ExtensionCollection (Zeitgeist.Engine engine);
		public void call_post_delete_events (uint32[] event_ids, GLib.BusName? sender);
		public void call_post_insert_events (GLib.GenericArray<Zeitgeist.Event?> events, GLib.BusName? sender);
		public unowned uint32[] call_pre_delete_events (uint32[] event_ids, GLib.BusName? sender);
		public void call_pre_insert_events (GLib.GenericArray<Zeitgeist.Event?> events, GLib.BusName? sender);
		public string[] get_extension_names ();
		public Zeitgeist.Engine engine { get; construct; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public abstract class ExtensionLoader : GLib.TypeModule {
		public ExtensionLoader ();
		public virtual Zeitgeist.Extension? create_instance (Zeitgeist.Engine engine);
		public GLib.Type extension_type { get; protected set; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class ExtensionStore : GLib.Object {
		public ExtensionStore (Zeitgeist.Engine engine);
		public GLib.Variant? retrieve (string extension, string key, GLib.VariantType format);
		public void store (string extension, string key, GLib.Variant data);
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class ModuleLoader : Zeitgeist.ExtensionLoader {
		public ModuleLoader (string module_path);
		protected override bool load ();
		protected override void unload ();
		public string module_path { get; construct; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class MonitorManager : GLib.Object {
		public static Zeitgeist.MonitorManager get_default ();
		public void install_monitor (GLib.BusName peer, string object_path, Zeitgeist.TimeRange time_range, GLib.GenericArray<Zeitgeist.Event> templates);
		public void notify_delete (Zeitgeist.TimeRange time_range, uint32[] event_ids);
		public void notify_insert (Zeitgeist.TimeRange time_range, GLib.GenericArray<Zeitgeist.Event> events);
		public void remove_monitor (GLib.BusName peer, string object_path);
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class Subject : GLib.Object {
		public Subject ();
		public Subject.from_variant (GLib.Variant subject_variant) throws Zeitgeist.EngineError;
		public Subject.full (string? uri = null, string? interpretation = null, string? manifestation = null, string? mimetype = null, string? origin = null, string? text = null, string? storage = null, string? current_uri = null);
		public bool matches_template (Zeitgeist.Subject template_subject);
		public GLib.Variant to_variant ();
		public string? current_uri { get; set; }
		public string? interpretation { get; set; }
		public string? manifestation { get; set; }
		public string? mimetype { get; set; }
		public string? origin { get; set; }
		public string? storage { get; set; }
		public string? text { get; set; }
		public string? uri { get; set; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h", type_signature = "(xx)")]
	public class TimeRange : GLib.Object {
		public TimeRange (int64 start_msec, int64 end_msec);
		public TimeRange.anytime ();
		public TimeRange.from_now ();
		public TimeRange.from_variant (GLib.Variant variant) throws Zeitgeist.EngineError;
		public Zeitgeist.TimeRange? intersect (Zeitgeist.TimeRange time_range);
		public TimeRange.to_now ();
		public GLib.Variant to_variant ();
		public int64 end { get; private set; }
		public int64 start { get; private set; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public class WhereClause : GLib.Object {
		public enum Type {
			AND,
			OR
		}
		public WhereClause (Zeitgeist.WhereClause.Type type, bool negate = false);
		public void add (string condition, string? argument = null);
		public void add_match_condition (string column, int val, bool negation = false);
		public void add_text_condition (string column, string val, bool negation = false);
		public void add_text_condition_subquery (string column, string val, bool negation = false);
		public void add_wildcard_condition (string column, string needle, bool negation = false);
		public void add_with_array (string condition, GLib.GenericArray<string> args);
		public void extend (Zeitgeist.WhereClause clause);
		public unowned GLib.GenericArray<string> get_bind_arguments ();
		public bool get_is_simple ();
		protected static string get_right_boundary (string text);
		public string get_sql_conditions ();
		public bool is_empty ();
		public bool may_have_results ();
		public void set_is_simple (bool simple);
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "net.connman.Manager")]
	public interface ConnmanManagerDBus : GLib.Object {
		public abstract string get_state () throws GLib.IOError;
		public signal void state_changed (string state);
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "org.freedesktop.NetworkManager")]
	public interface NetworkManagerDBus : GLib.Object {
		[DBus (name = "state")]
		public abstract uint32 state () throws GLib.IOError;
		public signal void state_changed (uint32 state);
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "org.freedesktop.DBus")]
	public interface RemoteDBus : GLib.Object {
		public abstract bool name_has_owner (string name) throws GLib.IOError;
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "org.gnome.zeitgeist.Log")]
	public interface RemoteLog : GLib.Object {
		[DBus (signature = "(xx)")]
		public abstract GLib.Variant delete_events (uint32[] event_ids, GLib.BusName sender) throws GLib.Error;
		public abstract uint32[] find_event_ids ([DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant event_templates, uint storage_state, uint num_events, uint result_type, GLib.BusName sender) throws GLib.Error;
		[DBus (signature = "a(asaasay)")]
		public abstract GLib.Variant find_events ([DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant event_templates, uint storage_state, uint num_events, uint result_type, GLib.BusName sender) throws GLib.Error;
		public abstract string[] find_related_uris ([DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant event_templates, [DBus (signature = "a(asaasay)")] GLib.Variant result_event_templates, uint storage_state, uint num_events, uint result_type, GLib.BusName sender) throws GLib.Error;
		[DBus (signature = "a(asaasay)")]
		public abstract GLib.Variant get_events (uint32[] event_ids, GLib.BusName sender) throws GLib.Error;
		public abstract uint32[] insert_events ([DBus (signature = "a(asaasay)")] GLib.Variant events, GLib.BusName sender) throws GLib.Error;
		public abstract void install_monitor (GLib.ObjectPath monitor_path, [DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant event_templates, GLib.BusName owner) throws GLib.Error;
		public abstract void quit () throws GLib.Error;
		public abstract void remove_monitor (GLib.ObjectPath monitor_path, GLib.BusName owner) throws GLib.Error;
		[DBus (name = "extensions")]
		public abstract string[] extensions { owned get; }
		[DBus (name = "version")]
		public abstract Zeitgeist.VersionStruct version { get; }
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "org.gnome.zeitgeist.Monitor")]
	public interface RemoteMonitor : GLib.Object {
		public abstract async void notify_delete ([DBus (signature = "(xx)")] GLib.Variant time_range, uint32[] event_ids) throws GLib.IOError;
		public abstract async void notify_insert ([DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant events) throws GLib.IOError, Zeitgeist.EngineError;
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "org.gnome.zeitgeist.Index")]
	public interface RemoteSimpleIndexer : GLib.Object {
		public abstract async void search (string query_string, [DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant filter_templates, uint offset, uint count, uint result_type, [DBus (signature = "a(asaasay)")] out GLib.Variant events, out uint matches) throws GLib.Error;
		public abstract async void search_with_relevancies (string query_string, [DBus (signature = "(xx)")] GLib.Variant time_range, [DBus (signature = "a(asaasay)")] GLib.Variant filter_templates, uint storage_state, uint offset, uint count, uint result_type, [DBus (signature = "a(asaasay)")] out GLib.Variant events, out double[] relevancies, out uint matches) throws GLib.Error;
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public struct VersionStruct {
		public int major;
		public int minor;
		public int micro;
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public enum RelevantResultType {
		RECENT,
		RELATED
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public enum ResultType {
		MOST_RECENT_EVENTS,
		LEAST_RECENT_EVENTS,
		MOST_RECENT_SUBJECTS,
		LEAST_RECENT_SUBJECTS,
		MOST_POPULAR_SUBJECTS,
		LEAST_POPULAR_SUBJECTS,
		MOST_POPULAR_ACTOR,
		LEAST_POPULAR_ACTOR,
		MOST_RECENT_ACTOR,
		LEAST_RECENT_ACTOR,
		MOST_RECENT_ORIGIN,
		LEAST_RECENT_ORIGIN,
		MOST_POPULAR_ORIGIN,
		LEAST_POPULAR_ORIGIN,
		OLDEST_ACTOR,
		MOST_RECENT_SUBJECT_INTERPRETATION,
		LEAST_RECENT_SUBJECT_INTERPRETATION,
		MOST_POPULAR_SUBJECT_INTERPRETATION,
		LEAST_POPULAR_SUBJECT_INTERPRETATION,
		MOST_RECENT_MIMETYPE,
		LEAST_RECENT_MIMETYPE,
		MOST_POPULAR_MIMETYPE,
		LEAST_POPULAR_MIMETYPE,
		MOST_RECENT_CURRENT_URI,
		LEAST_RECENT_CURRENT_URI,
		MOST_POPULAR_CURRENT_URI,
		LEAST_POPULAR_CURRENT_URI,
		MOST_RECENT_EVENT_ORIGIN,
		LEAST_RECENT_EVENT_ORIGIN,
		MOST_POPULAR_EVENT_ORIGIN,
		LEAST_POPULAR_EVENT_ORIGIN;
		public static bool is_sort_order_asc (Zeitgeist.ResultType result_type);
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public enum StorageState {
		NOT_AVAILABLE,
		AVAILABLE,
		ANY
	}
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	[DBus (name = "org.gnome.zeitgeist.EngineError")]
	public errordomain EngineError {
		BACKUP_FAILED,
		DATABASE_BUSY,
		DATABASE_CANTOPEN,
		DATABASE_CORRUPT,
		DATABASE_ERROR,
		DATABASE_RETIRE_FAILED,
		EXISTING_INSTANCE,
		INVALID_ARGUMENT,
		INVALID_KEY,
		INVALID_SIGNATURE,
		TOO_MANY_RESULTS
	}
	[CCode (cheader_filename = "zeitgeist-engine.h", has_target = false)]
	public delegate GLib.Type RegisterExtensionFunc (GLib.TypeModule module);
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public static unowned string? interpretation_for_mimetype (string mimetype);
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public static unowned string? manifestation_for_uri (string uri);
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public static void register_mimetype (string mimetype, string interpretation_uri);
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public static void register_mimetype_regex (string mimetype_regex, string interpretation_uri) throws GLib.RegexError;
	[CCode (cheader_filename = "zeitgeist-engine.h")]
	public static void register_uri_scheme (string uri_scheme, string manifestation_type);
}
