from StringIO import StringIO
from Products.CMFCore.utils import getToolByName

from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes
from Products.Archetypes.Extensions.utils import install_subskin

from Products.LinguaPlone import config


def install(self):
    out = StringIO()

    if not hasattr(self, "_isPortalRoot"):
        print >> out, "Must be installed in a CMF Site (read Plone)"
        return

    print >> out, "Installing %s" % listTypes(config.PKG_NAME)

    qi = getToolByName(self, 'portal_quickinstaller', None)
    if qi is None:
        if required:
            raise RuntimeError, (
                'portal_quickinstaller tool could not be found, and is '
                'required to install LinguaPlone dependencies')
        else:
            return
    qi.installProduct('PloneLanguageTool',)
    print >> out, 'Checked for the existence of PloneLanguageTool.\n'

    installTypes(self, out, listTypes(config.PKG_NAME), config.PKG_NAME)

    install_subskin(self, out, config.GLOBALS)

    print >> out, 'Successfully installed types.'

    # add language index and column to catalog
    catalogtool = getToolByName(self, 'portal_catalog')
    try:
        catalogtool.addIndex('Language', 'FieldIndex')
        print >> out, 'Added Language to portal catalogs indexes.\n'
        catalogtool.reindexIndex('Language', None)
        print >> out, 'Reindexed Language index.\n'
    except: pass
    try:
	catalogtool.addColumn('Language')
        print >> out, 'Added Language to portal catalogs columns.\n'
    except: pass

    return out.getvalue()
