/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _LOC_API_COMMON_H_RPCGEN
#define _LOC_API_COMMON_H_RPCGEN

#include <rpc/rpc.h>
#include "loc_api_fixup.h"

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#define LOC_API_TOOLVERS 0x00040024
#define LOC_API_FEATURES 0x00000001
#define RPC_LOC_EVENT_NI_NOTIFY_VERIFY_REQUEST 0x00000010
#define RPC_LOC_EVENT_WPS_NEEDED_REQUEST 0x00000200
#define RPC_LOC_EVENT_IOCTL_REPORT 0x00000080
#define RPC_LOC_EVENT_LOCATION_SERVER_REQUEST 0x00000040
#define RPC_LOC_EVENT_RESERVED 0x8000000000000000
#define RPC_LOC_EVENT_PARSED_POSITION_REPORT 0x00000001
#define RPC_LOC_EVENT_ASSISTANCE_DATA_REQUEST 0x00000020
#define RPC_LOC_EVENT_NMEA_POSITION_REPORT 0x00000008
#define RPC_LOC_EVENT_SATELLITE_REPORT 0x00000002
#define RPC_LOC_EVENT_STATUS_REPORT 0x00000100
#define RPC_LOC_EVENT_CB_F_TYPE_VERSION 0x00040001
#define RPC_LOC_OPEN_VERSION 0x00040001
#define RPC_LOC_API_RPC_GLUE_CODE_INFO_REMOTE_VERSION 0x00040001
#define RPC_LOC_API_NULL_VERSION 0x00040001
#define RPC_LOC_STOP_FIX_VERSION 0x00040001
#define RPC_LOC_IOCTL_VERSION 0x00040001
#define RPC_LOC_START_FIX_VERSION 0x00040001
#define RPC_LOC_CLOSE_VERSION 0x00040001
#define RPC_LOC_API_API_VERSIONS_VERSION 0x00040001
#define RPC_LOC_API_API_MAJOR_NUM 0x0004
#define RPC_LOC_APIAPI_VERSION_IS_HASHKEY 0

typedef bool_t rpc_boolean;

typedef u_long rpc_uint32;

typedef u_short rpc_uint16;

typedef u_char rpc_uint8;

typedef long rpc_int32;

typedef u_char rpc_byte;

typedef u_quad_t rpc_uint64;

typedef rpc_int32 rpc_loc_client_handle_type;

typedef rpc_uint64 rpc_loc_event_mask_type;

typedef rpc_uint64 rpc_loc_position_valid_mask_type;

typedef rpc_uint32 rpc_loc_pos_technology_mask_type;

enum rpc_loc_session_status_e_type {
	RPC_LOC_SESS_STATUS_SUCCESS = 0,
	RPC_LOC_SESS_STATUS_IN_PROGESS = 1,
	RPC_LOC_SESS_STATUS_GENERAL_FAILURE = 2,
	RPC_LOC_SESS_STATUS_TIMEOUT = 3,
	RPC_LOC_SESS_STATUS_USER_END = 4,
	RPC_LOC_SESS_STATUS_BAD_PARAMETER = 5,
	RPC_LOC_SESS_STATUS_PHONE_OFFLINE = 6,
	RPC_LOC_SESS_STATUS_ENGINE_LOCKED = 7,
	RPC_LOC_SESS_STATUS_MAX = 268435456,
};
typedef enum rpc_loc_session_status_e_type rpc_loc_session_status_e_type;

struct rpc_loc_calendar_time_s_type {
	rpc_uint16 year;
	u_char month;
	u_char day_of_week;
	u_char day;
	u_char hour;
	u_char minute;
	u_char second;
	rpc_uint16 millisecond;
};
typedef struct rpc_loc_calendar_time_s_type rpc_loc_calendar_time_s_type;

struct rpc_loc_parsed_position_s_type {
	rpc_loc_position_valid_mask_type valid_mask;
	rpc_loc_session_status_e_type session_status;
	rpc_loc_calendar_time_s_type timestamp_calendar;
	rpc_uint64 timestamp_utc;
	rpc_uint8 leap_seconds;
	float time_unc;
	double latitude;
	double longitude;
	float altitude_wrt_ellipsoid;
	float altitude_wrt_mean_sea_level;
	float speed_horizontal;
	float speed_vertical;
	float heading;
	float hor_unc_circular;
	float hor_unc_ellipse_semi_major;
	float hor_unc_ellipse_semi_minor;
	float hor_unc_ellipse_orient_azimuth;
	float vert_unc;
	float speed_unc;
	float heading_unc;
	u_char confidence_horizontal;
	u_char confidence_vertical;
	float magnetic_deviation;
	rpc_loc_pos_technology_mask_type technology_mask;
};
typedef struct rpc_loc_parsed_position_s_type rpc_loc_parsed_position_s_type;

enum rpc_loc_sv_system_e_type {
	RPC_LOC_SV_SYSTEM_GPS = 1,
	RPC_LOC_SV_SYSTEM_GALILEO = 2,
	RPC_LOC_SV_SYSTEM_SBAS = 3,
	RPC_LOC_SV_SYSTEM_COMPASS = 4,
	RPC_LOC_SV_SYSTEM_GLONASS = 5,
	RPC_LOC_SV_SYSTEM_MAX = 268435456,
};
typedef enum rpc_loc_sv_system_e_type rpc_loc_sv_system_e_type;

enum rpc_loc_sv_status_e_type {
	RPC_LOC_SV_STATUS_IDLE = 1,
	RPC_LOC_SV_STATUS_SEARCH = 2,
	RPC_LOC_SV_STATUS_TRACK = 3,
	RPC_LOC_SV_STATUS_MAX = 268435456,
};
typedef enum rpc_loc_sv_status_e_type rpc_loc_sv_status_e_type;

typedef rpc_uint32 rpc_loc_sv_info_valid_mask_type;

struct rpc_loc_sv_info_s_type {
	rpc_loc_sv_info_valid_mask_type valid_mask;
	rpc_loc_sv_system_e_type system;
	rpc_uint8 prn;
	rpc_uint8 health_status;
	rpc_loc_sv_status_e_type process_status;
	rpc_boolean has_eph;
	rpc_boolean has_alm;
	float elevation;
	float azimuth;
	float snr;
};
typedef struct rpc_loc_sv_info_s_type rpc_loc_sv_info_s_type;

typedef rpc_uint32 rpc_loc_gnss_info_valid_mask_type;

struct rpc_loc_gnss_info_s_type {
	rpc_loc_gnss_info_valid_mask_type valid_mask;
	float position_dop;
	float horizontal_dop;
	float vertical_dop;
	rpc_boolean altitude_assumed;
	rpc_uint16 sv_count;
	struct {
		u_int sv_list_len;
		rpc_loc_sv_info_s_type *sv_list_val;
	} sv_list;
};
typedef struct rpc_loc_gnss_info_s_type rpc_loc_gnss_info_s_type;

struct rpc_loc_nmea_report_s_type {
	rpc_uint16 length;
	char nmea_sentences[1200];
};
typedef struct rpc_loc_nmea_report_s_type rpc_loc_nmea_report_s_type;

enum rpc_loc_status_event_e_type {
	RPC_LOC_STATUS_EVENT_ENGINE_STATE = 1,
	RPC_LOC_STATUS_EVENT_FIX_SESSION_STATE = 2,
	RPC_LOC_STATUS_EVENT_MAX = 268435456,
};
typedef enum rpc_loc_status_event_e_type rpc_loc_status_event_e_type;

enum rpc_loc_engine_state_e_type {
	RPC_LOC_ENGINE_STATE_ON = 1,
	RPC_LOC_ENGINE_STATE_OFF = 2,
	RPC_LOC_ENGINE_STATE_MAX = 268435456,
};
typedef enum rpc_loc_engine_state_e_type rpc_loc_engine_state_e_type;

enum rpc_loc_fix_session_state_e_type {
	RPC_LOC_FIX_SESSION_STATE_BEGIN = 1,
	RPC_LOC_FIX_SESSION_STATE_END = 2,
	RPC_LOC_FIX_SESSION_STATE_MAX = 268435456,
};
typedef enum rpc_loc_fix_session_state_e_type rpc_loc_fix_session_state_e_type;

struct rpc_loc_status_event_payload_u_type {
	rpc_loc_status_event_e_type disc;
	union {
		rpc_loc_engine_state_e_type engine_state;
		rpc_loc_fix_session_state_e_type fix_session_state;
	} rpc_loc_status_event_payload_u_type_u;
};
typedef struct rpc_loc_status_event_payload_u_type rpc_loc_status_event_payload_u_type;

struct rpc_loc_status_event_s_type {
	rpc_loc_status_event_e_type event;
	rpc_loc_status_event_payload_u_type payload;
};
typedef struct rpc_loc_status_event_s_type rpc_loc_status_event_s_type;

enum rpc_loc_server_addr_e_type {
	RPC_LOC_SERVER_ADDR_IPV4 = 1,
	RPC_LOC_SERVER_ADDR_URL = 2,
	RPC_LOC_SERVER_ADDR_MAX = 268435456,
};
typedef enum rpc_loc_server_addr_e_type rpc_loc_server_addr_e_type;

struct rpc_loc_server_addr_ipv4_type {
	rpc_uint32 addr;
	rpc_uint16 port;
};
typedef struct rpc_loc_server_addr_ipv4_type rpc_loc_server_addr_ipv4_type;

struct rpc_loc_server_addr_url_type {
	rpc_uint16 length;
	char addr[256];
};
typedef struct rpc_loc_server_addr_url_type rpc_loc_server_addr_url_type;

struct rpc_loc_server_addr_u_type {
	rpc_loc_server_addr_e_type disc;
	union {
		rpc_loc_server_addr_ipv4_type ipv4;
		rpc_loc_server_addr_url_type url;
	} rpc_loc_server_addr_u_type_u;
};
typedef struct rpc_loc_server_addr_u_type rpc_loc_server_addr_u_type;

struct rpc_loc_server_info_s_type {
	rpc_loc_server_addr_e_type addr_type;
	rpc_loc_server_addr_u_type addr_info;
};
typedef struct rpc_loc_server_info_s_type rpc_loc_server_info_s_type;

enum rpc_loc_ni_notify_verify_e_type {
	RPC_LOC_NI_USER_NO_NOTIFY_NO_VERIFY = 1,
	RPC_LOC_NI_USER_NOTIFY_ONLY = 2,
	RPC_LOC_NI_USER_NOTIFY_VERIFY_ALLOW_NO_RESP = 3,
	RPC_LOC_NI_USER_NOTIFY_VERIFY_NOT_ALLOW_NO_RESP = 4,
	RPC_LOC_NI_USER_PRIVACY_OVERRIDE = 5,
	RPC_LOC_NI_USER_NOTIFY_VERITY_TYPE_MAX = 268435456,
};
typedef enum rpc_loc_ni_notify_verify_e_type rpc_loc_ni_notify_verify_e_type;

enum rpc_loc_ni_event_e_type {
	RPC_LOC_NI_EVENT_VX_NOTIFY_VERIFY_REQ = 1,
	RPC_LOC_NI_EVENT_SUPL_NOTIFY_VERIFY_REQ = 2,
	RPC_LOC_NI_EVENT_UMTS_CP_NOTIFY_VERIFY_REQ = 3,
	RPC_LOC_NI_EVENT_VX_SERVICE_INTERACTION_REQ = 4,
	RPC_LOC_NI_EVENT_MAX = 268435456,
};
typedef enum rpc_loc_ni_event_e_type rpc_loc_ni_event_e_type;

enum rpc_loc_ni_datacoding_scheme_e_type {
	RPC_LOC_NI_PRESUPL_ISO646IRV = 0,
	RPC_LOC_NI_PRESUPL_ISO8859 = 1,
	RPC_LOC_NI_PRESUPL_UTF8 = 2,
	RPC_LOC_NI_PRESUPL_UTF16 = 3,
	RPC_LOC_NI_PRESUPL_UCS2 = 4,
	RPC_LOC_NI_PRESUPL_GSM_DEFAULT = 5,
	RPC_LOC_NI_PRESUPL_SHIFT_JIS = 6,
	RPC_LOC_NI_PRESUPL_JIS = 7,
	RPC_LOC_NI_PRESUPL_EUC = 8,
	RPC_LOC_NI_PRESUPL_GB2312 = 9,
	RPC_LOC_NI_PRESUPL_CNS11643 = 10,
	RPC_LOC_NI_PRESUPL_KSC1001 = 11,
	RPC_LOC_NI_PRESUPL_ENCODING_UNKNOWN = 2147483647,
	RPC_LOC_NI_SS_GERMAN = 12,
	RPC_LOC_NI_SS_ENGLISH = 13,
	RPC_LOC_NI_SS_ITALIAN = 14,
	RPC_LOC_NI_SS_FRENCH = 15,
	RPC_LOC_NI_SS_SPANISH = 16,
	RPC_LOC_NI_SS_DUTCH = 17,
	RPC_LOC_NI_SS_SWEDISH = 18,
	RPC_LOC_NI_SS_DANISH = 19,
	RPC_LOC_NI_SS_PORTUGUESE = 20,
	RPC_LOC_NI_SS_FINNISH = 21,
	RPC_LOC_NI_SS_NORWEGIAN = 22,
	RPC_LOC_NI_SS_GREEK = 23,
	RPC_LOC_NI_SS_TURKISH = 24,
	RPC_LOC_NI_SS_HUNGARIAN = 25,
	RPC_LOC_NI_SS_POLISH = 26,
	RPC_LOC_NI_SS_LANGUAGE_UNSPEC = 27,
	RPC_LOC_NI_SUPL_UTF8 = 28,
	RPC_LOC_NI_SUPL_UCS2 = 29,
	RPC_LOC_NI_SUPL_GSM_DEFAULT = 30,
	RPC_LOC_NI_SUPL_ENCODING_UNKNOWN = 2147483647,
};
typedef enum rpc_loc_ni_datacoding_scheme_e_type rpc_loc_ni_datacoding_scheme_e_type;

enum rpc_loc_ni_vx_requester_id_encoding_scheme_e_type {
	RPC_LOC_NI_VX_OCTET = 0,
	RPC_LOC_NI_VX_EXN_PROTOCOL_MSG = 1,
	RPC_LOC_NI_VX_ASCII = 2,
	RPC_LOC_NI_VX_IA5 = 3,
	RPC_LOC_NI_VX_UNICODE = 4,
	RPC_LOC_NI_VX_SHIFT_JIS = 5,
	RPC_LOC_NI_VX_KOREAN = 6,
	RPC_LOC_NI_VX_LATIN_HEBREW = 7,
	RPC_LOC_NI_VX_LATIN = 8,
	RPC_LOC_NI_VX_GSM = 9,
	RPC_LOC_NI_VX_ENCODING_TYPE_MAX = 268435456,
};
typedef enum rpc_loc_ni_vx_requester_id_encoding_scheme_e_type rpc_loc_ni_vx_requester_id_encoding_scheme_e_type;

enum rpc_loc_ni_vx_pos_mode_e_type {
	RPC_LOC_VX_MS_ASSISTED_ONLY = 1,
	RPC_LOC_VX_MS_BASED_ONLY = 2,
	RPC_LOC_VX_MS_ASSISTED_PREF_MSBASED_ALLWD = 3,
	RPC_LOC_VX_MS_BASED_PREF_ASSISTED_ALLWD = 4,
	RPC_LOC_VX_POS_MODE_MAX = 268435456,
};
typedef enum rpc_loc_ni_vx_pos_mode_e_type rpc_loc_ni_vx_pos_mode_e_type;

struct rpc_loc_ni_vx_requester_id_s_type {
	u_char requester_id_length;
	char requester_id[200];
};
typedef struct rpc_loc_ni_vx_requester_id_s_type rpc_loc_ni_vx_requester_id_s_type;

struct rpc_loc_ni_vx_notify_verify_req_s_type {
	rpc_loc_ni_notify_verify_e_type notification_priv_type;
	u_char pos_qos_incl;
	u_char pos_qos;
	rpc_uint32 num_fixes;
	rpc_uint32 tbf;
	rpc_loc_ni_vx_pos_mode_e_type pos_mode;
	rpc_loc_ni_vx_requester_id_encoding_scheme_e_type encoding_scheme;
	rpc_loc_ni_vx_requester_id_s_type requester_id;
	rpc_uint16 user_resp_timer_val;
};
typedef struct rpc_loc_ni_vx_notify_verify_req_s_type rpc_loc_ni_vx_notify_verify_req_s_type;

enum rpc_loc_ni_supl_pos_method_e_type {
	RPC_LOC_NI_POSMETHOD_AGPS_SETASSISTED = 1,
	RPC_LOC_NI_POSMETHOD_AGPS_SETBASED = 2,
	RPC_LOC_NI_POSMETHOD_AGPS_SETASSISTED_PREF = 3,
	RPC_LOC_NI_POSMETHOD_AGPS_SETBASED_PREF = 4,
	RPC_LOC_NI_POSMETHOD_AUTONOMOUS_GPS = 5,
	RPC_LOC_NI_POSMETHOD_AFLT = 6,
	RPC_LOC_NI_POSMETHOD_ECID = 7,
	RPC_LOC_NI_POSMETHOD_EOTD = 8,
	RPC_LOC_NI_POSMETHOD_OTDOA = 9,
	RPC_LOC_NI_POSMETHOD_NO_POSITION = 10,
	RPC_LOC_NI_POSMETHOD_MAX = 268435456,
};
typedef enum rpc_loc_ni_supl_pos_method_e_type rpc_loc_ni_supl_pos_method_e_type;

struct rpc_loc_ni_supl_slp_session_id_s_type {
	u_char presence;
	char session_id[4];
	rpc_loc_server_info_s_type slp_address;
};
typedef struct rpc_loc_ni_supl_slp_session_id_s_type rpc_loc_ni_supl_slp_session_id_s_type;

struct rpc_loc_ni_requestor_id_s_type {
	u_char data_coding_scheme;
	char requestor_id_string[200];
	u_char string_len;
};
typedef struct rpc_loc_ni_requestor_id_s_type rpc_loc_ni_requestor_id_s_type;

struct rpc_loc_ni_supl_client_name_s_type {
	u_char data_coding_scheme;
	char client_name_string[64];
	u_char string_len;
};
typedef struct rpc_loc_ni_supl_client_name_s_type rpc_loc_ni_supl_client_name_s_type;

struct rpc_loc_ni_supl_qop_s_type {
	u_char bit_mask;
	u_char horacc;
	u_char veracc;
	rpc_uint16 maxLocAge;
	u_char delay;
};
typedef struct rpc_loc_ni_supl_qop_s_type rpc_loc_ni_supl_qop_s_type;

struct rpc_loc_ni_supl_notify_verify_req_s_type {
	rpc_loc_ni_notify_verify_e_type notification_priv_type;
	rpc_uint16 flags;
	rpc_loc_ni_supl_slp_session_id_s_type supl_slp_session_id;
	char supl_hash[8];
	rpc_loc_ni_datacoding_scheme_e_type datacoding_scheme;
	rpc_loc_ni_supl_pos_method_e_type pos_method;
	rpc_loc_ni_requestor_id_s_type requestor_id;
	rpc_loc_ni_supl_client_name_s_type client_name;
	rpc_loc_ni_supl_qop_s_type supl_qop;
	rpc_uint16 user_response_timer;
};
typedef struct rpc_loc_ni_supl_notify_verify_req_s_type rpc_loc_ni_supl_notify_verify_req_s_type;

struct rpc_loc_ni_ext_client_address_s_type {
	u_char ext_client_address_len;
	char ext_client_address[20];
};
typedef struct rpc_loc_ni_ext_client_address_s_type rpc_loc_ni_ext_client_address_s_type;

enum rpc_loc_ni_location_type_e_type {
	RPC_LOC_NI_LOCATIONTYPE_CURRENT_LOCATION = 1,
	RPC_LOC_NI_LOCATIONTYPE_CURRENT_OR_LAST_KNOWN_LOCATION = 2,
	RPC_LOC_NI_LOCATIONTYPE_INITIAL_LOCATION = 3,
	RPC_LOC_NI_LOCATIONTYPE_MAX = 268435456,
};
typedef enum rpc_loc_ni_location_type_e_type rpc_loc_ni_location_type_e_type;

struct rpc_loc_ni_deferred_location_s_type {
	u_char unused_bits;
	u_char ms_available;
};
typedef struct rpc_loc_ni_deferred_location_s_type rpc_loc_ni_deferred_location_s_type;

struct rpc_loc_ni_codeword_string_s_type {
	u_char data_coding_scheme;
	char lcs_codeword_string[20];
	u_char string_len;
};
typedef struct rpc_loc_ni_codeword_string_s_type rpc_loc_ni_codeword_string_s_type;

struct rpc_loc_ni_service_type_id_s_type {
	u_char lcs_service_type_id;
};
typedef struct rpc_loc_ni_service_type_id_s_type rpc_loc_ni_service_type_id_s_type;

struct rpc_loc_ni_umts_cp_notify_verify_req_s_type {
	rpc_loc_ni_notify_verify_e_type notification_priv_type;
	u_char invoke_id;
	rpc_uint16 flags;
	u_char notification_length;
	char notification_text[64];
	rpc_loc_ni_datacoding_scheme_e_type datacoding_scheme;
	rpc_loc_ni_ext_client_address_s_type ext_client_address_data;
	rpc_loc_ni_location_type_e_type location_type;
	rpc_loc_ni_deferred_location_s_type deferred_location;
	rpc_loc_ni_requestor_id_s_type requestor_id;
	rpc_loc_ni_codeword_string_s_type codeword_string;
	rpc_loc_ni_service_type_id_s_type service_type_id;
	rpc_uint16 user_response_timer;
};
typedef struct rpc_loc_ni_umts_cp_notify_verify_req_s_type rpc_loc_ni_umts_cp_notify_verify_req_s_type;

enum rpc_loc_ni_service_interaction_e_type {
	RPC_LOC_NI_SERVICE_INTERACTION_ONGOING_NI_INCOMING_MO = 1,
	RPC_LOC_NI_SERVICE_INTERACTION_MAX = 268435456,
};
typedef enum rpc_loc_ni_service_interaction_e_type rpc_loc_ni_service_interaction_e_type;

struct rpc_loc_ni_vx_service_interaction_req_s_type {
	rpc_loc_ni_vx_notify_verify_req_s_type ni_vx_req;
	rpc_loc_ni_service_interaction_e_type service_interation_type;
};
typedef struct rpc_loc_ni_vx_service_interaction_req_s_type rpc_loc_ni_vx_service_interaction_req_s_type;

struct rpc_loc_ni_event_payload_u_type {
	rpc_loc_ni_event_e_type disc;
	union {
		rpc_loc_ni_vx_notify_verify_req_s_type vx_req;
		rpc_loc_ni_supl_notify_verify_req_s_type supl_req;
		rpc_loc_ni_umts_cp_notify_verify_req_s_type umts_cp_req;
		rpc_loc_ni_vx_service_interaction_req_s_type service_interaction_req;
	} rpc_loc_ni_event_payload_u_type_u;
};
typedef struct rpc_loc_ni_event_payload_u_type rpc_loc_ni_event_payload_u_type;

struct rpc_loc_ni_event_s_type {
	rpc_loc_ni_event_e_type event;
	rpc_loc_ni_event_payload_u_type payload;
};
typedef struct rpc_loc_ni_event_s_type rpc_loc_ni_event_s_type;

enum rpc_loc_assist_data_request_e_type {
	RPC_LOC_ASSIST_DATA_TIME_REQ = 1,
	RPC_LOC_ASSIST_DATA_PREDICTED_ORBITS_REQ = 2,
	RPC_LOC_ASSIST_DATA_MAX = 268435456,
};
typedef enum rpc_loc_assist_data_request_e_type rpc_loc_assist_data_request_e_type;

typedef char *rpc_struct_loc_time_download_source_s_type_servers_ptr;

typedef rpc_struct_loc_time_download_source_s_type_servers_ptr rpc_struct_loc_time_download_source_s_type_servers[3];

struct rpc_loc_time_download_source_s_type {
	rpc_uint32 delay_threshold;
	rpc_struct_loc_time_download_source_s_type_servers servers;
};
typedef struct rpc_loc_time_download_source_s_type rpc_loc_time_download_source_s_type;

typedef char *rpc_struct_loc_predicted_orbits_data_source_s_type_servers_ptr;

typedef rpc_struct_loc_predicted_orbits_data_source_s_type_servers_ptr rpc_struct_loc_predicted_orbits_data_source_s_type_servers[3];

struct rpc_loc_predicted_orbits_data_source_s_type {
	rpc_uint32 max_file_size;
	rpc_uint32 max_part_size;
	rpc_struct_loc_predicted_orbits_data_source_s_type_servers servers;
};
typedef struct rpc_loc_predicted_orbits_data_source_s_type rpc_loc_predicted_orbits_data_source_s_type;

struct rpc_loc_assist_data_request_payload_u_type {
	rpc_loc_assist_data_request_e_type disc;
	union {
		rpc_loc_time_download_source_s_type time_download;
		rpc_loc_predicted_orbits_data_source_s_type data_download;
	} rpc_loc_assist_data_request_payload_u_type_u;
};
typedef struct rpc_loc_assist_data_request_payload_u_type rpc_loc_assist_data_request_payload_u_type;

struct rpc_loc_assist_data_request_s_type {
	rpc_loc_assist_data_request_e_type event;
	rpc_loc_assist_data_request_payload_u_type payload;
};
typedef struct rpc_loc_assist_data_request_s_type rpc_loc_assist_data_request_s_type;

typedef rpc_uint32 rpc_loc_server_connection_handle;

enum rpc_loc_server_protocol_e_type {
	RPC_LOC_SERVER_PROTOCOL_DEFAULT = 0,
	RPC_LOC_SERVER_PROTOCOL_SUPL = 1,
	RPC_LOC_SERVER_PROTOCOL_VX_MPC = 2,
	RPC_LOC_SERVER_PROTOCOL_VX_PDE = 3,
	RPC_LOC_SERVER_PROTOCOL_MAX = 16777216,
};
typedef enum rpc_loc_server_protocol_e_type rpc_loc_server_protocol_e_type;

enum rpc_loc_server_request_e_type {
	RPC_LOC_SERVER_REQUEST_OPEN = 1,
	RPC_LOC_SERVER_REQUEST_CLOSE = 2,
	RPC_LOC_SERVER_REQUEST_MAX = 268435456,
};
typedef enum rpc_loc_server_request_e_type rpc_loc_server_request_e_type;

struct rpc_loc_server_open_req_s_type {
	rpc_loc_server_connection_handle conn_handle;
	rpc_loc_server_protocol_e_type protocol;
};
typedef struct rpc_loc_server_open_req_s_type rpc_loc_server_open_req_s_type;

struct rpc_loc_server_close_req_s_type {
	rpc_loc_server_connection_handle conn_handle;
};
typedef struct rpc_loc_server_close_req_s_type rpc_loc_server_close_req_s_type;

struct rpc_loc_server_request_u_type {
	rpc_loc_server_request_e_type disc;
	union {
		rpc_loc_server_open_req_s_type open_req;
		rpc_loc_server_close_req_s_type close_req;
	} rpc_loc_server_request_u_type_u;
};
typedef struct rpc_loc_server_request_u_type rpc_loc_server_request_u_type;

struct rpc_loc_server_request_s_type {
	rpc_loc_server_request_e_type event;
	rpc_loc_server_request_u_type payload;
};
typedef struct rpc_loc_server_request_s_type rpc_loc_server_request_s_type;

enum rpc_loc_qwip_request_e_type {
	RPC_LOC_QWIP_START_PERIODIC_HI_FREQ_FIXES = 0,
	RPC_LOC_QWIP_START_PERIODIC_KEEP_WARM = 0 + 1,
	RPC_LOC_QWIP_STOP_PERIODIC_FIXES = 0 + 2,
	RPC_LOC_QWIP_SUSPEND = 0 + 3,
	RPC_LOC_QWIP_REQUEST_MAX = 268435456,
};
typedef enum rpc_loc_qwip_request_e_type rpc_loc_qwip_request_e_type;

struct rpc_loc_qwip_request_s_type {
	rpc_loc_qwip_request_e_type request_type;
	rpc_uint16 tbf_ms;
};
typedef struct rpc_loc_qwip_request_s_type rpc_loc_qwip_request_s_type;

struct rpc_loc_reserved_payload_s_type {
	rpc_uint16 data_size;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct rpc_loc_reserved_payload_s_type rpc_loc_reserved_payload_s_type;

enum rpc_loc_ioctl_e_type {
	RPC_LOC_IOCTL_GET_API_VERSION = 1,
	RPC_LOC_IOCTL_SET_FIX_CRITERIA = 2,
	RPC_LOC_IOCTL_GET_FIX_CRITERIA = 3,
	RPC_LOC_IOCTL_SERVICE_START_INDEX = 400,
	RPC_LOC_IOCTL_INFORM_NI_USER_RESPONSE = 400,
	RPC_LOC_IOCTL_INJECT_PREDICTED_ORBITS_DATA = 401,
	RPC_LOC_IOCTL_QUERY_PREDICTED_ORBITS_DATA_VALIDITY = 402,
	RPC_LOC_IOCTL_QUERY_PREDICTED_ORBITS_DATA_SOURCE = 403,
	RPC_LOC_IOCTL_SET_PREDICTED_ORBITS_DATA_AUTO_DOWNLOAD = 404,
	RPC_LOC_IOCTL_INJECT_UTC_TIME = 405,
	RPC_LOC_IOCTL_INJECT_RTC_VALUE = 406,
	RPC_LOC_IOCTL_INJECT_POSITION = 407,
	RPC_LOC_IOCTL_QUERY_ENGINE_STATE = 408,
	RPC_LOC_IOCTL_INFORM_SERVER_OPEN_STATUS = 409,
	RPC_LOC_IOCTL_INFORM_SERVER_CLOSE_STATUS = 410,
	RPC_LOC_IOCTL_SEND_WIPER_POSITION_REPORT = 411,
	RPC_LOC_IOCTL_NOTIFY_WIPER_STATUS = 412,
	RPC_LOC_IOCTL_ACCESS_EFS_DATA = 413,
	RPC_LOC_IOCTL_NV_SETTINGS_START_INDEX = 800,
	RPC_LOC_IOCTL_SET_ENGINE_LOCK = 800,
	RPC_LOC_IOCTL_GET_ENGINE_LOCK = 801,
	RPC_LOC_IOCTL_SET_SBAS_CONFIG = 802,
	RPC_LOC_IOCTL_GET_SBAS_CONFIG = 803,
	RPC_LOC_IOCTL_SET_NMEA_TYPES = 804,
	RPC_LOC_IOCTL_GET_NMEA_TYPES = 805,
	RPC_LOC_IOCTL_SET_CDMA_PDE_SERVER_ADDR = 806,
	RPC_LOC_IOCTL_GET_CDMA_PDE_SERVER_ADDR = 807,
	RPC_LOC_IOCTL_SET_CDMA_MPC_SERVER_ADDR = 808,
	RPC_LOC_IOCTL_GET_CDMA_MPC_SERVER_ADDR = 809,
	RPC_LOC_IOCTL_SET_UMTS_SLP_SERVER_ADDR = 810,
	RPC_LOC_IOCTL_GET_UMTS_SLP_SERVER_ADDR = 811,
	RPC_LOC_IOCTL_SET_ON_DEMAND_LPM = 812,
	RPC_LOC_IOCTL_GET_ON_DEMAND_LPM = 813,
	RPC_LOC_IOCTL_PROPRIETARY_START_INDEX = 1000,
	RPC_LOC_IOCTL_DELETE_ASSIST_DATA = 1000,
	RPC_LOC_IOCTL_SET_CUSTOM_PDE_SERVER_ADDR = 1001,
	RPC_LOC_IOCTL_GET_CUSTOM_PDE_SERVER_ADDR = 1002,
	RPC_LOC_IOCTL_THIRD_PARTY_START_INDEX = 1073741824,
};
typedef enum rpc_loc_ioctl_e_type rpc_loc_ioctl_e_type;

struct rpc_loc_api_version_s_type {
	u_char major;
	u_char minor;
};
typedef struct rpc_loc_api_version_s_type rpc_loc_api_version_s_type;

enum rpc_loc_fix_recurrence_e_type {
	RPC_LOC_PERIODIC_FIX = 1,
	RPC_LOC_SINGLE_FIX = 2,
	RPC_LOC_FIX_SESSION_TYPE_MAX = 268435456,
};
typedef enum rpc_loc_fix_recurrence_e_type rpc_loc_fix_recurrence_e_type;

enum rpc_loc_operation_mode_e_type {
	RPC_LOC_OPER_MODE_DEFAULT = 1,
	RPC_LOC_OPER_MODE_MSB = 2,
	RPC_LOC_OPER_MODE_MSA = 3,
	RPC_LOC_OPER_MODE_STANDALONE = 4,
	RPC_LOC_OPER_MODE_SPEED_OPTIMAL = 5,
	RPC_LOC_OPER_MODE_ACCURACY_OPTIMAL = 6,
	RPC_LOC_OPER_MODE_DATA_OPTIMAL = 7,
	RPC_LOC_OPER_MODE_CELL_ID = 8,
	RPC_LOC_OPER_MODE_MAX = 268435456,
};
typedef enum rpc_loc_operation_mode_e_type rpc_loc_operation_mode_e_type;

enum rpc_loc_notify_e_type {
	RPC_LOC_NOTIFY_ON_INTERVAL = 1,
	RPC_LOC_NOTIFY_ON_DISTANCE = 2,
	RPC_LOC_NOTIFY_ON_ANY = 3,
	RPC_LOC_NOTIFY_ON_ALL = 4,
	RPC_LOC_NOTIFY_TYPE_MAX = 268435456,
};
typedef enum rpc_loc_notify_e_type rpc_loc_notify_e_type;

struct rpc_loc_fix_criteria_s_type {
	rpc_uint32 valid_mask;
	rpc_loc_fix_recurrence_e_type recurrence_type;
	rpc_loc_operation_mode_e_type preferred_operation_mode;
	rpc_uint32 preferred_accuracy;
	rpc_uint32 preferred_response_time;
	rpc_boolean intermediate_pos_report_enabled;
	rpc_loc_notify_e_type notify_type;
	rpc_uint32 min_interval;
	float min_distance;
	rpc_uint32 min_dist_sample_interval;
};
typedef struct rpc_loc_fix_criteria_s_type rpc_loc_fix_criteria_s_type;

enum rpc_loc_ni_user_resp_e_type {
	RPC_LOC_NI_LCS_NOTIFY_VERIFY_ACCEPT = 1,
	RPC_LOC_NI_LCS_NOTIFY_VERIFY_DENY = 2,
	RPC_LOC_NI_LCS_NOTIFY_VERIFY_NORESP = 3,
	RPC_LOC_NI_LCS_NOTIFY_VERIFY_MAX = 268435456,
};
typedef enum rpc_loc_ni_user_resp_e_type rpc_loc_ni_user_resp_e_type;

struct rpc_loc_user_verify_s_type {
	rpc_loc_ni_user_resp_e_type user_resp;
	rpc_loc_ni_event_s_type ni_event_pass_back;
};
typedef struct rpc_loc_user_verify_s_type rpc_loc_user_verify_s_type;

enum rpc_loc_predicted_orbits_data_format_e_type {
	RPC_LOC_PREDICTED_ORBITS_XTRA = 0,
	RPC_LOC_PREDICTED_ORBITS_FORMAT_MAX = 268435456,
};
typedef enum rpc_loc_predicted_orbits_data_format_e_type rpc_loc_predicted_orbits_data_format_e_type;

struct rpc_loc_predicted_orbits_data_s_type {
	rpc_loc_predicted_orbits_data_format_e_type format_type;
	rpc_uint32 total_size;
	rpc_uint8 total_parts;
	rpc_uint8 part;
	rpc_uint16 part_len;
	struct {
		u_int data_ptr_len;
		char *data_ptr_val;
	} data_ptr;
};
typedef struct rpc_loc_predicted_orbits_data_s_type rpc_loc_predicted_orbits_data_s_type;

struct rpc_loc_predicted_orbits_data_validity_report_s_type {
	rpc_uint64 start_time_utc;
	rpc_uint16 valid_duration_hrs;
};
typedef struct rpc_loc_predicted_orbits_data_validity_report_s_type rpc_loc_predicted_orbits_data_validity_report_s_type;

struct rpc_loc_predicted_orbits_auto_download_config_s_type {
	rpc_boolean enable;
	u_char auto_check_every_hrs;
};
typedef struct rpc_loc_predicted_orbits_auto_download_config_s_type rpc_loc_predicted_orbits_auto_download_config_s_type;

struct rpc_loc_assist_data_time_s_type {
	rpc_uint64 time_utc;
	rpc_uint32 uncertainty;
};
typedef struct rpc_loc_assist_data_time_s_type rpc_loc_assist_data_time_s_type;

typedef rpc_uint64 rpc_loc_assist_pos_valid_mask_type;

struct rpc_loc_assist_data_pos_s_type {
	rpc_loc_assist_pos_valid_mask_type valid_mask;
	rpc_uint64 timestamp_utc;
	double latitude;
	double longitude;
	float altitude_wrt_ellipsoid;
	float altitude_wrt_mean_sea_level;
	float hor_unc_circular;
	float vert_unc;
	u_char confidence_horizontal;
	u_char confidence_vertical;
	rpc_int32 timestamp_age;
};
typedef struct rpc_loc_assist_data_pos_s_type rpc_loc_assist_data_pos_s_type;

enum rpc_loc_server_open_status_e_type {
	RPC_LOC_SERVER_OPEN_SUCCESS = 1,
	RPC_LOC_SERVER_OPEN_FAIL = 2,
	RPC_LOC_SERVER_OPEN_STATUS_MAX = 268435456,
};
typedef enum rpc_loc_server_open_status_e_type rpc_loc_server_open_status_e_type;

struct rpc_loc_server_open_status_s_type {
	rpc_loc_server_connection_handle conn_handle;
	rpc_loc_server_open_status_e_type open_status;
	char apn_name[100];
};
typedef struct rpc_loc_server_open_status_s_type rpc_loc_server_open_status_s_type;

enum rpc_loc_server_close_status_e_type {
	RPC_LOC_SERVER_CLOSE_SUCCESS = 1,
	RPC_LOC_SERVER_CLOSE_FAIL = 2,
	RPC_LOC_SERVER_CLOSE_STATUS_MAX = 268435456,
};
typedef enum rpc_loc_server_close_status_e_type rpc_loc_server_close_status_e_type;

struct rpc_loc_server_close_status_s_type {
	rpc_loc_server_connection_handle conn_handle;
	rpc_loc_server_close_status_e_type close_status;
};
typedef struct rpc_loc_server_close_status_s_type rpc_loc_server_close_status_s_type;

struct rpc_loc_wiper_fix_time_s_type {
	rpc_uint32 slow_clock_count;
};
typedef struct rpc_loc_wiper_fix_time_s_type rpc_loc_wiper_fix_time_s_type;

struct rpc_loc_wiper_fix_pos_s_type {
	rpc_int32 lat;
	rpc_int32 lon;
	rpc_uint16 HEPE;
	rpc_uint8 num_of_aps_used;
	rpc_uint8 fix_error_code;
};
typedef struct rpc_loc_wiper_fix_pos_s_type rpc_loc_wiper_fix_pos_s_type;

struct rpc_loc_wiper_ap_info_s_type {
	char mac_addr[6];
	rpc_int32 rssi;
	rpc_uint16 channel;
	rpc_uint8 ap_qualifier;
};
typedef struct rpc_loc_wiper_ap_info_s_type rpc_loc_wiper_ap_info_s_type;

struct rpc_loc_wiper_ap_set_s_type {
	rpc_uint8 num_of_aps;
	rpc_loc_wiper_ap_info_s_type ap_info[50];
};
typedef struct rpc_loc_wiper_ap_set_s_type rpc_loc_wiper_ap_set_s_type;

struct rpc_loc_wiper_position_report_s_type {
	rpc_uint8 wiper_valid_info_flag;
	rpc_loc_wiper_fix_time_s_type wiper_fix_time;
	rpc_loc_wiper_fix_pos_s_type wiper_fix_position;
	rpc_loc_wiper_ap_set_s_type wiper_ap_set;
};
typedef struct rpc_loc_wiper_position_report_s_type rpc_loc_wiper_position_report_s_type;

enum rpc_loc_wiper_status_e_type {
	RPC_LOC_WIPER_STATUS_AVAILABLE = 1,
	RPC_LOC_WIPER_STATUS_UNAVAILABLE = 2,
	RPC_LOC_WIPER_STATUS_E_SIZE = 268435456,
};
typedef enum rpc_loc_wiper_status_e_type rpc_loc_wiper_status_e_type;

enum rpc_loc_fs_operation_e_type {
	RPC_LOC_FS_CREATE_WRITE_FILE = 1,
	RPC_LOC_FS_APPEND_FILE = 2,
	RPC_LOC_FS_DELETE_FILE = 3,
	RPC_LOC_FS_READ_FILE = 4,
	RPC_LOC_FS_MAX = 268435456,
};
typedef enum rpc_loc_fs_operation_e_type rpc_loc_fs_operation_e_type;

struct rpc_loc_efs_data_s_type {
	char filename[64];
	rpc_loc_fs_operation_e_type operation;
	rpc_uint32 total_size;
	struct {
		u_int data_ptr_len;
		char *data_ptr_val;
	} data_ptr;
	rpc_uint32 part_len;
	rpc_uint8 part;
	rpc_uint8 total_parts;
	rpc_uint32 reserved;
};
typedef struct rpc_loc_efs_data_s_type rpc_loc_efs_data_s_type;

enum rpc_loc_lock_e_type {
	RPC_LOC_LOCK_NONE = 1,
	RPC_LOC_LOCK_MI = 2,
	RPC_LOC_LOCK_MT = 3,
	RPC_LOC_LOCK_ALL = 4,
	RPC_LOC_LOCK_MAX = 268435456,
};
typedef enum rpc_loc_lock_e_type rpc_loc_lock_e_type;

typedef rpc_uint32 rpc_loc_nmea_sentence_type;

typedef rpc_uint32 rpc_loc_assist_data_type;

struct rpc_loc_assist_data_delete_s_type {
	rpc_loc_assist_data_type type;
	rpc_uint32 reserved[8];
};
typedef struct rpc_loc_assist_data_delete_s_type rpc_loc_assist_data_delete_s_type;

struct rpc_loc_ioctl_data_u_type {
	rpc_loc_ioctl_e_type disc;
	union {
		rpc_loc_fix_criteria_s_type fix_criteria;
		rpc_loc_user_verify_s_type user_verify_resp;
		rpc_loc_predicted_orbits_data_s_type predicted_orbits_data;
		rpc_loc_predicted_orbits_auto_download_config_s_type predicted_orbits_auto_download;
		rpc_loc_assist_data_time_s_type assistance_data_time;
		rpc_loc_assist_data_pos_s_type assistance_data_position;
		rpc_loc_server_open_status_s_type conn_open_status;
		rpc_loc_server_close_status_s_type conn_close_status;
		rpc_loc_wiper_position_report_s_type wiper_pos;
		rpc_loc_wiper_status_e_type wiper_status;
		rpc_loc_lock_e_type engine_lock;
		rpc_boolean sbas_mode;
		rpc_loc_nmea_sentence_type nmea_types;
		rpc_boolean on_demand_lpm;
		rpc_loc_server_info_s_type server_addr;
		rpc_loc_assist_data_delete_s_type assist_data_delete;
		rpc_loc_efs_data_s_type efs_data;
	} rpc_loc_ioctl_data_u_type_u;
};
typedef struct rpc_loc_ioctl_data_u_type rpc_loc_ioctl_data_u_type;

struct rpc_loc_ioctl_callback_data_u_type {
	rpc_loc_ioctl_e_type disc;
	union {
		rpc_loc_api_version_s_type api_version;
		rpc_loc_fix_criteria_s_type fix_criteria;
		rpc_loc_lock_e_type engine_lock;
		rpc_boolean sbas_mode;
		rpc_loc_nmea_sentence_type nmea_types;
		rpc_boolean on_demand_lpm;
		rpc_loc_server_info_s_type server_addr;
		rpc_loc_predicted_orbits_data_source_s_type predicted_orbits_data_source;
		rpc_loc_predicted_orbits_data_validity_report_s_type predicted_orbits_data_validity;
	} rpc_loc_ioctl_callback_data_u_type_u;
};
typedef struct rpc_loc_ioctl_callback_data_u_type rpc_loc_ioctl_callback_data_u_type;

struct rpc_loc_ioctl_callback_s_type {
	rpc_loc_ioctl_e_type type;
	rpc_int32 status;
	rpc_loc_ioctl_callback_data_u_type data;
};
typedef struct rpc_loc_ioctl_callback_s_type rpc_loc_ioctl_callback_s_type;

struct rpc_loc_event_payload_u_type {
	u_quad_t disc;
	union {
		rpc_loc_parsed_position_s_type parsed_location_report;
		rpc_loc_gnss_info_s_type gnss_report;
		rpc_loc_nmea_report_s_type nmea_report;
		rpc_loc_ni_event_s_type ni_request;
		rpc_loc_assist_data_request_s_type assist_data_request;
		rpc_loc_server_request_s_type loc_server_request;
		rpc_loc_ioctl_callback_s_type ioctl_report;
		rpc_loc_status_event_s_type status_report;
		rpc_loc_qwip_request_s_type qwip_request;
		rpc_loc_reserved_payload_s_type reserved;
	} rpc_loc_event_payload_u_type_u;
};
typedef struct rpc_loc_event_payload_u_type rpc_loc_event_payload_u_type;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_rpc_boolean (XDR *, rpc_boolean*);
extern  bool_t xdr_rpc_uint32 (XDR *, rpc_uint32*);
extern  bool_t xdr_rpc_uint16 (XDR *, rpc_uint16*);
extern  bool_t xdr_rpc_uint8 (XDR *, rpc_uint8*);
extern  bool_t xdr_rpc_int32 (XDR *, rpc_int32*);
extern  bool_t xdr_rpc_byte (XDR *, rpc_byte*);
extern  bool_t xdr_rpc_uint64 (XDR *, rpc_uint64*);
extern  bool_t xdr_rpc_loc_client_handle_type (XDR *, rpc_loc_client_handle_type*);
extern  bool_t xdr_rpc_loc_event_mask_type (XDR *, rpc_loc_event_mask_type*);
extern  bool_t xdr_rpc_loc_position_valid_mask_type (XDR *, rpc_loc_position_valid_mask_type*);
extern  bool_t xdr_rpc_loc_pos_technology_mask_type (XDR *, rpc_loc_pos_technology_mask_type*);
extern  bool_t xdr_rpc_loc_session_status_e_type (XDR *, rpc_loc_session_status_e_type*);
extern  bool_t xdr_rpc_loc_calendar_time_s_type (XDR *, rpc_loc_calendar_time_s_type*);
extern  bool_t xdr_rpc_loc_parsed_position_s_type (XDR *, rpc_loc_parsed_position_s_type*);
extern  bool_t xdr_rpc_loc_sv_system_e_type (XDR *, rpc_loc_sv_system_e_type*);
extern  bool_t xdr_rpc_loc_sv_status_e_type (XDR *, rpc_loc_sv_status_e_type*);
extern  bool_t xdr_rpc_loc_sv_info_valid_mask_type (XDR *, rpc_loc_sv_info_valid_mask_type*);
extern  bool_t xdr_rpc_loc_sv_info_s_type (XDR *, rpc_loc_sv_info_s_type*);
extern  bool_t xdr_rpc_loc_gnss_info_valid_mask_type (XDR *, rpc_loc_gnss_info_valid_mask_type*);
extern  bool_t xdr_rpc_loc_gnss_info_s_type (XDR *, rpc_loc_gnss_info_s_type*);
extern  bool_t xdr_rpc_loc_nmea_report_s_type (XDR *, rpc_loc_nmea_report_s_type*);
extern  bool_t xdr_rpc_loc_status_event_e_type (XDR *, rpc_loc_status_event_e_type*);
extern  bool_t xdr_rpc_loc_engine_state_e_type (XDR *, rpc_loc_engine_state_e_type*);
extern  bool_t xdr_rpc_loc_fix_session_state_e_type (XDR *, rpc_loc_fix_session_state_e_type*);
extern  bool_t xdr_rpc_loc_status_event_payload_u_type (XDR *, rpc_loc_status_event_payload_u_type*);
extern  bool_t xdr_rpc_loc_status_event_s_type (XDR *, rpc_loc_status_event_s_type*);
extern  bool_t xdr_rpc_loc_server_addr_e_type (XDR *, rpc_loc_server_addr_e_type*);
extern  bool_t xdr_rpc_loc_server_addr_ipv4_type (XDR *, rpc_loc_server_addr_ipv4_type*);
extern  bool_t xdr_rpc_loc_server_addr_url_type (XDR *, rpc_loc_server_addr_url_type*);
extern  bool_t xdr_rpc_loc_server_addr_u_type (XDR *, rpc_loc_server_addr_u_type*);
extern  bool_t xdr_rpc_loc_server_info_s_type (XDR *, rpc_loc_server_info_s_type*);
extern  bool_t xdr_rpc_loc_ni_notify_verify_e_type (XDR *, rpc_loc_ni_notify_verify_e_type*);
extern  bool_t xdr_rpc_loc_ni_event_e_type (XDR *, rpc_loc_ni_event_e_type*);
extern  bool_t xdr_rpc_loc_ni_datacoding_scheme_e_type (XDR *, rpc_loc_ni_datacoding_scheme_e_type*);
extern  bool_t xdr_rpc_loc_ni_vx_requester_id_encoding_scheme_e_type (XDR *, rpc_loc_ni_vx_requester_id_encoding_scheme_e_type*);
extern  bool_t xdr_rpc_loc_ni_vx_pos_mode_e_type (XDR *, rpc_loc_ni_vx_pos_mode_e_type*);
extern  bool_t xdr_rpc_loc_ni_vx_requester_id_s_type (XDR *, rpc_loc_ni_vx_requester_id_s_type*);
extern  bool_t xdr_rpc_loc_ni_vx_notify_verify_req_s_type (XDR *, rpc_loc_ni_vx_notify_verify_req_s_type*);
extern  bool_t xdr_rpc_loc_ni_supl_pos_method_e_type (XDR *, rpc_loc_ni_supl_pos_method_e_type*);
extern  bool_t xdr_rpc_loc_ni_supl_slp_session_id_s_type (XDR *, rpc_loc_ni_supl_slp_session_id_s_type*);
extern  bool_t xdr_rpc_loc_ni_requestor_id_s_type (XDR *, rpc_loc_ni_requestor_id_s_type*);
extern  bool_t xdr_rpc_loc_ni_supl_client_name_s_type (XDR *, rpc_loc_ni_supl_client_name_s_type*);
extern  bool_t xdr_rpc_loc_ni_supl_qop_s_type (XDR *, rpc_loc_ni_supl_qop_s_type*);
extern  bool_t xdr_rpc_loc_ni_supl_notify_verify_req_s_type (XDR *, rpc_loc_ni_supl_notify_verify_req_s_type*);
extern  bool_t xdr_rpc_loc_ni_ext_client_address_s_type (XDR *, rpc_loc_ni_ext_client_address_s_type*);
extern  bool_t xdr_rpc_loc_ni_location_type_e_type (XDR *, rpc_loc_ni_location_type_e_type*);
extern  bool_t xdr_rpc_loc_ni_deferred_location_s_type (XDR *, rpc_loc_ni_deferred_location_s_type*);
extern  bool_t xdr_rpc_loc_ni_codeword_string_s_type (XDR *, rpc_loc_ni_codeword_string_s_type*);
extern  bool_t xdr_rpc_loc_ni_service_type_id_s_type (XDR *, rpc_loc_ni_service_type_id_s_type*);
extern  bool_t xdr_rpc_loc_ni_umts_cp_notify_verify_req_s_type (XDR *, rpc_loc_ni_umts_cp_notify_verify_req_s_type*);
extern  bool_t xdr_rpc_loc_ni_service_interaction_e_type (XDR *, rpc_loc_ni_service_interaction_e_type*);
extern  bool_t xdr_rpc_loc_ni_vx_service_interaction_req_s_type (XDR *, rpc_loc_ni_vx_service_interaction_req_s_type*);
extern  bool_t xdr_rpc_loc_ni_event_payload_u_type (XDR *, rpc_loc_ni_event_payload_u_type*);
extern  bool_t xdr_rpc_loc_ni_event_s_type (XDR *, rpc_loc_ni_event_s_type*);
extern  bool_t xdr_rpc_loc_assist_data_request_e_type (XDR *, rpc_loc_assist_data_request_e_type*);
extern  bool_t xdr_rpc_struct_loc_time_download_source_s_type_servers_ptr (XDR *, rpc_struct_loc_time_download_source_s_type_servers_ptr*);
extern  bool_t xdr_rpc_struct_loc_time_download_source_s_type_servers (XDR *, rpc_struct_loc_time_download_source_s_type_servers);
extern  bool_t xdr_rpc_loc_time_download_source_s_type (XDR *, rpc_loc_time_download_source_s_type*);
extern  bool_t xdr_rpc_struct_loc_predicted_orbits_data_source_s_type_servers_ptr (XDR *, rpc_struct_loc_predicted_orbits_data_source_s_type_servers_ptr*);
extern  bool_t xdr_rpc_struct_loc_predicted_orbits_data_source_s_type_servers (XDR *, rpc_struct_loc_predicted_orbits_data_source_s_type_servers);
extern  bool_t xdr_rpc_loc_predicted_orbits_data_source_s_type (XDR *, rpc_loc_predicted_orbits_data_source_s_type*);
extern  bool_t xdr_rpc_loc_assist_data_request_payload_u_type (XDR *, rpc_loc_assist_data_request_payload_u_type*);
extern  bool_t xdr_rpc_loc_assist_data_request_s_type (XDR *, rpc_loc_assist_data_request_s_type*);
extern  bool_t xdr_rpc_loc_server_connection_handle (XDR *, rpc_loc_server_connection_handle*);
extern  bool_t xdr_rpc_loc_server_protocol_e_type (XDR *, rpc_loc_server_protocol_e_type*);
extern  bool_t xdr_rpc_loc_server_request_e_type (XDR *, rpc_loc_server_request_e_type*);
extern  bool_t xdr_rpc_loc_server_open_req_s_type (XDR *, rpc_loc_server_open_req_s_type*);
extern  bool_t xdr_rpc_loc_server_close_req_s_type (XDR *, rpc_loc_server_close_req_s_type*);
extern  bool_t xdr_rpc_loc_server_request_u_type (XDR *, rpc_loc_server_request_u_type*);
extern  bool_t xdr_rpc_loc_server_request_s_type (XDR *, rpc_loc_server_request_s_type*);
extern  bool_t xdr_rpc_loc_qwip_request_e_type (XDR *, rpc_loc_qwip_request_e_type*);
extern  bool_t xdr_rpc_loc_qwip_request_s_type (XDR *, rpc_loc_qwip_request_s_type*);
extern  bool_t xdr_rpc_loc_reserved_payload_s_type (XDR *, rpc_loc_reserved_payload_s_type*);
extern  bool_t xdr_rpc_loc_ioctl_e_type (XDR *, rpc_loc_ioctl_e_type*);
extern  bool_t xdr_rpc_loc_api_version_s_type (XDR *, rpc_loc_api_version_s_type*);
extern  bool_t xdr_rpc_loc_fix_recurrence_e_type (XDR *, rpc_loc_fix_recurrence_e_type*);
extern  bool_t xdr_rpc_loc_operation_mode_e_type (XDR *, rpc_loc_operation_mode_e_type*);
extern  bool_t xdr_rpc_loc_notify_e_type (XDR *, rpc_loc_notify_e_type*);
extern  bool_t xdr_rpc_loc_fix_criteria_s_type (XDR *, rpc_loc_fix_criteria_s_type*);
extern  bool_t xdr_rpc_loc_ni_user_resp_e_type (XDR *, rpc_loc_ni_user_resp_e_type*);
extern  bool_t xdr_rpc_loc_user_verify_s_type (XDR *, rpc_loc_user_verify_s_type*);
extern  bool_t xdr_rpc_loc_predicted_orbits_data_format_e_type (XDR *, rpc_loc_predicted_orbits_data_format_e_type*);
extern  bool_t xdr_rpc_loc_predicted_orbits_data_s_type (XDR *, rpc_loc_predicted_orbits_data_s_type*);
extern  bool_t xdr_rpc_loc_predicted_orbits_data_validity_report_s_type (XDR *, rpc_loc_predicted_orbits_data_validity_report_s_type*);
extern  bool_t xdr_rpc_loc_predicted_orbits_auto_download_config_s_type (XDR *, rpc_loc_predicted_orbits_auto_download_config_s_type*);
extern  bool_t xdr_rpc_loc_assist_data_time_s_type (XDR *, rpc_loc_assist_data_time_s_type*);
extern  bool_t xdr_rpc_loc_assist_pos_valid_mask_type (XDR *, rpc_loc_assist_pos_valid_mask_type*);
extern  bool_t xdr_rpc_loc_assist_data_pos_s_type (XDR *, rpc_loc_assist_data_pos_s_type*);
extern  bool_t xdr_rpc_loc_server_open_status_e_type (XDR *, rpc_loc_server_open_status_e_type*);
extern  bool_t xdr_rpc_loc_server_open_status_s_type (XDR *, rpc_loc_server_open_status_s_type*);
extern  bool_t xdr_rpc_loc_server_close_status_e_type (XDR *, rpc_loc_server_close_status_e_type*);
extern  bool_t xdr_rpc_loc_server_close_status_s_type (XDR *, rpc_loc_server_close_status_s_type*);
extern  bool_t xdr_rpc_loc_wiper_fix_time_s_type (XDR *, rpc_loc_wiper_fix_time_s_type*);
extern  bool_t xdr_rpc_loc_wiper_fix_pos_s_type (XDR *, rpc_loc_wiper_fix_pos_s_type*);
extern  bool_t xdr_rpc_loc_wiper_ap_info_s_type (XDR *, rpc_loc_wiper_ap_info_s_type*);
extern  bool_t xdr_rpc_loc_wiper_ap_set_s_type (XDR *, rpc_loc_wiper_ap_set_s_type*);
extern  bool_t xdr_rpc_loc_wiper_position_report_s_type (XDR *, rpc_loc_wiper_position_report_s_type*);
extern  bool_t xdr_rpc_loc_wiper_status_e_type (XDR *, rpc_loc_wiper_status_e_type*);
extern  bool_t xdr_rpc_loc_fs_operation_e_type (XDR *, rpc_loc_fs_operation_e_type*);
extern  bool_t xdr_rpc_loc_efs_data_s_type (XDR *, rpc_loc_efs_data_s_type*);
extern  bool_t xdr_rpc_loc_lock_e_type (XDR *, rpc_loc_lock_e_type*);
extern  bool_t xdr_rpc_loc_nmea_sentence_type (XDR *, rpc_loc_nmea_sentence_type*);
extern  bool_t xdr_rpc_loc_assist_data_type (XDR *, rpc_loc_assist_data_type*);
extern  bool_t xdr_rpc_loc_assist_data_delete_s_type (XDR *, rpc_loc_assist_data_delete_s_type*);
extern  bool_t xdr_rpc_loc_ioctl_data_u_type (XDR *, rpc_loc_ioctl_data_u_type*);
extern  bool_t xdr_rpc_loc_ioctl_callback_data_u_type (XDR *, rpc_loc_ioctl_callback_data_u_type*);
extern  bool_t xdr_rpc_loc_ioctl_callback_s_type (XDR *, rpc_loc_ioctl_callback_s_type*);
extern  bool_t xdr_rpc_loc_event_payload_u_type (XDR *, rpc_loc_event_payload_u_type*);

#else /* K&R C */
extern bool_t xdr_rpc_boolean ();
extern bool_t xdr_rpc_uint32 ();
extern bool_t xdr_rpc_uint16 ();
extern bool_t xdr_rpc_uint8 ();
extern bool_t xdr_rpc_int32 ();
extern bool_t xdr_rpc_byte ();
extern bool_t xdr_rpc_uint64 ();
extern bool_t xdr_rpc_loc_client_handle_type ();
extern bool_t xdr_rpc_loc_event_mask_type ();
extern bool_t xdr_rpc_loc_position_valid_mask_type ();
extern bool_t xdr_rpc_loc_pos_technology_mask_type ();
extern bool_t xdr_rpc_loc_session_status_e_type ();
extern bool_t xdr_rpc_loc_calendar_time_s_type ();
extern bool_t xdr_rpc_loc_parsed_position_s_type ();
extern bool_t xdr_rpc_loc_sv_system_e_type ();
extern bool_t xdr_rpc_loc_sv_status_e_type ();
extern bool_t xdr_rpc_loc_sv_info_valid_mask_type ();
extern bool_t xdr_rpc_loc_sv_info_s_type ();
extern bool_t xdr_rpc_loc_gnss_info_valid_mask_type ();
extern bool_t xdr_rpc_loc_gnss_info_s_type ();
extern bool_t xdr_rpc_loc_nmea_report_s_type ();
extern bool_t xdr_rpc_loc_status_event_e_type ();
extern bool_t xdr_rpc_loc_engine_state_e_type ();
extern bool_t xdr_rpc_loc_fix_session_state_e_type ();
extern bool_t xdr_rpc_loc_status_event_payload_u_type ();
extern bool_t xdr_rpc_loc_status_event_s_type ();
extern bool_t xdr_rpc_loc_server_addr_e_type ();
extern bool_t xdr_rpc_loc_server_addr_ipv4_type ();
extern bool_t xdr_rpc_loc_server_addr_url_type ();
extern bool_t xdr_rpc_loc_server_addr_u_type ();
extern bool_t xdr_rpc_loc_server_info_s_type ();
extern bool_t xdr_rpc_loc_ni_notify_verify_e_type ();
extern bool_t xdr_rpc_loc_ni_event_e_type ();
extern bool_t xdr_rpc_loc_ni_datacoding_scheme_e_type ();
extern bool_t xdr_rpc_loc_ni_vx_requester_id_encoding_scheme_e_type ();
extern bool_t xdr_rpc_loc_ni_vx_pos_mode_e_type ();
extern bool_t xdr_rpc_loc_ni_vx_requester_id_s_type ();
extern bool_t xdr_rpc_loc_ni_vx_notify_verify_req_s_type ();
extern bool_t xdr_rpc_loc_ni_supl_pos_method_e_type ();
extern bool_t xdr_rpc_loc_ni_supl_slp_session_id_s_type ();
extern bool_t xdr_rpc_loc_ni_requestor_id_s_type ();
extern bool_t xdr_rpc_loc_ni_supl_client_name_s_type ();
extern bool_t xdr_rpc_loc_ni_supl_qop_s_type ();
extern bool_t xdr_rpc_loc_ni_supl_notify_verify_req_s_type ();
extern bool_t xdr_rpc_loc_ni_ext_client_address_s_type ();
extern bool_t xdr_rpc_loc_ni_location_type_e_type ();
extern bool_t xdr_rpc_loc_ni_deferred_location_s_type ();
extern bool_t xdr_rpc_loc_ni_codeword_string_s_type ();
extern bool_t xdr_rpc_loc_ni_service_type_id_s_type ();
extern bool_t xdr_rpc_loc_ni_umts_cp_notify_verify_req_s_type ();
extern bool_t xdr_rpc_loc_ni_service_interaction_e_type ();
extern bool_t xdr_rpc_loc_ni_vx_service_interaction_req_s_type ();
extern bool_t xdr_rpc_loc_ni_event_payload_u_type ();
extern bool_t xdr_rpc_loc_ni_event_s_type ();
extern bool_t xdr_rpc_loc_assist_data_request_e_type ();
extern bool_t xdr_rpc_struct_loc_time_download_source_s_type_servers_ptr ();
extern bool_t xdr_rpc_struct_loc_time_download_source_s_type_servers ();
extern bool_t xdr_rpc_loc_time_download_source_s_type ();
extern bool_t xdr_rpc_struct_loc_predicted_orbits_data_source_s_type_servers_ptr ();
extern bool_t xdr_rpc_struct_loc_predicted_orbits_data_source_s_type_servers ();
extern bool_t xdr_rpc_loc_predicted_orbits_data_source_s_type ();
extern bool_t xdr_rpc_loc_assist_data_request_payload_u_type ();
extern bool_t xdr_rpc_loc_assist_data_request_s_type ();
extern bool_t xdr_rpc_loc_server_connection_handle ();
extern bool_t xdr_rpc_loc_server_protocol_e_type ();
extern bool_t xdr_rpc_loc_server_request_e_type ();
extern bool_t xdr_rpc_loc_server_open_req_s_type ();
extern bool_t xdr_rpc_loc_server_close_req_s_type ();
extern bool_t xdr_rpc_loc_server_request_u_type ();
extern bool_t xdr_rpc_loc_server_request_s_type ();
extern bool_t xdr_rpc_loc_qwip_request_e_type ();
extern bool_t xdr_rpc_loc_qwip_request_s_type ();
extern bool_t xdr_rpc_loc_reserved_payload_s_type ();
extern bool_t xdr_rpc_loc_ioctl_e_type ();
extern bool_t xdr_rpc_loc_api_version_s_type ();
extern bool_t xdr_rpc_loc_fix_recurrence_e_type ();
extern bool_t xdr_rpc_loc_operation_mode_e_type ();
extern bool_t xdr_rpc_loc_notify_e_type ();
extern bool_t xdr_rpc_loc_fix_criteria_s_type ();
extern bool_t xdr_rpc_loc_ni_user_resp_e_type ();
extern bool_t xdr_rpc_loc_user_verify_s_type ();
extern bool_t xdr_rpc_loc_predicted_orbits_data_format_e_type ();
extern bool_t xdr_rpc_loc_predicted_orbits_data_s_type ();
extern bool_t xdr_rpc_loc_predicted_orbits_data_validity_report_s_type ();
extern bool_t xdr_rpc_loc_predicted_orbits_auto_download_config_s_type ();
extern bool_t xdr_rpc_loc_assist_data_time_s_type ();
extern bool_t xdr_rpc_loc_assist_pos_valid_mask_type ();
extern bool_t xdr_rpc_loc_assist_data_pos_s_type ();
extern bool_t xdr_rpc_loc_server_open_status_e_type ();
extern bool_t xdr_rpc_loc_server_open_status_s_type ();
extern bool_t xdr_rpc_loc_server_close_status_e_type ();
extern bool_t xdr_rpc_loc_server_close_status_s_type ();
extern bool_t xdr_rpc_loc_wiper_fix_time_s_type ();
extern bool_t xdr_rpc_loc_wiper_fix_pos_s_type ();
extern bool_t xdr_rpc_loc_wiper_ap_info_s_type ();
extern bool_t xdr_rpc_loc_wiper_ap_set_s_type ();
extern bool_t xdr_rpc_loc_wiper_position_report_s_type ();
extern bool_t xdr_rpc_loc_wiper_status_e_type ();
extern bool_t xdr_rpc_loc_fs_operation_e_type ();
extern bool_t xdr_rpc_loc_efs_data_s_type ();
extern bool_t xdr_rpc_loc_lock_e_type ();
extern bool_t xdr_rpc_loc_nmea_sentence_type ();
extern bool_t xdr_rpc_loc_assist_data_type ();
extern bool_t xdr_rpc_loc_assist_data_delete_s_type ();
extern bool_t xdr_rpc_loc_ioctl_data_u_type ();
extern bool_t xdr_rpc_loc_ioctl_callback_data_u_type ();
extern bool_t xdr_rpc_loc_ioctl_callback_s_type ();
extern bool_t xdr_rpc_loc_event_payload_u_type ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_LOC_API_COMMON_H_RPCGEN */
