/*******************************************************************
 * morpho_hdr_checker.h
 * [CP932/CRLF] {  p }
 *------------------------------------------------------------------
 * Copyright (C) 2011-2012 Morpho,Inc.
 *******************************************************************/

#ifndef MORPHO_HDR_CHECKER_H
#define MORPHO_HDR_CHECKER_H

/*******************************************************************/

#include "morpho_api.h"
#include "morpho_error.h"
#include "morpho_image_data.h"

/*******************************************************************/

#define MORPHO_HDR_CHECKER_VER "Morpho DR Checker Ver.1.1.0 2012/1/17"

/*-----------------------------------------------------------------*/

#define MORPHO_HDR_CHECKER_MIN_IMAGE_WIDTH     2
#define MORPHO_HDR_CHECKER_MAX_IMAGE_WIDTH  8192
#define MORPHO_HDR_CHECKER_MIN_IMAGE_HEIGHT    2
#define MORPHO_HDR_CHECKER_MAX_IMAGE_HEIGHT 8192

/*******************************************************************/

typedef struct _morpho_HDRChecker morpho_HDRChecker;

/* HDRwW] */
struct _morpho_HDRChecker
{
    void *p; /**< \̂ւ̃|C^ */
};

/* сEԂꔻ̕qx */
typedef enum {
    MORPHO_HDR_CHECKER_SENSITIVITY_SENSITIVE,
    MORPHO_HDR_CHECKER_SENSITIVITY_NORMAL,
    MORPHO_HDR_CHECKER_SENSITIVITY_INSENSITIVE,
} MORPHO_HDR_CHECKER_SENSITIVITY;

/*******************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/**
 * o[W擾
 *
 * @return o[W(MORPHO_EASY_HDR_VER)
 */
MORPHO_API(const char*)
morpho_HDRChecker_getVersion(void);

/**
 * KvȃTCY擾
 *
 * @param[in] width  ͉摜̕
 * @param[in] height ͉摜̍
 * @param[in] format ͉摜̃tH[}bg
 * @return KvȃTCY(byte)
 */
MORPHO_API(int)
morpho_HDRChecker_getBufferSize(
    int width,
    int height,
    const char *format);

/**
 * 
 *
 * @param[in,out] p           HDRCheckerCX^X
 * @param[in]     buffer      HDRCheckerɊ蓖Ă郁ւ̃|C^
 * @param[in]     buffer_size HDRCheckerɊ蓖Ă郁̃TCY
 * @param[in]     width       ͉摜̕
 * @param[in]     height      ͉摜̍
 * @param[in]     format      ͉摜̃tH[}bg
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_HDRChecker_initialize(
    morpho_HDRChecker * const p,
    void * const buffer,
    const int buffer_size,
    const int width,
    const int height,
    const char *format);

/**
 * N[Abv
 * initialize()sɎs\
 *
 * @param[in,out] p HDRCheckerCX^X
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_HDRChecker_finalize(
    morpho_HDRChecker *p);

/*-----------------------------------------------------------------*/

/**
 * HDRwWvZ̕q̐ݒ
 * initialize()sɎs\
 *
 * @param[in,out] p           HDRCheckerCX^X
 * @param[in]     sensitivity q(MORPHO_HDR_CHECKER_SENSITIVIY񋓑̂Ŏw)
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_HDRChecker_setSensitivity(
    morpho_HDRChecker * const p,
    MORPHO_HDR_CHECKER_SENSITIVITY sensitivity);

/**
 * HDRwWvZ̕q̎擾
 * initialize()sɎs\
 *
 * @param[in,out] p           HDRCheckerCX^X
 * @param[out]    sensitivity qւ̃|C^
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_HDRChecker_getSensitivity(
    morpho_HDRChecker * const p,
    MORPHO_HDR_CHECKER_SENSITIVITY *sensitivity);

/**
 * HDRwW̕]
 * initialize()sɎs\
 *
 * @param[in,out] p      HDRCheckerCX^X
 * @param[out]    result ]ʂi[z(vf4̔z)
 *                       vf[̏ꍇɑΉ鉺L̘Iỏ摜KvƔ
 *                       {+2, +1, -1, -2}̏ɔ茋ʂi[
 * @param[in]     input_image ͉摜
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_HDRChecker_evaluate(
    morpho_HDRChecker * const p,
    int * const result,
    const morpho_ImageData * const input_image);

/*-----------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* MORPHO_HDR_CHECKER_H */
