// $Id: XmiReferenceResolverImpl.java,v 1.8 2005/09/08 06:24:35 tfmorris Exp $
// Copyright (c) 2005 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies. This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason. IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.model.mdr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;

import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.lib.jmi.xmi.XmiContext;

/**
 * Custom 'resolver' to use with XMI reader.
 * 
 * All it really does is record the xmi.id's as they come in and then delegate
 * to the default MDR implementation for the actual resolution.
 * 
 * @author Tom Morris
 * 
 */
public class XmiReferenceResolverImpl extends XmiContext {

    private Map idToObjects = Collections.synchronizedMap(new HashMap());

    /**
     * @see org.netbeans.api.xmi.XMIReferenceResolver
     */
    public XmiReferenceResolverImpl(RefPackage[] extents, 
            XMIInputConfig config) {
        super(extents, config);
    }

    /**
     * Save registered ID in our object map
     * 
     * @param systemId
     *            URL of XMI field
     * @param xmiId
     *            xmi.id string for current object
     * @param object
     *            referenced object
     */
    public void register(String systemId, String xmiId, RefObject object) {
        super.register(systemId, xmiId, object);
        if (!idToObjects.containsKey(xmiId)) {
            idToObjects.put(xmiId, object);
        }
    }

    /**
     * Return complete map for all registered objects
     * 
     * @return map of xmi.id to RefObject correspondances
     */
    public Map getIdToObjectMap() {
        return idToObjects;
    }

}
