// $Id: AbstractActionNewModelElement.java,v 1.15 2005/01/09 14:59:01 linus Exp $
// Copyright (c) 1996-2005 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

// $Id: AbstractActionNewModelElement.java,v 1.15 2005/01/09 14:59:01 linus Exp $
package org.argouml.uml.ui;

import org.argouml.i18n.Translator;

/**
 * @since Oct 3, 2002
 * @author jaap.branderhorst@xs4all.nl
 */
public abstract class AbstractActionNewModelElement extends UMLAction {

    private Object/*MModelElement*/ target;

    /**
     * The constructor.
     * Defaults to name "action.new", global and NO_ICON
     */
    protected AbstractActionNewModelElement() {
        super(Translator.localize("action.new"), true, NO_ICON);
    }

    /**
     * The constructor.
     *
     * @param name the to be localized name of the action
     */
    protected AbstractActionNewModelElement(String name) {
        super(name, true, HAS_ICON);
    }

     /**
     * Returns the target.
     * @return MModelElement
     */
    public Object/*MModelElement*/ getTarget() {
        return target;
    }

    /**
     * Sets the target.
     * @param theTarget The target to set
     */
    public void setTarget(Object theTarget) {
        target = theTarget;
    }

}
