/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConditionalExpression
extends OperatorExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ConditionalExpression(Expression condition, Expression valueIfTrue, Expression valueIfFalse) {
        this.condition = condition;
        this.valueIfTrue = valueIfTrue;
        this.valueIfFalse = valueIfFalse;
        this.sourceStart = condition.sourceStart;
        this.sourceEnd = valueIfFalse.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo mergedInfo;
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != ASTNode.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != ASTNode.NotAConstant && !cst.booleanValue();
        int mode = flowInfo.reachMode();
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo, cst == ASTNode.NotAConstant);
        FlowInfo trueFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            trueFlowInfo.setReachMode(1);
        }
        this.trueInitStateIndex = currentScope.methodScope().recordInitializationStates(trueFlowInfo);
        trueFlowInfo = this.valueIfTrue.analyseCode(currentScope, flowContext, trueFlowInfo);
        FlowInfo falseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            falseFlowInfo.setReachMode(1);
        }
        this.falseInitStateIndex = currentScope.methodScope().recordInitializationStates(falseFlowInfo);
        falseFlowInfo = this.valueIfFalse.analyseCode(currentScope, flowContext, falseFlowInfo);
        if (isConditionOptimizedTrue) {
            mergedInfo = trueFlowInfo.addPotentialInitializationsFrom(falseFlowInfo);
        } else if (isConditionOptimizedFalse) {
            mergedInfo = falseFlowInfo.addPotentialInitializationsFrom(trueFlowInfo);
        } else {
            cst = this.optimizedIfTrueConstant;
            boolean isValueIfTrueOptimizedTrue = cst != null && cst != ASTNode.NotAConstant && cst.booleanValue();
            boolean isValueIfTrueOptimizedFalse = cst != null && cst != ASTNode.NotAConstant && !cst.booleanValue();
            cst = this.optimizedIfFalseConstant;
            boolean isValueIfFalseOptimizedTrue = cst != null && cst != ASTNode.NotAConstant && cst.booleanValue();
            boolean isValueIfFalseOptimizedFalse = cst != null && cst != ASTNode.NotAConstant && !cst.booleanValue();
            UnconditionalFlowInfo trueInfoWhenTrue = trueFlowInfo.initsWhenTrue().copy().unconditionalInits();
            if (isValueIfTrueOptimizedFalse) {
                trueInfoWhenTrue.setReachMode(1);
            }
            UnconditionalFlowInfo falseInfoWhenTrue = falseFlowInfo.initsWhenTrue().copy().unconditionalInits();
            if (isValueIfFalseOptimizedFalse) {
                falseInfoWhenTrue.setReachMode(1);
            }
            UnconditionalFlowInfo trueInfoWhenFalse = trueFlowInfo.initsWhenFalse().copy().unconditionalInits();
            if (isValueIfTrueOptimizedTrue) {
                trueInfoWhenFalse.setReachMode(1);
            }
            UnconditionalFlowInfo falseInfoWhenFalse = falseFlowInfo.initsWhenFalse().copy().unconditionalInits();
            if (isValueIfFalseOptimizedTrue) {
                falseInfoWhenFalse.setReachMode(1);
            }
            mergedInfo = FlowInfo.conditional(trueInfoWhenTrue.mergedWith(falseInfoWhenTrue), trueInfoWhenFalse.mergedWith(falseInfoWhenFalse));
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        mergedInfo.setReachMode(mode);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != ASTNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
            return;
        }
        Constant cst = this.condition.constant;
        Constant condCst = this.condition.optimizedBooleanConstant();
        boolean needTruePart = !(cst != ASTNode.NotAConstant && !cst.booleanValue() || condCst != ASTNode.NotAConstant && !condCst.booleanValue());
        boolean needFalsePart = !(cst != ASTNode.NotAConstant && cst.booleanValue() || condCst != ASTNode.NotAConstant && condCst.booleanValue());
        Label endifLabel = new Label(codeStream);
        boolean needConditionValue = cst == ASTNode.NotAConstant && condCst == ASTNode.NotAConstant;
        Label falseLabel = new Label(codeStream);
        this.condition.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, needConditionValue);
        if (this.trueInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
        }
        if (needTruePart) {
            this.valueIfTrue.generateCode(currentScope, codeStream, valueRequired);
            if (needFalsePart) {
                int position = codeStream.position;
                codeStream.goto_(endifLabel);
                codeStream.updateLastRecordedEndPC(currentScope, position);
                if (valueRequired) {
                    codeStream.decrStackSize(this.resolvedType == BaseTypes.LongBinding || this.resolvedType == BaseTypes.DoubleBinding ? 2 : 1);
                }
            }
        }
        if (needFalsePart) {
            falseLabel.place();
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
            }
            this.valueIfFalse.generateCode(currentScope, codeStream, valueRequired);
            endifLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, Label trueLabel, Label falseLabel, boolean valueRequired) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5 || (this.valueIfTrue.implicitConversion & 0xFF) >> 4 != 5) {
            super.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            return;
        }
        Constant cst = this.condition.constant;
        Constant condCst = this.condition.optimizedBooleanConstant();
        boolean needTruePart = !(cst != ASTNode.NotAConstant && !cst.booleanValue() || condCst != ASTNode.NotAConstant && !condCst.booleanValue());
        boolean needFalsePart = !(cst != ASTNode.NotAConstant && cst.booleanValue() || condCst != ASTNode.NotAConstant && condCst.booleanValue());
        Label endifLabel = new Label(codeStream);
        boolean needConditionValue = cst == ASTNode.NotAConstant && condCst == ASTNode.NotAConstant;
        Label internalFalseLabel = new Label(codeStream);
        this.condition.generateOptimizedBoolean(currentScope, codeStream, null, internalFalseLabel, needConditionValue);
        if (this.trueInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.trueInitStateIndex);
        }
        if (needTruePart) {
            this.valueIfTrue.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            if (needFalsePart) {
                int position = codeStream.position;
                codeStream.goto_(endifLabel);
                codeStream.updateLastRecordedEndPC(currentScope, position);
            }
        }
        if (needFalsePart) {
            internalFalseLabel.place();
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.falseInitStateIndex);
            }
            this.valueIfFalse.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel, valueRequired);
            endifLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.updateLastRecordedEndPC(currentScope, codeStream.position);
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.condition.printExpression(indent, output).append(" ? ");
        this.valueIfTrue.printExpression(0, output).append(" : ");
        return this.valueIfFalse.printExpression(0, output);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypeBinding resolveType(BlockScope scope) {
        Constant falseConstant;
        Constant trueConstant;
        Constant condConstant;
        TypeBinding valueIfFalseType;
        TypeBinding valueIfTrueType;
        TypeBinding originalValueIfFalseType;
        TypeBinding originalValueIfTrueType;
        boolean use15specifics;
        LookupEnvironment env;
        block36: {
            TypeBinding unboxedIfTrueType;
            block39: {
                block37: {
                    TypeBinding unboxedIfFalseType;
                    block38: {
                        this.constant = ASTNode.NotAConstant;
                        env = scope.environment();
                        use15specifics = scope.compilerOptions().sourceLevel >= 0x310000L;
                        TypeBinding conditionType = this.condition.resolveTypeExpecting(scope, BaseTypes.BooleanBinding);
                        this.condition.computeConversion(scope, BaseTypes.BooleanBinding, conditionType);
                        if (this.valueIfTrue instanceof CastExpression) {
                            this.valueIfTrue.bits |= 0x20;
                        }
                        originalValueIfTrueType = this.valueIfTrue.resolveType(scope);
                        if (this.valueIfFalse instanceof CastExpression) {
                            this.valueIfFalse.bits |= 0x20;
                        }
                        originalValueIfFalseType = this.valueIfFalse.resolveType(scope);
                        if (conditionType == null || originalValueIfTrueType == null || originalValueIfFalseType == null) {
                            return null;
                        }
                        valueIfTrueType = originalValueIfTrueType;
                        valueIfFalseType = originalValueIfFalseType;
                        if (!use15specifics || valueIfTrueType == valueIfFalseType) break block36;
                        if (!valueIfTrueType.isBaseType()) break block37;
                        if (!valueIfFalseType.isBaseType()) break block38;
                        if (valueIfTrueType == BaseTypes.NullBinding) {
                            valueIfFalseType = env.computeBoxingType(valueIfFalseType);
                            break block36;
                        } else if (valueIfFalseType == BaseTypes.NullBinding) {
                            valueIfTrueType = env.computeBoxingType(valueIfTrueType);
                        }
                        break block36;
                    }
                    TypeBinding typeBinding = unboxedIfFalseType = valueIfFalseType.isBaseType() ? valueIfFalseType : env.computeBoxingType(valueIfFalseType);
                    if (valueIfTrueType.isNumericType() && unboxedIfFalseType.isNumericType()) {
                        valueIfFalseType = unboxedIfFalseType;
                        break block36;
                    } else if (valueIfTrueType != BaseTypes.NullBinding) {
                        valueIfFalseType = env.computeBoxingType(valueIfFalseType);
                    }
                    break block36;
                }
                if (!valueIfFalseType.isBaseType()) break block39;
                TypeBinding typeBinding = unboxedIfTrueType = valueIfTrueType.isBaseType() ? valueIfTrueType : env.computeBoxingType(valueIfTrueType);
                if (unboxedIfTrueType.isNumericType() && valueIfFalseType.isNumericType()) {
                    valueIfTrueType = unboxedIfTrueType;
                    break block36;
                } else if (valueIfFalseType != BaseTypes.NullBinding) {
                    valueIfTrueType = env.computeBoxingType(valueIfTrueType);
                }
                break block36;
            }
            unboxedIfTrueType = env.computeBoxingType(valueIfTrueType);
            TypeBinding unboxedIfFalseType = env.computeBoxingType(valueIfFalseType);
            if (unboxedIfTrueType.isNumericType() && unboxedIfFalseType.isNumericType()) {
                valueIfTrueType = unboxedIfTrueType;
                valueIfFalseType = unboxedIfFalseType;
            }
        }
        if ((condConstant = this.condition.constant) != ASTNode.NotAConstant && (trueConstant = this.valueIfTrue.constant) != ASTNode.NotAConstant && (falseConstant = this.valueIfFalse.constant) != ASTNode.NotAConstant) {
            Constant constant = this.constant = condConstant.booleanValue() ? trueConstant : falseConstant;
        }
        if (valueIfTrueType == valueIfFalseType) {
            this.valueIfTrue.computeConversion(scope, valueIfTrueType, originalValueIfTrueType);
            this.valueIfFalse.computeConversion(scope, valueIfFalseType, originalValueIfFalseType);
            if (valueIfTrueType == BaseTypes.BooleanBinding) {
                this.optimizedIfTrueConstant = this.valueIfTrue.optimizedBooleanConstant();
                this.optimizedIfFalseConstant = this.valueIfFalse.optimizedBooleanConstant();
                if (this.optimizedIfTrueConstant != ASTNode.NotAConstant && this.optimizedIfFalseConstant != ASTNode.NotAConstant && this.optimizedIfTrueConstant.booleanValue() == this.optimizedIfFalseConstant.booleanValue()) {
                    this.optimizedBooleanConstant = this.optimizedIfTrueConstant;
                } else {
                    condConstant = this.condition.optimizedBooleanConstant();
                    if (condConstant != ASTNode.NotAConstant) {
                        this.optimizedBooleanConstant = condConstant.booleanValue() ? this.optimizedIfTrueConstant : this.optimizedIfFalseConstant;
                    }
                }
            }
            this.resolvedType = valueIfTrueType;
            return this.resolvedType;
        }
        if (valueIfTrueType.isNumericType() && valueIfFalseType.isNumericType()) {
            if (valueIfTrueType == BaseTypes.ByteBinding && valueIfFalseType == BaseTypes.ShortBinding || valueIfTrueType == BaseTypes.ShortBinding && valueIfFalseType == BaseTypes.ByteBinding) {
                this.valueIfTrue.computeConversion(scope, BaseTypes.ShortBinding, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, BaseTypes.ShortBinding, originalValueIfFalseType);
                this.resolvedType = BaseTypes.ShortBinding;
                return this.resolvedType;
            }
            if ((valueIfTrueType == BaseTypes.ByteBinding || valueIfTrueType == BaseTypes.ShortBinding || valueIfTrueType == BaseTypes.CharBinding) && valueIfFalseType == BaseTypes.IntBinding && this.valueIfFalse.isConstantValueOfTypeAssignableToType(valueIfFalseType, valueIfTrueType)) {
                this.valueIfTrue.computeConversion(scope, valueIfTrueType, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, valueIfTrueType, originalValueIfFalseType);
                this.resolvedType = valueIfTrueType;
                return this.resolvedType;
            }
            if ((valueIfFalseType == BaseTypes.ByteBinding || valueIfFalseType == BaseTypes.ShortBinding || valueIfFalseType == BaseTypes.CharBinding) && valueIfTrueType == BaseTypes.IntBinding && this.valueIfTrue.isConstantValueOfTypeAssignableToType(valueIfTrueType, valueIfFalseType)) {
                this.valueIfTrue.computeConversion(scope, valueIfFalseType, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, valueIfFalseType, originalValueIfFalseType);
                this.resolvedType = valueIfFalseType;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 10) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 10)) {
                this.valueIfTrue.computeConversion(scope, BaseTypes.IntBinding, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, BaseTypes.IntBinding, originalValueIfFalseType);
                this.resolvedType = BaseTypes.IntBinding;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 7) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 7)) {
                this.valueIfTrue.computeConversion(scope, BaseTypes.LongBinding, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, BaseTypes.LongBinding, originalValueIfFalseType);
                this.resolvedType = BaseTypes.LongBinding;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(valueIfTrueType.id, 9) && BaseTypeBinding.isNarrowing(valueIfFalseType.id, 9)) {
                this.valueIfTrue.computeConversion(scope, BaseTypes.FloatBinding, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, BaseTypes.FloatBinding, originalValueIfFalseType);
                this.resolvedType = BaseTypes.FloatBinding;
                return this.resolvedType;
            }
            this.valueIfTrue.computeConversion(scope, BaseTypes.DoubleBinding, originalValueIfTrueType);
            this.valueIfFalse.computeConversion(scope, BaseTypes.DoubleBinding, originalValueIfFalseType);
            this.resolvedType = BaseTypes.DoubleBinding;
            return this.resolvedType;
        }
        if (valueIfTrueType.isBaseType() && valueIfTrueType != BaseTypes.NullBinding) {
            if (!use15specifics) {
                scope.problemReporter().conditionalArgumentsIncompatibleTypes(this, valueIfTrueType, valueIfFalseType);
                return null;
            }
            valueIfTrueType = env.computeBoxingType(valueIfTrueType);
        } else if (valueIfFalseType.isBaseType() && valueIfFalseType != BaseTypes.NullBinding) {
            if (!use15specifics) {
                scope.problemReporter().conditionalArgumentsIncompatibleTypes(this, valueIfTrueType, valueIfFalseType);
                return null;
            }
            valueIfFalseType = env.computeBoxingType(valueIfFalseType);
        }
        if (use15specifics) {
            TypeBinding commonType = null;
            commonType = valueIfTrueType == BaseTypes.NullBinding ? valueIfFalseType : (valueIfFalseType == BaseTypes.NullBinding ? valueIfTrueType : scope.lowerUpperBound(new TypeBinding[]{valueIfTrueType, valueIfFalseType}));
            if (commonType != null) {
                this.valueIfTrue.computeConversion(scope, commonType, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, commonType, originalValueIfFalseType);
                this.resolvedType = commonType.capture(scope, this.sourceEnd);
                return this.resolvedType;
            }
        } else {
            if (valueIfFalseType.isCompatibleWith(valueIfTrueType)) {
                this.valueIfTrue.computeConversion(scope, valueIfTrueType, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, valueIfTrueType, originalValueIfFalseType);
                this.resolvedType = valueIfTrueType;
                return this.resolvedType;
            }
            if (valueIfTrueType.isCompatibleWith(valueIfFalseType)) {
                this.valueIfTrue.computeConversion(scope, valueIfFalseType, originalValueIfTrueType);
                this.valueIfFalse.computeConversion(scope, valueIfFalseType, originalValueIfFalseType);
                this.resolvedType = valueIfFalseType;
                return this.resolvedType;
            }
        }
        scope.problemReporter().conditionalArgumentsIncompatibleTypes(this, valueIfTrueType, valueIfFalseType);
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.valueIfTrue.traverse(visitor, scope);
            this.valueIfFalse.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

