/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredLocalVariable
extends RecoveredStatement {
    public LocalDeclaration localDeclaration;
    boolean alreadyCompletedLocalInitialization;

    public RecoveredLocalVariable(LocalDeclaration localDeclaration, RecoveredElement parent, int bracketBalance) {
        super(localDeclaration, parent, bracketBalance);
        this.localDeclaration = localDeclaration;
        this.alreadyCompletedLocalInitialization = localDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement stmt, int bracketBalanceValue) {
        if (this.alreadyCompletedLocalInitialization || !(stmt instanceof Expression)) {
            return super.add(stmt, bracketBalanceValue);
        }
        this.alreadyCompletedLocalInitialization = true;
        this.localDeclaration.initialization = (Expression)stmt;
        this.localDeclaration.declarationSourceEnd = stmt.sourceEnd;
        this.localDeclaration.declarationEnd = stmt.sourceEnd;
        return this;
    }

    public ASTNode parseTree() {
        return this.localDeclaration;
    }

    public int sourceEnd() {
        return this.localDeclaration.declarationSourceEnd;
    }

    public String toString(int tab) {
        return String.valueOf(this.tabString(tab)) + "Recovered local variable:\n" + this.localDeclaration.print(tab + 1, new StringBuffer(10));
    }

    public Statement updatedStatement() {
        return this.localDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.alreadyCompletedLocalInitialization = true;
            }
            return this;
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.localDeclaration.declarationSourceEnd == 0 && this.localDeclaration.type instanceof ArrayTypeReference && !this.alreadyCompletedLocalInitialization) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(braceStart - 1, braceEnd - 1);
        return this.parent.updateOnOpeningBrace(braceStart, braceEnd);
    }

    public void updateParseTree() {
        this.updatedStatement();
    }

    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.localDeclaration.declarationSourceEnd == 0) {
            this.localDeclaration.declarationSourceEnd = bodyEnd;
            this.localDeclaration.declarationEnd = bodyEnd;
        }
    }
}

