/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public boolean inherited = false;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i;
        ASTNode.printIndent(indent, output).append("/**\n");
        if (this.paramReferences != null) {
            i = 0;
            length = this.paramReferences.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @param ");
                this.paramReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.paramTypeParameters != null) {
            i = 0;
            length = this.paramTypeParameters.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @param <");
                this.paramTypeParameters[i].print(indent, output).append(">\n");
                ++i;
            }
        }
        if (this.returnStatement != null) {
            ASTNode.printIndent(indent + 1, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            i = 0;
            length = this.exceptionReferences.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @throws ");
                this.exceptionReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.seeReferences != null) {
            i = 0;
            length = this.seeReferences.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @see");
                this.seeReferences[i].print(indent, output).append('\n');
                ++i;
            }
        }
        ASTNode.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope classScope) {
        int paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
        int i = 0;
        while (i < paramTagsSize) {
            JavadocSingleNameReference param = this.paramReferences[i];
            classScope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
            ++i;
        }
        this.resolveTypeParameterTags(classScope, true);
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        int i2 = 0;
        while (i2 < throwsTagsLength) {
            int end;
            int start;
            TypeReference typeRef = this.exceptionReferences[i2];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(start, end);
            ++i2;
        }
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        int i3 = 0;
        while (i3 < seeTagsLength) {
            this.resolveReference(this.seeReferences[i3], classScope);
            ++i3;
        }
    }

    public void resolve(MethodScope methScope) {
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null ? false : (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean superRef = false;
        int i = 0;
        while (i < seeTagsLength) {
            this.resolveReference(this.seeReferences[i], methScope);
            try {
                if (methDecl != null && (methDecl.isConstructor() || overriding) && !superRef) {
                    if (this.seeReferences[i] instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i];
                        if (messageSend.binding != null && messageSend.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(messageSend.actualReceiverType) && CharOperation.equals(messageSend.selector, methDecl.selector) && messageSend.binding.returnType == methDecl.binding.returnType) {
                            if (messageSend.arguments == null && methDecl.arguments == null) {
                                superRef = true;
                            } else if (messageSend.arguments != null && methDecl.arguments != null) {
                                superRef = methDecl.binding.areParametersEqual(messageSend.binding);
                            }
                        }
                    } else if (this.seeReferences[i] instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i];
                        if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(allocationExpr.resolvedType)) {
                            if (allocationExpr.arguments == null && methDecl.arguments == null) {
                                superRef = true;
                            } else if (allocationExpr.arguments != null && methDecl.arguments != null) {
                                superRef = methDecl.binding.areParametersEqual(allocationExpr.binding);
                            }
                        }
                    }
                }
            }
            catch (Exception allocationExpr) {
                // empty catch block
            }
            ++i;
        }
        boolean reportMissing = methDecl == null || (!overriding || !this.inherited) && !superRef && (methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        this.resolveParamTags(methScope, reportMissing);
        this.resolveTypeParameterTags(methScope, reportMissing);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && methDecl.isMethod()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding.returnType != BaseTypes.VoidBinding) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.returnType.sourceStart, meth.returnType.sourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        int i2 = 0;
        while (i2 < length) {
            this.invalidParameters[i2].resolve(methScope, false);
            ++i2;
        }
    }

    private void resolveReference(Expression reference, Scope scope) {
        int modifiers;
        boolean verifyValues;
        switch (scope.kind) {
            case 2: {
                reference.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                reference.resolveType((ClassScope)scope);
            }
        }
        boolean bl = verifyValues = scope.environment().options.sourceLevel >= 0x310000L;
        if (reference instanceof JavadocFieldReference) {
            JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
            int n = modifiers = fieldRef.binding == null ? -1 : fieldRef.binding.modifiers;
            if (fieldRef.methodBinding != null) {
                if (fieldRef.tagValue == 10) {
                    scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, modifiers);
                } else if (fieldRef.receiverType != null) {
                    fieldRef.superAccess = scope.enclosingSourceType().isCompatibleWith(fieldRef.receiverType);
                    fieldRef.methodBinding = scope.findMethod((ReferenceBinding)fieldRef.receiverType, fieldRef.token, new TypeBinding[0], fieldRef);
                }
            } else if (verifyValues && fieldRef.binding != null && fieldRef.binding.isValidBinding() && fieldRef.tagValue == 10 && !fieldRef.binding.isStatic()) {
                scope.problemReporter().javadocInvalidValueReference(fieldRef.sourceStart, fieldRef.sourceEnd, modifiers);
            }
        }
        if (!verifyValues) {
            return;
        }
        if (reference instanceof JavadocMessageSend) {
            JavadocMessageSend msgSend = (JavadocMessageSend)reference;
            int n = modifiers = msgSend.binding == null ? -1 : msgSend.binding.modifiers;
            if (msgSend.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(msgSend.sourceStart, msgSend.sourceEnd, modifiers);
            }
        } else if (reference instanceof JavadocAllocationExpression) {
            JavadocAllocationExpression alloc = (JavadocAllocationExpression)reference;
            int n = modifiers = alloc.binding == null ? -1 : alloc.binding.modifiers;
            if (alloc.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(alloc.sourceStart, alloc.sourceEnd, modifiers);
            }
        }
    }

    private void resolveParamTags(MethodScope methScope, boolean reportMissing) {
        block14: {
            int j;
            boolean found;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration md;
            block13: {
                md = methScope.referenceMethod();
                int n = paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (md == null) {
                    int i = 0;
                    while (i < paramTagsSize) {
                        JavadocSingleNameReference param = this.paramReferences[i];
                        methScope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                        ++i;
                    }
                    return;
                }
                int n2 = argumentsSize = md.arguments == null ? 0 : md.arguments.length;
                if (paramTagsSize != 0) break block13;
                if (!reportMissing) break block14;
                int i = 0;
                while (i < argumentsSize) {
                    Argument arg = md.arguments[i];
                    methScope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, md.binding.modifiers);
                    ++i;
                }
                break block14;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            int i = 0;
            while (i < paramTagsSize) {
                JavadocSingleNameReference param = this.paramReferences[i];
                param.resolve(methScope);
                if (param.binding != null && param.binding.isValidBinding()) {
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        if (bindings[j] == param.binding) {
                            methScope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, md.binding.modifiers);
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        bindings[maxBindings++] = (LocalVariableBinding)param.binding;
                    }
                }
                ++i;
            }
            if (reportMissing) {
                i = 0;
                while (i < argumentsSize) {
                    Argument arg = md.arguments[i];
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding == binding) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        methScope.problemReporter().javadocMissingParamTag(arg.name, arg.sourceStart, arg.sourceEnd, md.binding.modifiers);
                    }
                    ++i;
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean reportMissing) {
        block23: {
            int typeParametersLength;
            TypeParameter[] parameters;
            int modifiers;
            TypeVariableBinding[] typeVariables;
            int paramTypeParamLength;
            block22: {
                paramTypeParamLength = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                TypeDeclaration typeDeclaration = null;
                AbstractMethodDeclaration methodDeclaration = null;
                typeVariables = null;
                modifiers = -1;
                switch (scope.kind) {
                    case 2: {
                        methodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (methodDeclaration == null) {
                            int i = 0;
                            while (i < paramTypeParamLength) {
                                JavadocSingleNameReference param = this.paramReferences[i];
                                scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                                ++i;
                            }
                            return;
                        }
                        typeVariables = methodDeclaration.binding.typeVariables;
                        modifiers = methodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        typeDeclaration = ((ClassScope)scope).referenceContext;
                        typeVariables = typeDeclaration.binding.typeVariables;
                        modifiers = typeDeclaration.binding.modifiers;
                    }
                }
                if (typeVariables == null || typeVariables.length == 0) {
                    int i = 0;
                    while (i < paramTypeParamLength) {
                        JavadocSingleTypeReference param = this.paramTypeParameters[i];
                        scope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                        ++i;
                    }
                    return;
                }
                parameters = typeDeclaration == null ? methodDeclaration.typeParameters() : typeDeclaration.typeParameters;
                int n = typeParametersLength = parameters == null ? 0 : parameters.length;
                if (paramTypeParamLength != 0) break block22;
                if (!reportMissing) break block23;
                int i = 0;
                int l = parameters.length;
                while (i < l) {
                    scope.problemReporter().javadocMissingParamTag(parameters[i].name, parameters[i].sourceStart, parameters[i].sourceEnd, modifiers);
                    ++i;
                }
                break block23;
            }
            if (typeVariables.length == typeParametersLength) {
                TypeVariableBinding[] bindings = new TypeVariableBinding[paramTypeParamLength];
                int maxBindings = 0;
                int i = 0;
                while (i < paramTypeParamLength) {
                    JavadocSingleTypeReference param = this.paramTypeParameters[i];
                    TypeBinding paramBindind = param.internalResolveType(scope);
                    if (paramBindind != null && paramBindind.isValidBinding()) {
                        if (paramBindind.isTypeVariable()) {
                            boolean duplicate = false;
                            int j = 0;
                            while (j < maxBindings && !duplicate) {
                                if (bindings[j] == param.resolvedType) {
                                    scope.problemReporter().javadocDuplicatedParamTag(param.token, param.sourceStart, param.sourceEnd, modifiers);
                                    duplicate = true;
                                }
                                ++j;
                            }
                            if (!duplicate) {
                                bindings[maxBindings++] = (TypeVariableBinding)param.resolvedType;
                            }
                        } else {
                            scope.problemReporter().javadocUndeclaredParamTagName(param.token, param.sourceStart, param.sourceEnd, modifiers);
                        }
                    }
                    ++i;
                }
                if (reportMissing) {
                    i = 0;
                    while (i < typeParametersLength) {
                        TypeParameter parameter = parameters[i];
                        boolean found = false;
                        int j = 0;
                        while (j < maxBindings && !found) {
                            if (parameter.binding == bindings[j]) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            scope.problemReporter().javadocMissingParamTag(parameter.name, parameter.sourceStart, parameter.sourceEnd, modifiers);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        block23: {
            int j;
            TypeReference typeRef;
            int thrownExceptionLength;
            int boundExceptionLength;
            int throwsTagsLength;
            AbstractMethodDeclaration md;
            block22: {
                md = methScope.referenceMethod();
                int n = throwsTagsLength = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (md == null) {
                    int i = 0;
                    while (i < throwsTagsLength) {
                        TypeReference typeRef2 = this.exceptionReferences[i];
                        int start = typeRef2.sourceStart;
                        int end = typeRef2.sourceEnd;
                        if (typeRef2 instanceof JavadocQualifiedTypeReference) {
                            start = ((JavadocQualifiedTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocQualifiedTypeReference)typeRef2).tagSourceEnd;
                        } else if (typeRef2 instanceof JavadocSingleTypeReference) {
                            start = ((JavadocSingleTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocSingleTypeReference)typeRef2).tagSourceEnd;
                        }
                        methScope.problemReporter().javadocUnexpectedTag(start, end);
                        ++i;
                    }
                    return;
                }
                boundExceptionLength = md.binding == null || md.binding.thrownExceptions == null ? 0 : md.binding.thrownExceptions.length;
                int n2 = thrownExceptionLength = md.thrownExceptions == null ? 0 : md.thrownExceptions.length;
                if (throwsTagsLength != 0) break block22;
                if (!reportMissing) break block23;
                int i = 0;
                while (i < boundExceptionLength) {
                    ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i];
                    if (exceptionBinding != null && exceptionBinding.isValidBinding()) {
                        int j2 = i;
                        while (j2 < thrownExceptionLength && exceptionBinding != md.thrownExceptions[j2].resolvedType) {
                            ++j2;
                        }
                        if (j2 < thrownExceptionLength) {
                            methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[j2], md.binding.modifiers);
                        }
                    }
                    ++i;
                }
                break block23;
            }
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            int i = 0;
            while (i < throwsTagsLength) {
                typeRef = this.exceptionReferences[i];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding != null && typeBinding.isValidBinding() && typeBinding.isClass()) {
                    typeReferences[maxRef++] = typeRef;
                }
                ++i;
            }
            i = 0;
            while (i < boundExceptionLength) {
                ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i];
                boolean found = false;
                j = 0;
                while (j < maxRef && !found) {
                    TypeBinding typeBinding;
                    if (typeReferences[j] != null && exceptionBinding == (typeBinding = typeReferences[j].resolvedType)) {
                        found = true;
                        typeReferences[j] = null;
                    }
                    ++j;
                }
                if (!found && reportMissing && exceptionBinding != null && exceptionBinding.isValidBinding()) {
                    int k = i;
                    while (k < thrownExceptionLength && exceptionBinding != md.thrownExceptions[k].resolvedType) {
                        ++k;
                    }
                    if (k < thrownExceptionLength) {
                        methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[k], md.binding.modifiers);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < maxRef) {
                typeRef = typeReferences[i];
                if (typeRef != null) {
                    boolean compatible = false;
                    j = 0;
                    while (j < thrownExceptionLength && !compatible) {
                        TypeBinding exceptionBinding = md.thrownExceptions[j].resolvedType;
                        if (exceptionBinding != null) {
                            compatible = typeRef.resolvedType.isCompatibleWith(exceptionBinding);
                        }
                        ++j;
                    }
                    if (!(compatible || typeRef.resolvedType.isCompatibleWith(methScope.getJavaLangRuntimeException()) || typeRef.resolvedType.isCompatibleWith(methScope.getJavaLangError()))) {
                        methScope.problemReporter().javadocInvalidThrowsClassName(typeRef, md.binding.modifiers);
                    }
                }
                ++i;
            }
        }
    }

    public ASTNode getNodeStartingAt(int start) {
        Expression param;
        int i;
        int length = 0;
        if (this.paramReferences != null) {
            length = this.paramReferences.length;
            i = 0;
            while (i < length) {
                param = this.paramReferences[i];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.invalidParameters != null) {
            length = this.invalidParameters.length;
            i = 0;
            while (i < length) {
                param = this.invalidParameters[i];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.paramTypeParameters != null) {
            length = this.paramTypeParameters.length;
            i = 0;
            while (i < length) {
                param = this.paramTypeParameters[i];
                if (((JavadocSingleTypeReference)param).sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.exceptionReferences != null) {
            length = this.exceptionReferences.length;
            i = 0;
            while (i < length) {
                TypeReference typeRef = this.exceptionReferences[i];
                if (typeRef.sourceStart == start) {
                    return typeRef;
                }
                ++i;
            }
        }
        if (this.seeReferences != null) {
            length = this.seeReferences.length;
            i = 0;
            while (i < length) {
                int l;
                int j;
                Expression expression = this.seeReferences[i];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.seeReferences[i];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && allocationExpr.arguments != null) {
                        j = 0;
                        l = allocationExpr.arguments.length;
                        while (j < l) {
                            if (allocationExpr.arguments[j].sourceStart == start) {
                                return allocationExpr.arguments[j];
                            }
                            ++j;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.seeReferences[i];
                    if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.arguments != null) {
                        j = 0;
                        l = messageSend.arguments.length;
                        while (j < l) {
                            if (messageSend.arguments[j].sourceStart == start) {
                                return messageSend.arguments[j];
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

