/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.ataspectj.Aj5Attributes;
import org.aspectj.weaver.ataspectj.Ajc5MemberMaker;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelField;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelSourceContext;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.patterns.PerClause;

public class BcelObjectType
extends ResolvedTypeX.ConcreteName {
    private JavaClass javaClass;
    private boolean isObject = false;
    private LazyClassGen lazyClassGen = null;
    private ResolvedTypeX[] interfaces = null;
    private ResolvedTypeX superClass = null;
    private ResolvedMember[] fields = null;
    private ResolvedMember[] methods = null;
    private ResolvedTypeX[] annotationTypes = null;
    private AnnotationX[] annotations = null;
    private ResolvedPointcutDefinition[] pointcuts = null;
    private PerClause perClause = null;
    private WeaverStateInfo weaverState = null;
    private AjAttribute.WeaverVersionInfo wvInfo = null;
    private List typeMungers = Collections.EMPTY_LIST;
    private List declares = Collections.EMPTY_LIST;
    private ResolvedMember[] privilegedAccess = null;
    private boolean discoveredWhetherAnnotationStyle = false;
    private boolean isAnnotationStyleAspect = false;
    private boolean isCodeStyleAspect = false;

    public Collection getTypeMungers() {
        return this.typeMungers;
    }

    public Collection getDeclares() {
        return this.declares;
    }

    public Collection getPrivilegedAccesses() {
        if (this.privilegedAccess == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.privilegedAccess);
    }

    BcelObjectType(ResolvedTypeX.Name resolvedTypeX, JavaClass javaClass, boolean exposedToWeaver) {
        super(resolvedTypeX, exposedToWeaver);
        this.javaClass = javaClass;
        resolvedTypeX.setDelegate(this);
        if (resolvedTypeX.getSourceContext() == null) {
            resolvedTypeX.setSourceContext(new BcelSourceContext(this));
        }
        this.isObject = javaClass.getSuperclassNameIndex() == 0;
        this.unpackAspectAttributes();
    }

    public void setJavaClass(JavaClass newclass) {
        this.javaClass = newclass;
        this.resetState();
    }

    public int getModifiers() {
        return this.javaClass.getAccessFlags();
    }

    public ResolvedTypeX getSuperclass() {
        if (this.isObject) {
            return null;
        }
        if (this.superClass == null) {
            this.superClass = this.getResolvedTypeX().getWorld().resolve(TypeX.forName(this.javaClass.getSuperclassName()));
        }
        return this.superClass;
    }

    public ResolvedTypeX[] getDeclaredInterfaces() {
        if (this.interfaces == null) {
            String[] ifaceNames = this.javaClass.getInterfaceNames();
            this.interfaces = new ResolvedTypeX[ifaceNames.length];
            int len = ifaceNames.length;
            for (int i = 0; i < len; ++i) {
                this.interfaces[i] = this.getResolvedTypeX().getWorld().resolve(TypeX.forName(ifaceNames[i]));
            }
        }
        return this.interfaces;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.methods == null) {
            Method[] ms = this.javaClass.getMethods();
            ResolvedMember[] ret = new ResolvedMember[ms.length];
            for (int i = ms.length - 1; i >= 0; --i) {
                ret[i] = new BcelMethod(this, ms[i]);
            }
            this.methods = ret;
        }
        return this.methods;
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.fields == null) {
            Field[] fs = this.javaClass.getFields();
            ResolvedMember[] ret = new ResolvedMember[fs.length];
            int len = fs.length;
            for (int i = 0; i < len; ++i) {
                ret[i] = new BcelField(this, fs[i]);
            }
            this.fields = ret;
        }
        return this.fields;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        return this.pointcuts;
    }

    public void addPointcutDefinition(ResolvedPointcutDefinition d) {
        int len = this.pointcuts.length;
        ResolvedPointcutDefinition[] ret = new ResolvedPointcutDefinition[len + 1];
        System.arraycopy(this.pointcuts, 0, ret, 0, len);
        ret[len] = d;
        this.pointcuts = ret;
    }

    public boolean isAspect() {
        return this.perClause != null;
    }

    public boolean isAnnotationStyleAspect() {
        if (!this.discoveredWhetherAnnotationStyle) {
            this.discoveredWhetherAnnotationStyle = true;
            this.isAnnotationStyleAspect = !this.isCodeStyleAspect && this.hasAnnotation(Ajc5MemberMaker.ASPECT);
        }
        return this.isAnnotationStyleAspect;
    }

    private void unpackAspectAttributes() {
        ArrayList pointcuts = new ArrayList();
        this.typeMungers = new ArrayList();
        this.declares = new ArrayList();
        List l = BcelAttributes.readAjAttributes(this.javaClass.getClassName(), this.javaClass.getAttributes(), this.getResolvedTypeX().getSourceContext(), this.getResolvedTypeX().getWorld().getMessageHandler());
        this.processAttributes(l, pointcuts, false);
        l = Aj5Attributes.readAj5ClassAttributes(this.javaClass, this.getResolvedTypeX(), this.getResolvedTypeX().getSourceContext(), this.getResolvedTypeX().getWorld().getMessageHandler(), this.isCodeStyleAspect);
        this.processAttributes(l, pointcuts, true);
        this.pointcuts = pointcuts.toArray(new ResolvedPointcutDefinition[pointcuts.size()]);
    }

    private void processAttributes(List attributeList, List pointcuts, boolean fromAnnotations) {
        Iterator iter = attributeList.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.Aspect) {
                this.perClause = ((AjAttribute.Aspect)a).reify(this.getResolvedTypeX());
                if (fromAnnotations) continue;
                this.isCodeStyleAspect = true;
                continue;
            }
            if (a instanceof AjAttribute.PointcutDeclarationAttribute) {
                pointcuts.add(((AjAttribute.PointcutDeclarationAttribute)a).reify());
                continue;
            }
            if (a instanceof AjAttribute.WeaverState) {
                this.weaverState = ((AjAttribute.WeaverState)a).reify();
                continue;
            }
            if (a instanceof AjAttribute.TypeMunger) {
                this.typeMungers.add(((AjAttribute.TypeMunger)a).reify(this.getResolvedTypeX().getWorld(), this.getResolvedTypeX()));
                continue;
            }
            if (a instanceof AjAttribute.DeclareAttribute) {
                this.declares.add(((AjAttribute.DeclareAttribute)a).getDeclare());
                continue;
            }
            if (a instanceof AjAttribute.PrivilegedAttribute) {
                this.privilegedAccess = ((AjAttribute.PrivilegedAttribute)a).getAccessedMembers();
                continue;
            }
            if (a instanceof AjAttribute.SourceContextAttribute) {
                if (!(this.getResolvedTypeX().getSourceContext() instanceof BcelSourceContext)) continue;
                ((BcelSourceContext)this.getResolvedTypeX().getSourceContext()).addAttributeInfo((AjAttribute.SourceContextAttribute)a);
                continue;
            }
            if (a instanceof AjAttribute.WeaverVersionInfo) {
                this.wvInfo = (AjAttribute.WeaverVersionInfo)a;
                continue;
            }
            throw new BCException("bad attribute " + a);
        }
    }

    public PerClause getPerClause() {
        return this.perClause;
    }

    JavaClass getJavaClass() {
        return this.javaClass;
    }

    public void resetState() {
        this.interfaces = null;
        this.superClass = null;
        this.fields = null;
        this.methods = null;
        this.pointcuts = null;
        this.perClause = null;
        this.weaverState = null;
        this.lazyClassGen = null;
        this.annotations = null;
        this.annotationTypes = null;
        this.isObject = this.javaClass.getSuperclassNameIndex() == 0;
        this.unpackAspectAttributes();
        this.discoveredWhetherAnnotationStyle = false;
        this.isAnnotationStyleAspect = false;
    }

    public void finishedWith() {
    }

    public WeaverStateInfo getWeaverState() {
        return this.weaverState;
    }

    void setWeaverState(WeaverStateInfo weaverState) {
        this.weaverState = weaverState;
    }

    public void printWackyStuff(PrintStream out) {
        if (this.typeMungers.size() > 0) {
            out.println("  TypeMungers: " + this.typeMungers);
        }
        if (this.declares.size() > 0) {
            out.println("     declares: " + this.declares);
        }
    }

    public LazyClassGen getLazyClassGen() {
        LazyClassGen ret = this.lazyClassGen;
        if (ret == null) {
            ret = new LazyClassGen(this);
            if (this.isAspect()) {
                this.lazyClassGen = ret;
            }
        }
        return ret;
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isEnum() {
        return this.javaClass.isEnum();
    }

    public boolean isAnnotation() {
        return this.javaClass.isAnnotation();
    }

    public void addAnnotation(AnnotationX annotation) {
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        len = this.annotationTypes.length;
        ResolvedTypeX[] ret2 = new ResolvedTypeX[len + 1];
        System.arraycopy(this.annotationTypes, 0, ret2, 0, len);
        ret2[len] = this.getResolvedTypeX().getWorld().resolve(TypeX.forName(annotation.getTypeName()));
        this.annotationTypes = ret2;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        if (!this.isAnnotation()) {
            return false;
        }
        Annotation[] annotationsOnThisType = this.javaClass.getAnnotations();
        for (int i = 0; i < annotationsOnThisType.length; ++i) {
            Annotation a = annotationsOnThisType[i];
            if (!a.getTypeName().equals(TypeX.AT_RETENTION.getName())) continue;
            List values = a.getValues();
            boolean isRuntime = false;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                ElementNameValuePair element = (ElementNameValuePair)it.next();
                ElementValue v = element.getValue();
                isRuntime = v.stringifyValue().equals("RUNTIME");
            }
            return isRuntime;
        }
        return false;
    }

    public boolean isSynthetic() {
        return this.getResolvedTypeX().isSynthetic();
    }

    public ISourceLocation getSourceLocation() {
        return this.getResolvedTypeX().getSourceContext().makeSourceLocation(0);
    }

    public AjAttribute.WeaverVersionInfo getWeaverVersionAttribute() {
        return this.wvInfo;
    }

    public void addParent(ResolvedTypeX newParent) {
        if (newParent.isClass()) {
            this.superClass = newParent;
        } else {
            ResolvedTypeX[] oldInterfaceNames = this.getDeclaredInterfaces();
            int len = oldInterfaceNames.length;
            ResolvedTypeX[] newInterfaceNames = new ResolvedTypeX[len + 1];
            System.arraycopy(oldInterfaceNames, 0, newInterfaceNames, 0, len);
            newInterfaceNames[len] = newParent;
            this.interfaces = newInterfaceNames;
        }
    }

    public boolean hasAnnotation(TypeX ofType) {
        this.ensureAnnotationTypesRetrieved();
        for (int i = 0; i < this.annotationTypes.length; ++i) {
            ResolvedTypeX annX = this.annotationTypes[i];
            if (!annX.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null) {
            Annotation[] annos = this.javaClass.getAnnotations();
            this.annotationTypes = new ResolvedTypeX[annos.length];
            this.annotations = new AnnotationX[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                ResolvedTypeX rtx;
                Annotation annotation = annos[i];
                this.annotationTypes[i] = rtx = this.getResolvedTypeX().getWorld().resolve(TypeX.forName(annotation.getTypeName()));
                this.annotations[i] = new AnnotationX(annotation, this.getResolvedTypeX().getWorld());
            }
        }
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotationTypes;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotations;
    }
}

