/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class DeclareErrorOrWarning
extends Declare {
    private boolean isError;
    private Pointcut pointcut;
    private String message;

    public DeclareErrorOrWarning(boolean isError, Pointcut pointcut, String message) {
        this.isError = isError;
        this.pointcut = pointcut;
        this.message = message;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare ");
        if (this.isError) {
            buf.append("error: ");
        } else {
            buf.append("warning: ");
        }
        buf.append(this.pointcut);
        buf.append(": ");
        buf.append("\"");
        buf.append(this.message);
        buf.append("\";");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DeclareErrorOrWarning)) {
            return false;
        }
        DeclareErrorOrWarning o = (DeclareErrorOrWarning)other;
        return o.isError == this.isError && o.pointcut.equals(this.pointcut) && o.message.equals(this.message);
    }

    public int hashCode() {
        int result = this.isError ? 19 : 23;
        result = 37 * result + this.pointcut.hashCode();
        result = 37 * result + this.message.hashCode();
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(1);
        s.writeBoolean(this.isError);
        this.pointcut.write(s);
        s.writeUTF(this.message);
        this.writeLocation(s);
    }

    public static Declare read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        DeclareErrorOrWarning ret = new DeclareErrorOrWarning(s.readBoolean(), Pointcut.read(s, context), s.readUTF());
        ret.readLocation(context, s);
        return ret;
    }

    public boolean isError() {
        return this.isError;
    }

    public String getMessage() {
        return this.message;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void resolve(IScope scope) {
        this.pointcut = this.pointcut.resolve(scope);
    }

    public boolean isAdviceLike() {
        return true;
    }
}

