/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.StringMaker;

abstract class SignatureImpl
implements Signature {
    private static boolean useCache = true;
    int modifiers = -1;
    String name;
    String declaringTypeName;
    Class declaringType;
    SoftReference toStringCacheRef;
    private String stringRep;
    ClassLoader lookupClassLoader = null;
    static final char SEP = '-';
    static Hashtable prims = new Hashtable();
    static String[] EMPTY_STRING_ARRAY;
    static Class[] EMPTY_CLASS_ARRAY;
    static final String INNER_SEP = ":";
    static /* synthetic */ Class class$java$lang$ClassNotFoundException;

    SignatureImpl(int modifiers, String name, Class declaringType) {
        this.modifiers = modifiers;
        this.name = name;
        this.declaringType = declaringType;
    }

    protected abstract String createToString(StringMaker var1);

    String toString(StringMaker sm) {
        String[] toStringCache = null;
        if (this.toStringCacheRef == null || this.toStringCacheRef.get() == null) {
            toStringCache = new String[3];
            if (useCache) {
                this.toStringCacheRef = new SoftReference<String[]>(toStringCache);
            }
        } else {
            toStringCache = (String[])this.toStringCacheRef.get();
        }
        if (toStringCache[sm.cacheOffset] == null) {
            toStringCache[sm.cacheOffset] = this.createToString(sm);
        }
        return toStringCache[sm.cacheOffset];
    }

    public final String toString() {
        return this.toString(StringMaker.middleStringMaker);
    }

    public final String toShortString() {
        return this.toString(StringMaker.shortStringMaker);
    }

    public final String toLongString() {
        return this.toString(StringMaker.longStringMaker);
    }

    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.extractInt(0);
        }
        return this.modifiers;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.extractString(1);
        }
        return this.name;
    }

    public Class getDeclaringType() {
        if (this.declaringType == null) {
            this.declaringType = this.extractType(2);
        }
        return this.declaringType;
    }

    public String getDeclaringTypeName() {
        if (this.declaringTypeName == null) {
            this.declaringTypeName = this.getDeclaringType().getName();
        }
        return this.declaringTypeName;
    }

    String fullTypeName(Class type) {
        if (type == null) {
            return "ANONYMOUS";
        }
        if (type.isArray()) {
            return this.fullTypeName(type.getComponentType()) + "[]";
        }
        return type.getName().replace('$', '.');
    }

    String stripPackageName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return name;
        }
        return name.substring(dot + 1);
    }

    String shortTypeName(Class type) {
        if (type == null) {
            return "ANONYMOUS";
        }
        if (type.isArray()) {
            return this.shortTypeName(type.getComponentType()) + "[]";
        }
        return this.stripPackageName(type.getName()).replace('$', '.');
    }

    void addFullTypeNames(StringBuffer buf, Class[] types) {
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.fullTypeName(types[i]));
            ++i;
        }
    }

    void addShortTypeNames(StringBuffer buf, Class[] types) {
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.shortTypeName(types[i]));
            ++i;
        }
    }

    void addTypeArray(StringBuffer buf, Class[] types) {
        this.addFullTypeNames(buf, types);
    }

    public void setLookupClassLoader(ClassLoader loader) {
        this.lookupClassLoader = loader;
    }

    private ClassLoader getLookupClassLoader() {
        if (this.lookupClassLoader == null) {
            this.lookupClassLoader = this.getClass().getClassLoader();
        }
        return this.lookupClassLoader;
    }

    public SignatureImpl(String stringRep) {
        this.stringRep = stringRep;
    }

    String extractString(int n) {
        int startIndex = 0;
        int endIndex = this.stringRep.indexOf(45);
        while (n-- > 0) {
            startIndex = endIndex + 1;
            endIndex = this.stringRep.indexOf(45, startIndex);
        }
        if (endIndex == -1) {
            endIndex = this.stringRep.length();
        }
        return this.stringRep.substring(startIndex, endIndex);
    }

    int extractInt(int n) {
        String s = this.extractString(n);
        return Integer.parseInt(s, 16);
    }

    Class extractType(int n) {
        String s = this.extractString(n);
        return this.makeClass(s);
    }

    Class makeClass(String s) {
        if (s.equals("*")) {
            return null;
        }
        Class ret = (Class)prims.get(s);
        if (ret != null) {
            return ret;
        }
        try {
            ClassLoader loader = this.getLookupClassLoader();
            if (loader == null) {
                return Class.forName(s);
            }
            return Class.forName(s, false, loader);
        }
        catch (ClassNotFoundException e) {
            return class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = SignatureImpl.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException;
        }
    }

    String[] extractStrings(int n) {
        String s = this.extractString(n);
        StringTokenizer st = new StringTokenizer(s, INNER_SEP);
        int N = st.countTokens();
        String[] ret = new String[N];
        int i = 0;
        while (i < N) {
            ret[i] = st.nextToken();
            ++i;
        }
        return ret;
    }

    Class[] extractTypes(int n) {
        String s = this.extractString(n);
        StringTokenizer st = new StringTokenizer(s, INNER_SEP);
        int N = st.countTokens();
        Class[] ret = new Class[N];
        int i = 0;
        while (i < N) {
            ret[i] = this.makeClass(st.nextToken());
            ++i;
        }
        return ret;
    }

    static void setUseCache(boolean b) {
        useCache = b;
    }

    static boolean getUseCache() {
        return useCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        prims.put("void", Void.TYPE);
        prims.put("boolean", Boolean.TYPE);
        prims.put("byte", Byte.TYPE);
        prims.put("char", Character.TYPE);
        prims.put("short", Short.TYPE);
        prims.put("int", Integer.TYPE);
        prims.put("long", Long.TYPE);
        prims.put("float", Float.TYPE);
        prims.put("double", Double.TYPE);
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }
}

