/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.core.LocalVariable;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.VariablePattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class LocalVariablePattern
extends VariablePattern
implements IIndexConstants {
    LocalVariable localVariable;

    public LocalVariablePattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, LocalVariable localVariable, int matchRule) {
        super(512, findDeclarations, readAccess, writeAccess, localVariable.getElementName().toCharArray(), matchRule);
        this.localVariable = localVariable;
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        JavaSearchScope javaSearchScope;
        AccessRestriction access;
        String path;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.localVariable.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.localVariable.getAncestor(7);
            String filePath = String.valueOf(type.getFullyQualifiedName('/').replace('.', '/')) + ".class";
            path = root.getPath() + "|" + filePath;
        } else {
            path = this.localVariable.getPath().toString();
        }
        if (scope instanceof JavaSearchScope ? !JavaSearchScope.UNINIT_RESTRICTION.equals(access = (javaSearchScope = (JavaSearchScope)scope).getAccessRestriction(path)) && !requestor.acceptIndexMatch(path, this, participant, access) : scope.encloses(path) && !requestor.acceptIndexMatch(path, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "LocalVarCombinedPattern: " : "LocalVarDeclarationPattern: ");
        } else {
            output.append("LocalVarReferencePattern: ");
        }
        output.append(this.localVariable.toStringWithAncestors());
        return super.print(output);
    }
}

