/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ArrayElementValue;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValue;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;

public class AnnotationX {
    private Annotation theRealAnnotation;
    private ResolvedTypeX signature = null;
    private boolean lookedForAtTargetAnnotation = false;
    private AnnotationX atTargetAnnotation = null;
    private Set supportedTargets = null;

    public AnnotationX(Annotation a, World world) {
        this.theRealAnnotation = a;
        this.signature = TypeX.forSignature(this.theRealAnnotation.getTypeSignature()).resolve(world);
    }

    public Annotation getBcelAnnotation() {
        return this.theRealAnnotation;
    }

    public TypeX getSignature() {
        return this.signature;
    }

    public String toString() {
        return this.theRealAnnotation.toString();
    }

    public String getTypeName() {
        return this.theRealAnnotation.getTypeName();
    }

    public String getTypeSignature() {
        return this.theRealAnnotation.getTypeSignature();
    }

    public boolean allowedOnAnnotationType() {
        this.ensureAtTargetInitialized();
        if (this.atTargetAnnotation == null) {
            return true;
        }
        return this.supportedTargets.contains("ANNOTATION_TYPE");
    }

    public boolean specifiesTarget() {
        this.ensureAtTargetInitialized();
        return this.atTargetAnnotation != null;
    }

    public boolean allowedOnRegularType() {
        this.ensureAtTargetInitialized();
        if (this.atTargetAnnotation == null) {
            return true;
        }
        return this.supportedTargets.contains("TYPE");
    }

    public String stringify() {
        return this.signature.getName();
    }

    public String getValidTargets() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator iter = this.supportedTargets.iterator();
        while (iter.hasNext()) {
            String evalue = (String)iter.next();
            sb.append(evalue);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private AnnotationX retrieveAnnotationOnAnnotation(TypeX requiredAnnotationSignature) {
        AnnotationX[] annos = this.signature.getAnnotations();
        for (int i = 0; i < annos.length; ++i) {
            AnnotationX annotationX = annos[i];
            if (!annotationX.getSignature().equals(requiredAnnotationSignature)) continue;
            return annos[i];
        }
        return null;
    }

    private void ensureAtTargetInitialized() {
        if (!this.lookedForAtTargetAnnotation) {
            this.lookedForAtTargetAnnotation = true;
            this.atTargetAnnotation = this.retrieveAnnotationOnAnnotation(TypeX.AT_TARGET);
            if (this.atTargetAnnotation != null) {
                this.supportedTargets = new HashSet();
                List values = this.atTargetAnnotation.getBcelAnnotation().getValues();
                ElementNameValuePair envp = (ElementNameValuePair)values.get(0);
                ArrayElementValue aev = (ArrayElementValue)envp.getValue();
                ElementValue[] evs = aev.getElementValuesArray();
                for (int i = 0; i < evs.length; ++i) {
                    EnumElementValue ev = (EnumElementValue)evs[i];
                    this.supportedTargets.add(ev.getEnumValueString());
                }
            }
        }
    }

    public boolean allowedOnField() {
        this.ensureAtTargetInitialized();
        if (this.atTargetAnnotation == null) {
            return true;
        }
        return this.supportedTargets.contains("FIELD");
    }
}

