/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.ataspectj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePair;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnotations;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisibleAnnotations;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.Message;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PerCflow;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerObject;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.PerTypeWithin;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.SimpleScope;

public class Aj5Attributes {
    private static final List EMPTY_LIST = new ArrayList();
    private static final String[] EMPTY_STRINGS = new String[0];
    public static final TypeX TYPEX_JOINPOINT = TypeX.forName((class$org$aspectj$lang$JoinPoint == null ? (class$org$aspectj$lang$JoinPoint = Aj5Attributes.class$("org.aspectj.lang.JoinPoint")) : class$org$aspectj$lang$JoinPoint).getName().replace('/', '.'));
    public static final TypeX TYPEX_PROCEEDINGJOINPOINT = TypeX.forName((class$org$aspectj$lang$ProceedingJoinPoint == null ? (class$org$aspectj$lang$ProceedingJoinPoint = Aj5Attributes.class$("org.aspectj.lang.ProceedingJoinPoint")) : class$org$aspectj$lang$ProceedingJoinPoint).getName().replace('/', '.'));
    public static final TypeX TYPEX_STATICJOINPOINT = TypeX.forName((class$org$aspectj$lang$JoinPoint$StaticPart == null ? (class$org$aspectj$lang$JoinPoint$StaticPart = Aj5Attributes.class$("org.aspectj.lang.JoinPoint$StaticPart")) : class$org$aspectj$lang$JoinPoint$StaticPart).getName().replace('/', '.'));
    public static final TypeX TYPEX_ENCLOSINGSTATICJOINPOINT = TypeX.forName((class$org$aspectj$lang$JoinPoint$EnclosingStaticPart == null ? (class$org$aspectj$lang$JoinPoint$EnclosingStaticPart = Aj5Attributes.class$("org.aspectj.lang.JoinPoint$EnclosingStaticPart")) : class$org$aspectj$lang$JoinPoint$EnclosingStaticPart).getName().replace('/', '.'));
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint;
    static /* synthetic */ Class class$org$aspectj$lang$ProceedingJoinPoint;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint$StaticPart;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint$EnclosingStaticPart;

    public static boolean acceptAttribute(Attribute attribute) {
        return attribute instanceof RuntimeVisibleAnnotations;
    }

    public static List readAj5ClassAttributes(JavaClass javaClass, ResolvedTypeX type, ISourceContext context, IMessageHandler msgHandler, boolean isCodeStyleAspect) {
        AjAttributeStruct struct = new AjAttributeStruct(type, context, msgHandler);
        Attribute[] attributes = javaClass.getAttributes();
        boolean hasAtAspectAnnotation = false;
        boolean hasAtPrecedenceAnnotation = false;
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!Aj5Attributes.acceptAttribute(attribute)) continue;
            RuntimeAnnotations rvs = (RuntimeAnnotations)attribute;
            if (!isCodeStyleAspect) {
                hasAtAspectAnnotation = Aj5Attributes.handleAspectAnnotation(rvs, struct);
            }
            hasAtPrecedenceAnnotation = Aj5Attributes.handlePrecedenceAnnotation(rvs, struct);
            break;
        }
        if (hasAtPrecedenceAnnotation && !hasAtAspectAnnotation) {
            msgHandler.handleMessage(new Message("Found @DeclarePrecedence on a non @Aspect type '" + type.getName() + "'", IMessage.WARNING, null, type.getSourceLocation()));
            return EMPTY_LIST;
        }
        if (!hasAtAspectAnnotation) {
            return EMPTY_LIST;
        }
        for (int m = 0; m < javaClass.getMethods().length; ++m) {
            Method method = javaClass.getMethods()[m];
            if (method.getName().startsWith("ajc$")) continue;
            AjAttributeMethodStruct mstruct = new AjAttributeMethodStruct(method, type, context, msgHandler);
            Attribute[] mattributes = method.getAttributes();
            for (int i = 0; i < mattributes.length; ++i) {
                Attribute mattribute = mattributes[i];
                if (!Aj5Attributes.acceptAttribute(mattribute)) continue;
                RuntimeAnnotations mrvs = (RuntimeAnnotations)mattribute;
                Aj5Attributes.handlePointcutAnnotation(mrvs, mstruct);
                break;
            }
            struct.ajAttributes.addAll(mstruct.ajAttributes);
        }
        return struct.ajAttributes;
    }

    public static List readAj5MethodAttributes(Method method, ResolvedTypeX type, ResolvedPointcutDefinition preResolvedPointcut, ISourceContext context, IMessageHandler msgHandler) {
        if (method.getName().startsWith("ajc$")) {
            return Collections.EMPTY_LIST;
        }
        AjAttributeMethodStruct struct = new AjAttributeMethodStruct(method, type, context, msgHandler);
        Attribute[] attributes = method.getAttributes();
        boolean hasAtAspectJAnnotation = false;
        boolean hasAtAspectJAnnotationMustReturnVoid = false;
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attribute = attributes[i];
            if (!Aj5Attributes.acceptAttribute(attribute)) continue;
            RuntimeAnnotations rvs = (RuntimeAnnotations)attribute;
            hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || Aj5Attributes.handleBeforeAnnotation(rvs, struct, preResolvedPointcut);
            hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || Aj5Attributes.handleAfterAnnotation(rvs, struct, preResolvedPointcut);
            hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || Aj5Attributes.handleAfterReturningAnnotation(rvs, struct, preResolvedPointcut);
            hasAtAspectJAnnotationMustReturnVoid = hasAtAspectJAnnotationMustReturnVoid || Aj5Attributes.handleAfterThrowingAnnotation(rvs, struct, preResolvedPointcut);
            hasAtAspectJAnnotation = hasAtAspectJAnnotation || Aj5Attributes.handleAroundAnnotation(rvs, struct, preResolvedPointcut);
            break;
        }
        boolean bl = hasAtAspectJAnnotation = hasAtAspectJAnnotation || hasAtAspectJAnnotationMustReturnVoid;
        if (hasAtAspectJAnnotation && !type.isAnnotationStyleAspect()) {
            msgHandler.handleMessage(new Message("Found @AspectJ annotations in a non @Aspect type '" + type.getName() + "'", IMessage.WARNING, null, type.getSourceLocation()));
        }
        if (hasAtAspectJAnnotation && !struct.method.isPublic()) {
            msgHandler.handleMessage(new Message("Found @AspectJ annotation on a non public advice '" + Aj5Attributes.methodToString(struct.method) + "'", IMessage.ERROR, null, type.getSourceLocation()));
        }
        if (hasAtAspectJAnnotationMustReturnVoid && !Type.VOID.equals(struct.method.getReturnType())) {
            msgHandler.handleMessage(new Message("Found @AspectJ annotation on a non around advice not returning void '" + Aj5Attributes.methodToString(struct.method) + "'", IMessage.ERROR, null, type.getSourceLocation()));
        }
        return struct.ajAttributes;
    }

    public static List readAj5FieldAttributes(Field field, ResolvedTypeX type, ISourceContext context, IMessageHandler msgHandler) {
        if (field.getName().startsWith("ajc$")) {
            return Collections.EMPTY_LIST;
        }
        return EMPTY_LIST;
    }

    private static boolean handleAspectAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeStruct struct) {
        Annotation aspect = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.Aspect");
        if (aspect != null) {
            ElementNameValuePair aspectPerClause = Aj5Attributes.getAnnotationElement(aspect, "value");
            if (aspectPerClause == null) {
                PerSingleton clause = new PerSingleton();
                clause.setLocation(struct.context, -1, -1);
                struct.ajAttributes.add(new AjAttribute.Aspect(clause));
                return true;
            }
            String perX = aspectPerClause.getValue().stringifyValue();
            PerClause clause = perX == null || perX.length() <= 0 ? new PerSingleton() : Aj5Attributes.parsePerClausePointcut(perX, struct);
            clause.setLocation(struct.context, -1, -1);
            struct.ajAttributes.add(new AjAttribute.Aspect(clause));
            return true;
        }
        return false;
    }

    private static PerClause parsePerClausePointcut(String perClause, AjAttributeStruct struct) {
        if (perClause.startsWith(PerClause.KindAnnotationPrefix.PERCFLOW.getName())) {
            String pointcut = PerClause.KindAnnotationPrefix.PERCFLOW.extractPointcut(perClause);
            return new PerCflow(Pointcut.fromString(pointcut), false);
        }
        if (perClause.startsWith(PerClause.KindAnnotationPrefix.PERCFLOWBELOW.getName())) {
            String pointcut = PerClause.KindAnnotationPrefix.PERCFLOWBELOW.extractPointcut(perClause);
            return new PerCflow(Pointcut.fromString(pointcut), true);
        }
        if (perClause.startsWith(PerClause.KindAnnotationPrefix.PERTARGET.getName())) {
            String pointcut = PerClause.KindAnnotationPrefix.PERTARGET.extractPointcut(perClause);
            return new PerObject(Pointcut.fromString(pointcut), false);
        }
        if (perClause.startsWith(PerClause.KindAnnotationPrefix.PERTHIS.getName())) {
            String pointcut = PerClause.KindAnnotationPrefix.PERTHIS.extractPointcut(perClause);
            return new PerObject(Pointcut.fromString(pointcut), true);
        }
        if (perClause.startsWith(PerClause.KindAnnotationPrefix.PERTYPEWITHIN.getName())) {
            String pointcut = PerClause.KindAnnotationPrefix.PERTYPEWITHIN.extractPointcut(perClause);
            return new PerTypeWithin(new PatternParser(pointcut).parseTypePattern());
        }
        if (perClause.equalsIgnoreCase(PerClause.SINGLETON.getName() + "()")) {
            return new PerSingleton();
        }
        struct.handler.handleMessage(new Message("cannot read per clause from @Aspect: " + perClause, struct.enclosingType.getSourceLocation(), true));
        throw new RuntimeException("cannot read perclause " + perClause);
    }

    private static boolean handlePrecedenceAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeStruct struct) {
        ElementNameValuePair precedence;
        Annotation aspect = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.DeclarePrecedence");
        if (aspect != null && (precedence = Aj5Attributes.getAnnotationElement(aspect, "value")) != null) {
            String precedencePattern = precedence.getValue().stringifyValue();
            PatternParser parser = new PatternParser(precedencePattern);
            DeclarePrecedence ajPrecedence = parser.parseDominates();
            struct.ajAttributes.add(new AjAttribute.DeclareAttribute(ajPrecedence));
            return true;
        }
        return false;
    }

    private static boolean handleBeforeAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        ElementNameValuePair beforeAdvice;
        Annotation before = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.Before");
        if (before != null && (beforeAdvice = Aj5Attributes.getAnnotationElement(before, "value")) != null) {
            FormalBinding[] bindings = Aj5Attributes.extractBindings(struct);
            BindingScope binding = new BindingScope(struct.enclosingType, bindings);
            int extraArgument = Aj5Attributes.extractExtraArgument(struct.method);
            Pointcut pc = null;
            pc = preResolvedPointcut != null ? preResolvedPointcut.getPointcut() : Pointcut.fromString(beforeAdvice.getValue().stringifyValue()).resolve(binding);
            Aj5Attributes.setIgnoreUnboundBindingNames(pc, bindings);
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.Before, pc, extraArgument, -1, -1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAfterAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        ElementNameValuePair afterAdvice;
        Annotation after = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.After");
        if (after != null && (afterAdvice = Aj5Attributes.getAnnotationElement(after, "value")) != null) {
            FormalBinding[] bindings = Aj5Attributes.extractBindings(struct);
            BindingScope binding = new BindingScope(struct.enclosingType, bindings);
            int extraArgument = Aj5Attributes.extractExtraArgument(struct.method);
            Pointcut pc = null;
            pc = preResolvedPointcut != null ? preResolvedPointcut.getPointcut() : Pointcut.fromString(afterAdvice.getValue().stringifyValue()).resolve(binding);
            Aj5Attributes.setIgnoreUnboundBindingNames(pc, bindings);
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.After, pc, extraArgument, -1, -1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAfterReturningAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        Annotation after = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.AfterReturning");
        if (after != null) {
            ElementNameValuePair annValue = Aj5Attributes.getAnnotationElement(after, "value");
            ElementNameValuePair annPointcut = Aj5Attributes.getAnnotationElement(after, "pointcut");
            ElementNameValuePair annReturned = Aj5Attributes.getAnnotationElement(after, "returning");
            String pointcut = null;
            String returned = null;
            if (annValue != null && annPointcut != null || annValue == null && annPointcut == null) {
                throw new RuntimeException("AfterReturning at most value or pointcut must be filled");
            }
            pointcut = annValue != null ? annValue.getValue().stringifyValue() : annPointcut.getValue().stringifyValue();
            if (Aj5Attributes.isNullOrEmpty(pointcut)) {
                throw new RuntimeException("AfterReturning pointcut unspecified");
            }
            if (annReturned != null && Aj5Attributes.isNullOrEmpty(returned = annReturned.getValue().stringifyValue())) {
                returned = null;
            }
            FormalBinding[] bindings = returned == null ? Aj5Attributes.extractBindings(struct) : Aj5Attributes.extractBindings(struct, returned);
            BindingScope binding = new BindingScope(struct.enclosingType, bindings);
            int extraArgument = Aj5Attributes.extractExtraArgument(struct.method);
            if (returned != null) {
                extraArgument |= 1;
            }
            Pointcut pc = null;
            pc = preResolvedPointcut != null ? preResolvedPointcut.getPointcut() : Pointcut.fromString(pointcut).resolve(binding);
            Aj5Attributes.setIgnoreUnboundBindingNames(pc, bindings);
            pc.setLocation(struct.enclosingType.getSourceContext(), 0, 0);
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.AfterReturning, pc, extraArgument, -1, -1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAfterThrowingAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        Annotation after = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.AfterThrowing");
        if (after != null) {
            ElementNameValuePair annValue = Aj5Attributes.getAnnotationElement(after, "value");
            ElementNameValuePair annPointcut = Aj5Attributes.getAnnotationElement(after, "pointcut");
            ElementNameValuePair annThrowned = Aj5Attributes.getAnnotationElement(after, "throwing");
            String pointcut = null;
            String throwned = null;
            if (annValue != null && annPointcut != null || annValue == null && annPointcut == null) {
                throw new RuntimeException("AfterReturning at most value or pointcut must be filled");
            }
            pointcut = annValue != null ? annValue.getValue().stringifyValue() : annPointcut.getValue().stringifyValue();
            if (Aj5Attributes.isNullOrEmpty(pointcut)) {
                throw new RuntimeException("AfterReturning pointcut unspecified");
            }
            if (annThrowned != null && Aj5Attributes.isNullOrEmpty(throwned = annThrowned.getValue().stringifyValue())) {
                throwned = null;
            }
            FormalBinding[] bindings = throwned == null ? Aj5Attributes.extractBindings(struct) : Aj5Attributes.extractBindings(struct, throwned);
            BindingScope binding = new BindingScope(struct.enclosingType, bindings);
            int extraArgument = Aj5Attributes.extractExtraArgument(struct.method);
            if (throwned != null) {
                extraArgument |= 1;
            }
            Pointcut pc = null;
            pc = preResolvedPointcut != null ? preResolvedPointcut.getPointcut() : Pointcut.fromString(pointcut).resolve(binding);
            Aj5Attributes.setIgnoreUnboundBindingNames(pc, bindings);
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.AfterThrowing, pc, extraArgument, -1, -1, struct.context));
            return true;
        }
        return false;
    }

    private static boolean handleAroundAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct, ResolvedPointcutDefinition preResolvedPointcut) {
        ElementNameValuePair aroundAdvice;
        Annotation around = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.Around");
        if (around != null && (aroundAdvice = Aj5Attributes.getAnnotationElement(around, "value")) != null) {
            FormalBinding[] bindings = Aj5Attributes.extractBindings(struct);
            BindingScope binding = new BindingScope(struct.enclosingType, bindings);
            int extraArgument = Aj5Attributes.extractExtraArgument(struct.method);
            Pointcut pc = null;
            pc = preResolvedPointcut != null ? preResolvedPointcut.getPointcut() : Pointcut.fromString(aroundAdvice.getValue().stringifyValue()).resolve(binding);
            Aj5Attributes.setIgnoreUnboundBindingNames(pc, bindings);
            struct.ajAttributes.add(new AjAttribute.AdviceAttribute(AdviceKind.Around, pc, extraArgument, -1, -1, struct.context));
            return true;
        }
        return false;
    }

    private static void handlePointcutAnnotation(RuntimeAnnotations runtimeAnnotations, AjAttributeMethodStruct struct) {
        ElementNameValuePair pointcutExpr;
        Annotation pointcut = Aj5Attributes.getAnnotation(runtimeAnnotations, "org.aspectj.lang.annotation.Pointcut");
        if (pointcut != null && (pointcutExpr = Aj5Attributes.getAnnotationElement(pointcut, "value")) != null) {
            if (!Type.VOID.equals(struct.method.getReturnType())) {
                struct.handler.handleMessage(new Message("Found @Pointcut on a method not returning void '" + Aj5Attributes.methodToString(struct.method) + "'", IMessage.WARNING, null, struct.enclosingType.getSourceLocation()));
                return;
            }
            if (struct.method.getExceptionTable() != null) {
                struct.handler.handleMessage(new Message("Found @Pointcut on a method throwing exception '" + Aj5Attributes.methodToString(struct.method) + "'", IMessage.WARNING, null, struct.enclosingType.getSourceLocation()));
                return;
            }
            BindingScope binding = new BindingScope(struct.enclosingType, Aj5Attributes.extractBindings(struct));
            TypeX[] argumentTypes = new TypeX[struct.method.getArgumentTypes().length];
            for (int i = 0; i < argumentTypes.length; ++i) {
                argumentTypes[i] = TypeX.forSignature(struct.method.getArgumentTypes()[i].getSignature());
            }
            try {
                struct.ajAttributes.add(new AjAttribute.PointcutDeclarationAttribute(new LazyResolvedPointcutDefinition(struct.enclosingType, struct.method.getModifiers(), struct.method.getName(), argumentTypes, Pointcut.fromString(pointcutExpr.getValue().stringifyValue()), binding)));
            }
            catch (ParserException e) {
                struct.handler.handleMessage(new Message("Cannot parse @Pointcut '" + pointcutExpr.getValue().stringifyValue() + "'", IMessage.ERROR, e, struct.enclosingType.getSourceLocation()));
                return;
            }
        }
    }

    private static String methodToString(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        sb.append(method.getSignature());
        return sb.toString();
    }

    private static FormalBinding[] extractBindings(AjAttributeMethodStruct struct) {
        Method method = struct.method;
        String[] argumentNames = struct.getArgumentNames();
        if (argumentNames.length != method.getArgumentTypes().length) {
            throw new RuntimeException("cannot access debug info " + method);
        }
        ArrayList<FormalBinding> bindings = new ArrayList<FormalBinding>();
        for (int i = 0; i < argumentNames.length; ++i) {
            String argumentName = argumentNames[i];
            TypeX argumentType = TypeX.forSignature(method.getArgumentTypes()[i].getSignature());
            if (TYPEX_JOINPOINT.equals(argumentType) || TYPEX_PROCEEDINGJOINPOINT.equals(argumentType) || TYPEX_STATICJOINPOINT.equals(argumentType) || TYPEX_ENCLOSINGSTATICJOINPOINT.equals(argumentType) || AjcMemberMaker.AROUND_CLOSURE_TYPE.equals(argumentType)) {
                bindings.add(new FormalBinding.ImplicitFormalBinding(argumentType, argumentName, i));
                continue;
            }
            bindings.add(new FormalBinding(argumentType, argumentName, i));
        }
        return bindings.toArray(new FormalBinding[0]);
    }

    private static FormalBinding[] extractBindings(AjAttributeMethodStruct struct, String excludeFormal) {
        FormalBinding[] bindings = Aj5Attributes.extractBindings(struct);
        int excludeIndex = -1;
        for (int i = 0; i < bindings.length; ++i) {
            FormalBinding binding = bindings[i];
            if (!binding.getName().equals(excludeFormal)) continue;
            excludeIndex = i;
            bindings[i] = new FormalBinding.ImplicitFormalBinding(binding.getType(), binding.getName(), binding.getIndex());
            break;
        }
        return bindings;
    }

    private static int extractExtraArgument(Method method) {
        int extraArgument = 0;
        Type[] methodArgs = method.getArgumentTypes();
        for (int i = 0; i < methodArgs.length; ++i) {
            String methodArg = methodArgs[i].getSignature();
            if (TYPEX_JOINPOINT.getSignature().equals(methodArg)) {
                extraArgument |= 2;
                continue;
            }
            if (TYPEX_PROCEEDINGJOINPOINT.getSignature().equals(methodArg)) {
                extraArgument |= 2;
                continue;
            }
            if (TYPEX_STATICJOINPOINT.getSignature().equals(methodArg)) {
                extraArgument |= 4;
                continue;
            }
            if (!TYPEX_ENCLOSINGSTATICJOINPOINT.getSignature().equals(methodArg)) continue;
            extraArgument |= 8;
        }
        return extraArgument;
    }

    private static Annotation getAnnotation(RuntimeAnnotations rvs, String annotationType) {
        Iterator iterator = rvs.getAnnotations().iterator();
        while (iterator.hasNext()) {
            Annotation rv = (Annotation)iterator.next();
            if (!annotationType.equals(rv.getTypeName())) continue;
            return rv;
        }
        return null;
    }

    private static ElementNameValuePair getAnnotationElement(Annotation annotation, String elementName) {
        Iterator iterator1 = annotation.getValues().iterator();
        while (iterator1.hasNext()) {
            ElementNameValuePair element = (ElementNameValuePair)iterator1.next();
            if (!elementName.equals(element.getNameString())) continue;
            return element;
        }
        return null;
    }

    private static String[] getMethodArgumentNamesAsInSource(Method method) {
        if (method.getArgumentTypes().length == 0) {
            return EMPTY_STRINGS;
        }
        int startAtStackIndex = method.isStatic() ? 0 : 1;
        ArrayList<MethodArgument> arguments = new ArrayList<MethodArgument>();
        LocalVariableTable lt = method.getLocalVariableTable();
        if (lt != null) {
            for (int j = 0; j < lt.getLocalVariableTable().length; ++j) {
                LocalVariable localVariable = lt.getLocalVariableTable()[j];
                if (localVariable.getStartPC() != 0 || localVariable.getIndex() < startAtStackIndex) continue;
                arguments.add(new MethodArgument(localVariable.getName(), localVariable.getIndex()));
            }
        }
        if (arguments.size() != method.getArgumentTypes().length) {
            return EMPTY_STRINGS;
        }
        Collections.sort(arguments, new Comparator(){

            public int compare(Object o, Object o1) {
                MethodArgument mo = (MethodArgument)o;
                MethodArgument mo1 = (MethodArgument)o1;
                if (mo.indexOnStack == mo1.indexOnStack) {
                    return 0;
                }
                if (mo.indexOnStack > mo1.indexOnStack) {
                    return 1;
                }
                return -1;
            }
        });
        String[] argumentNames = new String[arguments.size()];
        int i = 0;
        Iterator iterator = arguments.iterator();
        while (iterator.hasNext()) {
            MethodArgument methodArgument = (MethodArgument)iterator.next();
            argumentNames[i] = methodArgument.name;
            ++i;
        }
        return argumentNames;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() <= 0;
    }

    private static void setIgnoreUnboundBindingNames(Pointcut pointcut, FormalBinding[] bindings) {
        ArrayList<String> ignores = new ArrayList<String>();
        for (int i = 0; i < bindings.length; ++i) {
            FormalBinding formalBinding = bindings[i];
            if (!(formalBinding instanceof FormalBinding.ImplicitFormalBinding)) continue;
            ignores.add(formalBinding.getName());
        }
        pointcut.m_ignoreUnboundBindingForNames = ignores.toArray(new String[ignores.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LazyResolvedPointcutDefinition
    extends ResolvedPointcutDefinition {
        private Pointcut m_pointcutUnresolved;
        private IScope m_binding;
        private Pointcut m_lazyPointcut = null;

        public LazyResolvedPointcutDefinition(ResolvedTypeX declaringType, int modifiers, String name, TypeX[] parameterTypes, Pointcut pointcut, IScope binding) {
            super(declaringType, modifiers, name, parameterTypes, null);
            this.m_pointcutUnresolved = pointcut;
            this.m_binding = binding;
            this.m_pointcutUnresolved.setLocation(declaringType.getSourceContext(), 0, 0);
        }

        public Pointcut getPointcut() {
            if (this.m_lazyPointcut == null) {
                this.m_lazyPointcut = this.m_pointcutUnresolved.resolve(this.m_binding);
                this.m_lazyPointcut.copyLocationFrom(this.m_pointcutUnresolved);
            }
            return this.m_lazyPointcut;
        }
    }

    public static class BindingScope
    extends SimpleScope {
        private ResolvedTypeX m_enclosingType;

        public BindingScope(ResolvedTypeX type, FormalBinding[] bindings) {
            super(type.getWorld(), bindings);
            this.m_enclosingType = type;
        }

        public ResolvedTypeX getEnclosingType() {
            return this.m_enclosingType;
        }
    }

    private static class MethodArgument {
        String name;
        int indexOnStack;

        public MethodArgument(String name, int indexOnStack) {
            this.name = name;
            this.indexOnStack = indexOnStack;
        }
    }

    private static class AjAttributeMethodStruct
    extends AjAttributeStruct {
        private String[] m_argumentNamesLazy = null;
        final Method method;

        public AjAttributeMethodStruct(Method method, ResolvedTypeX type, ISourceContext sourceContext, IMessageHandler messageHandler) {
            super(type, sourceContext, messageHandler);
            this.method = method;
        }

        public String[] getArgumentNames() {
            if (this.m_argumentNamesLazy == null) {
                this.m_argumentNamesLazy = Aj5Attributes.getMethodArgumentNamesAsInSource(this.method);
            }
            return this.m_argumentNamesLazy;
        }
    }

    private static class AjAttributeStruct {
        List ajAttributes = new ArrayList();
        final ResolvedTypeX enclosingType;
        final ISourceContext context;
        final IMessageHandler handler;

        public AjAttributeStruct(ResolvedTypeX type, ISourceContext sourceContext, IMessageHandler messageHandler) {
            this.enclosingType = type;
            this.context = sourceContext;
            this.handler = messageHandler;
        }
    }
}

