/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BucketTree {
    public static final int DEPTH_INFINITE = Integer.MAX_VALUE;
    public static final int DEPTH_ONE = 1;
    public static final int DEPTH_ZERO = 0;
    private static final int SEGMENT_LENGTH = 2;
    private static final long SEGMENT_QUOTA = (long)Math.pow(2.0, 8.0);
    private static final String VERSION_FILE = "version";
    private Bucket current;
    private File rootLocation;

    public BucketTree(File rootLocation, Bucket bucket) {
        this.rootLocation = rootLocation;
        this.current = bucket;
    }

    public void accept(Bucket.Visitor visitor, IPath root, int depth) throws CoreException {
        this.internalAccept(visitor, root, this.locationFor(root), depth, 0);
    }

    public void close() throws CoreException {
        this.current.save();
        this.saveVersion();
    }

    public Bucket getCurrent() {
        return this.current;
    }

    private boolean internalAccept(Bucket.Visitor visitor, IPath root, File bucketDir, int depthRequested, int currentDepth) throws CoreException {
        this.current.load(bucketDir);
        int outcome = this.current.accept(visitor, root, depthRequested);
        if (outcome != 0) {
            return outcome == 2;
        }
        if (depthRequested == currentDepth) {
            return true;
        }
        File[] subDirs = bucketDir.listFiles();
        if (subDirs == null) {
            return true;
        }
        int i = 0;
        while (i < subDirs.length) {
            if (subDirs[i].isDirectory() && !this.internalAccept(visitor, root, subDirs[i], depthRequested, currentDepth + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void loadBucketFor(IPath path) throws CoreException {
        this.current.load(this.locationFor(path));
    }

    public File locationFor(IPath resourcePath) {
        int segmentCount = resourcePath.segmentCount();
        if (segmentCount == 0) {
            return this.rootLocation;
        }
        if (segmentCount == 1) {
            return new File(this.rootLocation, resourcePath.segment(0));
        }
        IPath location = new Path(resourcePath.segment(0));
        int i = 1;
        while (i < segmentCount - 1) {
            location = location.append(this.translateSegment(resourcePath.segment(i)));
            ++i;
        }
        return new File(this.rootLocation, location.toOSString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveVersion() throws CoreException {
        if (!this.rootLocation.isDirectory()) {
            return;
        }
        File versionFile = new File(this.rootLocation, VERSION_FILE);
        FileOutputStream stream = null;
        boolean failed = false;
        try {
            try {
                stream = new FileOutputStream(versionFile);
                stream.write(this.current.getVersion());
            }
            catch (IOException e) {
                failed = true;
                String message = Policy.bind("resources.writeWorkspaceMeta", versionFile.getAbsolutePath());
                throw new ResourceException(568, null, message, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                if (failed) throw throwable;
                String message = Policy.bind("resources.writeWorkspaceMeta", versionFile.getAbsolutePath());
                throw new ResourceException(568, null, message, e);
            }
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException e) {
            if (failed) return;
            String message = Policy.bind("resources.writeWorkspaceMeta", versionFile.getAbsolutePath());
            throw new ResourceException(568, null, message, e);
        }
        if (stream == null) return;
        stream.close();
    }

    private String translateSegment(String segment) {
        return Long.toHexString((long)Math.abs(segment.hashCode()) % SEGMENT_QUOTA);
    }
}

