/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceForwarder
extends Preferences
implements IEclipsePreferences.IPreferenceChangeListener,
IEclipsePreferences.INodeChangeListener {
    private static final byte[] BYTE_ARRAY_DEFAULT_DEFAULT = new byte[0];
    private IEclipsePreferences pluginRoot = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
    private DefaultPreferences defaultsRoot = (DefaultPreferences)Platform.getPreferencesService().getRootNode().node("default");
    private String pluginID;
    private Plugin plugin;
    private boolean notify = true;

    public PreferenceForwarder(String pluginID) {
        this(null, pluginID);
    }

    public PreferenceForwarder(Plugin plugin, String pluginID) {
        this.plugin = plugin;
        this.pluginID = pluginID;
        this.pluginRoot.addNodeChangeListener(this);
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
        if (this.listeners.size() > 0 && this.pluginID.equals(event.getChild().name())) {
            this.getPluginPreferences().addPreferenceChangeListener(this);
        }
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
    }

    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.getPluginPreferences().addPreferenceChangeListener(this);
        this.listeners.add(listener);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        String key = event.getKey();
        if (newValue == null) {
            newValue = this.getDefault(key, oldValue);
        } else if (oldValue == null) {
            oldValue = this.getDefault(key, newValue);
        }
        this.firePropertyChangeEvent(key, oldValue, newValue);
    }

    private EclipsePreferences getPluginPreferences() {
        try {
            return (EclipsePreferences)this.pluginRoot.node(this.pluginID);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Plug-in preferences must be instances of EclipsePreferences: " + e.getMessage());
        }
    }

    private IEclipsePreferences getDefaultPreferences() {
        return this.defaultsRoot.node(this.pluginID, this.plugin);
    }

    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private Object getDefault(String key, Object obj) {
        IEclipsePreferences defaults = this.getDefaultPreferences();
        if (obj instanceof String) {
            return defaults.get(key, "");
        }
        if (obj instanceof Integer) {
            return new Integer(defaults.getInt(key, 0));
        }
        if (obj instanceof Double) {
            return new Double(defaults.getDouble(key, 0.0));
        }
        if (obj instanceof Float) {
            return new Float(defaults.getFloat(key, 0.0f));
        }
        if (obj instanceof Long) {
            return new Long(defaults.getLong(key, 0L));
        }
        if (obj instanceof byte[]) {
            return defaults.getByteArray(key, BYTE_ARRAY_DEFAULT_DEFAULT);
        }
        if (obj instanceof Boolean) {
            return new Boolean(defaults.getBoolean(key, false));
        }
        return null;
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        String value = this.getPluginPreferences().get(name, null);
        if (value != null) {
            return true;
        }
        return this.getDefaultPreferences().get(name, null) != null;
    }

    public boolean getBoolean(String name) {
        return this.getPluginPreferences().getBoolean(name, this.getDefaultPreferences().getBoolean(name, false));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String name, boolean value) {
        Boolean oldValue = this.getBoolean(name) ? Boolean.TRUE : Boolean.FALSE;
        Boolean newValue = value ? Boolean.TRUE : Boolean.FALSE;
        try {
            this.notify = false;
            if (this.getDefaultBoolean(name) == value) {
                this.getPluginPreferences().remove(name);
            } else {
                this.getPluginPreferences().putBoolean(name, value);
            }
            if (!newValue.equals(oldValue)) {
                this.firePropertyChangeEvent(name, oldValue, newValue);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.notify = true;
            return;
        }
    }

    public boolean getDefaultBoolean(String name) {
        return this.getDefaultPreferences().getBoolean(name, false);
    }

    public void setDefault(String name, boolean value) {
        this.getDefaultPreferences().putBoolean(name, value);
    }

    public double getDouble(String name) {
        return this.getPluginPreferences().getDouble(name, this.getDefaultPreferences().getDouble(name, 0.0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String name, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        Double oldValue = new Double(this.getDouble(name));
        Double newValue = new Double(value);
        try {
            this.notify = false;
            if (this.getDefaultDouble(name) == value) {
                this.getPluginPreferences().remove(name);
            } else {
                this.getPluginPreferences().putDouble(name, value);
            }
            if (!newValue.equals(oldValue)) {
                this.firePropertyChangeEvent(name, oldValue, newValue);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.notify = true;
            return;
        }
    }

    public double getDefaultDouble(String name) {
        return this.getDefaultPreferences().getDouble(name, 0.0);
    }

    public void setDefault(String name, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().putDouble(name, value);
    }

    public float getFloat(String name) {
        return this.getPluginPreferences().getFloat(name, this.getDefaultPreferences().getFloat(name, 0.0f));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String name, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        Float oldValue = new Float(this.getFloat(name));
        Float newValue = new Float(value);
        try {
            this.notify = false;
            if (this.getDefaultFloat(name) == value) {
                this.getPluginPreferences().remove(name);
            } else {
                this.getPluginPreferences().putFloat(name, value);
            }
            if (!newValue.equals(oldValue)) {
                this.firePropertyChangeEvent(name, oldValue, newValue);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.notify = true;
            return;
        }
    }

    public float getDefaultFloat(String name) {
        return this.getDefaultPreferences().getFloat(name, 0.0f);
    }

    public void setDefault(String name, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().putFloat(name, value);
    }

    public int getInt(String name) {
        return this.getPluginPreferences().getInt(name, this.getDefaultPreferences().getInt(name, 0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String name, int value) {
        Integer oldValue = new Integer(this.getInt(name));
        Integer newValue = new Integer(value);
        try {
            this.notify = false;
            if (this.getDefaultInt(name) == value) {
                this.getPluginPreferences().remove(name);
            } else {
                this.getPluginPreferences().putInt(name, value);
            }
            if (!newValue.equals(oldValue)) {
                this.firePropertyChangeEvent(name, oldValue, newValue);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.notify = true;
            return;
        }
    }

    public int getDefaultInt(String name) {
        return this.getDefaultPreferences().getInt(name, 0);
    }

    public void setDefault(String name, int value) {
        this.getDefaultPreferences().putInt(name, value);
    }

    public long getLong(String name) {
        return this.getPluginPreferences().getLong(name, this.getDefaultPreferences().getLong(name, 0L));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String name, long value) {
        Long oldValue = new Long(this.getLong(name));
        Long newValue = new Long(value);
        try {
            this.notify = false;
            if (this.getDefaultLong(name) == value) {
                this.getPluginPreferences().remove(name);
            } else {
                this.getPluginPreferences().putLong(name, value);
            }
            if (!newValue.equals(oldValue)) {
                this.firePropertyChangeEvent(name, oldValue, newValue);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.notify = true;
            return;
        }
    }

    public long getDefaultLong(String name) {
        return this.getDefaultPreferences().getLong(name, 0L);
    }

    public void setDefault(String name, long value) {
        this.getDefaultPreferences().putLong(name, value);
    }

    public String getString(String name) {
        return this.getPluginPreferences().get(name, this.getDefaultPreferences().get(name, ""));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setValue(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        String oldValue = this.getString(name);
        try {
            this.notify = false;
            if (this.getDefaultString(name).equals(value)) {
                this.getPluginPreferences().remove(name);
            } else {
                this.getPluginPreferences().put(name, value);
            }
            if (!value.equals(oldValue)) {
                this.firePropertyChangeEvent(name, oldValue, value);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.notify = true;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.notify = true;
            return;
        }
    }

    public String getDefaultString(String name) {
        return this.getDefaultPreferences().get(name, "");
    }

    public void setDefault(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.getDefaultPreferences().put(name, value);
    }

    public boolean isDefault(String name) {
        if (name == null) {
            return false;
        }
        return this.getPluginPreferences().get(name, null) == null;
    }

    public void setToDefault(String name) {
        EclipsePreferences preferences = this.getPluginPreferences();
        String oldValue = preferences.get(name, null);
        if (oldValue != null) {
            preferences.remove(name);
        }
    }

    public String[] propertyNames() {
        return this.getPluginPreferences().keys();
    }

    public String[] defaultPropertyNames() {
        try {
            return this.getDefaultPreferences().keys();
        }
        catch (BackingStoreException e) {
            this.logError(e.getMessage(), e);
            return new String[0];
        }
    }

    public boolean needsSaving() {
        return this.getPluginPreferences().dirty;
    }

    public void flush() throws BackingStoreException {
        this.getPluginPreferences().flush();
    }

    public void sync() throws BackingStoreException {
        this.getPluginPreferences().sync();
    }

    private void logError(String message, Exception e) {
        Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
        InternalPlatform.getDefault().log(status);
    }

    public void load(InputStream in) throws IOException {
        Properties result = new Properties();
        result.load(in);
        this.convertFromProperties(result);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void store(OutputStream out, String header) throws IOException {
        Properties result = this.convertToProperties();
        result.store(out, header);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void convertFromProperties(Properties props) {
        EclipsePreferences preferences = this.getPluginPreferences();
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = props.getProperty(key);
            if (value == null) continue;
            preferences.put(key, value);
        }
    }

    public String toString() {
        return "PreferenceForwarder(" + this.pluginID + ")";
    }

    private Properties convertToProperties() {
        Properties result = new Properties();
        String[] keys = this.propertyNames();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            String value = this.getString(key);
            if (!"".equals(value)) {
                result.put(key, value);
            }
            ++i;
        }
        return result;
    }
}

