/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;

public class ContextFinder
extends ClassLoader {
    static final Finder contextFinder = (Finder)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new Finder();
        }
    });
    static /* synthetic */ Class class$0;

    public ContextFinder(ClassLoader contextClassLoader) {
        super(contextClassLoader);
    }

    ClassLoader basicFindClassLoader() {
        Class[] stack = contextFinder.getClassContext();
        ClassLoader result = null;
        int i = 1;
        while (i < stack.length) {
            ClassLoader tmp = stack[i].getClassLoader();
            Class clazz = stack[i];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.core.runtime.internal.adaptor.ContextFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2 && tmp != null) {
                result = tmp;
                break;
            }
            ++i;
        }
        if (this.checkClassLoader(result)) {
            return result;
        }
        return null;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        ClassLoader parent = classloader.getParent();
        while (parent != null) {
            if (parent == this) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    private ClassLoader findClassLoader() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ContextFinder.this.basicFindClassLoader();
            }
        });
    }

    protected synchronized Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        ClassLoader toConsult;
        Class<?> result = null;
        try {
            result = super.loadClass(arg0, arg1);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (result == null && (toConsult = this.findClassLoader()) != null) {
            result = toConsult.loadClass(arg0);
        }
        if (result == null) {
            throw new ClassNotFoundException(arg0);
        }
        return result;
    }

    protected URL findResource(String arg0) {
        ClassLoader toConsult;
        URL result = super.findResource(arg0);
        if (result == null && (toConsult = this.findClassLoader()) != null) {
            result = toConsult.getResource(arg0);
        }
        return result;
    }

    protected Enumeration findResources(String arg0) {
        try {
            ClassLoader toConsult;
            Enumeration<URL> result = super.findResources(arg0);
            if (result == null && (toConsult = this.findClassLoader()) != null) {
                result = toConsult.getResources(arg0);
            }
            return result;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static final class Finder
    extends SecurityManager {
        Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

