/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.concurrent;

/**
 *
 * @version CVS $Revision: 1.4 $ $Date: 2001/12/11 09:53:28 $
 * @since 4.0
 */

public class Semaphore
    implements Sync
{
    private long   m_tokens;

    public Semaphore( final long tokens )
    {
        m_tokens = tokens;
    }

    public synchronized void acquire()
        throws InterruptedException
    {
        //TODO: check for interuption outside sync block?
        if( Thread.interrupted() ) throw new InterruptedException();

        //While there is no more tokens left wait
        while( 0 >= m_tokens )
        {
            wait();
        }
        m_tokens--;
    }

    public synchronized void release()
    {
        m_tokens++;
        notify();
    }

    public synchronized boolean attempt( final long msecs )
        throws InterruptedException
    {
        if( Thread.interrupted() ) throw new InterruptedException();

        if( m_tokens > 0 )
        {
            m_tokens--;
            return true;
        }
        else
        {
            final long start = System.currentTimeMillis();
            long wait = msecs;

            while( wait > 0 )
            {
                wait( wait );

                if( m_tokens > 0 )
                {
                    m_tokens--;
                    return true;
                }
                else
                {
                    wait = msecs - (System.currentTimeMillis() - start);
                }
            }

            return false;
        }
    }
}
