/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.Map;
import java.util.Locale;

/**
 * This is the interface of the ResourceBundle, for used for i18n support.
 *
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version CVS $Revision: 1.6 $ $Date: 2002/01/02 19:04:56 $ $Author: neeme $
 */
public interface Bundle {

    String ROLE = "org.apache.avalon.excalibur.i18n.Bundle";

    /**
     * Get the bundle info.
     */
    BundleInfo getBundleInfo();

    /**
     * Set the bundle info.
     */
    void setBundleInfo(BundleInfo bundleInfo);

    /**
     * Set the bundle info mapper.
     */
    void setMapper(BundleInfoMapper mapper);

    /**
     * Get the parent bundle of the current bundle.
     *
     * @return the parent bundle
     */
    Bundle getParent();

    /**
     * Set the parent bundle of the current bundle.
     *
     * @param parent    the parent bundle
     */
    void setParent(Bundle parent);

    /**
     * Get value by key.
     *
     * @param key           key
     * @return              value
     * @exception MissingResourceException if value was not found
     */
    String getString(String key);

    /**
     * Get value by key and substitute variables.
     *
     * @param key           key
     * @param values        map with variable values
     * @return              value with variable values substituted
     * @exception MissingResourceException if value was not found
     */
    String getString(String key, Map values);

    /**
     * Convert the &quot;user view&quot; of the lookup key to the
     * &quot;system view&quot;. Used to hide the implemented storage
     * mechanism and/or XML file schema.
     *
     * @param key           user key
     * @return              system key
     */
    String convertKey(String userKey);

    /**
     * Returns the last modification time of this bundle, in milliseconds.
     *
     * @return              last modification time, -1 if N/A
     */
    long getLastModified();

    /**
     * Sets the last modification time of this bundle, in milliseconds.
     *
     * @param lastModified  last modification time
     */
    void setLastModified(long lastModified);
}
