/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n;

/**
 * Used to map bundle information to string representation (e.g. URI),
 * to find the relevant bundle.
 *
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version CVS $Revision: 1.6 $ $Date: 2002/01/24 02:10:27 $ $Author: leif $
 */
public interface BundleInfoMapper {

    String ROLE = "org.apache.avalon.excalibur.i18n.BundleInfoMapper";

    /**
     * Get the string form of the bundle, based on bundle info.
     *
     * @return      the string form
     */
    String map(BundleInfo bundleInfo);
}
