/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.pool;

/**
 * This interface is for a PoolManager that creates pools that are managed
 * asynchronously.  The contract is that the controller type is specified in
 * the constructor.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.2 $ $Date: 2001/12/26 17:59:20 $
 * @since 4.1
 */
public interface PoolManager
{
    /**
     * Return a managed pool that has a controller.
     */
    Pool getManagedPool( ObjectFactory factory, int initialEntries )
        throws Exception;
}
