/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.Poolable;

/**
 * Used to define an object which can be validated by a ValidatedResourceLimitingPool.
 *
 * @author <a href="mailto:leif@silveregg.co.jp">Leif Mortenson</a>
 * @version CVS $Revision: 1.2 $ $Date: 2002/01/25 01:24:27 $
 * @since 4.1
 */
public interface Validatable
    extends Poolable
{
    /**
     * Called when an object is retrieved from a ValidatedResourceLimitingPool for reuse.
     *
     * @returns true if the object is ok.  false will cause the object to be discarded.
     */
    boolean validate();
}

