package org.apache.avalon.excalibur.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.TestResult;
import junit.swingui.TestRunner;

public class ExcaliburTestSuite 
    extends TestCase
{
    private Test m_excaliburTest = ExcaliburTestSuite.suite();

    public ExcaliburTestSuite( final String name )
    {
        super( name );
    }

    public int countTestCases()
    {
        return m_excaliburTest.countTestCases();
    }

    public void run( final TestResult result )
    {
        m_excaliburTest.run( result );
    }

    public static Test suite()
    {
        final TestSuite suite = new TestSuite();
        suite.addTestSuite( org.apache.avalon.excalibur.cli.test.ClutilTestCase.class );
        suite.addTestSuite( org.apache.avalon.excalibur.collections.test.BinaryHeapTestCase.class );
        suite.addTestSuite( org.apache.avalon.excalibur.datasource.test.DataSourceTestCase.class );
        suite.addTestSuite( org.apache.avalon.excalibur.io.test.FileUtilTestCase.class );
        suite.addTestSuite( org.apache.avalon.excalibur.io.test.IOUtilTestCase.class );
        suite.addTestSuite( org.apache.avalon.excalibur.property.test.PropertyUtilTestCase.class );
        //suite.addTestSuite( org.apache.avalon.excalibur.pool.test.PoolProfile.class );

        return suite;
    }

    public static void main( final String[] args )
    {
        final String[] testCaseName = { ExcaliburTestSuite.class.getName() };
        TestRunner.main( testCaseName );
    }
}
