/**********************************************************************
 * MPEG/Audio Tables I/O routines
 **********************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include "toolame.h"
#include "toolame_global_flags.h"
#include "common.h"
#include "mem.h"
#include "tables.h"

#define NUMTABLES 38
char table_names[NUMTABLES][9];
long table_offsets[NUMTABLES];
int numtables = 0;
char table_filename[250];

int pick_table (toolame_options *glopts, frame_info * frame)
/* choose table, load if necess, return # sb's */
{
  int table, lay, bsp, br_per_ch, sfrq;
  int sblim = frame->sblimit;	/* return current value if no load */

  lay = frame->header->lay - 1;
  bsp = frame->header->bitrate_index;
  br_per_ch = toolame_getBitrate(glopts) / frame->nch;
  sfrq = (int)(frame->header->sampling_frequency/1000.0);
  /* decision rules refer to per-channel bitrates (kbits/sec/chan) */
  if (frame->header->version == MPEG_AUDIO_ID) {	/* MPEG-1 */
    if ((sfrq == 48 && br_per_ch >= 56)
	|| (br_per_ch >= 56 && br_per_ch <= 80))
      table = 0;
    else if (sfrq != 48 && br_per_ch >= 96)
      table = 1;
    else if (sfrq != 32 && br_per_ch <= 48)
      table = 2;
    else
      table = 3;
  } else {			/* MPEG-2 LSF */
    table = 4;
  }
  if (frame->tab_num != table) {
    if (frame->tab_num >= 0)
      toolame_free ((void **) &(frame->alloc));
    frame->alloc = (al_table *) toolame_malloc (sizeof (al_table), "alloc");
    sblim = read_bit_alloc (frame->tab_num = table, frame->alloc);
  }
  return sblim;
}


/***********************************************************************
 *
 * Read one of the data files ("alloc_*") specifying the bit allocation
 * quatization parameters for each subband in layer II encoding
 *
 **********************************************************************/

int read_bit_alloc (int table, al_table *alloc)	/* read in table, return # subbands */
{

  static const int startindex_subband[5] = { 0, 290, 592, 674, 788 };

  static const char alloc_subbands[][20] = {
    "<alloc_0>",
    "27",
    "0 0 0 4 0 0",
    "0 1 3 5 1 0",
    "0 2 7 3 3 2",
    "0 3 15 4 3 4",
    "0 4 31 5 3 5",
    "0 5 63 6 3 6",
    "0 6 127 7 3 7",
    "0 7 255 8 3 8",
    "0 8 511 9 3 9",
    "0 9 1023 10 3 10",
    "0 10 2047 11 3 11",
    "0 11 4095 12 3 12",
    "0 12 8191 13 3 13",
    "0 13 16383 14 3 14",
    "0 14 32767 15 3 15",
    "0 15 65535 16 3 16",
    "1 0 0 4 0 0",
    "1 1 3 5 1 0",
    "1 2 7 3 3 2",
    "1 3 15 4 3 4",
    "1 4 31 5 3 5",
    "1 5 63 6 3 6",
    "1 6 127 7 3 7",
    "1 7 255 8 3 8",
    "1 8 511 9 3 9",
    "1 9 1023 10 3 10",
    "1 10 2047 11 3 11",
    "1 11 4095 12 3 12",
    "1 12 8191 13 3 13",
    "1 13 16383 14 3 14",
    "1 14 32767 15 3 15",
    "1 15 65535 16 3 16",
    "2 0 0 4 0 0",
    "2 1 3 5 1 0",
    "2 2 7 3 3 2",
    "2 3 15 4 3 4",
    "2 4 31 5 3 5",
    "2 5 63 6 3 6",
    "2 6 127 7 3 7",
    "2 7 255 8 3 8",
    "2 8 511 9 3 9",
    "2 9 1023 10 3 10",
    "2 10 2047 11 3 11",
    "2 11 4095 12 3 12",
    "2 12 8191 13 3 13",
    "2 13 16383 14 3 14",
    "2 14 32767 15 3 15",
    "2 15 65535 16 3 16",
    "3 0 0 4 0 0",
    "3 1 3 5 1 0",
    "3 2 5 7 1 1",
    "3 3 7 3 3 2",
    "3 4 9 10 1 3",
    "3 5 15 4 3 4",
    "3 6 31 5 3 5",
    "3 7 63 6 3 6",
    "3 8 127 7 3 7 ",
    "3 9 255 8 3 8",
    "3 10 511 9 3 9",
    "3 11 1023 10 3 10",
    "3 12 2047 11 3 11",
    "3 13 4095 12 3 12",
    "3 14 8191 13 3 13",
    "3 15 65535 16 3 16",
    "4 0 0 4 0 0",
    "4 1 3 5 1 0",
    "4 2 5 7 1 1",
    "4 3 7 3 3 2",
    "4 4 9 10 1 3",
    "4 5 15 4 3 4",
    "4 6 31 5 3 5",
    "4 7 63 6 3 6",
    "4 8 127 7 3 7 ",
    "4 9 255 8 3 8",
    "4 10 511 9 3 9",
    "4 11 1023 10 3 10",
    "4 12 2047 11 3 11",
    "4 13 4095 12 3 12",
    "4 14 8191 13 3 13",
    "4 15 65535 16 3 16",
    "5 0 0 4 0 0",
    "5 1 3 5 1 0",
    "5 2 5 7 1 1",
    "5 3 7 3 3 2",
    "5 4 9 10 1 3",
    "5 5 15 4 3 4",
    "5 6 31 5 3 5",
    "5 7 63 6 3 6",
    "5 8 127 7 3 7 ",
    "5 9 255 8 3 8",
    "5 10 511 9 3 9",
    "5 11 1023 10 3 10",
    "5 12 2047 11 3 11",
    "5 13 4095 12 3 12",
    "5 14 8191 13 3 13",
    "5 15 65535 16 3 16",
    "6 0 0 4 0 0",
    "6 1 3 5 1 0",
    "6 2 5 7 1 1",
    "6 3 7 3 3 2",
    "6 4 9 10 1 3",
    "6 5 15 4 3 4",
    "6 6 31 5 3 5",
    "6 7 63 6 3 6",
    "6 8 127 7 3 7 ",
    "6 9 255 8 3 8",
    "6 10 511 9 3 9",
    "6 11 1023 10 3 10",
    "6 12 2047 11 3 11",
    "6 13 4095 12 3 12",
    "6 14 8191 13 3 13",
    "6 15 65535 16 3 16",
    "7 0 0 4 0 0",
    "7 1 3 5 1 0",
    "7 2 5 7 1 1",
    "7 3 7 3 3 2",
    "7 4 9 10 1 3",
    "7 5 15 4 3 4",
    "7 6 31 5 3 5",
    "7 7 63 6 3 6",
    "7 8 127 7 3 7 ",
    "7 9 255 8 3 8",
    "7 10 511 9 3 9",
    "7 11 1023 10 3 10",
    "7 12 2047 11 3 11",
    "7 13 4095 12 3 12",
    "7 14 8191 13 3 13",
    "7 15 65535 16 3 16",
    "8 0 0 4 0 0",
    "8 1 3 5 1 0",
    "8 2 5 7 1 1",
    "8 3 7 3 3 2",
    "8 4 9 10 1 3",
    "8 5 15 4 3 4",
    "8 6 31 5 3 5",
    "8 7 63 6 3 6",
    "8 8 127 7 3 7 ",
    "8 9 255 8 3 8",
    "8 10 511 9 3 9",
    "8 11 1023 10 3 10",
    "8 12 2047 11 3 11",
    "8 13 4095 12 3 12",
    "8 14 8191 13 3 13",
    "8 15 65535 16 3 16",
    "9 0 0 4 0 0",
    "9 1 3 5 1 0",
    "9 2 5 7 1 1",
    "9 3 7 3 3 2",
    "9 4 9 10 1 3",
    "9 5 15 4 3 4",
    "9 6 31 5 3 5",
    "9 7 63 6 3 6",
    "9 8 127 7 3 7 ",
    "9 9 255 8 3 8",
    "9 10 511 9 3 9",
    "9 11 1023 10 3 10",
    "9 12 2047 11 3 11",
    "9 13 4095 12 3 12",
    "9 14 8191 13 3 13",
    "9 15 65535 16 3 16",
    "10 0 0 4 0 0",
    "10 1 3 5 1 0",
    "10 2 5 7 1 1",
    "10 3 7 3 3 2",
    "10 4 9 10 1 3",
    "10 5 15 4 3 4",
    "10 6 31 5 3 5",
    "10 7 63 6 3 6",
    "10 8 127 7 3 7 ",
    "10 9 255 8 3 8",
    "10 10 511 9 3 9",
    "10 11 1023 10 3 10",
    "10 12 2047 11 3 11",
    "10 13 4095 12 3 12",
    "10 14 8191 13 3 13",
    "10 15 65535 16 3 16",
    "11 0 0 3 0 0",
    "11 1 3 5 1 0",
    "11 2 5 7 1 1",
    "11 3 7 3 3 2",
    "11 4 9 10 1 3",
    "11 5 15 4 3 4",
    "11 6 31 5 3 5",
    "11 7 65535 16 3 16 ",
    "12 0 0 3 0 0",
    "12 1 3 5 1 0",
    "12 2 5 7 1 1",
    "12 3 7 3 3 2",
    "12 4 9 10 1 3",
    "12 5 15 4 3 4",
    "12 6 31 5 3 5",
    "12 7 65535 16 3 16 ",
    "13 0 0 3 0 0",
    "13 1 3 5 1 0",
    "13 2 5 7 1 1",
    "13 3 7 3 3 2",
    "13 4 9 10 1 3",
    "13 5 15 4 3 4",
    "13 6 31 5 3 5",
    "13 7 65535 16 3 16 ",
    "14 0 0 3 0 0",
    "14 1 3 5 1 0",
    "14 2 5 7 1 1",
    "14 3 7 3 3 2",
    "14 4 9 10 1 3",
    "14 5 15 4 3 4",
    "14 6 31 5 3 5",
    "14 7 65535 16 3 16 ",
    "15 0 0 3 0 0",
    "15 1 3 5 1 0",
    "15 2 5 7 1 1",
    "15 3 7 3 3 2",
    "15 4 9 10 1 3",
    "15 5 15 4 3 4",
    "15 6 31 5 3 5",
    "15 7 65535 16 3 16 ",
    "16 0 0 3 0 0",
    "16 1 3 5 1 0",
    "16 2 5 7 1 1",
    "16 3 7 3 3 2",
    "16 4 9 10 1 3",
    "16 5 15 4 3 4",
    "16 6 31 5 3 5",
    "16 7 65535 16 3 16 ",
    "17 0 0 3 0 0",
    "17 1 3 5 1 0",
    "17 2 5 7 1 1",
    "17 3 7 3 3 2",
    "17 4 9 10 1 3",
    "17 5 15 4 3 4",
    "17 6 31 5 3 5",
    "17 7 65535 16 3 16 ",
    "18 0 0 3 0 0",
    "18 1 3 5 1 0",
    "18 2 5 7 1 1",
    "18 3 7 3 3 2",
    "18 4 9 10 1 3",
    "18 5 15 4 3 4",
    "18 6 31 5 3 5",
    "18 7 65535 16 3 16 ",
    "19 0 0 3 0 0",
    "19 1 3 5 1 0",
    "19 2 5 7 1 1",
    "19 3 7 3 3 2",
    "19 4 9 10 1 3",
    "19 5 15 4 3 4",
    "19 6 31 5 3 5",
    "19 7 65535 16 3 16 ",
    "20 0 0 3 0 0",
    "20 1 3 5 1 0",
    "20 2 5 7 1 1",
    "20 3 7 3 3 2",
    "20 4 9 10 1 3",
    "20 5 15 4 3 4",
    "20 6 31 5 3 5",
    "20 7 65535 16 3 16 ",
    "21 0 0 3 0 0",
    "21 1 3 5 1 0",
    "21 2 5 7 1 1",
    "21 3 7 3 3 2",
    "21 4 9 10 1 3",
    "21 5 15 4 3 4",
    "21 6 31 5 3 5",
    "21 7 65535 16 3 16 ",
    "22 0 0 3 0 0",
    "22 1 3 5 1 0",
    "22 2 5 7 1 1",
    "22 3 7 3 3 2",
    "22 4 9 10 1 3",
    "22 5 15 4 3 4",
    "22 6 31 5 3 5",
    "22 7 65535 16 3 16 ",
    "23 0 0 2 0 0",
    "23 1 3 5 1 0",
    "23 2 5 7 1 1",
    "23 3 65535 16 3 16",
    "24 0 0 2 0 0",
    "24 1 3 5 1 0",
    "24 2 5 7 1 1",
    "24 3 65535 16 3 16",
    "25 0 0 2 0 0",
    "25 1 3 5 1 0",
    "25 2 5 7 1 1",
    "25 3 65535 16 3 16",
    "26 0 0 2 0 0",
    "26 1 3 5 1 0",
    "26 2 5 7 1 1",
    "26 3 65535 16 3 16",
    "<alloc_1>",
    "30",
    "0 0 0 4 0 0",
    "0 1 3 5 1 0",
    "0 2 7 3 3 2",
    "0 3 15 4 3 4",
    "0 4 31 5 3 5",
    "0 5 63 6 3 6",
    "0 6 127 7 3 7",
    "0 7 255 8 3 8",
    "0 8 511 9 3 9",
    "0 9 1023 10 3 10",
    "0 10 2047 11 3 11",
    "0 11 4095 12 3 12",
    "0 12 8191 13 3 13",
    "0 13 16383 14 3 14",
    "0 14 32767 15 3 15",
    "0 15 65535 16 3 16",
    "1 0 0 4 0 0",
    "1 1 3 5 1 0",
    "1 2 7 3 3 2",
    "1 3 15 4 3 4",
    "1 4 31 5 3 5",
    "1 5 63 6 3 6",
    "1 6 127 7 3 7",
    "1 7 255 8 3 8",
    "1 8 511 9 3 9",
    "1 9 1023 10 3 10",
    "1 10 2047 11 3 11",
    "1 11 4095 12 3 12",
    "1 12 8191 13 3 13",
    "1 13 16383 14 3 14",
    "1 14 32767 15 3 15",
    "1 15 65535 16 3 16",
    "2 0 0 4 0 0",
    "2 1 3 5 1 0",
    "2 2 7 3 3 2",
    "2 3 15 4 3 4",
    "2 4 31 5 3 5",
    "2 5 63 6 3 6",
    "2 6 127 7 3 7",
    "2 7 255 8 3 8",
    "2 8 511 9 3 9",
    "2 9 1023 10 3 10",
    "2 10 2047 11 3 11",
    "2 11 4095 12 3 12",
    "2 12 8191 13 3 13",
    "2 13 16383 14 3 14",
    "2 14 32767 15 3 15",
    "2 15 65535 16 3 16",
    "3 0 0 4 0 0",
    "3 1 3 5 1 0",
    "3 2 5 7 1 1",
    "3 3 7 3 3 2",
    "3 4 9 10 1 3",
    "3 5 15 4 3 4",
    "3 6 31 5 3 5",
    "3 7 63 6 3 6",
    "3 8 127 7 3 7 ",
    "3 9 255 8 3 8",
    "3 10 511 9 3 9",
    "3 11 1023 10 3 10",
    "3 12 2047 11 3 11",
    "3 13 4095 12 3 12",
    "3 14 8191 13 3 13",
    "3 15 65535 16 3 16",
    "4 0 0 4 0 0",
    "4 1 3 5 1 0",
    "4 2 5 7 1 1",
    "4 3 7 3 3 2",
    "4 4 9 10 1 3",
    "4 5 15 4 3 4",
    "4 6 31 5 3 5",
    "4 7 63 6 3 6",
    "4 8 127 7 3 7 ",
    "4 9 255 8 3 8",
    "4 10 511 9 3 9",
    "4 11 1023 10 3 10",
    "4 12 2047 11 3 11",
    "4 13 4095 12 3 12",
    "4 14 8191 13 3 13",
    "4 15 65535 16 3 16",
    "5 0 0 4 0 0",
    "5 1 3 5 1 0",
    "5 2 5 7 1 1",
    "5 3 7 3 3 2",
    "5 4 9 10 1 3",
    "5 5 15 4 3 4",
    "5 6 31 5 3 5",
    "5 7 63 6 3 6",
    "5 8 127 7 3 7 ",
    "5 9 255 8 3 8",
    "5 10 511 9 3 9",
    "5 11 1023 10 3 10",
    "5 12 2047 11 3 11",
    "5 13 4095 12 3 12",
    "5 14 8191 13 3 13",
    "5 15 65535 16 3 16",
    "6 0 0 4 0 0",
    "6 1 3 5 1 0",
    "6 2 5 7 1 1",
    "6 3 7 3 3 2",
    "6 4 9 10 1 3",
    "6 5 15 4 3 4",
    "6 6 31 5 3 5",
    "6 7 63 6 3 6",
    "6 8 127 7 3 7 ",
    "6 9 255 8 3 8",
    "6 10 511 9 3 9",
    "6 11 1023 10 3 10",
    "6 12 2047 11 3 11",
    "6 13 4095 12 3 12",
    "6 14 8191 13 3 13",
    "6 15 65535 16 3 16",
    "7 0 0 4 0 0",
    "7 1 3 5 1 0",
    "7 2 5 7 1 1",
    "7 3 7 3 3 2",
    "7 4 9 10 1 3",
    "7 5 15 4 3 4",
    "7 6 31 5 3 5",
    "7 7 63 6 3 6",
    "7 8 127 7 3 7 ",
    "7 9 255 8 3 8",
    "7 10 511 9 3 9",
    "7 11 1023 10 3 10",
    "7 12 2047 11 3 11",
    "7 13 4095 12 3 12",
    "7 14 8191 13 3 13",
    "7 15 65535 16 3 16",
    "8 0 0 4 0 0",
    "8 1 3 5 1 0",
    "8 2 5 7 1 1",
    "8 3 7 3 3 2",
    "8 4 9 10 1 3",
    "8 5 15 4 3 4",
    "8 6 31 5 3 5",
    "8 7 63 6 3 6",
    "8 8 127 7 3 7 ",
    "8 9 255 8 3 8",
    "8 10 511 9 3 9",
    "8 11 1023 10 3 10",
    "8 12 2047 11 3 11",
    "8 13 4095 12 3 12",
    "8 14 8191 13 3 13",
    "8 15 65535 16 3 16",
    "9 0 0 4 0 0",
    "9 1 3 5 1 0",
    "9 2 5 7 1 1",
    "9 3 7 3 3 2",
    "9 4 9 10 1 3",
    "9 5 15 4 3 4",
    "9 6 31 5 3 5",
    "9 7 63 6 3 6",
    "9 8 127 7 3 7 ",
    "9 9 255 8 3 8",
    "9 10 511 9 3 9",
    "9 11 1023 10 3 10",
    "9 12 2047 11 3 11",
    "9 13 4095 12 3 12",
    "9 14 8191 13 3 13",
    "9 15 65535 16 3 16",
    "10 0 0 4 0 0",
    "10 1 3 5 1 0",
    "10 2 5 7 1 1",
    "10 3 7 3 3 2",
    "10 4 9 10 1 3",
    "10 5 15 4 3 4",
    "10 6 31 5 3 5",
    "10 7 63 6 3 6",
    "10 8 127 7 3 7 ",
    "10 9 255 8 3 8",
    "10 10 511 9 3 9",
    "10 11 1023 10 3 10",
    "10 12 2047 11 3 11",
    "10 13 4095 12 3 12",
    "10 14 8191 13 3 13",
    "10 15 65535 16 3 16",
    "11 0 0 3 0 0",
    "11 1 3 5 1 0",
    "11 2 5 7 1 1",
    "11 3 7 3 3 2",
    "11 4 9 10 1 3",
    "11 5 15 4 3 4",
    "11 6 31 5 3 5",
    "11 7 65535 16 3 16 ",
    "12 0 0 3 0 0",
    "12 1 3 5 1 0",
    "12 2 5 7 1 1",
    "12 3 7 3 3 2",
    "12 4 9 10 1 3",
    "12 5 15 4 3 4",
    "12 6 31 5 3 5",
    "12 7 65535 16 3 16 ",
    "13 0 0 3 0 0",
    "13 1 3 5 1 0",
    "13 2 5 7 1 1",
    "13 3 7 3 3 2",
    "13 4 9 10 1 3",
    "13 5 15 4 3 4",
    "13 6 31 5 3 5",
    "13 7 65535 16 3 16 ",
    "14 0 0 3 0 0",
    "14 1 3 5 1 0",
    "14 2 5 7 1 1",
    "14 3 7 3 3 2",
    "14 4 9 10 1 3",
    "14 5 15 4 3 4",
    "14 6 31 5 3 5",
    "14 7 65535 16 3 16 ",
    "15 0 0 3 0 0",
    "15 1 3 5 1 0",
    "15 2 5 7 1 1",
    "15 3 7 3 3 2",
    "15 4 9 10 1 3",
    "15 5 15 4 3 4",
    "15 6 31 5 3 5",
    "15 7 65535 16 3 16 ",
    "16 0 0 3 0 0",
    "16 1 3 5 1 0",
    "16 2 5 7 1 1",
    "16 3 7 3 3 2",
    "16 4 9 10 1 3",
    "16 5 15 4 3 4",
    "16 6 31 5 3 5",
    "16 7 65535 16 3 16 ",
    "17 0 0 3 0 0",
    "17 1 3 5 1 0",
    "17 2 5 7 1 1",
    "17 3 7 3 3 2",
    "17 4 9 10 1 3",
    "17 5 15 4 3 4",
    "17 6 31 5 3 5",
    "17 7 65535 16 3 16 ",
    "18 0 0 3 0 0",
    "18 1 3 5 1 0",
    "18 2 5 7 1 1",
    "18 3 7 3 3 2",
    "18 4 9 10 1 3",
    "18 5 15 4 3 4",
    "18 6 31 5 3 5",
    "18 7 65535 16 3 16 ",
    "19 0 0 3 0 0",
    "19 1 3 5 1 0",
    "19 2 5 7 1 1",
    "19 3 7 3 3 2",
    "19 4 9 10 1 3",
    "19 5 15 4 3 4",
    "19 6 31 5 3 5",
    "19 7 65535 16 3 16 ",
    "20 0 0 3 0 0",
    "20 1 3 5 1 0",
    "20 2 5 7 1 1",
    "20 3 7 3 3 2",
    "20 4 9 10 1 3",
    "20 5 15 4 3 4",
    "20 6 31 5 3 5",
    "20 7 65535 16 3 16 ",
    "21 0 0 3 0 0",
    "21 1 3 5 1 0",
    "21 2 5 7 1 1",
    "21 3 7 3 3 2",
    "21 4 9 10 1 3",
    "21 5 15 4 3 4",
    "21 6 31 5 3 5",
    "21 7 65535 16 3 16 ",
    "22 0 0 3 0 0",
    "22 1 3 5 1 0",
    "22 2 5 7 1 1",
    "22 3 7 3 3 2",
    "22 4 9 10 1 3",
    "22 5 15 4 3 4",
    "22 6 31 5 3 5",
    "22 7 65535 16 3 16 ",
    "23 0 0 2 0 0",
    "23 1 3 5 1 0",
    "23 2 5 7 1 1",
    "23 3 65535 16 3 16",
    "24 0 0 2 0 0",
    "24 1 3 5 1 0",
    "24 2 5 7 1 1",
    "24 3 65535 16 3 16",
    "25 0 0 2 0 0",
    "25 1 3 5 1 0",
    "25 2 5 7 1 1",
    "25 3 65535 16 3 16",
    "26 0 0 2 0 0",
    "26 1 3 5 1 0",
    "26 2 5 7 1 1",
    "26 3 65535 16 3 16",
    "27 0 0 2 0 0",
    "27 1 3 5 1 0",
    "27 2 5 7 1 1",
    "27 3 65535 16 3 16",
    "28 0 0 2 0 0",
    "28 1 3 5 1 0",
    "28 2 5 7 1 1",
    "28 3 65535 16 3 16",
    "29 0 0 2 0 0",
    "29 1 3 5 1 0",
    "29 2 5 7 1 1",
    "29 3 65535 16 3 16",
    "<alloc_2>",
    "8",
    "0 0 0 4 0 0",
    "0 1 3 5 1 0",
    "0 2 5 7 1 1",
    "0 3 9 10 1 3",
    "0 4 15 4 3 4",
    "0 5 31 5 3 5",
    "0 6 63 6 3 6",
    "0 7 127 7 3 7",
    "0 8 255 8 3 8",
    "0 9 511 9 3 9",
    "0 10 1023 10 3 10",
    "0 11 2047 11 3 11",
    "0 12 4095 12 3 12",
    "0 13 8191 13 3 13",
    "0 14 16383 14 3 14",
    "0 15 32767 15 3 15",
    "1 0 0 4 0 0",
    "1 1 3 5 1 0",
    "1 2 5 7 1 1",
    "1 3 9 10 1 3",
    "1 4 15 4 3 4",
    "1 5 31 5 3 5",
    "1 6 63 6 3 6",
    "1 7 127 7 3 7",
    "1 8 255 8 3 8",
    "1 9 511 9 3 9",
    "1 10 1023 10 3 10",
    "1 11 2047 11 3 11",
    "1 12 4095 12 3 12",
    "1 13 8191 13 3 13",
    "1 14 16383 14 3 14",
    "1 15 32767 15 3 15",
    "2 0 0 3 0 0",
    "2 1 3 5 1 0",
    "2 2 5 7 1 1",
    "2 3 9 10 1 3",
    "2 4 15 4 3 4",
    "2 5 31 5 3 5",
    "2 6 63 6 3 6",
    "2 7 127 7 3 7",
    "3 0 0 3 0 0",
    "3 1 3 5 1 0",
    "3 2 5 7 1 1",
    "3 3 9 10 1 3",
    "3 4 15 4 3 4",
    "3 5 31 5 3 5",
    "3 6 63 6 3 6",
    "3 7 127 7 3 7",
    "4 0 0 3 0 0",
    "4 1 3 5 1 0",
    "4 2 5 7 1 1",
    "4 3 9 10 1 3",
    "4 4 15 4 3 4",
    "4 5 31 5 3 5",
    "4 6 63 6 3 6",
    "4 7 127 7 3 7",
    "5 0 0 3 0 0",
    "5 1 3 5 1 0",
    "5 2 5 7 1 1",
    "5 3 9 10 1 3",
    "5 4 15 4 3 4",
    "5 5 31 5 3 5",
    "5 6 63 6 3 6",
    "5 7 127 7 3 7",
    "6 0 0 3 0 0",
    "6 1 3 5 1 0",
    "6 2 5 7 1 1",
    "6 3 9 10 1 3",
    "6 4 15 4 3 4",
    "6 5 31 5 3 5",
    "6 6 63 6 3 6",
    "6 7 127 7 3 7",
    "7 0 0 3 0 0",
    "7 1 3 5 1 0",
    "7 2 5 7 1 1",
    "7 3 9 10 1 3",
    "7 4 15 4 3 4",
    "7 5 31 5 3 5",
    "7 6 63 6 3 6",
    "7 7 127 7 3 7",
    "<alloc_3>",
    "12",
    "0 0 0 4 0 0",
    "0 1 3 5 1 0",
    "0 2 5 7 1 1",
    "0 3 9 10 1 3",
    "0 4 15 4 3 4",
    "0 5 31 5 3 5",
    "0 6 63 6 3 6",
    "0 7 127 7 3 7",
    "0 8 255 8 3 8",
    "0 9 511 9 3 9",
    "0 10 1023 10 3 10",
    "0 11 2047 11 3 11",
    "0 12 4095 12 3 12",
    "0 13 8191 13 3 13",
    "0 14 16383 14 3 14",
    "0 15 32767 15 3 15",
    "1 0 0 4 0 0",
    "1 1 3 5 1 0",
    "1 2 5 7 1 1",
    "1 3 9 10 1 3",
    "1 4 15 4 3 4",
    "1 5 31 5 3 5",
    "1 6 63 6 3 6",
    "1 7 127 7 3 7",
    "1 8 255 8 3 8",
    "1 9 511 9 3 9",
    "1 10 1023 10 3 10",
    "1 11 2047 11 3 11",
    "1 12 4095 12 3 12",
    "1 13 8191 13 3 13",
    "1 14 16383 14 3 14",
    "1 15 32767 15 3 15",
    "2 0 0 3 0 0",
    "2 1 3 5 1 0",
    "2 2 5 7 1 1",
    "2 3 9 10 1 3",
    "2 4 15 4 3 4",
    "2 5 31 5 3 5",
    "2 6 63 6 3 6",
    "2 7 127 7 3 7",
    "3 0 0 3 0 0",
    "3 1 3 5 1 0",
    "3 2 5 7 1 1",
    "3 3 9 10 1 3",
    "3 4 15 4 3 4",
    "3 5 31 5 3 5",
    "3 6 63 6 3 6",
    "3 7 127 7 3 7",
    "4 0 0 3 0 0",
    "4 1 3 5 1 0",
    "4 2 5 7 1 1",
    "4 3 9 10 1 3",
    "4 4 15 4 3 4",
    "4 5 31 5 3 5",
    "4 6 63 6 3 6",
    "4 7 127 7 3 7",
    "5 0 0 3 0 0",
    "5 1 3 5 1 0",
    "5 2 5 7 1 1",
    "5 3 9 10 1 3",
    "5 4 15 4 3 4",
    "5 5 31 5 3 5",
    "5 6 63 6 3 6",
    "5 7 127 7 3 7",
    "6 0 0 3 0 0",
    "6 1 3 5 1 0",
    "6 2 5 7 1 1",
    "6 3 9 10 1 3",
    "6 4 15 4 3 4",
    "6 5 31 5 3 5",
    "6 6 63 6 3 6",
    "6 7 127 7 3 7",
    "7 0 0 3 0 0",
    "7 1 3 5 1 0",
    "7 2 5 7 1 1",
    "7 3 9 10 1 3",
    "7 4 15 4 3 4",
    "7 5 31 5 3 5",
    "7 6 63 6 3 6",
    "7 7 127 7 3 7",
    "8 0 0 3 0 0",
    "8 1 3 5 1 0",
    "8 2 5 7 1 1",
    "8 3 9 10 1 3",
    "8 4 15 4 3 4",
    "8 5 31 5 3 5",
    "8 6 63 6 3 6",
    "8 7 127 7 3 7",
    "9 0 0 3 0 0",
    "9 1 3 5 1 0",
    "9 2 5 7 1 1",
    "9 3 9 10 1 3",
    "9 4 15 4 3 4",
    "9 5 31 5 3 5",
    "9 6 63 6 3 6",
    "9 7 127 7 3 7",
    "10 0 0 3 0 0",
    "10 1 3 5 1 0",
    "10 2 5 7 1 1",
    "10 3 9 10 1 3",
    "10 4 15 4 3 4",
    "10 5 31 5 3 5",
    "10 6 63 6 3 6",
    "10 7 127 7 3 7",
    "11 0 0 3 0 0",
    "11 1 3 5 1 0",
    "11 2 5 7 1 1",
    "11 3 9 10 1 3",
    "11 4 15 4 3 4",
    "11 5 31 5 3 5",
    "11 6 63 6 3 6",
    "11 7 127 7 3 7",
    "<alloc_4>",
    "30",
    "0 0 0 4 0 0",
    "0 1 3 5 1 0",
    "0 2 5 7 1 1",
    "0 3 7 3 3 2",
    "0 4 9 10 1 3",
    "0 5 15 4 3 4",
    "0 6 31 5 3 5",
    "0 7 63 6 3 6",
    "0 8 127 7 3 7",
    "0 9 255 8 3 8",
    "0 10 511 9 3 9",
    "0 11 1023 10 3 10",
    "0 12 2047 11 3 11",
    "0 13 4095 12 3 12",
    "0 14 8191 13 3 13",
    "0 15 16383 14 3 14",
    "1 0 0 4 0 0",
    "1 1 3 5 1 0",
    "1 2 5 7 1 1",
    "1 3 7 3 3 2",
    "1 4 9 10 1 3",
    "1 5 15 4 3 4",
    "1 6 31 5 3 5",
    "1 7 63 6 3 6",
    "1 8 127 7 3 7",
    "1 9 255 8 3 8",
    "1 10 511 9 3 9",
    "1 11 1023 10 3 10",
    "1 12 2047 11 3 11",
    "1 13 4095 12 3 12",
    "1 14 8191 13 3 13",
    "1 15 16383 14 3 14",
    "2 0 0 4 0 0",
    "2 1 3 5 1 0",
    "2 2 5 7 1 1",
    "2 3 7 3 3 2",
    "2 4 9 10 1 3",
    "2 5 15 4 3 4",
    "2 6 31 5 3 5",
    "2 7 63 6 3 6",
    "2 8 127 7 3 7",
    "2 9 255 8 3 8",
    "2 10 511 9 3 9",
    "2 11 1023 10 3 10",
    "2 12 2047 11 3 11",
    "2 13 4095 12 3 12",
    "2 14 8191 13 3 13",
    "2 15 16383 14 3 14",
    "3 0 0 4 0 0",
    "3 1 3 5 1 0",
    "3 2 5 7 1 1",
    "3 3 7 3 3 2",
    "3 4 9 10 1 3",
    "3 5 15 4 3 4",
    "3 6 31 5 3 5",
    "3 7 63 6 3 6",
    "3 8 127 7 3 7",
    "3 9 255 8 3 8",
    "3 10 511 9 3 9",
    "3 11 1023 10 3 10",
    "3 12 2047 11 3 11",
    "3 13 4095 12 3 12",
    "3 14 8191 13 3 13",
    "3 15 16383 14 3 14",
    "4 0 0 3 0 0",
    "4 1 3 5 1 0",
    "4 2 5 7 1 1",
    "4 3 9 10 1 3",
    "4 4 15 4 3 4",
    "4 5 31 5 3 5",
    "4 6 63 6 3 6",
    "4 7 127 7 3 7 ",
    "5 0 0 3 0 0",
    "5 1 3 5 1 0",
    "5 2 5 7 1 1",
    "5 3 9 10 1 3",
    "5 4 15 4 3 4",
    "5 5 31 5 3 5",
    "5 6 63 6 3 6",
    "5 7 127 7 3 7 ",
    "6 0 0 3 0 0",
    "6 1 3 5 1 0",
    "6 2 5 7 1 1",
    "6 3 9 10 1 3",
    "6 4 15 4 3 4",
    "6 5 31 5 3 5",
    "6 6 63 6 3 6",
    "6 7 127 7 3 7 ",
    "7 0 0 3 0 0",
    "7 1 3 5 1 0",
    "7 2 5 7 1 1",
    "7 3 9 10 1 3",
    "7 4 15 4 3 4",
    "7 5 31 5 3 5",
    "7 6 63 6 3 6",
    "7 7 127 7 3 7 ",
    "8 0 0 3 0 0",
    "8 1 3 5 1 0",
    "8 2 5 7 1 1",
    "8 3 9 10 1 3",
    "8 4 15 4 3 4",
    "8 5 31 5 3 5",
    "8 6 63 6 3 6",
    "8 7 127 7 3 7 ",
    "9 0 0 3 0 0",
    "9 1 3 5 1 0",
    "9 2 5 7 1 1",
    "9 3 9 10 1 3",
    "9 4 15 4 3 4",
    "9 5 31 5 3 5",
    "9 6 63 6 3 6",
    "9 7 127 7 3 7 ",
    "10 0 0 3 0 0",
    "10 1 3 5 1 0",
    "10 2 5 7 1 1",
    "10 3 9 10 1 3",
    "10 4 15 4 3 4",
    "10 5 31 5 3 5",
    "10 6 63 6 3 6",
    "10 7 127 7 3 7 ",
    "11 0 0 2 0 0",
    "11 1 3 5 1 0",
    "11 2 5 7 1 1",
    "11 3 9 10 1 3",
    "12 0 0 2 0 0",
    "12 1 3 5 1 0",
    "12 2 5 7 1 1",
    "12 3 9 10 1 3",
    "13 0 0 2 0 0",
    "13 1 3 5 1 0",
    "13 2 5 7 1 1",
    "13 3 9 10 1 3",
    "14 0 0 2 0 0",
    "14 1 3 5 1 0",
    "14 2 5 7 1 1",
    "14 3 9 10 1 3",
    "15 0 0 2 0 0",
    "15 1 3 5 1 0",
    "15 2 5 7 1 1",
    "15 3 9 10 1 3",
    "16 0 0 2 0 0",
    "16 1 3 5 1 0",
    "16 2 5 7 1 1",
    "16 3 9 10 1 3",
    "17 0 0 2 0 0",
    "17 1 3 5 1 0",
    "17 2 5 7 1 1",
    "17 3 9 10 1 3",
    "18 0 0 2 0 0",
    "18 1 3 5 1 0",
    "18 2 5 7 1 1",
    "18 3 9 10 1 3",
    "19 0 0 2 0 0",
    "19 1 3 5 1 0",
    "19 2 5 7 1 1",
    "19 3 9 10 1 3",
    "20 0 0 2 0 0",
    "20 1 3 5 1 0",
    "20 2 5 7 1 1",
    "20 3 9 10 1 3",
    "21 0 0 2 0 0",
    "21 1 3 5 1 0",
    "21 2 5 7 1 1",
    "21 3 9 10 1 3",
    "22 0 0 2 0 0",
    "22 1 3 5 1 0",
    "22 2 5 7 1 1",
    "22 3 9 10 1 3",
    "23 0 0 2 0 0",
    "23 1 3 5 1 0",
    "23 2 5 7 1 1",
    "23 3 9 10 1 3",
    "24 0 0 2 0 0",
    "24 1 3 5 1 0",
    "24 2 5 7 1 1",
    "24 3 9 10 1 3",
    "25 0 0 2 0 0",
    "25 1 3 5 1 0",
    "25 2 5 7 1 1",
    "25 3 9 10 1 3",
    "26 0 0 2 0 0",
    "26 1 3 5 1 0",
    "26 2 5 7 1 1",
    "26 3 9 10 1 3",
    "27 0 0 2 0 0",
    "27 1 3 5 1 0",
    "27 2 5 7 1 1",
    "27 3 9 10 1 3",
    "28 0 0 2 0 0",
    "28 1 3 5 1 0",
    "28 2 5 7 1 1",
    "28 3 9 10 1 3",
    "29 0 0 2 0 0",
    "29 1 3 5 1 0",
    "29 2 5 7 1 1",
    "29 3 9 10 1 3",
    "<next>"
  };

  unsigned int a, b, c, d, i, j;
  char t[80];
  int sblim;
  int startindex;

  if ((table < 0) || (table > 4))
    table = 0;

  startindex = startindex_subband[table] + 1;

//      if (g_verbose) printf("using bit allocation table %d\n", table);

  sprintf (t, "%s", alloc_subbands[startindex]);
  startindex++;
  sscanf (t, "%d\n", &sblim);

  while (t[0] != '<') {
    sprintf (t, "%s", alloc_subbands[startindex]);
    startindex++;
    if (t[0] == '<')
      break;

    sscanf (t, "%d %d %d %d %d %d\n", &i, &j, &a, &b, &c, &d);
    (*alloc)[i][j].steps = a;
    (*alloc)[i][j].bits = b;
    (*alloc)[i][j].group = c;
    (*alloc)[i][j].quant = d;
  }
  return sblim;
}
