/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.cxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CxxImplSource {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private CodeSplicer d_splicer = null;
    private final String USER_DEF = "user-defined ";

    public CxxImplSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String nm = "CxxImplSource: generateCode: ";
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Cxx.generateFilename(id, 1, 2);
        try {
            block4: {
                try {
                    this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
                    this.d_writer = Cxx.createSource(this.d_ext, 1, "IMPLSRCS");
                    this.d_splicer.setLineRedirector(this.d_writer);
                    this.writeIncludes();
                    this.writeCtorDtor();
                    this.writeCheckErr();
                    this.writeSIDLDefinedMethods();
                    this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._misc", this.d_writer, "miscellaneous code");
                    this.d_writer.println();
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block4;
                    this.d_writer.printlnUnformatted("#error File has unused splicer blocks.");
                    this.d_writer.beginBlockComment(true);
                    this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_writer.println("This can result from a method rename/removal in the sidl file.");
                    this.d_writer.println("Move or remove the code in order to compile cleanly.");
                    this.d_writer.endBlockComment(true);
                    this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
                    this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ex) {
                    throw new CodeGenerationException("CxxImplSource: generateCode: IOException : " + ex.getMessage());
                }
            }
            Object var7_5 = null;
            if (this.d_writer == null) return;
            this.d_writer.close();
            this.d_writer = null;
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
    }

    private void writeIncludes() {
        this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 1, 1), false);
        this.d_writer.println();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._includes", this.d_writer, "additional includes or code");
        this.d_writer.println();
    }

    private void writeCtorDtor() {
        this.d_writer.writeCommentLine("user-defined constructor.");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_ctor() {");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._ctor", this.d_writer, "constructor");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user-defined destructor.");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_dtor() {");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._dtor", this.d_writer, "destructor");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("static class initializer.");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_load() {");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._load", this.d_writer, "class initialization");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeCheckErr() throws CodeGenerationException {
        String handler_desc = "assertion exception handler.";
        if (IOR.supportAssertions(this.d_ext)) {
            Method method;
            SymbolID id = this.d_ext.getSymbolID();
            if (this.d_ext.hasStaticMethod(true)) {
                method = IOR.getBuiltinMethod(8, id, true);
                this.d_writer.writeCommentLine("user-defined static assertion exception handler.");
                this.d_writer.println();
                this.generateMethod(method, "");
            }
            this.d_writer.writeCommentLine("user-defined assertion exception handler.");
            method = IOR.getBuiltinMethod(8, id, false);
            this.d_writer.println();
            this.generateMethod(method, "");
        }
    }

    private void writeSIDLDefinedMethods() throws CodeGenerationException {
        String meth_desc = "methods:";
        String desc = "static ";
        List static_methods = (List)this.d_ext.getStaticMethods(false);
        if (static_methods.size() > 0) {
            this.d_writer.writeCommentLine("user-defined " + desc + "methods:");
            Iterator m = static_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (IOR.supportInterceptors(this.d_ext)) {
                    this.generateMethod(method, "_pre");
                    this.generateMethod(method, "");
                    this.generateMethod(method, "_post");
                    continue;
                }
                this.generateMethod(method, "");
            }
        } else {
            this.d_writer.writeCommentLine("user-defined " + desc + "methods:" + " (none)");
        }
        desc = "non-static ";
        this.d_writer.println();
        List nonstatic_methods = (List)this.d_ext.getNonstaticMethods(false);
        if (nonstatic_methods.size() > 0) {
            this.d_writer.writeCommentLine("user-defined " + desc + "methods:");
            Iterator m = nonstatic_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isAbstract()) continue;
                this.generateMethod(method, "");
            }
        } else {
            this.d_writer.writeCommentLine("user-defined " + desc + "methods:" + " (none)");
        }
        this.d_writer.println();
    }

    private void generateMethod(Method method, String suffix) throws CodeGenerationException {
        if (method == null) {
            return;
        }
        boolean isOrig = suffix.equals("");
        boolean doReturn = suffix.equals("_post") && method.getReturnType().getType() != 0;
        this.d_writer.writeComment(method, true);
        if (isOrig) {
            this.d_writer.println(Cxx.getReturnString(method.getReturnType()));
        } else {
            this.d_writer.println("void");
        }
        this.d_writer.print(Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.print("_impl::");
        this.d_writer.print(method.getShortMethodName() + suffix);
        if (method.getArgumentList().size() > 0) {
            this.d_writer.println(" (");
            this.d_writer.tab();
            Cxx.generateArgumentList(this.d_writer, method, true);
            if (doReturn) {
                this.d_writer.println(",_result");
            }
            this.d_writer.println(" ) ");
            this.d_writer.backTab();
            Cxx.generateThrowsList(this.d_writer, method, false);
        } else {
            this.d_writer.print(" (");
            if (doReturn) {
                this.d_writer.print("_result");
            }
            this.d_writer.println(")");
            Cxx.generateThrowsList(this.d_writer, method, false);
            this.d_writer.println();
        }
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "." + method.getLongMethodName() + suffix, this.d_writer, method.getShortMethodName() + " method");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

