/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Version;

public class TypeModule {
    private static final int s_maxArray = BabelConfiguration.getMaximumArray();
    private LanguageWriterForFortran d_lw;
    private Symbol d_sym;

    public TypeModule(LanguageWriterForFortran writer, Symbol sym) {
        this.d_lw = writer;
        this.d_sym = sym;
    }

    private void describeFile() {
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("This file contains a FORTRAN 90 derived type for the");
        if (this.d_sym == null) {
            this.d_lw.println("sidl type sidl_array.");
        } else {
            this.d_lw.println("sidl type " + this.d_sym.getFullName() + ".");
        }
        this.d_lw.endBlockComment(false);
    }

    static void writeArrayType(LanguageWriter lw, SymbolID id, String implDataType) {
        for (int i = 1; i <= s_maxArray; ++i) {
            lw.println("type " + Fortran.getArrayName(id, i));
            lw.tab();
            lw.println("sequence");
            lw.println("integer (selected_int_kind(18)) :: d_array");
            if (implDataType != null) {
                lw.println(implDataType + ", pointer, &");
                lw.tab();
                lw.print("dimension(:");
                for (int j = 1; j < i; ++j) {
                    lw.print(",:");
                }
                lw.println(") :: d_data");
                lw.backTab();
            }
            lw.backTab();
            lw.println("end type " + Fortran.getArrayName(id, i));
            lw.println();
        }
    }

    private void writeGenericArrayType() {
        this.d_lw.println("type sidl__array");
        this.d_lw.tab();
        this.d_lw.println("sequence");
        this.d_lw.println("integer (selected_int_kind(18)) :: d_array");
        this.d_lw.backTab();
        this.d_lw.println("end type sidl__array");
        this.d_lw.println();
    }

    private void writeModule() {
        SymbolID id = null;
        id = this.d_sym == null ? new SymbolID("sidl.array", new Version()) : this.d_sym.getSymbolID();
        this.d_lw.println("module " + Fortran.getTypeModule(id));
        this.d_lw.tab();
        if (this.d_sym != null && this.d_sym instanceof Extendable) {
            this.d_lw.println("type " + Fortran.getTypeName(id));
            this.d_lw.tab();
            this.d_lw.println("sequence");
            this.d_lw.println("integer (selected_int_kind(18)) :: d_ior");
            this.d_lw.backTab();
            this.d_lw.println("end type " + Fortran.getTypeName(id));
            this.d_lw.println();
        }
        if (this.d_sym == null) {
            this.writeGenericArrayType();
        } else {
            TypeModule.writeArrayType(this.d_lw, id, null);
        }
        this.d_lw.backTab();
        this.d_lw.println("end module " + Fortran.getTypeModule(id));
    }

    public void generateCode() {
        SymbolID id = null;
        id = this.d_sym == null ? new SymbolID("sidl.array", new Version()) : this.d_sym.getSymbolID();
        if (this.d_sym != null) {
            this.d_lw.writeBanner(this.d_sym, Fortran.getTypeFile(id), false, "Client-side module for " + id.getFullName());
        }
        this.d_lw.disableLineBreak();
        this.d_lw.printlnUnformatted("#include \"" + Fortran.getStubNameFile(id) + "\"");
        this.d_lw.enableLineBreak();
        this.d_lw.println();
        this.describeFile();
        this.writeModule();
    }

    public static void generateCode(Symbol sym, LanguageWriterForFortran writer) throws CodeGenerationException {
        TypeModule tm = new TypeModule(writer, sym);
        tm.generateCode();
    }
}

