/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ior;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.ior.IORHeader;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateIORClient
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            Symbol symbol;
            SymbolID id = (SymbolID)s.next();
            if (BabelConfiguration.isSIDLBaseClass(id) && !BabelConfiguration.getInstance().generateStdlib() || (symbol = SymbolTable.getInstance().lookupSymbol(id)) == null) continue;
            this.generateHeader(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHeader(Symbol symbol) throws CodeGenerationException {
        int type = symbol.getSymbolType();
        SymbolID id = symbol.getSymbolID();
        PrintWriter pw = null;
        try {
            String f = IOR.getHeaderFile(id);
            pw = FileManager.getInstance().createFile(id, type, "IORHDRS", f);
            LanguageWriterForC writer = new LanguageWriterForC(pw);
            IORHeader.generateCode(symbol, writer);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("ior");
        return result;
    }
}

