/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.rmi.RMIStubSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateRMIClient
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            this.generateSource(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSource(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type == 12) {
            PrintWriter pw = null;
            try {
                String f = id.getFullName().replace('.', '_') + "_RStub.c";
                pw = FileManager.getInstance().createFile(id, type, "RSTUBSRCS", f);
                LanguageWriterForC writer = new LanguageWriterForC(pw);
                RMIStubSource.generateCode(symbol, writer);
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("rmi");
        return result;
    }
}

