/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.sidl;

import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Version;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ScopedName {
    public static char s_delim = (char)32;
    private static String s_require = "require";

    private ScopedName() {
    }

    private static String buildSymVers(String sym, String vers) {
        return sym + s_delim + vers;
    }

    private static String buildSymVers(String sym) {
        Version vers = SymbolUtilities.getVersion(sym);
        String vstr = null;
        vstr = vers != null ? vers.getVersionString() : "0";
        return ScopedName.buildSymVers(sym, vstr);
    }

    private static int getOccurs(String symvers, TreeMap requires) {
        int occurs = -1;
        if (requires.containsKey(symvers)) {
            Integer val = (Integer)requires.get(symvers);
            occurs = val;
        }
        return occurs;
    }

    private static boolean reportableParent(String symvers, TreeMap requires) {
        int dpos;
        boolean is_reportable = false;
        int bpos = symvers.indexOf(s_delim);
        if (bpos > 0 && (dpos = symvers.substring(0, bpos).lastIndexOf(46)) > 0) {
            String psymvers = ScopedName.buildSymVers(symvers.substring(0, dpos), symvers.substring(bpos + 1));
            int has = ScopedName.getOccurs(psymvers, requires);
            is_reportable = has > 0;
        }
        return is_reportable;
    }

    public static void printRequires(Package pkg, LanguageWriter lw) {
        SymbolTable stbl = SymbolTable.getInstance();
        String pkgscope = SymbolUtilities.getOutermostPackage(pkg.getSymbolID().getFullName());
        Symbol opkg = stbl.lookupSymbol(pkgscope);
        Set symset = opkg.getAllSymbolReferences();
        TreeMap<String, Integer> requires = new TreeMap<String, Integer>();
        if (!symset.isEmpty()) {
            Iterator iter = symset.iterator();
            while (iter.hasNext()) {
                String psym;
                SymbolID sid = (SymbolID)iter.next();
                String fqn = sid.getFullName();
                String scope = SymbolUtilities.getOutermostPackage(fqn);
                String sym = stbl.lookupSymbol(sid).getSymbolType() == 14 ? fqn : SymbolUtilities.getParentPackage(fqn);
                if (scope.equals(pkgscope) || scope.equals("sidl")) continue;
                String symvers = ScopedName.buildSymVers(sym);
                if (!requires.containsKey(symvers)) {
                    requires.put(symvers, new Integer(1));
                } else {
                    int val = ScopedName.getOccurs(symvers, requires) + 1;
                    requires.put(symvers, new Integer(val));
                }
                if ((psym = SymbolUtilities.getParentPackage(sym)) == null) continue;
                String psymvers = ScopedName.buildSymVers(psym);
                if (!requires.containsKey(psymvers)) {
                    requires.put(psymvers, new Integer(0));
                    continue;
                }
                int pval = ScopedName.getOccurs(psymvers, requires);
                if (pval <= 0) continue;
                requires.put(psymvers, new Integer(pval + 1));
            }
        }
        if (!requires.isEmpty()) {
            Set impset = requires.entrySet();
            Iterator iter = impset.iterator();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String symvers = (String)e.getKey();
                int dind = symvers.indexOf(s_delim);
                String sym = symvers.substring(0, dind);
                String vers = symvers.substring(dind + 1);
                String vstr = SymbolUtilities.getVersionString(vers);
                String sttmt = vstr != null ? s_require + " " + sym + " " + vstr + ";" : s_require + " " + sym + ";";
                Integer occurs = (Integer)e.getValue();
                int num = occurs;
                if (ScopedName.reportableParent(symvers, requires)) continue;
                if (num == 1) {
                    lw.println(sttmt);
                    continue;
                }
                if (num <= 1) continue;
                lw.println(sttmt);
            }
            lw.println();
        }
        requires.clear();
    }

    public static String getScopedName(String currentScope, String fullyQualifiedName) {
        int len = currentScope.length();
        if (fullyQualifiedName.startsWith(currentScope) && fullyQualifiedName.length() > len + 1 && fullyQualifiedName.charAt(len) == ".".charAt(0)) {
            return fullyQualifiedName.substring(len + 1);
        }
        return fullyQualifiedName;
    }
}

