/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.sidl;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.sidl.ScopedName;
import gov.llnl.babel.backend.sidl.Sidl;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForSidl;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SidlSource {
    private LanguageWriterForSidl d_lw;
    private static SymbolTable d_table = SymbolTable.getInstance();

    public SidlSource(LanguageWriterForSidl writer) {
        this.d_lw = writer;
    }

    public void generateCode(Enumeration enm) throws CodeGenerationException {
        SymbolID id = enm.getSymbolID();
        String ename = id.getShortName();
        this.d_lw.println();
        this.d_lw.writeComment(enm, true, false);
        this.d_lw.println("enum " + ename + " {");
        this.d_lw.tab();
        int maxlength = Utilities.getWidth(enm.getEnumerators());
        Iterator e = enm.getIterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            Comment cmt = enm.getEnumeratorComment(name);
            this.d_lw.writeComment(cmt, true);
            this.d_lw.printAligned(name, maxlength);
            if (enm.definedByUser(name)) {
                this.d_lw.print(" = ");
                this.d_lw.print(String.valueOf(enm.getEnumeratorValue(name)));
            }
            this.d_lw.println(",");
            if (cmt == null || cmt.isEmpty()) continue;
            this.d_lw.println();
        }
        this.d_lw.backTab();
        this.d_lw.println("};");
    }

    public static boolean isBaseClassName(String name) {
        boolean isBase = false;
        String base = BabelConfiguration.getBaseClass();
        if (name.equals(base) || name.equals(SymbolID.getShortName(base))) {
            isBase = true;
        }
        return isBase;
    }

    public static boolean isBaseInterfaceName(String name) {
        boolean isBase = false;
        String base = BabelConfiguration.getBaseInterface();
        if (name.equals(base) || name.equals(SymbolID.getShortName(base))) {
            isBase = true;
        }
        return isBase;
    }

    public void printParentInterfaces(Extendable ext) throws CodeGenerationException {
        Collection ifaces = ext.getParentInterfaces(false);
        boolean printed_spec = false;
        String scope = SymbolUtilities.getParentPackage(ext.getSymbolID().getFullName());
        String spec = ext.isInterface() ? " extends " : "implements ";
        boolean increased_tab = false;
        Iterator i = ifaces.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            String name = ScopedName.getScopedName(scope, sym.getSymbolID().getFullName());
            if ((!ext.isInterface() || SidlSource.isBaseInterfaceName(name)) && ext.isInterface()) continue;
            if (!printed_spec) {
                this.d_lw.print(spec);
                printed_spec = true;
            }
            this.d_lw.print(name);
            if (!i.hasNext()) continue;
            this.d_lw.println(",");
            if (increased_tab) continue;
            this.d_lw.tab();
            increased_tab = true;
        }
        if (printed_spec) {
            this.d_lw.println();
        }
        if (increased_tab) {
            this.d_lw.backTab();
        }
    }

    public void printAssertion(LanguageWriter lw, Assertion as) {
        Comment cmt = as.getComment();
        lw.writeComment(cmt, true);
        lw.println(as.toString() + ";");
    }

    public void printSignaturePlus(LanguageWriter lw, boolean is_interface, Method meth, String parent_pkg) {
        ArrayList postconditions;
        lw.print(meth.getSignaturePreface(is_interface, parent_pkg) + "(");
        int increased_tabs = 0;
        ArrayList args = meth.getArgumentListWithIndices();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            lw.print(((Argument)a.next()).getArgumentString(parent_pkg));
            if (!a.hasNext()) continue;
            lw.println(",");
            if (increased_tabs != 0) continue;
            lw.tab();
            lw.tab();
            lw.tab();
            increased_tabs += 3;
        }
        lw.print(")" + meth.getCommunicationModifierString());
        Set exceptions = meth.getThrows();
        if (!exceptions.isEmpty()) {
            lw.println();
            if (increased_tabs > 0) {
                lw.backTab();
                --increased_tabs;
            } else {
                lw.tab();
                lw.tab();
                increased_tabs = 2;
            }
            lw.print("throws ");
            Iterator t = exceptions.iterator();
            while (t.hasNext()) {
                SymbolID sid = (SymbolID)t.next();
                String fname = sid.getFullName();
                if (parent_pkg != null) {
                    lw.print(ScopedName.getScopedName(parent_pkg, fname));
                } else {
                    lw.print(fname);
                }
                if (!t.hasNext()) continue;
                lw.println(",");
            }
        }
        boolean noAssertions = true;
        ArrayList preconditions = meth.getPreconditions();
        if (!preconditions.isEmpty()) {
            lw.println();
            for (int i = increased_tabs; i > 1; --i) {
                lw.backTab();
                --increased_tabs;
            }
            noAssertions = false;
            lw.tab();
            lw.println("require ");
            lw.tab();
            Iterator i = preconditions.iterator();
            while (i.hasNext()) {
                this.printAssertion(lw, (Assertion)i.next());
            }
            lw.backTab();
            lw.backTab();
        }
        if (!(postconditions = meth.getPostconditions()).isEmpty()) {
            if (noAssertions) {
                noAssertions = false;
                lw.println();
                for (int i = increased_tabs; i > 1; --i) {
                    lw.backTab();
                    --increased_tabs;
                }
            }
            lw.tab();
            lw.println("ensure ");
            lw.tab();
            Iterator i = postconditions.iterator();
            while (i.hasNext()) {
                this.printAssertion(lw, (Assertion)i.next());
            }
            lw.backTab();
            lw.backTab();
        }
        if (noAssertions) {
            lw.println(";");
        }
        for (int i = increased_tabs; i > 0; --i) {
            lw.backTab();
        }
    }

    public void printMethods(Extendable ext) throws CodeGenerationException {
        Collection methods = ext.getMethods(false);
        String name = Sidl.getSymbolName(ext.getSymbolID());
        this.d_lw.println("{");
        this.d_lw.tab();
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method meth = (Method)m.next();
            this.d_lw.writeComment(meth, true, false);
            this.printSignaturePlus(this.d_lw, ext.isInterface(), meth, SymbolUtilities.getParentPackage(name));
            if (!m.hasNext()) continue;
            this.d_lw.println();
        }
        this.d_lw.backTab();
        this.d_lw.println("}");
    }

    public void generateCode(Class cls) throws CodeGenerationException {
        SymbolID pid;
        String pname;
        SymbolID sid = cls.getSymbolID();
        String sname = sid.getShortName();
        String scope = SymbolUtilities.getParentPackage(sid.getFullName());
        this.d_lw.println();
        this.d_lw.writeComment(cls, true, false);
        if (cls.isAbstract()) {
            this.d_lw.print("abstract ");
        }
        this.d_lw.print("class " + sname + " ");
        Class parent = cls.getParentClass();
        boolean printed_extends = false;
        if (parent != null && (pname = ScopedName.getScopedName(scope, (pid = parent.getSymbolID()).getFullName())) != null && !SidlSource.isBaseClassName(pname)) {
            this.d_lw.println("extends " + pname);
            printed_extends = true;
        }
        if (printed_extends) {
            this.d_lw.tab();
        }
        this.printParentInterfaces(cls);
        if (printed_extends) {
            this.d_lw.backTab();
        }
        this.printMethods(cls);
    }

    public void generateCode(Interface iface) throws CodeGenerationException {
        String name = iface.getSymbolID().getShortName();
        this.d_lw.println();
        this.d_lw.writeComment(iface, true, false);
        this.d_lw.print("interface " + name + " ");
        this.printParentInterfaces(iface);
        this.printMethods(iface);
    }

    public void printRequires(Package pkg) {
        ScopedName.printRequires(pkg, this.d_lw);
    }

    public void generateCode(Package pkg) throws CodeGenerationException {
        Collection symids = pkg.getOrderedSymbolReferences();
        SymbolID id = pkg.getSymbolID();
        String name = id.getShortName();
        String vstr = null;
        if (!SymbolUtilities.hasParentPackage(id)) {
            this.printRequires(pkg);
        }
        this.d_lw.writeComment(pkg, true, false);
        if (pkg.getFinal()) {
            this.d_lw.print("final ");
        }
        this.d_lw.print("package " + name);
        if (!SymbolUtilities.sameVersionAsParent(id) && (vstr = SymbolUtilities.getVersionString(id)) != null) {
            this.d_lw.print(" " + vstr);
        }
        this.d_lw.println(" {");
        this.d_lw.tab();
        Iterator s = symids.iterator();
        block6: while (s.hasNext()) {
            SymbolID sid = (SymbolID)s.next();
            Symbol sym = d_table.lookupSymbol(sid);
            switch (sym.getSymbolType()) {
                case 12: {
                    this.generateCode((Class)sym);
                    continue block6;
                }
                case 11: {
                    this.generateCode((Enumeration)sym);
                    continue block6;
                }
                case 13: {
                    this.generateCode((Interface)sym);
                    continue block6;
                }
                case 14: {
                    this.d_lw.println();
                    this.generateCode((Package)sym);
                    this.d_lw.println();
                    continue block6;
                }
            }
            throw new CodeGenerationException("Unknown/Invalid Symbol Type detected during SIDL Package generation");
        }
        this.d_lw.backTab();
        this.d_lw.println();
        this.d_lw.println("}");
    }

    public static void generateCode(Symbol sym, LanguageWriterForSidl writer) throws CodeGenerationException {
        if (sym instanceof Package) {
            SidlSource sidlFile = new SidlSource(writer);
            sidlFile.generateCode((Package)sym);
        }
    }
}

