/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.config;

import gov.llnl.babel.config.Metadata;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.SAXException;

public class MetadataTest {
    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("usage: gov.llnl.babel.config.MetadataTest URI");
            System.exit(1);
        }
        Metadata metadata = null;
        try {
            metadata = new Metadata(argv[0]);
        }
        catch (IOException ex) {
            System.err.println("Babel: Error: IOException");
            System.err.println(ex.getMessage());
        }
        catch (SAXException ex) {
            System.err.println("Babel: Error: SAXException");
            System.err.println(ex.getMessage());
        }
        if (metadata != null) {
            String language;
            Set languages = metadata.getValidLanguages();
            System.out.println();
            System.out.println("Currently supported languages:");
            Iterator l = languages.iterator();
            while (l.hasNext()) {
                language = (String)l.next();
                System.out.println("   " + language);
            }
            System.out.println();
            l = languages.iterator();
            while (l.hasNext()) {
                language = (String)l.next();
                System.out.println("Options for language " + language + ":");
                Set options = metadata.getValidOptions(language);
                if (options == null) {
                    System.out.println("No valid options");
                    continue;
                }
                Iterator o = options.iterator();
                while (o.hasNext()) {
                    String option = (String)o.next();
                    System.out.println("Option name: " + option);
                    System.out.println("Summary: " + metadata.getOptionSummary(language, option));
                    System.out.println("Comment:");
                    System.out.println(metadata.getOptionDescription(language, option));
                    Set parameters = metadata.getValidOptionParameters(language, option);
                    Iterator p = parameters.iterator();
                    while (p.hasNext()) {
                        String param = (String)p.next();
                        System.out.println("Parameter: " + param);
                    }
                }
            }
        }
    }
}

