/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;

public class IdentifierLiteral
extends AssertionExpression {
    private int d_type = 0;
    private int d_argument_mode = -1;
    private String d_identifier = null;
    public static final int ARGUMENT = 0;
    public static final int NULL = 1;
    public static final int PURE = 2;
    public static final int RESULT = 3;
    private static final int MIN_TYPE_VALUE = 0;
    private static final int MAX_TYPE_VALUE = 3;
    private static final String[] s_type_name = new String[]{"argument", "null", "pure", "result"};
    public static final int IN = 0;
    public static final int INOUT = 1;
    public static final int OUT = 2;

    public IdentifierLiteral(String id) throws AssertionException {
        super(false);
        if (id == null || id.equals("")) {
            throw new AssertionException("Cannot instantiate an IdentifierLiteral without the identifier.");
        }
        this.d_identifier = id;
        if (id.equalsIgnoreCase("null")) {
            this.d_type = 1;
        } else if (id.equalsIgnoreCase("pure")) {
            this.d_type = 2;
            this.setReturnToBoolean();
        } else {
            this.d_type = id.equalsIgnoreCase("result") ? 3 : 0;
        }
    }

    public String getIdentifier() {
        return this.d_identifier;
    }

    public int getIdentifierType() {
        return this.d_type;
    }

    public boolean isNull() {
        return this.d_type == 1;
    }

    public boolean isArgument() {
        return this.d_type == 0;
    }

    public boolean isReserved() {
        return this.d_type == 1 || this.d_type == 2 || this.d_type == 3;
    }

    public String getIdentifierTypeName() {
        return s_type_name[this.d_type];
    }

    public boolean hasPure() {
        return this.d_type == 2;
    }

    public boolean hasResult() {
        return this.d_type == 3;
    }

    public boolean hasMethodCall() {
        return false;
    }

    public boolean hasReservedMethod(int type) {
        return false;
    }

    public boolean hasUnreservedMethod(boolean any) {
        return false;
    }

    public boolean requiresExtendableContext() {
        return this.d_type == 0 || this.d_type == 1 || this.d_type == 3;
    }

    public boolean requiresMethodContext() {
        return this.d_type == 0 || this.d_type == 3;
    }

    private String getMissingMessage(String entity) {
        return "IdentifierLiteral: Cannot determine the return type of the identifier \"" + this.d_identifier + "\" in an assertion clause " + "without the owning " + entity + ".";
    }

    protected void validateSemantics(Extendable ext, Method m) throws AssertionException {
        switch (this.d_type) {
            case 1: {
                if (this.getReturnType() != null) break;
                throw new AssertionException("The return type associated with the NULL IdentifierLiteral for " + this.getExceptionPrefix(ext, m) + " must have already been set prior to its validation.");
            }
            case 2: {
                if (this.getReturnType() == null) {
                    this.setReturnToBoolean();
                    break;
                }
                if (this.returnIsBoolean()) break;
                throw new AssertionException("The return type for an IdentifierLiteral pure clause for " + this.getExceptionPrefix(ext, m) + " should never have been (re)set to anything other than " + "boolean.");
            }
            case 3: {
                if (this.getReturnType() != null) break;
                if (ext != null) {
                    if (m != null) {
                        this.setReturnType(m.getReturnType());
                        break;
                    }
                    throw new AssertionException(this.getExceptionPrefix(ext, m), this.getMissingMessage("method"));
                }
                throw new AssertionException(this.getMissingMessage("extendable"));
            }
            case 0: {
                if (this.getReturnType() != null) break;
                if (ext != null) {
                    if (m != null) {
                        Type type = m.getArgumentType(this.d_identifier);
                        int mode = m.getArgumentMode(this.d_identifier);
                        if (type != null) {
                            this.setReturnType(type);
                            this.d_argument_mode = mode;
                            break;
                        }
                        throw new AssertionException("The IdentifierLiteral " + this.d_identifier + " is not a recognized argument of method " + m.getLongMethodName() + " for " + this.getExceptionPrefix(ext, m) + ".");
                    }
                    throw new AssertionException(this.getExceptionPrefix(ext, m), this.getMissingMessage("method"));
                }
                throw new AssertionException(this.getMissingMessage("extendable"));
            }
            default: {
                throw new AssertionException("Unrecognized type encountered during semantic validation for IdentifierLiteral \"" + this.d_identifier + "\" of " + this.getExceptionPrefix(ext, m) + ". This should NEVER happen.");
            }
        }
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        return null;
    }

    public int getNumArrayIterMacrosByType(char type) {
        return 0;
    }

    public String cExpression(String epvVar, int[] startInd) {
        String res;
        switch (this.d_type) {
            case 3: {
                res = "_result";
                break;
            }
            case 2: {
                res = null;
                break;
            }
            case 1: {
                res = "NULL";
                break;
            }
            case 0: {
                if (this.d_argument_mode == 1 || this.d_argument_mode == 2) {
                    res = "(*" + this.d_identifier + ")";
                    break;
                }
                res = this.d_identifier;
                break;
            }
            default: {
                res = null;
            }
        }
        return res;
    }

    public String toString() {
        return this.hasParens() ? "(" + this.d_identifier + ")" : this.d_identifier;
    }
}

