/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.url;

import gov.llnl.babel.url.HttpException;
import gov.llnl.babel.url.cookie.CookieJar;
import gov.llnl.babel.url.cookie.Http;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class CookieConnection {
    private CookieJar d_cookie_jar = new CookieJar();

    public InputStream getFromURL(String url_string) throws HttpException, IOException {
        HttpURLConnection http;
        URL url = new URL(url_string);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            http = (HttpURLConnection)connection;
            http.setRequestMethod("GET");
            Http.sendCookies(http, this.d_cookie_jar);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection) {
            http = (HttpURLConnection)connection;
            Http.gleanCookies(http, this.d_cookie_jar);
            int response = http.getResponseCode();
            if (response != 200) {
                throw new HttpException(response, "HTTP Error (" + String.valueOf(response) + "): " + http.getResponseMessage());
            }
        }
        return connection.getInputStream();
    }

    public void postToURL(String url_string, String content_type, InputStream content) throws HttpException, IOException {
        URL url = new URL(url_string);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("Content-type", content_type);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            http.setRequestMethod("POST");
            Http.sendCookies(http, this.d_cookie_jar);
        }
        OutputStream out = connection.getOutputStream();
        connection.connect();
        CookieConnection.copyStream(content, out);
        out.close();
        content.close();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            Http.gleanCookies(http, this.d_cookie_jar);
            int response = http.getResponseCode();
            if (response != 200) {
                throw new HttpException(response, "HTTP Error (" + String.valueOf(response) + "): " + http.getResponseMessage());
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int bytes_read;
        byte[] buffer = new byte[1024];
        while ((bytes_read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytes_read);
        }
    }
}

