/*
 * File:          c_Ruleset_Impl.c
 * Symbol:        c.Ruleset-v2.0
 * Symbol Type:   class
 * Babel Version: 0.9.6
 * sidl Created:  20041004 22:26:31 PDT
 * Generated:     20041004 22:26:33 PDT
 * Description:   Server-side implementation for c.Ruleset
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.9.6
 * source-line   = 6
 * source-url    = file:/home/kumfert/scdemo/hands-on/task_0/babel-life/libC/clife.sidl
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "c.Ruleset" (version 2.0)
 */

#include "c_Ruleset_Impl.h"

/* DO-NOT-DELETE splicer.begin(c.Ruleset._includes) */
#include "c_BoundsException.h"
#include "sidl_Exception.h"
/* DO-NOT-DELETE splicer.end(c.Ruleset._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_c_Ruleset__ctor"

void
impl_c_Ruleset__ctor(
  /*in*/ c_Ruleset self)
{
  /* DO-NOT-DELETE splicer.begin(c.Ruleset._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(c.Ruleset._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_c_Ruleset__dtor"

void
impl_c_Ruleset__dtor(
  /*in*/ c_Ruleset self)
{
  /* DO-NOT-DELETE splicer.begin(c.Ruleset._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(c.Ruleset._dtor) */
}

/*
 * Birth: an empty cell has 3 living neighbors
 * Death: a living cell has 0 or 1 neighbors (loneliness)
 *        or a living cell has 4-8 neighbors (overcrowding)
 * Life: a living cell has 2 or three neighbors
 */

#undef __FUNC__
#define __FUNC__ "impl_c_Ruleset_setAlive"

sidl_bool
impl_c_Ruleset_setAlive(
  /*in*/ c_Ruleset self, /*in*/ int32_t x, /*in*/ int32_t y,
    /*in*/ conway_Environment env, /*out*/ sidl_BaseInterface* _ex)
{
  /* DO-NOT-DELETE splicer.begin(c.Ruleset.setAlive) */
  int32_t n;

  n = conway_Environment_nNeighbors( env, x, y, _ex); SIDL_CHECK(*_ex);

  switch(n) { 
  case 0: case 1:
    return 0;  /*  if was alive, dies of loneliness */
  case 2: 
    return conway_Environment_isAlive(env, x, y, _ex); SIDL_CHECK(*_ex); /* is alive only if it was last turn */
  case 3: 
    return 1;  /* if was alive, it continues, if not, new one is born */
  default: /* case 4 and above */
    return 0;  /* if was alive, dies of overcrowding */

  }
 EXIT:
  return 0;
  /* DO-NOT-DELETE splicer.end(c.Ruleset.setAlive) */
}
