// 
// File:          ArrayTest_ArrayOps_Impl.cc
// Symbol:        ArrayTest.ArrayOps-v1.3
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for ArrayTest.ArrayOps
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "ArrayTest_ArrayOps_Impl.hh"

#line 14 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
// DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._includes)
#include "sidlArray.h"

double powTwo(int32_t i) {
  double result = 1;
  if (i >= 0) {
    while (i--) {
      result *= 2;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5;
    }
  }
  return result;
}

float fpowTwo(int32_t i) {
  register float result = 1.0F;
  static volatile float forcestore; /* force memory storage on x86 architectures */
  if (i >= 0) {
    while (i--) {
      result *= 2.0F;
    }
  }
  else if (i < 0) {
    while (i++) {
      result *= 0.5F;
    }
  }
  forcestore = result;
  return forcestore;
}

static int isPrime(const int64_t num) {
  register int64_t i;
  for(i = 3; i*i <= num; ++i) {
    if (!(num % i)) return 0;
  }
  return 1;
}

int64_t
nextPrime(int64_t prev) {
  if (prev <= 1L) {
    return 2L;
  }
  else if (prev == 2L) {
    return 3L;
  }
  else {
    do {
      prev += 2;
    } while (!isPrime(prev));
    return prev;
  }
}

static const char s_TestText[] = "\
I'd rather write programs to write programs than write programs.";

static const char *s_TestWords[] = {
  "I'd",
  "rather",
  "write",
  "programs",
  "to",
  "write",
  "programs",
  "than",
  "write",
  "programs.",
  NULL
};

const char *nextChar(const char *str) {
  if (!*(++str)) {
    str = s_TestText;
  }
  return str;
}

const char * const* nextWord(const char *const*word) {
  if (!*(++word)){
    word = s_TestWords;
  }
  return word;
}

static bool
nextElem(const int32_t dimen,
         int32_t ind[],
         const int32_t lower[],
         const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static int32_t
arrayValue(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0; i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static bool
hasElements(const int dimen, const int32_t lower[], const int32_t upper[])
{
  int i;
  for (i = 0; i < dimen; ++i){
    if (lower[i] > upper[i]) return false;
  }
  return true;
}

static int32_t intFunc(const int dimen, const int32_t ind[])
{
  int32_t result = 1;
  int i;
  for(i = 0;i < dimen; ++i){
    result *= (ind[i] + (i + 1));
  }
  return result;
}

static bool
next(const int dimen, int32_t ind[],
     const int32_t lower[], const int32_t upper[])
{
  int i = 0;
  while ((i < dimen) && (++(ind[i]) > upper[i])) {
    ind[i] = lower[i];
    ++i;
  }
  return i < dimen;
}

static sidl::array<int32_t>
makeIntTestMatrix(int dimen)
{
  struct sidl::array<int32_t> result;
  static const int32_t lower[] = {0, 0, 0, 0, 0, 0, 0};
  static const int32_t upper[] = {3, 3, 2, 2, 2, 2, 2};
  int32_t ind[] = {0, 0, 0, 0, 0, 0, 0};
  int32_t value;
  result  = sidl::array<int32_t>::createCol(dimen, lower, upper);
  do {
    value = intFunc(dimen, ind);
    switch(rand() % 2) {
    case 0:
      switch(dimen) {
      case 3:
        result.set(ind[0], ind[1], ind[2], value);
	break;
      case 4:
        result.set(ind[0], ind[1], ind[2], ind[3], value);
	break;
      case 5:
	result.set(ind[0], ind[1], ind[2], ind[3], ind[4], value);
	break;
      case 6:
	result.set(ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], value);
	break;
      case 7:
	result.set(ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], ind[6], value);
	break;
      }
    case 1:
      result.set(ind, value);
      break;
    }
  } while (next(dimen, ind, lower, upper));
  return result;
}

static sidl::basearray
createArrayByType(const int32_t type,
                  const int32_t dimen,
                  const int32_t lower[],
                  const int32_t upper[])
{
  switch(type){
  case sidl_bool_array:
    return
      ::sidl::array< bool >::createRow(dimen, lower, upper);
  case sidl_char_array:
    return
      ::sidl::array< char >::createRow(dimen, lower, upper);
  case sidl_dcomplex_array:
    return
      ::sidl::array< ::sidl::dcomplex >::createRow(dimen, lower, upper);
  case sidl_double_array:
    return
      ::sidl::array< double >::createRow(dimen, lower, upper);
  case sidl_fcomplex_array:
    return
      ::sidl::array< ::sidl::fcomplex >::createRow(dimen, lower, upper);
  case sidl_float_array:
    return
      ::sidl::array< float >::createRow(dimen, lower, upper);
  case sidl_int_array:
    return
      ::sidl::array< int32_t >::createRow(dimen, lower, upper);
  case sidl_long_array:
    return
      ::sidl::array< int64_t >::createRow(dimen, lower, upper);
  case sidl_opaque_array:
    return
      ::sidl::array< ::sidl::opaque >::createRow(dimen, lower, upper);
  case sidl_string_array:
    return
      ::sidl::array< ::sidl::string >::createRow(dimen, lower, upper);
  case sidl_interface_array:
    return
      ::sidl::array< ::sidl::BaseInterface >::createRow(dimen, lower, upper);
  default:
    return ::sidl::basearray();
  }
}

static void
copyArrayByType(const sidl::basearray &src,
                sidl::basearray &dest)
{
  switch(src.arrayType()){
  case sidl_bool_array:
    static_cast< ::sidl::array< bool > &>(dest).copy
      (static_cast< const ::sidl::array< bool > &>(src));
    break;
  case sidl_char_array:
    static_cast< ::sidl::array< char > &>(dest).copy
      (static_cast<  const ::sidl::array< char > &>(src));
    break;
  case sidl_dcomplex_array:
    static_cast< ::sidl::array< ::sidl::dcomplex > &>(dest).copy
      (static_cast<  const ::sidl::array< ::sidl::dcomplex > &>(src));
    break;
  case sidl_double_array:
    static_cast< ::sidl::array< double > &>(dest).copy
      (static_cast<  const ::sidl::array< double > &>(src));
    break;
  case sidl_fcomplex_array:
    static_cast< ::sidl::array< ::sidl::fcomplex > &>(dest).copy
      (static_cast<  const ::sidl::array< ::sidl::fcomplex > &>(src));
    break;
  case sidl_float_array:
    static_cast< ::sidl::array< float > &>(dest).copy
      (static_cast<  const ::sidl::array< float > &>(src));
    break;
  case sidl_int_array:
    static_cast< ::sidl::array< int32_t > &>(dest).copy
      (static_cast<  const ::sidl::array< int32_t > &>(src));
    break;
  case sidl_long_array:
    static_cast< ::sidl::array< int64_t > &>(dest).copy
      (static_cast<  const ::sidl::array< int64_t > &>(src));
    break;
  case sidl_opaque_array:
    static_cast< ::sidl::array< ::sidl::opaque > &>(dest).copy
      (static_cast<  const ::sidl::array< ::sidl::opaque > &>(src));
    break;
  case sidl_string_array:
    static_cast< ::sidl::array< ::sidl::string > &>(dest).copy
      (static_cast<  const ::sidl::array< ::sidl::string > &>(src));
    break;
  case sidl_interface_array:
    static_cast< ::sidl::array< ::sidl::BaseInterface > &>(dest).copy
      (static_cast<  const ::sidl::array< ::sidl::BaseInterface > &>(src));
    break;
  }
}


void locMatrixMultiply(
  /*in*/ int32_t* a, /*in*/ int32_t* b, /*inout*/ int32_t* res,
    /*in*/ int32_t n, /*in*/ int32_t m, /*in*/ int32_t o)
{
  int32_t i,j,k;

  for(i=0;i<n;++i){
    for(k=0;k<o;++k){
      int32_t temp = 0;
      for(j=0;j<m;++j) {
	temp += (RarrayElem2(a,i,j,n) * RarrayElem2(b,j,k,m));
	
      }
      RarrayElem2(res,i,k,n) = temp;
    }
  }  
}
// DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._includes)
#line 316 "ArrayTest_ArrayOps_Impl.cc"

// user-defined constructor.
void ArrayTest::ArrayOps_impl::_ctor() {
#line 318 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._ctor)
#line 324 "ArrayTest_ArrayOps_Impl.cc"
}

// user-defined destructor.
void ArrayTest::ArrayOps_impl::_dtor() {
#line 325 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._dtor)
#line 333 "ArrayTest_ArrayOps_Impl.cc"
}

// static class initializer.
void ArrayTest::ArrayOps_impl::_load() {
#line 332 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._load)
#line 342 "ArrayTest_ArrayOps_Impl.cc"
}

// user-defined static methods:
/**
 * Return <code>true</code> iff the even elements are true and
 * the odd elements are false.
 */
bool
ArrayTest::ArrayOps_impl::checkBool (
  /* in */ ::sidl::array<bool> a ) 
throw () 
{
#line 347 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkBool)
  if ( a._is_nil() ||
       ( a.dimen() != 1) ||
       (sidlArrayDim(a._get_ior()) != 1) ||
       (a.lower(0) != sidlLower(a._get_ior(),0)) ||
       (a.upper(0) != sidlUpper(a._get_ior(),0)) ) {
    return false;
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i) {
    if ( ( a.get(i) != sidl_bool__array_get1(a._get_ior(), i ) ) ||
	 ( a.get(i) != ((i & 0x1) ? FALSE : TRUE) ) ) { 
      return false;
    }    
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkBool)
#line 372 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkChar[]
 */
bool
ArrayTest::ArrayOps_impl::checkChar (
  /* in */ ::sidl::array<char> a ) 
throw () 
{
#line 373 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkChar)
  if ( a._is_nil() ||
       ( a.dimen() != 1) ||
       (sidlArrayDim(a._get_ior()) != 1) ||
       (a.lower(0) != sidlLower(a._get_ior(),0)) ||
       (a.upper(0) != sidlUpper(a._get_ior(),0)) ) {
    return false;
  }
  const char * testStr = s_TestText;
  for( int32_t i=a.lower(0); i<a.upper(0); ++i, testStr = nextChar(testStr) ) {
    if ( ( a.get(i) != sidl_char__array_get1(a._get_ior(), i ) ) ||
	 ( a.get(i) != *testStr ) ) { 
      return false;
    }    
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkChar)
#line 401 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkInt[]
 */
bool
ArrayTest::ArrayOps_impl::checkInt (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 400 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkInt)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( sidlArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != sidlLower(a._get_ior(),0) ) ||
      ( a.upper(0) != sidlUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  int32_t prime = nextPrime(0);
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i, prime = nextPrime(prime) ) { 
    if ( ( a.get(i) != sidlArrayElem1(a._get_ior(), i) ) ||
	   ( a.get(i) != prime ) ) { 
	return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkInt)
#line 430 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkLong[]
 */
bool
ArrayTest::ArrayOps_impl::checkLong (
  /* in */ ::sidl::array<int64_t> a ) 
throw () 
{
#line 427 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkLong)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( sidlArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != sidlLower(a._get_ior(),0) ) ||
      ( a.upper(0) != sidlUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  int64_t prime = nextPrime(0);
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i, prime = nextPrime(prime) ) { 
    if ( ( a.get(i) != sidlArrayElem1(a._get_ior(), i) ) ||
	 ( a.get(i) != prime ) ) { 
      return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkLong)
#line 459 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkString[]
 */
bool
ArrayTest::ArrayOps_impl::checkString (
  /* in */ ::sidl::array< ::std::string> a ) 
throw () 
{
#line 454 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkString)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const char * const * testWord = s_TestWords;
  for(int32_t i=a.lower(0); i<=a.upper(0); 
      ++i, testWord = nextWord(testWord) ) { 
    char * s1 = sidl_string__array_get1(a._get_ior(), i);
    std::string s2 = a.get(i);
    //const char * s2c_str = s2.c_str();
    //int size = s2.size();
    //int cmp1 = strcmp(s1,s2.c_str());
    //int cmp2 = strcmp(s2.c_str(),*testWord);
    if ( !s1 || 
	 (s2.size() == 0) ||
	 strcmp(s1,s2.c_str()) ||
	 strcmp(s2.c_str(),*testWord) ) { 
      free(s1);
      return false;
    }
    free(s1);
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkString)
#line 495 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkDouble[]
 */
bool
ArrayTest::ArrayOps_impl::checkDouble (
  /* in */ ::sidl::array<double> a ) 
throw () 
{
#line 488 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDouble)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( sidlArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != sidlLower(a._get_ior(),0) ) ||
      ( a.upper(0) != sidlUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i ) { 
    if ( ( a.get(i) != sidlArrayElem1(a._get_ior(), i) ) ||
	 ( a.get(i) != powTwo(-i) ) ) { 
	return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDouble)
#line 523 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkFloat[]
 */
bool
ArrayTest::ArrayOps_impl::checkFloat (
  /* in */ ::sidl::array<float> a ) 
throw () 
{
#line 514 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFloat)
  if( a._is_nil() ||
      ( a.dimen() != 1 ) ||
      ( sidlArrayDim(a._get_ior()) != 1 ) ||
      ( a.lower(0) != sidlLower(a._get_ior(),0) ) ||
      ( a.upper(0) != sidlUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<=a.upper(0); ++i ) { 
    if ( ( a.get(i) != sidlArrayElem1(a._get_ior(), i) ) ||
	   ( a.get(i) != fpowTwo(-i) ) ) { 
	return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFloat)
#line 551 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkFcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::checkFcomplex (
  /* in */ ::sidl::array< ::sidl::fcomplex> a ) 
throw () 
{
#line 540 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkFcomplex)
  if ( a._is_nil() ||
       (a.lower(0) != sidlLower(a._get_ior(),0) ) ||
       (a.upper(0) != sidlUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<= a.upper(0); ++i ) { 
    std::complex<double> r1 = a.get(i);
    if ( (r1.real() != sidlArrayElem1(a._get_ior(), i).real ) ||
	 (r1.imag() != sidlArrayElem1(a._get_ior(), i).imaginary ) ||
	 (r1.real() != fpowTwo(i)) ||
	 (r1.imag() != fpowTwo(-i))) { 
      return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkFcomplex)
#line 580 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkDcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::checkDcomplex (
  /* in */ ::sidl::array< ::sidl::dcomplex> a ) 
throw () 
{
#line 567 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkDcomplex)
  if ( a._is_nil() ||
       (a.lower(0) != sidlLower(a._get_ior(),0) ) ||
       (a.upper(0) != sidlUpper(a._get_ior(),0) ) ) { 
    return false;
  }
  for( int32_t i=a.lower(0); i<= a.upper(0); ++i ) { 
    std::complex<double> r1 = a.get(i);
    if ( (r1.real() != sidlArrayElem1(a._get_ior(), i).real ) ||
	 (r1.imag() != sidlArrayElem1(a._get_ior(), i).imaginary ) ||
	 (r1.real() != powTwo(i)) ||
	 (r1.imag() != powTwo(-i))) { 
      return false;
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkDcomplex)
#line 609 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check2Int[]
 */
bool
ArrayTest::ArrayOps_impl::check2Int (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 594 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Int)
  if ( a._is_nil() ||
       ( a.dimen() != 2) ||
       ( sidlArrayDim(a._get_ior())) != 2 ) { 
    return false;
  }
  for( int i=0; i<2; ++i ) { 
    if ( ( a.lower(i) != sidlLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != sidlUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i ) { 
    for( int32_t j=a.lower(1); j<a.upper(1); ++j ) { 
      if ( ( a.get(i,j) != sidlArrayElem2(a._get_ior(),i,j) ) ||
	   ( a.get(i,j) != (int)powTwo(abs(i-j)) ) ) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Int)
#line 643 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check2Double[]
 */
bool
ArrayTest::ArrayOps_impl::check2Double (
  /* in */ ::sidl::array<double> a ) 
throw () 
{
#line 626 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Double)
  if ( a._is_nil() ||
       ( a.dimen() != 2) ||
       ( sidlArrayDim(a._get_ior())) != 2 ) { 
    return false;
  }
  for( int i=0; i<2; ++i ) { 
    if ( ( a.lower(i) != sidlLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != sidlUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i ) { 
    for( int32_t j=a.lower(1); j<a.upper(1); ++j ) { 
      if ( ( a.get(i,j) != sidlArrayElem2(a._get_ior(),i,j) ) ||
	   ( a.get(i,j) != powTwo(i-j) ) ) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Double)
#line 677 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check2Float[]
 */
bool
ArrayTest::ArrayOps_impl::check2Float (
  /* in */ ::sidl::array<float> a ) 
throw () 
{
#line 658 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Float)
  if ( a._is_nil() ||
       ( a.dimen() != 2 ) || 
       ( sidlArrayDim(a._get_ior()) != 2 ) ) { 
    return false;
  }
  for( int i=0; i<2; ++i ) { 
    if ( ( a.lower(i) != sidlLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != sidlUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  }
  for( int32_t i=a.lower(0); i<a.upper(0); ++i ) { 
    for( int32_t j=a.lower(1); j<a.upper(1); ++j ) { 
      if ( ( a.get(i,j) != sidlArrayElem2(a._get_ior(),i,j) ) ||
	   ( a.get(i,j) != (float)powTwo(i-j) ) ) { 
	
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Float)
#line 712 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check2Fcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::check2Fcomplex (
  /* in */ ::sidl::array< ::sidl::fcomplex> a ) 
throw () 
{
#line 691 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Fcomplex)
  if ( a._is_nil() ||
       (a.dimen() != 2) || 
       (sidlArrayDim(a._get_ior()) != 2) ) { 
    return false;
  }
  for(int i = 0; i < 2; ++i){
    if ( ( a.lower(i) != sidlLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != sidlUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  } 
  for( int32_t i = a.lower(0); i<= a.upper(0); ++i ) { 
    for( int32_t j = a.lower(1); j<= a.upper(1); ++j ) { 
      std::complex<float> r1 = a.get(i,j);
      if ( (r1.real() != sidlArrayElem2(a._get_ior(), i, j).real ) ||
	   (r1.imag() != sidlArrayElem2(a._get_ior(), i, j).imaginary ) ||
	   (r1.real() != (float)powTwo(i)) ||
	   (r1.imag() != (float)powTwo(-j))) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Fcomplex)
#line 749 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check2Dcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::check2Dcomplex (
  /* in */ ::sidl::array< ::sidl::dcomplex> a ) 
throw () 
{
#line 726 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check2Dcomplex)
  if ( a._is_nil() ||
       ( a.dimen() != 2) ||
       ( sidlArrayDim(a._get_ior()) != 2)) { 
    return false;
  }
  for(int i = 0; i < 2; ++i){
    if ( ( a.lower(i) != sidlLower(a._get_ior(),i) ) ||
	 ( a.upper(i) != sidlUpper(a._get_ior(),i) ) ) { 
      return false;
    }
  } 
  for( int32_t i = a.lower(0); i<= a.upper(0); ++i ) { 
    for( int32_t j = a.lower(1); j<= a.upper(1); ++j ) { 
      std::complex<double> r1 = a.get(i,j);
      if ( (r1.real() != sidlArrayElem2(a._get_ior(), i, j).real ) ||
	   (r1.imag() != sidlArrayElem2(a._get_ior(), i, j).imaginary ) ||
	   (r1.real() != powTwo(i)) ||
	   (r1.imag() != powTwo(-j))) { 
	return false;
      }
    }
  }
  return true;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check2Dcomplex)
#line 786 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check3Int[]
 */
bool
ArrayTest::ArrayOps_impl::check3Int (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 761 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check3Int)
  int i;
  int32_t ind[3], lower[3], upper[3], value;
  bool result = false;
  if (a.dimen() == 3) {
    for(i = 0; i < 3; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(3, lower, upper)) {
      do {
	value = arrayValue(3, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(3, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check3Int)
#line 826 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check4Int[]
 */
bool
ArrayTest::ArrayOps_impl::check4Int (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 799 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check4Int)
  int i;
  int32_t ind[4], lower[4], upper[4], value;
  bool result = false;
  if (a.dimen() == 4) {
    for(i = 0; i < 4; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(4, lower, upper)) {
      do {
	value = arrayValue(4, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2], ind[3]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(4, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check4Int)
#line 866 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check5Int[]
 */
bool
ArrayTest::ArrayOps_impl::check5Int (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 837 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check5Int)
  int i;
  int32_t ind[5], lower[5], upper[5], value;
  bool result = false;
  if (a.dimen() == 5) {
    for(i = 0; i < 5; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(5, lower, upper)) {
      do {
	value = arrayValue(5, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2], ind[3], ind[4]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(5, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check5Int)
#line 906 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check6Int[]
 */
bool
ArrayTest::ArrayOps_impl::check6Int (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 875 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check6Int)
  int i;
  int32_t ind[6], lower[6], upper[6], value;
  bool result = false;
  if (a.dimen() == 6) {
    for(i = 0; i < 6; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(6, lower, upper)) {
      do {
	value = arrayValue(6, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2], ind[3], ind[4], ind[5]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(6, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check6Int)
#line 946 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  check7Int[]
 */
bool
ArrayTest::ArrayOps_impl::check7Int (
  /* in */ ::sidl::array<int32_t> a ) 
throw () 
{
#line 913 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.check7Int)
  int i;
  int32_t ind[7], lower[7], upper[7], value;
  bool result = false;
  if (a.dimen() == 7) {
    for(i = 0; i < 7; ++i) {
      ind[i] = lower[i] = a.lower(i);
      upper[i] = a.upper(i);
    }
    result = true;
    if (hasElements(7, lower, upper)) {
      do {
	value = arrayValue(7, ind);
	switch(rand() % 2) {
	case 0:
	  if (a.get(ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], ind[6]) != value)
	    result = false;
	  break;
	case 1:
	  if (a.get(ind) != value) 
	    result = false;
	  break;
	}
      } while (result && nextElem(7, ind, lower, upper));
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.check7Int)
#line 986 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkObject[]
 */
int32_t
ArrayTest::ArrayOps_impl::checkObject (
  /* in */ ::sidl::array< ::ArrayTest::ArrayOps> a ) 
throw () 
{
#line 951 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkObject)
  if ( a._is_nil() ||
       (a.dimen() != 1 ) ) { 
    return 0;
  }
  int32_t count=0;
  for( int32_t i=a.lower(0); i<= a.upper(0); ++i ) { 
    ArrayTest::ArrayOps ops = a.get(i);
    if ( !ops._is_nil() ) { 
      ++count;
    }
  }
  return count;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkObject)
#line 1012 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseBool[]
 */
bool
ArrayTest::ArrayOps_impl::reverseBool (
  /* inout */ ::sidl::array<bool>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 976 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseBool)
  if ( !a ||
       a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkBool(a);
  
  if (newArray) { // build a new array that is the reverse of the old one
    const int32_t len = upper - lower + 1;
    sidl::array<bool> copy = sidl::array<bool>::createRow(1,&lower,&upper);
    for(int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1) >> 1;
    for ( int32_t i=0; i<len; ++i ) { 
      bool temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }      
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseBool)
#line 1052 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseChar[]
 */
bool
ArrayTest::ArrayOps_impl::reverseChar (
  /* inout */ ::sidl::array<char>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1014 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseChar)
  if ( !a ||
       a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkChar(a);
  
  if (newArray) { // build a new array that is the reverse of the old one
    const int32_t len = upper - lower + 1;
    sidl::array<char> copy = sidl::array<char>::createRow(1,&lower,&upper);
    for(int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1) >> 1;
    for ( int32_t i=0; i<len; ++i ) { 
      char temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }      
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseChar)
#line 1092 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseInt[]
 */
bool
ArrayTest::ArrayOps_impl::reverseInt (
  /* inout */ ::sidl::array<int32_t>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1052 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseInt)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkInt(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<int32_t> copy = sidl::array<int32_t>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      int32_t temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseInt)
#line 1130 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseLong[]
 */
bool
ArrayTest::ArrayOps_impl::reverseLong (
  /* inout */ ::sidl::array<int64_t>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1088 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseLong)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkLong(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<int64_t> copy = sidl::array<int64_t>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      int64_t temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseLong)
#line 1168 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseString[]
 */
bool
ArrayTest::ArrayOps_impl::reverseString (
  /* inout */ ::sidl::array< ::std::string>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1124 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseString)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkString(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<std::string> copy = sidl::array<std::string>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      std::string temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseString)
#line 1206 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseDouble[]
 */
bool
ArrayTest::ArrayOps_impl::reverseDouble (
  /* inout */ ::sidl::array<double>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1160 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDouble)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkDouble(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<double> copy = sidl::array<double>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      double temp = a.get(lower+i);
      a.set(lower+i,a.get(upper-i));
      a.set(upper-i,temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDouble)
#line 1244 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseFloat[]
 */
bool
ArrayTest::ArrayOps_impl::reverseFloat (
  /* inout */ ::sidl::array<float>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1196 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFloat)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkFloat(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<float> copy = sidl::array<float>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i,a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      float temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFloat)
#line 1282 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseFcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::reverseFcomplex (
  /* inout */ ::sidl::array< ::sidl::fcomplex>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1232 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseFcomplex)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkFcomplex(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<sidl::fcomplex> copy = sidl::array<sidl::fcomplex>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      std::complex<float> temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseFcomplex)
#line 1320 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  reverseDcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::reverseDcomplex (
  /* inout */ ::sidl::array< ::sidl::dcomplex>& a,
  /* in */ bool newArray ) 
throw () 
{
#line 1268 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.reverseDcomplex)
  if ( !a || a.dimen() != 1 ) { 
    return false;
  }
  const int32_t upper = a.upper(0);
  const int32_t lower = a.lower(0);
  bool result = ArrayTest::ArrayOps::checkDcomplex(a);
  if ( newArray ) { // create a separate copy
    const int32_t len = upper - lower + 1;
    sidl::array<sidl::dcomplex> copy = sidl::array<sidl::dcomplex>::createRow(1,&lower,&upper);
    for( int32_t i=0; i<len; ++i ) { 
      copy.set(upper-i, a.get(lower+i));
    }
    a.deleteRef();
    a=copy;
  } else { // reverse in place
    const int32_t len = (upper - lower + 1 ) >> 1;
    for( int32_t i=0; i<len; ++i ) { 
      std::complex<double> temp = a.get(lower+i);
      a.set(lower+i, a.get(upper-i));
      a.set(upper-i, temp);
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.reverseDcomplex)
#line 1358 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createBool[]
 */
::sidl::array<bool>
ArrayTest::ArrayOps_impl::createBool (
  /* in */ int32_t len ) 
throw () 
{
#line 1303 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createBool)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<bool> result = sidl::array<bool>::createRow(1,lower,upper);
  
  for( int32_t i=0; i<len; ++i ) { 
    switch( rand() % 3) { 
    case 0:
      sidlArrayElem1(result._get_ior(),i) = ((i & 0x1) ? FALSE : TRUE);
      break;
    case 1:
      sidl_bool__array_set1(result._get_ior(), i, ((i & 0x1) ? FALSE : TRUE));
      break;
    case 2:
      result.set(i, ((i & 0x1) ? FALSE : TRUE));
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createBool)
#line 1391 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createChar[]
 */
::sidl::array<char>
ArrayTest::ArrayOps_impl::createChar (
  /* in */ int32_t len ) 
throw () 
{
#line 1334 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createChar)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<char> result = sidl::array<char>::createRow(1,lower,upper);
  
  const char* testStr = s_TestText;
  for( int32_t i=0; i<len; ++i, testStr=nextChar(testStr) ) { 
    switch( rand() % 3) { 
    case 0:
      sidlArrayElem1(result._get_ior(),i) = *testStr;
      break;
    case 1:
      sidl_char__array_set1(result._get_ior(), i, *testStr);
      break;
    case 2:
      result.set(i, *testStr);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createChar)
#line 1425 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createInt[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::createInt (
  /* in */ int32_t len ) 
throw () 
{
#line 1366 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createInt)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  int32_t prime = nextPrime(0);
  sidl::array<int32_t> result = sidl::array<int32_t>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i, prime = nextPrime(prime) ) { 
    switch( rand()%3 ) { 
    case 0:
      sidlArrayElem1(result._get_ior(), i ) = prime;
      break;
    case 1:
      sidl_int__array_set1(result._get_ior(), i, prime );
      break;
    case 2:
      result.set(i, prime);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createInt)
#line 1458 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createLong[]
 */
::sidl::array<int64_t>
ArrayTest::ArrayOps_impl::createLong (
  /* in */ int32_t len ) 
throw () 
{
#line 1397 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createLong)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  int64_t prime = nextPrime(0);
  sidl::array<int64_t> result = sidl::array<int64_t>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i, prime = nextPrime(prime) ) { 
    switch( rand()%3 ) { 
    case 0:
      sidlArrayElem1(result._get_ior(), i ) = prime;
      break;
    case 1:
      sidl_long__array_set1(result._get_ior(), i, prime );
      break;
    case 2:
      result.set(i, prime);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createLong)
#line 1491 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createString[]
 */
::sidl::array< ::std::string>
ArrayTest::ArrayOps_impl::createString (
  /* in */ int32_t len ) 
throw () 
{
#line 1428 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createString)
  if (len < 0) return NULL;
  const char* const * testWord = s_TestWords;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<std::string> result = sidl::array<std::string>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i, testWord = nextWord(testWord)) { 
    switch(rand()%2) { 
    case 0:
      sidl_string__array_set1( result._get_ior(), i, *testWord );
      break;
    case 1:
      result.set(i, *testWord);
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createString)
#line 1521 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createDouble[]
 */
::sidl::array<double>
ArrayTest::ArrayOps_impl::createDouble (
  /* in */ int32_t len ) 
throw () 
{
#line 1456 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDouble)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<double> result = sidl::array<double>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand()%3) { 
    case 0:
      sidlArrayElem1(result._get_ior(), i) = powTwo(-i);
      break;
    case 1:
      sidl_double__array_set1(result._get_ior(), i, powTwo(-i) );
      break;
    case 2:
      result.set(i, powTwo(-i));
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDouble)
#line 1553 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createFloat[]
 */
::sidl::array<float>
ArrayTest::ArrayOps_impl::createFloat (
  /* in */ int32_t len ) 
throw () 
{
#line 1486 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFloat)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<float> result = sidl::array<float>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand()%3) { 
    case 0:
      sidlArrayElem1(result._get_ior(), i) = powTwo(-i);
      break;
    case 1:
      sidl_float__array_set1(result._get_ior(), i, powTwo(-i) );
      break;
    case 2:
      result.set(i, powTwo(-i) );
      break;
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFloat)
#line 1585 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createFcomplex[]
 */
::sidl::array< ::sidl::fcomplex>
ArrayTest::ArrayOps_impl::createFcomplex (
  /* in */ int32_t len ) 
throw () 
{
#line 1516 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createFcomplex)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<sidl::fcomplex> result = sidl::array<sidl::fcomplex>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand() % 3 ) { 
    case 0:
      sidlArrayElem1(result._get_ior(), i).real = fpowTwo(i);
      sidlArrayElem1(result._get_ior(), i).imaginary = fpowTwo(-i);
      break;
    case 1:
      { 
	struct sidl_fcomplex tmp;
        tmp.real = fpowTwo(i);
        tmp.imaginary = fpowTwo(-i);
	sidl_fcomplex__array_set1(result._get_ior(), i, tmp);
      }
      break;
    case 2:
      {
	std::complex<float> f( fpowTwo(i), fpowTwo(-i) );
	result.set(i,f);
      }
      break;
      
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createFcomplex)
#line 1627 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createDcomplex[]
 */
::sidl::array< ::sidl::dcomplex>
ArrayTest::ArrayOps_impl::createDcomplex (
  /* in */ int32_t len ) 
throw () 
{
#line 1556 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createDcomplex)
  if (len < 0) return NULL;
  int32_t lower[1] = {0};
  int32_t upper[1] = {len-1};
  sidl::array<sidl::dcomplex> result= sidl::array<sidl::dcomplex>::createRow(1,lower,upper);
  for( int32_t i=0; i<len; ++i ) { 
    switch(rand() % 3 ) { 
    case 0:
      sidlArrayElem1(result._get_ior(), i).real = powTwo(i);
      sidlArrayElem1(result._get_ior(), i).imaginary = powTwo(-i);
      break;
    case 1:
      { 
	struct sidl_dcomplex tmp;
        tmp.real = powTwo(i);
        tmp.imaginary = powTwo(-i);
	sidl_dcomplex__array_set1(result._get_ior(), i, tmp);
      }
      break;
    case 2:
      {
	std::complex<double> d( powTwo(i), powTwo(-i) );
	result.set(i,d);
      }
      break;
      
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createDcomplex)
#line 1669 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  createObject[]
 */
::sidl::array< ::ArrayTest::ArrayOps>
ArrayTest::ArrayOps_impl::createObject (
  /* in */ int32_t len ) 
throw () 
{
#line 1596 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createObject)
  sidl::array<ArrayTest::ArrayOps> a;
  if ( len >= 0 ) { 
    int32_t lower = 0;
    int32_t upper = len-1;
    a = sidl::array<ArrayTest::ArrayOps>::createRow(1,&lower,&upper);
    while( len--) { 
      ArrayTest::ArrayOps obj = ArrayTest::ArrayOps::_create();
      a.set(len,obj);
    }
  }
  return a;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createObject)
#line 1694 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create2Int[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::create2Int (
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 1620 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Int)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {d1-1, d2-1};
  sidl::array<int32_t> result = sidl::array<int32_t>::createRow(2,lower,upper);
  for( int32_t i=0; i<d1; ++i ) {
    for( int32_t j=0;  j<d2; ++j ) {
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result._get_ior(),i,j) = (int)powTwo(abs(i-j));
        break;
      case 1:
        sidl_int__array_set2(result._get_ior(), i, j, (int)powTwo(abs(i-j)));
        break;
      case 2:
        result.set(i, j, (int)powTwo(abs(i-j)));
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Int)
#line 1729 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create2Double[]
 */
::sidl::array<double>
ArrayTest::ArrayOps_impl::create2Double (
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 1653 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Double)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {d1-1, d2-1};
  sidl::array<double> result = sidl::array<double>::createRow(2,lower,upper);
  for( int32_t i=0; i<d1; ++i ) {
    for( int32_t j=0;  j<d2; ++j ) {
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result._get_ior(),i,j) = powTwo(i-j);
        break;
      case 1:
        sidl_double__array_set2(result._get_ior(), i, j, powTwo(i-j));
        break;
      case 2:
        result.set(i, j, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Double)
#line 1764 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create2Float[]
 */
::sidl::array<float>
ArrayTest::ArrayOps_impl::create2Float (
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 1686 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Float)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = { d1-1, d2-1};
  sidl::array<float> result = sidl::array<float>::createRow(2, lower, upper);
  for( int32_t i=0; i<d1; ++i) {
    for( int32_t j=0; j<d2; ++j) {
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result._get_ior(),i,j) = powTwo(i-j);
        break;
      case 1:
        sidl_float__array_set2(result._get_ior(), i, j, powTwo(i-j));
        break;
      case 2:
        result.set(i, j, powTwo(i-j));
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Float)
#line 1799 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create2Dcomplex[]
 */
::sidl::array< ::sidl::dcomplex>
ArrayTest::ArrayOps_impl::create2Dcomplex (
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 1719 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Dcomplex)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0, 0};
  int32_t upper[2] = {d1-1, d2-1};
  sidl::array<sidl::dcomplex> result = sidl::array<sidl::dcomplex>::createRow(2, lower, upper);
  for(int32_t i=0; i<d1; ++i) {
    for(int32_t j=0; j<d2; ++j) {
      std::complex<double> tmp( powTwo(i), powTwo(-j) );
      struct sidl_dcomplex tmp2;
      tmp2.real = tmp.real();
      tmp2.imaginary = tmp.imag();
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result._get_ior(),i,j) = tmp2;
        break;
      case 1:
        sidl_dcomplex__array_set2(result._get_ior(), i, j, tmp2);
        break;
      case 2:
        result.set(i, j, tmp);
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Dcomplex)
#line 1838 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create2Fcomplex[]
 */
::sidl::array< ::sidl::fcomplex>
ArrayTest::ArrayOps_impl::create2Fcomplex (
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 1756 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create2Fcomplex)
  if ((d1 < 0) || (d2 < 0)) return NULL;
  int32_t lower[2] = {0,0};
  int32_t upper[2] = { d1-1, d2-1};
  sidl::array<sidl::fcomplex> result = sidl::array<sidl::fcomplex>::createRow(2, lower, upper);
  for(int32_t i=0; i<d1; ++i) {
    for(int32_t j=0; j<d2; ++j) {
      std::complex<float> tmp2( fpowTwo(i), fpowTwo(-j) );
      struct sidl_fcomplex tmp;
      tmp.real = fpowTwo(i);
      tmp.imaginary = fpowTwo(-j);
      switch(rand() % 3) {
      case 0:
        sidlArrayElem2(result._get_ior(),i,j) = tmp;
        break;
      case 1:
        sidl_fcomplex__array_set2(result._get_ior(), i, j, tmp);
        break;
      case 2:
        result.set(i, j, tmp2);
        break;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create2Fcomplex)
#line 1877 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create3Int[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::create3Int ()
throw () 

{
#line 1792 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create3Int)
  return makeIntTestMatrix(3);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create3Int)
#line 1892 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create4Int[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::create4Int ()
throw () 

{
#line 1805 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create4Int)
  return makeIntTestMatrix(4);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create4Int)
#line 1907 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create5Int[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::create5Int ()
throw () 

{
#line 1818 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create5Int)
  return makeIntTestMatrix(5);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create5Int)
#line 1922 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create6Int[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::create6Int ()
throw () 

{
#line 1831 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create6Int)
  return makeIntTestMatrix(6);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create6Int)
#line 1937 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  create7Int[]
 */
::sidl::array<int32_t>
ArrayTest::ArrayOps_impl::create7Int ()
throw () 

{
#line 1844 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.create7Int)
  return makeIntTestMatrix(7);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.create7Int)
#line 1952 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeBool[]
 */
void
ArrayTest::ArrayOps_impl::makeBool (
  /* in */ int32_t len,
  /* out */ ::sidl::array<bool>& a ) 
throw () 
{
#line 1858 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeBool)
  a = ArrayTest::ArrayOps::createBool(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeBool)
#line 1968 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeChar[]
 */
void
ArrayTest::ArrayOps_impl::makeChar (
  /* in */ int32_t len,
  /* out */ ::sidl::array<char>& a ) 
throw () 
{
#line 1872 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeChar)
  a = ArrayTest::ArrayOps::createChar(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeChar)
#line 1984 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInt[]
 */
void
ArrayTest::ArrayOps_impl::makeInt (
  /* in */ int32_t len,
  /* out */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 1886 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInt)
  a = ArrayTest::ArrayOps::createInt(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInt)
#line 2000 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeLong[]
 */
void
ArrayTest::ArrayOps_impl::makeLong (
  /* in */ int32_t len,
  /* out */ ::sidl::array<int64_t>& a ) 
throw () 
{
#line 1900 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeLong)
  a = ArrayTest::ArrayOps::createLong(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeLong)
#line 2016 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeString[]
 */
void
ArrayTest::ArrayOps_impl::makeString (
  /* in */ int32_t len,
  /* out */ ::sidl::array< ::std::string>& a ) 
throw () 
{
#line 1914 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeString)
  a = ArrayTest::ArrayOps::createString(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeString)
#line 2032 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeDouble[]
 */
void
ArrayTest::ArrayOps_impl::makeDouble (
  /* in */ int32_t len,
  /* out */ ::sidl::array<double>& a ) 
throw () 
{
#line 1928 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDouble)
  a = ArrayTest::ArrayOps::createDouble(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDouble)
#line 2048 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeFloat[]
 */
void
ArrayTest::ArrayOps_impl::makeFloat (
  /* in */ int32_t len,
  /* out */ ::sidl::array<float>& a ) 
throw () 
{
#line 1942 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFloat)
  a = ArrayTest::ArrayOps::createFloat(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFloat)
#line 2064 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeFcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeFcomplex (
  /* in */ int32_t len,
  /* out */ ::sidl::array< ::sidl::fcomplex>& a ) 
throw () 
{
#line 1956 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeFcomplex)
  a = ArrayTest::ArrayOps::createFcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeFcomplex)
#line 2080 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeDcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeDcomplex (
  /* in */ int32_t len,
  /* out */ ::sidl::array< ::sidl::dcomplex>& a ) 
throw () 
{
#line 1970 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeDcomplex)
  a = ArrayTest::ArrayOps::createDcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeDcomplex)
#line 2096 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutBool[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutBool (
  /* inout */ ::sidl::array<bool>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 1984 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutBool)
  a = ArrayTest::ArrayOps::createBool(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutBool)
#line 2112 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutChar[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutChar (
  /* inout */ ::sidl::array<char>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 1998 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutChar)
  a = ArrayTest::ArrayOps::createChar(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutChar)
#line 2128 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutInt[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutInt (
  /* inout */ ::sidl::array<int32_t>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2012 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutInt)
  a = ArrayTest::ArrayOps::createInt(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutInt)
#line 2144 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutLong[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutLong (
  /* inout */ ::sidl::array<int64_t>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2026 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutLong)
  a = ArrayTest::ArrayOps::createLong(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutLong)
#line 2160 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutString[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutString (
  /* inout */ ::sidl::array< ::std::string>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2040 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutString)
  a = ArrayTest::ArrayOps::createString(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutString)
#line 2176 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutDouble[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutDouble (
  /* inout */ ::sidl::array<double>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2054 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDouble)
  a = ArrayTest::ArrayOps::createDouble(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDouble)
#line 2192 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutFloat[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutFloat (
  /* inout */ ::sidl::array<float>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2068 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFloat)
  a = ArrayTest::ArrayOps::createFloat(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFloat)
#line 2208 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutDcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutDcomplex (
  /* inout */ ::sidl::array< ::sidl::dcomplex>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2082 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutDcomplex)
  a = ArrayTest::ArrayOps::createDcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutDcomplex)
#line 2224 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOutFcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOutFcomplex (
  /* inout */ ::sidl::array< ::sidl::fcomplex>& a,
  /* in */ int32_t len ) 
throw () 
{
#line 2096 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOutFcomplex)
  a = ArrayTest::ArrayOps::createFcomplex(len);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOutFcomplex)
#line 2240 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut2Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Int (
  /* inout */ ::sidl::array<int32_t>& a,
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 2111 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Int)
  a = ArrayTest::ArrayOps::create2Int(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Int)
#line 2257 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut2Double[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Double (
  /* inout */ ::sidl::array<double>& a,
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 2126 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Double)
  a = ArrayTest::ArrayOps::create2Double(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Double)
#line 2274 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut2Float[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Float (
  /* inout */ ::sidl::array<float>& a,
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 2141 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Float)
  a = ArrayTest::ArrayOps::create2Float(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Float)
#line 2291 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut2Dcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Dcomplex (
  /* inout */ ::sidl::array< ::sidl::dcomplex>& a,
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 2156 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Dcomplex)
  a = ArrayTest::ArrayOps::create2Dcomplex(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Dcomplex)
#line 2308 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut2Fcomplex[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut2Fcomplex (
  /* inout */ ::sidl::array< ::sidl::fcomplex>& a,
  /* in */ int32_t d1,
  /* in */ int32_t d2 ) 
throw () 
{
#line 2171 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut2Fcomplex)
  a = ArrayTest::ArrayOps::create2Fcomplex(d1, d2);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut2Fcomplex)
#line 2325 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut3Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut3Int (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 2184 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut3Int)
  a = ArrayTest::ArrayOps::create3Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut3Int)
#line 2340 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut4Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut4Int (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 2197 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut4Int)
  a = ArrayTest::ArrayOps::create4Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut4Int)
#line 2355 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut5Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut5Int (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 2210 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut5Int)
  a = ArrayTest::ArrayOps::create5Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut5Int)
#line 2370 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut6Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut6Int (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 2223 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut6Int)
  a = ArrayTest::ArrayOps::create6Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut6Int)
#line 2385 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  makeInOut7Int[]
 */
void
ArrayTest::ArrayOps_impl::makeInOut7Int (
  /* inout */ ::sidl::array<int32_t>& a ) 
throw () 
{
#line 2236 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.makeInOut7Int)
  a = ArrayTest::ArrayOps::create7Int();
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.makeInOut7Int)
#line 2400 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Return as out parameters the type and dimension of the 
 * array passed in. If a is NULL, dimen == type == 0 on exit.
 * The contents of the array have the default values for a 
 * newly created array.
 */
void
ArrayTest::ArrayOps_impl::checkGeneric (
  /* in */ ::sidl::basearray a,
  /* out */ int32_t& dmn,
  /* out */ int32_t& tp ) 
throw () 
{
#line 2254 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkGeneric)
  if (a) {
    dmn = a.dimen();
    tp = a.arrayType();
  }
  else {
    dmn = 0;
    tp = 0;
  }
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkGeneric)
#line 2427 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Create an array of the type and dimension specified and
 * return it. A type of 0 causes a NULL array to be returned.
 */
::sidl::basearray
ArrayTest::ArrayOps_impl::createGeneric (
  /* in */ int32_t dmn,
  /* in */ int32_t tp ) 
throw () 
{
#line 2276 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.createGeneric)
  static const int32_t lower[] = {0, 0, 0, 0, 0, 0, 0};
  static const int32_t upper[] = {2, 2, 2, 2, 2, 2, 2};
  return createArrayByType(tp, dmn, lower, upper);
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.createGeneric)
#line 2446 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Testing passing generic arrays using every possible mode.
 * The returned array is a copy of inArg, so if inArg != NULL,
 * the return value should != NULL. outArg is also a copy of
 * inArg.
 * If inOutArg is NULL on entry, a 2-D array of int that should
 * pass check2Int is returned.
 * If inOutArg is not NULL on entry and its dimension is even,
 * it is returned unchanged; otherwise, NULL is returned.
 */
::sidl::basearray
ArrayTest::ArrayOps_impl::passGeneric (
  /* in */ ::sidl::basearray inArg,
  /* inout */ ::sidl::basearray& inOutArg,
  /* out */ ::sidl::basearray& outArg ) 
throw () 
{
#line 2300 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.passGeneric)
  int32_t lower[7], upper[7], i;
  ::sidl::basearray result = NULL;
  if (inArg) {
    const int32_t dimen = inArg.dimen();
    for(i = 0; i < dimen; ++i) {
      lower[i] = inArg.lower(i);
      upper[i] = inArg.upper(i);
    }
    result = createArrayByType(inArg.arrayType(), dimen, lower, upper);
    outArg = createArrayByType(inArg.arrayType(), dimen, lower, upper);
    copyArrayByType(inArg, result);
    copyArrayByType(inArg, outArg);
  }
  if (inOutArg) {
    if (inOutArg.dimen() & 1) {
      inOutArg = NULL;
    }
  }
  else {
    inOutArg = ::ArrayTest::ArrayOps::create2Int(3, 3);
  }

  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.passGeneric)
#line 2492 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  initRarray1Int[]
 */
void
ArrayTest::ArrayOps_impl::initRarray1Int (
  /* inout */ int32_t* a,
  /* in */ int32_t n ) 
throw () 
{
#line 2336 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray1Int)
  int64_t lprime = nextPrime(0L);
  int32_t i, prime;
  if (n < 0) return;
  for(i = 0; i < n; ++i, lprime = nextPrime(lprime)) {
    prime = (int32_t)lprime;
    switch(rand() % 2) {
    case 0:      
      a[i] = prime;
      break;
    case 1:
      RarrayElem1(a,i) = prime;
      break;
    }
  }
  return;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray1Int)
#line 2522 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  initRarray3Int[]
 */
void
ArrayTest::ArrayOps_impl::initRarray3Int (
  /* inout */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o ) 
throw () 
{
#line 2366 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray3Int)
  int32_t lower[] = {0, 0, 0};
  int32_t upper[3];
  int32_t ind[] = {0, 0, 0};
  int32_t dimen = 3;
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  do {  
    RarrayElem3(a,ind[0], ind[1], ind[2], n, m)  = intFunc(dimen, ind);
  } while (next(dimen, ind, lower, upper));
  return;

  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray3Int)
#line 2551 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  initRarray7Int[]
 */
void
ArrayTest::ArrayOps_impl::initRarray7Int (
  /* inout */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o,
  /* in */ int32_t p,
  /* in */ int32_t q,
  /* in */ int32_t r,
  /* in */ int32_t s ) 
throw () 
{
#line 2397 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray7Int)
  int32_t lower[] = {0, 0, 0, 0, 0, 0, 0};
  int32_t upper[7];
  int32_t ind[] = {0, 0, 0, 0, 0, 0, 0};
  int32_t dimen = 7;
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  upper[3] = p-1;
  upper[4] = q-1;
  upper[5] = r-1;
  upper[6] = s-1;
  do {  
    RarrayElem7(a,ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], ind[6],
		n, m, o, p, q, r)  = intFunc(dimen, ind);
  } while (next(dimen, ind, lower, upper));
  return;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray7Int)
#line 2588 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  initRarray1Double[]
 */
void
ArrayTest::ArrayOps_impl::initRarray1Double (
  /* inout */ double* a,
  /* in */ int32_t n ) 
throw () 
{
#line 2426 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray1Double)
  int32_t lower[1], upper[1], i;
  if (n < 0) return;
  lower[0] = 0;
  upper[0] = n - 1;
  for(i = 0; i < n; ++i) {
    switch(rand() % 2) {
    case 0:
      RarrayElem1(a, i) = powTwo(-i);
      break;
    case 1:
      a[i] = powTwo(-i);
      break;
    }
  }
  return;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray1Double)
#line 2618 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  initRarray1Dcomplex[]
 */
void
ArrayTest::ArrayOps_impl::initRarray1Dcomplex (
  /* inout */ struct sidl_dcomplex* a,
  /* in */ int32_t n ) 
throw () 
{
#line 2454 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.initRarray1Dcomplex)
  int32_t lower[1], upper[1], i;
  if (n < 0) return;
  lower[0] = 0;
  upper[0] = n - 1;
  for(i = 0; i < n; ++i) {
    switch(rand() % 2) {
    case 0:
      RarrayElem1(a, i).real = powTwo(i);
      RarrayElem1(a, i).imaginary = powTwo(-i);
      break;
    case 1:
      {
	a[i].real = powTwo(i);
	a[i].imaginary = powTwo(-i);
      }
      break;

    }
  }
  return;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.initRarray1Dcomplex)
#line 2653 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkRarray1Int[]
 */
bool
ArrayTest::ArrayOps_impl::checkRarray1Int (
  /* in */ int32_t* a,
  /* in */ int32_t n ) 
throw () 
{
#line 2487 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray1Int)
  if (a) {
    int32_t i;
    int64_t lprime = nextPrime(0L);
    int32_t prime;
    for(i = 0; i < n; ++i, lprime = nextPrime(lprime)) {
      prime = (int32_t)lprime;
      if (a[i] != RarrayElem1(a,i) ||
          a[i] != prime) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray1Int)
#line 2682 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkRarray3Int[]
 */
bool
ArrayTest::ArrayOps_impl::checkRarray3Int (
  /* in */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o ) 
throw () 
{
#line 2516 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray3Int)
  int result = FALSE;
  int32_t lower[3] = {0,0,0};
  int32_t upper[3];
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  if (a) {

    int32_t ind[3] = {0, 0, 0};
    int32_t value = 0;
    result = TRUE;
    do {
      value = arrayValue(3, ind);
      if (RarrayElem3(a, ind[0], ind[1], ind[2], n, m) != value) {
	result = FALSE;
      }
    } while (result && nextElem(3, ind, lower, upper));
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray3Int)
#line 2718 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkRarray7Int[]
 */
bool
ArrayTest::ArrayOps_impl::checkRarray7Int (
  /* in */ int32_t* a,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o,
  /* in */ int32_t p,
  /* in */ int32_t q,
  /* in */ int32_t r,
  /* in */ int32_t s ) 
throw () 
{
#line 2554 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray7Int)
  int result = FALSE;
  int32_t lower[7] = {0,0,0,0,0,0,0};
  int32_t upper[7];
  upper[0] = n-1;
  upper[1] = m-1;
  upper[2] = o-1;
  upper[3] = p-1;
  upper[4] = q-1;
  upper[5] = r-1;
  upper[6] = s-1;
  if (a) {
    result = TRUE;
    int32_t ind[7] = {0, 0, 0, 0, 0, 0, 0};
    int32_t value = 0;
    do {
      value = arrayValue(7, ind);
      if (RarrayElem7(a, ind[0], ind[1], ind[2], ind[3], ind[4], ind[5], ind[6],
		      n, m, o, p, q, r) != value) {
	result = FALSE;
      }
    } while (result && nextElem(7, ind, lower, upper));
  }
  return result;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray7Int)
#line 2762 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkRarray1Double[]
 */
bool
ArrayTest::ArrayOps_impl::checkRarray1Double (
  /* in */ double* a,
  /* in */ int32_t n ) 
throw () 
{
#line 2590 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray1Double)
  if (a) {
    int32_t i, ind[1];
    for(i = 0; i < n; ++i) {
      ind[0] = i;
      if (RarrayElem1(a,i) != a[i] || a[i] != powTwo(-i)) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray1Double)
#line 2788 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkRarray1Dcomplex[]
 */
bool
ArrayTest::ArrayOps_impl::checkRarray1Dcomplex (
  /* in */ struct sidl_dcomplex* a,
  /* in */ int32_t n ) 
throw () 
{
#line 2614 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkRarray1Dcomplex)
  if (a) {
    int32_t i;
    for(i = 0; i < n; ++i) {
      if ((RarrayElem1(a,i).real != powTwo(i)) ||
          (RarrayElem1(a,i).imaginary != powTwo(-i)) ||
	  (a[i].real != powTwo(i)) ||
	  (a[i].imaginary != powTwo(-i))) {
        return FALSE;
      }
    }
    return TRUE;
  }
  return FALSE;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkRarray1Dcomplex)
#line 2816 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  matrixMultiply[]
 */
void
ArrayTest::ArrayOps_impl::matrixMultiply (
  /* in */ int32_t* a,
  /* in */ int32_t* b,
  /* inout */ int32_t* res,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o ) 
throw () 
{
#line 2644 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.matrixMultiply)
  if(a && b && res) {
    locMatrixMultiply(a,b,res,n,m,o);
  }
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.matrixMultiply)
#line 2838 "ArrayTest_ArrayOps_Impl.cc"
}

/**
 * Method:  checkMatrixMultiply[]
 */
bool
ArrayTest::ArrayOps_impl::checkMatrixMultiply (
  /* in */ int32_t* a,
  /* in */ int32_t* b,
  /* in */ int32_t* res,
  /* in */ int32_t n,
  /* in */ int32_t m,
  /* in */ int32_t o ) 
throw () 
{
#line 2664 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps.checkMatrixMultiply)
  int32_t *test;
  int32_t i,j;
  if(a && b && res) {
    test = (int32_t *)malloc(n*o*sizeof(int32_t));
    locMatrixMultiply(a,b,test,n,m,o);
    for(i=0;i<n;++i) {
      for(j=0;j<o;++j) {
	if(RarrayElem2(test,i,j,n) != RarrayElem2(res,i,j,n)) {
	  free((void *)test);
	  return FALSE;
	}
      }
    }
    free((void *)test);
    return TRUE;
  }
  return FALSE;
  // DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps.checkMatrixMultiply)
#line 2874 "ArrayTest_ArrayOps_Impl.cc"
}


// user-defined non-static methods: (none)

#line 2688 "../../../../babel/regression/arrays/libCxx/ArrayTest_ArrayOps_Impl.cc"
// DO-NOT-DELETE splicer.begin(ArrayTest.ArrayOps._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(ArrayTest.ArrayOps._misc)
#line 2884 "ArrayTest_ArrayOps_Impl.cc"

