// 
// File:          ExceptionTest_Fib_Impl.cc
// Symbol:        ExceptionTest.Fib-v1.0
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for ExceptionTest.Fib
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "ExceptionTest_Fib_Impl.hh"

// 
// Includes for all method dependencies.
// 
#ifndef included_ExceptionTest_FibException_hh
#include "ExceptionTest_FibException.hh"
#endif
#ifndef included_ExceptionTest_NegativeValueException_hh
#include "ExceptionTest_NegativeValueException.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif
#line 29 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.cc"
// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._includes)
#include "ExceptionTest_NegativeValueException.hh"
#include "ExceptionTest_TooDeepException.hh"
#include "ExceptionTest_TooBigException.hh"
//using namespace ucxx::ExceptionTest;
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._includes)
#line 36 "ExceptionTest_Fib_Impl.cc"

// user defined constructor
void ExceptionTest::Fib_impl::_ctor() {
#line 38 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._ctor)
#line 44 "ExceptionTest_Fib_Impl.cc"
}

// user defined destructor
void ExceptionTest::Fib_impl::_dtor() {
#line 45 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor)
#line 53 "ExceptionTest_Fib_Impl.cc"
}

// static class initializer
void ExceptionTest::Fib_impl::_load() {
#line 52 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._load)
#line 62 "ExceptionTest_Fib_Impl.cc"
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * <p>
 * Generate the requested Fibonacci number or generate exceptions if
 * the input Fibonacci number is invalid or if any of the maximum depth
 * or maximum value parameters are exceeded.  The last argument of the
 * method should be zero.
 * </p>
 * <p>
 * The algorithm should be similar to the <code>Java</code> code below.
 * </p>
 * <pre>
 * public int getFib(int n, int max_depth, int max_value, int depth)
 *     throws NegativeValueException, FibException {
 * 
 *   if (n < 0) {
 *     throw new NegativeValueException("n negative");
 * 
 *   } else if (depth > max_depth) {
 *     throw new TooDeepException("too deep");
 * 
 *   } else if (n == 0) {
 *     return 1;
 * 
 *   } else if (n == 1) {
 *     return 1;
 * 
 *   } else {
 *     int a = getFib(n-1, max_depth, max_value, depth+1);
 *     int b = getFib(n-2, max_depth, max_value, depth+1);
 *     if (a + b > max_value) {
 *       throw new TooBigException("too big");
 *     }
 *     return a + b;
 *   }
 * } 
 * </pre>
 */
int32_t
ExceptionTest::Fib_impl::getFib_impl (
  /* in */int32_t n,
  /* in */int32_t max_depth,
  /* in */int32_t max_value,
  /* in */int32_t depth ) 
throw ( 
  ::ucxx::ExceptionTest::NegativeValueException, 
  ::ucxx::ExceptionTest::FibException
){
#line 107 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.cc"
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib)
  if (n < 0) {
    ucxx::ExceptionTest::NegativeValueException ex = ucxx::ExceptionTest::NegativeValueException::_create();
    ex.setNote("n negative");
    ex.add(__FILE__, __LINE__, "ExceptionTest::Fib_impl::getFib");
    throw ex;

  } else if (depth > max_depth) {
    ucxx::ExceptionTest::TooDeepException ex = ucxx::ExceptionTest::TooDeepException::_create();
    ex.setNote("too deep");
    ex.add(__FILE__, __LINE__, "ExceptionTest::Fib_impl::getFib");
    throw ex;

  } else if (n == 0) {
    return 1;

  } else if (n == 1) {
    return 1;

  } else {
    int32_t a = getFib(n-1, max_depth, max_value, depth+1);
    int32_t b = getFib(n-2, max_depth, max_value, depth+1);
    if (a + b > max_value) {
      ucxx::ExceptionTest::TooBigException ex = ucxx::ExceptionTest::TooBigException::_create();
      ex.setNote("too big");
      ex.add(__FILE__, __LINE__, "ExceptionTest::Fib_impl::getFib");
      throw ex;
    }
    return a + b;
  }
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib)
#line 147 "ExceptionTest_Fib_Impl.cc"
}


#line 141 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.cc"
// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._misc)
#line 155 "ExceptionTest_Fib_Impl.cc"

