##
## File:        make.runPy
## Package:     Generic Makefile.am support for running Python drivers
## Revision:    $Revision: 4434 $
## Modified:    $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
## Description: automake makefile for python driver regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


OUTPUTSIDL=$(srcdir)/../../output/output.sidl

BABELDIR=$(top_builddir)/bin
INCLUDEDIR=$(top_builddir)/runtime/sidl
INCLUDEDIR2=.
PYTHONDIR=$(top_builddir)/runtime/python
PYINCLUDEDIR=$(PYTHONDIR)
SIDLPYTHONLIB=$(top_builddir)/runtime/sidl/.libs
SIDLXPYTHONLIB=$(top_builddir)/runtime/sidlx/.libs
PYTHONLIB = @PYTHONLIB@
CLEANFILES = $(IORSRCS) $(IORHDRS) $(PYMOD_HDRS) \
	$(synch_IORSRCS) $(synch_IORHDRS) $(synch_PYMOD_HDRS) \
	runPy2C runPy2Cxx runPy2UCxx runPy2F77 runPy2F90 runPy2Java \
	babel-stamp stamp-installcheck core babel-temp

if SUPPORT_FORTRAN77
PY2F77_DRIVER=runPy2F77
else
PY2F77_DRIVER=
endif
if SUPPORT_FORTRAN90
PY2F90_DRIVER=runPy2F90
else
PY2F90_DRIVER=
endif
check_SCRIPTS = $(DRIVERSCRIPTS)

if SERVER_PYTHON
SUBDIRS = Py2Py
endif

if SUPPORT_PYTHON
python-support: babel-stamp $(DRIVERSCRIPTS)
babel-stamp: $(TESTPROG) $(SIDLFILE) $(OUTPUTSIDL)
	@if test "X$(srcdir)" != "X."; then				\
	  for file in $(PYTHONISHFILES); do				\
	    d=`dirname $$file`;						\
	    test -f $$d							\
	    || mkdir -p $$d						\
	    || exit 1;							\
	    echo cp -p $(srcdir)/$$file $$file;				\
	    cp -p $(srcdir)/$$file $$file;				\
	    echo chmod +x $$file;					\
	    chmod +x $$file;						\
	  done;								\
	fi
	test -f $(PYTHONIMPL)						 \
	|| mkdir -p $(PYTHONIMPL)					 \
	|| exit 1
	$(SHELL) $(BABELDIR)/babel --client=python \
		--suppress-timestamp $(SIDLFILE)
	$(SHELL) $(BABELDIR)/babel --client=python --make-prefix=synch_ \
		--suppress-timestamp --exclude-external $(OUTPUTSIDL)
	$(PYTHON) setup.py build_ext	\
	  --include-dirs=`cd $(INCLUDEDIR) && pwd`		\
	  --include-dirs=`cd $(INCLUDEDIR2) && pwd`		\
	  --include-dirs=`cd $(PYINCLUDEDIR) && pwd`		\
	  --library-dirs=`cd $(SIDLPYTHONLIB) && pwd`		\
	  --library-dirs=`cd $(SIDLXPYTHONLIB) && pwd`		\
	  --rpath=`cd $(SIDLPYTHONLIB) && pwd`		\
	  $(PYTHON_SETUP_ARGS) 					\
	  --inplace
	$(PYTHON) synch_setup.py build_ext	\
	  --include-dirs=`cd $(INCLUDEDIR) && pwd`		\
	  --include-dirs=`cd $(INCLUDEDIR2) && pwd`		\
	  --include-dirs=`cd $(PYINCLUDEDIR) && pwd`		\
	  --library-dirs=`cd $(SIDLPYTHONLIB) && pwd`		\
	  --library-dirs=`cd $(SIDLXPYTHONLIB) && pwd`		\
	  --rpath=`cd $(SIDLPYTHONLIB) && pwd`		\
	  $(PYTHON_SETUP_ARGS) 					\
	  --inplace
	touch babel-stamp

runPy2C: $(srcdir)/runPy2C.in
	rm -f runPy2C
	sed -e s%PYTHONDIR%$(PYTHONDIR)%g				\
	  -e s%PYTHONLIB%$(SIDLPYTHONLIB):$(SIDLXPYTHONLIB)%g		\
	  -e s%SHARED_LIB_VAR%$(SHARED_LIB_VAR)%g			\
	  -e s%PYTHONEXEC%$(PYTHON)%g $(srcdir)/runPy2C.in > runPy2C
	chmod +x runPy2C

runPy2Cxx: $(srcdir)/runPy2Cxx.in
	rm -f runPy2Cxx
	sed -e s%PYTHONDIR%$(PYTHONDIR)%g				\
	  -e s%PYTHONLIB%$(SIDLPYTHONLIB):$(SIDLXPYTHONLIB)%g		\
	  -e s%SHARED_LIB_VAR%$(SHARED_LIB_VAR)%g			\
	  -e s%PYTHONEXEC%$(PYTHON)%g $(srcdir)/runPy2Cxx.in > runPy2Cxx
	chmod +x runPy2Cxx

runPy2UCxx: $(srcdir)/runPy2UCxx.in
	rm -f runPy2UCxx
	sed -e s%PYTHONDIR%$(PYTHONDIR)%g				\
	  -e s%PYTHONLIB%$(SIDLPYTHONLIB):$(SIDLXPYTHONLIB)%g		\
	  -e s%SHARED_LIB_VAR%$(SHARED_LIB_VAR)%g			\
	  -e s%PYTHONEXEC%$(PYTHON)%g $(srcdir)/runPy2UCxx.in > runPy2UCxx
	chmod +x runPy2UCxx

runPy2Java: $(srcdir)/runPy2Java.in
	rm -f runPy2Java
	sed -e s%PYTHONDIR%$(PYTHONDIR)%g				\
	  -e s%PYTHONLIB%$(SIDLPYTHONLIB):$(SIDLXPYTHONLIB)%g		\
	  -e s%LIBJAVA_DIR%$(LIBJAVA_DIR)%g                             \
	  -e s%LIBJVM_DIR%$(LIBJVM_DIR)%g                               \
	  -e s%SHARED_LIB_VAR%$(SHARED_LIB_VAR)%g			\
	  -e s%PYTHONEXEC%$(PYTHON)%g $(srcdir)/runPy2Java.in > runPy2Java
	chmod +x runPy2Java


if SUPPORT_FORTRAN77
runPy2F77: $(srcdir)/runPy2F77.in
	rm -f runPy2F77
	sed -e s%PYTHONDIR%$(PYTHONDIR)%g				\
	  -e s%PYTHONLIB%$(SIDLPYTHONLIB)::$(SIDLXPYTHONLIB)%g		\
	  -e s%SHARED_LIB_VAR%$(SHARED_LIB_VAR)%g			\
	  -e s%PYTHONEXEC%$(PYTHON)%g $(srcdir)/runPy2F77.in > runPy2F77
	chmod +x runPy2F77
endif

if SUPPORT_FORTRAN90
runPy2F90: $(srcdir)/runPy2F90.in
	rm -f runPy290F
	sed -e s%PYTHONDIR%$(PYTHONDIR)%g				\
	  -e s%PYTHONLIB%$(SIDLPYTHONLIB)::$(SIDLXPYTHONLIB)%g		\
	  -e s%SHARED_LIB_VAR%$(SHARED_LIB_VAR)%g			\
	  -e s%PYTHONEXEC%$(PYTHON)%g $(srcdir)/runPy2F90.in > runPy2F90
	chmod +x runPy2F90
endif

clean-local: clean-generic
	rm -f *setup.py
	rm -rf build synch
	test "X$(srcdir)" = "X." || rm -rf babel.make synch_babel.make $(TESTPROG)
	@if test -d $(sidlSUBDIR); then					\
	  cd $(sidlSUBDIR);						\
	  echo rm -f sedscript Makefile Makefile.pre Setup config.c;	\
	  rm -f sedscript Makefile Makefile.pre Setup config.c;		\
	  echo rm -f Setup.in *.so *.o *~ *.c *.h __init__.*;		\
	  rm -f Setup.in *.so *.o *~ *.c *.h __init__.*;		\
	fi

distclean-local:
	test "X$(srcdir)" = "X." || rm -rf $(sidlSUBDIR) $(PYTHONISHFILES)

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean-local;	\
	  $(MAKE) $(AM_MAKEFLAGS) clean-local;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS) python-support

installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean-local;	\
	  $(MAKE) $(AM_MAKEFLAGS) clean-local;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir)				\
	  INCLUDEDIR=$(includedir)			\
	  INCLUDEDIR2=$(exec_prefix)/include		\
	  PYINCLUDEDIR=$(prefix)/include/python$(PYTHON_VERSION)/babel \
	  PYTHONDIR=$(exec_prefix)/lib/python$(PYTHON_VERSION)/site-packages \
	  SIDLPYTHONLIB=$(libdir) SIDLXPYTHONLIB=$(libdir) python-support
	touch stamp-installcheck
else
clean-local:
check-local:
installcheck-local:
endif

dist-hook:
	@for file in $(PYTHONISHFILES); do				\
	  d=`dirname $(distdir)/$$file`; 				\
	  test -f $$d							\
	  || mkdir -p $$d						\
	  || exit 1;							\
	  echo cp -p $(srcdir)/$$file $(distdir)/$$file;		\
	  cp -p $(srcdir)/$$file $(distdir)/$$file;			\
	done
	touch -c $(distdir)/Makefile.in
