!     
! File:        inherittest.F90
! Copyright:   (c) 2002 The Regents of the University of California
! Revision:    $Revision: 4434 $
! Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description: Regression test to test FORTRAN calls to BABEL
!
#include "synch_RegOut_fAbbrev.h"
#include "Inherit_A_fAbbrev.h"
#include "Inherit_B_fAbbrev.h"
#include "Inherit_C_fAbbrev.h"
#include "Inherit_D_fAbbrev.h"
#include "Inherit_E2_fAbbrev.h"
#include "Inherit_E_fAbbrev.h"
#include "Inherit_F2_fAbbrev.h"
#include "Inherit_F_fAbbrev.h"
#include "Inherit_G2_fAbbrev.h"
#include "Inherit_G_fAbbrev.h"
#include "Inherit_H_fAbbrev.h"
#include "Inherit_I_fAbbrev.h"

subroutine castcheck(partno, sourcename, destname, notnull)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (selected_int_kind(9))  :: partno
  character (len=*)                  :: sourcename, destname
  character (len=1024)               :: buffer
  type(synch_RegOut_t) :: tracker
  logical                         :: notnull
  partno = partno + 1
  call getInstance(tracker)
  call startPart(tracker, partno)
  buffer = 'Casting ' // sourcename //  ' to '// destname
  call writeComment(tracker, buffer)
  if (notnull) then
     call endPart(tracker, partno, PASS)
  else
     call endPart(tracker, partno, FAIL)
  endif
  call deleteRef(tracker)
end subroutine castcheck


subroutine reporttest(partno, methodname, expectedresult, result)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (selected_int_kind(9)) :: partno
  character (len=*)                 :: methodname, expectedresult, result
  character (len=1024)               :: buffer
  type(synch_RegOut_t) :: tracker
  partno = partno + 1
  call getInstance(tracker)
  call startPart(tracker, partno)
  buffer = 'Method Inherit_' // methodname // ' should return '//expectedresult
  call writeComment(tracker, buffer)
  buffer = 'Method Inherit_' // methodname // ' returned '// result
  call writeComment(tracker, buffer)
  if (result .eq. expectedresult) then
     call endPart(tracker, partno, PASS)
  else
     call endPart(tracker, partno, FAIL)
  endif
end subroutine reporttest

program inherittest
  use synch_RegOut
  use Inherit_A
  use Inherit_B
  use Inherit_C
  use Inherit_D
  use Inherit_E
  use Inherit_E2
  use Inherit_F
  use Inherit_F2
  use Inherit_G
  use Inherit_G2
  use Inherit_H
  use Inherit_I
  implicit none
  integer (selected_int_kind(9))  :: partno
  character (len=32)              :: strresult
  type(Inherit_A_t)  :: A_object
  type(Inherit_B_t)  :: B_object
  type(Inherit_C_t)  :: C_object
  type(Inherit_D_t)  :: D_object
  type(Inherit_E_t)  :: E_object
  type(Inherit_E2_t) :: E2_object
  type(Inherit_F_t)  :: F_object
  type(Inherit_F2_t) :: F2_object
  type(Inherit_G_t)  :: G_object
  type(Inherit_G2_t) :: G2_object
  type(Inherit_H_t)  :: H_object
  type(Inherit_I_t)  :: I_object
  type(synch_RegOut_t) :: tracker
  partno = 0
  call getInstance(tracker)
  call setExpectations(tracker, 54)

  call new(C_object)
  call writeComment(tracker, 'Class C:')
  call c(C_object,strresult)
  call reporttest(partno, 'C_c', 'C.c', strresult)
  call deleteRef(C_object)

  call new(D_object)
  call writeComment(tracker, 'Class D: inheritance of interface A')
  call a(D_object,strresult)
  call reporttest(partno, 'D_a', 'D.a', strresult)
  call d(D_object,strresult)
  call reporttest(partno, 'D_d', 'D.d', strresult)

  call writeComment(tracker, 'Class D: via interface A')
  call cast(D_object, A_object)
  call castcheck(partno, 'Class D', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, 'A_a', 'D.a', strresult)
     call set_null(A_object)
  endif
  call deleteRef(D_object)

  call new(E_object)
  call writeComment(tracker, 'Class E: inheritance of class C')
  call c(E_object,strresult)
  call reporttest(partno, 'E_c', 'C.c', strresult)
  call e(E_object,strresult)
  call reporttest(partno, 'E_e', 'E.e', strresult)

  call writeComment(tracker, 'Class E: via class C (C.c not overridden)')
  call cast(E_object, C_object)
  call castcheck(partno, 'Class E', 'Class C', not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, 'C_c', 'C.c', strresult)
     call set_null(C_object)
  endif
  call deleteRef(E_object)

  call new(E2_object)
  call writeComment(tracker, 'Class E2: inheritance of class C')
  call c(E2_object,strresult)
  call reporttest(partno, 'E2_c', 'E2.c', strresult)
  call e(E2_object,strresult)
  call reporttest(partno, 'E2_e', 'E2.e', strresult)

  call writeComment(tracker, 'Class E2: via class C (C.c overridden)')
  call cast(E2_object, C_object)
  call castcheck(partno, 'Class E2', 'Class C', not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, 'C_c', 'E2.c', strresult)
     call set_null(C_object)
  endif
  call deleteRef(E2_object)

  call new(F_object)
  call writeComment(tracker, 'Class F: Multiple inheritance (no overriding)')
  call a(F_object,strresult)
  call reporttest(partno, 'F_a', 'F.a', strresult)
  call b(F_object,strresult)
  call reporttest(partno, 'F_b', 'F.b', strresult)
  call c(F_object,strresult)
  call reporttest(partno, 'F_c', 'C.c', strresult)
  call f(F_object,strresult)
  call reporttest(partno, 'F_f', 'F.f', strresult)
  call writeComment(tracker, 'Class F: via interface A')
  call cast(F_object, A_object)
  call castcheck(partno, 'Class F', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, 'A_a', 'F.a', strresult)
     call set_null(A_object)
  endif


  call writeComment(tracker, 'Class F: via interface B')
  call cast(F_object, B_object)
  call castcheck(partno, 'Class F', 'Interface B', &
       not_null(B_object))
  if (not_null(B_object)) then
     call b(B_object,strresult)
     call reporttest(partno, 'B_b', 'F.b', strresult)
     call set_null(B_object)
  endif

  call writeComment(tracker, 'Class F: via class C (no overloading of C.c)')
  call cast(F_object, C_object)
  call castcheck(partno, 'Class F', 'Class C', not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, 'C_c', 'C.c', strresult)
     call set_null(C_object)
  endif

  call deleteRef(F_object)

  call new(F2_object)
  call writeComment(tracker, 'Class F2: Multiple inheritance (overrides C.c)')
  call a(F2_object,strresult)
  call reporttest(partno, 'F2_a', 'F2.a', strresult)
  call b(F2_object,strresult)
  call reporttest(partno, 'F2_b', 'F2.b', strresult)
  call c(F2_object,strresult)
  call reporttest(partno, 'F2_c', 'F2.c', strresult)
  call f(F2_object,strresult)
  call reporttest(partno, 'F2_f', 'F2.f', strresult)

  call writeComment(tracker, 'Class F2: via interface A')
  call cast(F2_object, A_object)
  call castcheck(partno, 'Class F2', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, 'A_a', 'F2.a', strresult)
     call set_null(A_object)
  endif

  call writeComment(tracker, 'Class F2: via interface B')
  call cast(F2_object, B_object)
  call castcheck(partno, 'Class F2', 'Interface B', &
       not_null(B_object))
  if (not_null(B_object)) then
     call b(B_object,strresult)
     call reporttest(partno, 'B_b', 'F2.b', strresult)
     call set_null(B_object)
  endif

  call writeComment(tracker, 'Class F2: via class C (overloads C.c)')
  call cast(F2_object, C_object)
  call castcheck(partno, 'Class F2', 'Class C', &
       not_null(C_object))
  if (not_null(C_object)) then
     call c(C_object,strresult)
     call reporttest(partno, 'C_c', 'F2.c', strresult)
     call set_null(C_object)
  endif

  call deleteRef(F2_object)

  call writeComment(tracker, 'Class G: indirect multiple inheritance (no overloads)')
  call new(G_object)
  call a(G_object,strresult)
  call reporttest(partno, 'G_a', 'D.a', strresult)
  call d(G_object,strresult)
  call reporttest(partno, 'G_d', 'D.d', strresult)
  call g(G_object,strresult)
  call reporttest(partno, 'G_g', 'G.g', strresult)

  call writeComment(tracker, 'Class G: via interface A')
  call cast(G_object, A_object)
  call castcheck(partno, 'Class G', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, 'A_a', 'D.a', strresult)
     call set_null(A_object)
  endif
  call writeComment(tracker, 'Class G: via class D')
  call cast(G_object, D_object)
  call castcheck(partno, 'Class G', 'Class D', &
       not_null(D_object))
  if (not_null(D_object)) then
     call a(D_object,strresult)
     call reporttest(partno, 'D_a', 'D.a', strresult)
     call d(D_object,strresult)
     call reporttest(partno, 'D_d', 'D.d', strresult)
     call set_null(D_object)
  endif

  call deleteRef(G_object)

  call writeComment(tracker, 'Class G2: indirect multiple inheritance (overloads)')
  call new(G2_object)
  call a(G2_object,strresult)
  call reporttest(partno, 'G2_a', 'G2.a', strresult)
  call d(G2_object,strresult)
  call reporttest(partno, 'G2_d', 'G2.d', strresult)
  call g(G2_object,strresult)
  call reporttest(partno, 'G2_g', 'G2.g', strresult)

  call writeComment(tracker, 'Class G2: via interface A')
  call cast(G2_object, A_object)
  call castcheck(partno, 'Class G2', 'Interface A', &
       not_null(A_object))
  if (not_null(A_object)) then
     call a(A_object,strresult)
     call reporttest(partno, 'A_a', 'G2.a', strresult)
     call set_null(A_object)
  endif

  call writeComment(tracker, 'Class G2: via class D')
  call cast(G2_object, D_object)
  call castcheck(partno, 'Class G2', 'Class D', &
       not_null(D_object))
  if (not_null(D_object)) then
     call a(D_object,strresult)
     call reporttest(partno, 'D_a', 'G2.a', strresult)
     call d(D_object,strresult)
     call reporttest(partno, 'D_d', 'G2.d', strresult)
     call set_null(D_object)
  endif
  call deleteRef(G2_object)

  call new(I_object)
  call writeComment(tracker, 'Class I:')
  call a(I_object,strresult)
  call reporttest(partno, 'I_a', 'I.a', strresult)
  call h(I_object,strresult)
  call reporttest(partno, 'I_h', 'I.h', strresult)

  call writeComment(tracker, 'Class I: via class H')
  call cast(I_object, H_object)
  call castcheck(partno, 'Class I', 'Class H', &
       not_null(H_object))
  
  if (not_null(H_object)) then
     call a(H_object,strresult)
     call reporttest(partno, 'H_a', 'I.a', strresult)
     call h(H_object,strresult)
     call reporttest(partno, 'H_h', 'I.h', strresult)
     call set_null(H_object)
  endif

  call deleteRef(I_object)

  call close(tracker)
  call deleteRef(tracker)
end program inherittest
