// 
// File:          sort_HeapSort_Impl.cc
// Symbol:        sort.HeapSort-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.HeapSort
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_HeapSort_Impl.hh"

#line 14 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.HeapSort._includes)
// Put additional includes or other arbitrary code here...
static void remakeHeap(sort::Container &elem,
                       sort::Comparator &comp,
                       sort::Counter &cmp,
                       sort::Counter &swp,
                       const int32_t last,
                       int32_t first)
{
  const int32_t half = (last >> 1) - 1;
  int32_t child;
  while (first <= half) {
    child = first + first + 1;
    if ((child+1) < last) {
      cmp.inc();
      if (elem.compare(child, child+1, comp) < 0) ++child;
    }
    cmp.inc();
    if (elem.compare(first, child, comp) >= 0) break;
    swp.inc();
    elem.swap(first, child);
    first = child;
  }
}
// DO-NOT-DELETE splicer.end(sort.HeapSort._includes)
#line 40 "sort_HeapSort_Impl.cc"

// user-defined constructor.
void sort::HeapSort_impl::_ctor() {
#line 42 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.HeapSort._ctor)
#line 48 "sort_HeapSort_Impl.cc"
}

// user-defined destructor.
void sort::HeapSort_impl::_dtor() {
#line 49 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.HeapSort._dtor)
#line 57 "sort_HeapSort_Impl.cc"
}

// static class initializer.
void sort::HeapSort_impl::_load() {
#line 56 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.HeapSort._load)
#line 66 "sort_HeapSort_Impl.cc"
}

// user-defined static methods: (none)

// user-defined non-static methods:
/**
 * Sort elements using Heap Sort.
 */
void
sort::HeapSort_impl::sort (
  /* in */ ::sort::Container elems,
  /* in */ ::sort::Comparator comp ) 
throw () 
{
#line 73 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort.sort)
  int32_t i;
  const int32_t num = elems.getLength();
  sort::Counter cmp = self.getCompareCounter();
  sort::Counter swp = self.getSwapCounter();
  /* make the heap */
  for(i = ((num/2) - 1); i >= 0; --i) {
    remakeHeap(elems, comp, cmp, swp, num, i);
  }
  /* put top of heap at back and remake the heap */
  i = num - 1;
  while (i > 0) {
    swp.inc();
    elems.swap(0, i);
    remakeHeap(elems, comp, cmp, swp, i--, 0);
  }
  // DO-NOT-DELETE splicer.end(sort.HeapSort.sort)
#line 99 "sort_HeapSort_Impl.cc"
}

/**
 * Return heap sort.
 */
::std::string
sort::HeapSort_impl::getName ()
throw () 

{
#line 100 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.HeapSort.getName)
  return "Heap sort";
  // DO-NOT-DELETE splicer.end(sort.HeapSort.getName)
#line 114 "sort_HeapSort_Impl.cc"
}


#line 106 "../../../../babel/regression/sort/libCxx/sort_HeapSort_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.HeapSort._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.HeapSort._misc)
#line 122 "sort_HeapSort_Impl.cc"

