/*
 * File:          sort_IntegerContainer_jniStub.c
 * Symbol:        sort.IntegerContainer-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Client-side JNI glue code for sort.IntegerContainer
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sort_IntegerContainer_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sort_IntegerContainer__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sort_IntegerContainer__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct sort_IntegerContainer__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * This sets the container length and pseudo-randomly orders the
 * Integer elements contained.
 */

static void
jni_setLength(
  JNIEnv* env,
  jobject obj,
  jint _arg_len)
{
  /*
   * Declare return and temporary variables.
   */

  struct sort_IntegerContainer__object* _ior = NULL;
  int32_t _tmp_len = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_len = (int32_t) _arg_len;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setLength))(
    _ior,
    _tmp_len);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return the number of elements in the container.
 */

static jint
jni_getLength(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sort_IntegerContainer__object* _ior = NULL;
  int32_t _ior_res = 0;
  jint _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getLength))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;

  return _res;
}

/*
 * Return -1 if element i is less than element j, 0 if element i
 * is equal to element j, or otherwise 1.
 */

static jint
jni_compare(
  JNIEnv* env,
  jobject obj,
  jint _arg_i,
  jint _arg_j,
  jobject _arg_comp)
{
  /*
   * Declare return and temporary variables.
   */

  struct sort_IntegerContainer__object* _ior = NULL;
  int32_t _tmp_i = 0;
  int32_t _tmp_j = 0;
  struct sort_Comparator__object* _tmp_comp = (struct sort_Comparator__object*) 
    NULL;
  int32_t _ior_res = 0;
  jint _res = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_i = (int32_t) _arg_i;
  _tmp_j = (int32_t) _arg_j;
  _tmp_comp = (struct sort_Comparator__object*) sidl_Java_J2I_ifc(env,
    _arg_comp, "sort.Comparator");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_compare))(
    _ior,
    _tmp_i,
    _tmp_j,
    _tmp_comp);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jint) _ior_res;

  return _res;
}

/*
 * Swap elements i and j.
 */

static void
jni_swap(
  JNIEnv* env,
  jobject obj,
  jint _arg_i,
  jint _arg_j)
{
  /*
   * Declare return and temporary variables.
   */

  struct sort_IntegerContainer__object* _ior = NULL;
  int32_t _tmp_i = 0;
  int32_t _tmp_j = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_i = (int32_t) _arg_i;
  _tmp_j = (int32_t) _arg_j;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_swap))(
    _ior,
    _tmp_i,
    _tmp_j);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Print elements s through e-1
 */

static void
jni_output(
  JNIEnv* env,
  jobject obj,
  jint _arg_s,
  jint _arg_e)
{
  /*
   * Declare return and temporary variables.
   */

  struct sort_IntegerContainer__object* _ior = NULL;
  int32_t _tmp_s = 0;
  int32_t _tmp_e = 0;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_s = (int32_t) _arg_s;
  _tmp_e = (int32_t) _arg_e;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_output))(
    _ior,
    _tmp_s,
    _tmp_e);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Register JNI methods with the Java JVM.
 */

void sort_IntegerContainer__register(JNIEnv* env)
{
  JNINativeMethod methods[6];
  jclass cls;

#ifdef SIDL_STATIC_LIBRARY
  s_external = sort_IntegerContainer__externals();
#else
  sidl_DLL dll = sidl_DLL__create();
  const struct sort_IntegerContainer__external*(*dll_f)(void);
  /* check global namespace for symbol first */
  if (dll && sidl_DLL_loadLibrary(dll, "main:", TRUE, FALSE)) {
    dll_f =
      (const struct sort_IntegerContainer__external*(*)(void)) 
        sidl_DLL_lookupSymbol(
        dll, "sort_IntegerContainer__externals");
    s_external = (dll_f ? (*dll_f)() : NULL);
  }
  if (dll) sidl_DLL_deleteRef(dll);
  if (!s_external) {
    dll = sidl_Loader_findLibrary("sort.IntegerContainer",
      "ior/impl", sidl_Scope_SCLSCOPE,
      sidl_Resolve_SCLRESOLVE);
    if (dll) {
      dll_f =
        (const struct sort_IntegerContainer__external*(*)(void)) 
          sidl_DLL_lookupSymbol(
          dll, "sort_IntegerContainer__externals");
      s_external = (dll_f ? (*dll_f)() : NULL);
      sidl_DLL_deleteRef(dll);
    }
  }
  if (!s_external) {
    jclass e = (*env)->FindClass(env, "java/lang/UnsatisfiedLinkError");
    if (e != NULL) {
      (*env)->ThrowNew(env, e, "Could not find implementation for sidl class sort.IntegerContainer");
      (*env)->DeleteLocalRef(env, e);
    }
  }
#endif

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "setLength";
  methods[1].signature = "(I)V";
  methods[1].fnPtr     = (void *)jni_setLength;
  methods[2].name      = "getLength";
  methods[2].signature = "()I";
  methods[2].fnPtr     = (void *)jni_getLength;
  methods[3].name      = "compare";
  methods[3].signature = "(IILsort/Comparator;)I";
  methods[3].fnPtr     = (void *)jni_compare;
  methods[4].name      = "swap";
  methods[4].signature = "(II)V";
  methods[4].fnPtr     = (void *)jni_swap;
  methods[5].name      = "output";
  methods[5].signature = "(II)V";
  methods[5].fnPtr     = (void *)jni_output;


  cls = (*env)->FindClass(env, "sort/IntegerContainer");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 6);
    (*env)->DeleteLocalRef(env, cls);
  }
}
