/*
 * File:          sidlx_io_TxtOStream_Impl.c
 * Symbol:        sidlx.io.TxtOStream-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sidlx.io.TxtOStream
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidlx.io.TxtOStream" (version 0.1)
 * 
 * Simple text-based output stream appends spaces
 */

#include "sidlx_io_TxtOStream_Impl.h"

#line 26 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream._includes) */
#include "sidlx_common.h"
/* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream._includes) */
#line 30 "sidlx_io_TxtOStream_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream__load"

void
impl_sidlx_io_TxtOStream__load(
  void)
{
#line 41 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream._load) */
#line 47 "sidlx_io_TxtOStream_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream__ctor"

void
impl_sidlx_io_TxtOStream__ctor(
  /* in */ sidlx_io_TxtOStream self)
{
#line 56 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream._ctor) */
  struct sidlx_io_TxtOStream__data *data = (struct sidlx_io_TxtOStream__data *)
    malloc( sizeof (  struct sidlx_io_TxtOStream__data) );
  data->filedes = -1;
  sidlx_io_TxtOStream__set_data(self,data);
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream._ctor) */
#line 67 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream__dtor"

void
impl_sidlx_io_TxtOStream__dtor(
  /* in */ sidlx_io_TxtOStream self)
{
#line 75 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream._dtor) */
  struct sidlx_io_TxtOStream__data *data = sidlx_io_TxtOStream__get_data(self);
  if (data) { 
    free((void*)data);
  }
  sidlx_io_TxtOStream__set_data(self,NULL);
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream._dtor) */
#line 89 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  setFD[]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_setFD"

void
impl_sidlx_io_TxtOStream_setFD(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ int32_t fd)
{
#line 96 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.setFD) */
  /* Insert the implementation of the destructor method here... */
  sidlx_io_TxtOStream__get_data(self)->filedes=fd;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.setFD) */
#line 109 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * flushes the buffer, if any 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_flush"

void
impl_sidlx_io_TxtOStream_flush(
  /* in */ sidlx_io_TxtOStream self)
{
#line 113 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.flush) */

  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.flush) */
#line 127 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * low level write for an array of bytes 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_write"

int32_t
impl_sidlx_io_TxtOStream_write(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ struct sidl_char__array* data,
  /* out */ sidl_BaseInterface *_ex)
{
#line 131 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.write) */
  int n;
  int fd = sidlx_io_TxtOStream__get_data(self)->filedes;
  
  n = s_writen( fd, -1, data, _ex ); SIDL_CHECK(_ex);
 EXIT:
  return n;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.write) */
#line 152 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Bool]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putBool"

void
impl_sidlx_io_TxtOStream_putBool(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ sidl_bool item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 154 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putBool) */
  const char true = 'T';
  const char false = 'F';
  const char * p = (item==TRUE) ? &true : &false;
  const int fd = sidlx_io_TxtOStream__get_data(self)->filedes;
  int32_t k = s_writen2(fd, 1, p, _ex); SIDL_CHECK(*_ex);
 EXIT:
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putBool) */
#line 178 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Char]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putChar"

void
impl_sidlx_io_TxtOStream_putChar(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ char item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 178 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putChar) */
  const int fd = sidlx_io_TxtOStream__get_data(self)->filedes;
  int32_t k = s_writen2(fd, 1, &item, _ex); SIDL_CHECK(*_ex);
 EXIT:
  return;
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putChar) */
#line 201 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Int]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putInt"

void
impl_sidlx_io_TxtOStream_putInt(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ int32_t item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 199 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putInt) */
  const int fd = sidlx_io_TxtOStream__get_data(self)->filedes;
  char buffer[5]; 
  int32_t k ;
  *((int32_t*)buffer) = item;
  /* should massage buffer to be portable */
  k=s_writen2(fd, 4, buffer, _ex); SIDL_CHECK(*_ex);
 EXIT:
  return;

  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putInt) */
#line 229 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Long]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putLong"

void
impl_sidlx_io_TxtOStream_putLong(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ int64_t item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 225 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putLong) */
  /* Insert the implementation of the putLong method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putLong) */
#line 249 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Float]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putFloat"

void
impl_sidlx_io_TxtOStream_putFloat(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ float item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 243 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putFloat) */
  /* Insert the implementation of the putFloat method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putFloat) */
#line 269 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Double]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putDouble"

void
impl_sidlx_io_TxtOStream_putDouble(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ double item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 261 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putDouble) */
  /* Insert the implementation of the putDouble method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putDouble) */
#line 289 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Fcomplex]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putFcomplex"

void
impl_sidlx_io_TxtOStream_putFcomplex(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ struct sidl_fcomplex item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 279 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putFcomplex) */
  /* Insert the implementation of the putFcomplex method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putFcomplex) */
#line 309 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[Dcomplex]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putDcomplex"

void
impl_sidlx_io_TxtOStream_putDcomplex(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ struct sidl_dcomplex item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 297 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putDcomplex) */
  /* Insert the implementation of the putDcomplex method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putDcomplex) */
#line 329 "sidlx_io_TxtOStream_Impl.c"
}

/*
 * Method:  put[String]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_io_TxtOStream_putString"

void
impl_sidlx_io_TxtOStream_putString(
  /* in */ sidlx_io_TxtOStream self,
  /* in */ const char* item,
  /* out */ sidl_BaseInterface *_ex)
{
#line 315 "../../../babel/runtime/sidlx/sidlx_io_TxtOStream_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.io.TxtOStream.putString) */
  /* Insert the implementation of the putString method here... */
  /* DO-NOT-DELETE splicer.end(sidlx.io.TxtOStream.putString) */
#line 349 "sidlx_io_TxtOStream_Impl.c"
}
