/*
 * File:          sidlx_rmi_ClientSocket_Impl.c
 * Symbol:        sidlx.rmi.ClientSocket-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sidlx.rmi.ClientSocket
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidlx.rmi.ClientSocket" (version 0.1)
 * 
 * Automatically sets up a port for listening for new connections
 */

#include "sidlx_rmi_ClientSocket_Impl.h"

#line 26 "../../../babel/runtime/sidlx/sidlx_rmi_ClientSocket_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidlx.rmi.ClientSocket._includes) */
#include "sidlx_rmi_Socket.h"
#include "sidlx_rmi_Common.h"
/* DO-NOT-DELETE splicer.end(sidlx.rmi.ClientSocket._includes) */
#line 31 "sidlx_rmi_ClientSocket_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_ClientSocket__load"

void
impl_sidlx_rmi_ClientSocket__load(
  void)
{
#line 42 "../../../babel/runtime/sidlx/sidlx_rmi_ClientSocket_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.ClientSocket._load) */
  /* insert implementation here: sidlx.rmi.ClientSocket._load (static class initializer method) */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.ClientSocket._load) */
#line 48 "sidlx_rmi_ClientSocket_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_ClientSocket__ctor"

void
impl_sidlx_rmi_ClientSocket__ctor(
  /* in */ sidlx_rmi_ClientSocket self)
{
#line 57 "../../../babel/runtime/sidlx/sidlx_rmi_ClientSocket_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.ClientSocket._ctor) */
  /* insert implementation here: sidlx.rmi.ClientSocket._ctor (constructor method) */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.ClientSocket._ctor) */
#line 65 "sidlx_rmi_ClientSocket_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_ClientSocket__dtor"

void
impl_sidlx_rmi_ClientSocket__dtor(
  /* in */ sidlx_rmi_ClientSocket self)
{
#line 73 "../../../babel/runtime/sidlx/sidlx_rmi_ClientSocket_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.ClientSocket._dtor) */
  /* insert implementation here: sidlx.rmi.ClientSocket._dtor (destructor method) */
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.ClientSocket._dtor) */
#line 83 "sidlx_rmi_ClientSocket_Impl.c"
}

/*
 * Method:  init[]
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_ClientSocket_init"

int32_t
impl_sidlx_rmi_ClientSocket_init(
  /* in */ sidlx_rmi_ClientSocket self,
  /* in */ const char* hostname,
  /* in */ int32_t port,
  /* out */ sidl_BaseInterface *_ex)
{
#line 92 "../../../babel/runtime/sidlx/sidlx_rmi_ClientSocket_Impl.c"
  /* DO-NOT-DELETE splicer.begin(sidlx.rmi.ClientSocket.init) */
  int sockfd;
  int n;
  int port_number,address;
  int32_t data;
  struct sockaddr_in servaddr;
  struct sidl_char__array * sendline = NULL;
  struct sidl_char__array * recvline = NULL;
  sidlx_rmi_Socket osock = NULL;/* sidlx_rmi_IPv4Socket__create(); */

  address = sidlx_rmi_Common_gethostbyname(hostname, _ex); SIDL_CHECK(*_ex);

  struct sidlx_rmi_ClientSocket__data *dptr;
  dptr = malloc(sizeof(struct sidlx_rmi_ClientSocket__data));
  dptr->d_serv_addr.sin_family = AF_INET;
  dptr->d_serv_addr.sin_addr.s_addr = htonl(address);
  dptr->d_serv_addr.sin_port = htons( port );
  dptr->addrlen = sizeof(struct sockaddr_in);

  if ( (sockfd = socket(AF_INET, SOCK_STREAM,0)) < 0 ) { 
    SIDL_THROW( *_ex, sidlx_rmi_GenNetworkException, "socket() error");
  }

  if ( connect( sockfd, (struct sockaddr *) &(dptr->d_serv_addr), dptr->addrlen) < 0) {
    SIDL_THROW( *_ex, sidlx_rmi_GenNetworkException, "connect() error");
  }

  sidlx_rmi_ClientSocket_setFileDescriptor(self, sockfd, _ex); SIDL_CHECK(*_ex);
  return 0;
 EXIT:
  return -1;
  /* DO-NOT-DELETE splicer.end(sidlx.rmi.ClientSocket.init) */
#line 133 "sidlx_rmi_ClientSocket_Impl.c"
}
