/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.c.StubHeader;
import gov.llnl.babel.backend.c.StubSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateClientC
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            this.generateStubHeader(symbol);
            this.generateStubSource(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStubHeader(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        PrintWriter pw = null;
        try {
            String f = C.getHeaderFile(symbol.getSymbolID());
            pw = FileManager.getInstance().createFile(id, type, "STUBHDRS", f);
            LanguageWriterForC writer = new LanguageWriterForC(pw);
            StubHeader.generateCode(symbol, writer);
            Object var8_7 = null;
            if (pw != null) {
                pw.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (pw != null) {
                pw.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStubSource(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type == 12 || type == 13 || type == 11) {
            PrintWriter pw = null;
            try {
                String f = C.getStubFile(symbol.getSymbolID());
                pw = FileManager.getInstance().createFile(id, type, "STUBSRCS", f);
                LanguageWriterForC writer = new LanguageWriterForC(pw);
                StubSource.generateCode(symbol, writer);
                Object var8_7 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (pw != null) {
                    pw.close();
                }
                throw throwable;
            }
        }
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("c");
        return result;
    }
}

