/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class StubSource {
    private LanguageWriterForC d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateCode(symbol);
    }

    public StubSource(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        block7: {
            block6: {
                if (symbol == null) break block6;
                switch (symbol.getSymbolType()) {
                    case 12: {
                        this.generateExtendable((Extendable)symbol);
                        break block7;
                    }
                    case 11: {
                        this.generateEnum(symbol);
                        break block7;
                    }
                    case 13: {
                        this.generateExtendable((Extendable)symbol);
                        break block7;
                    }
                    case 14: {
                        break block7;
                    }
                    default: {
                        throw new CodeGenerationException("Unsupported symbol type.");
                    }
                }
            }
            throw new CodeGenerationException("Unexpected null Symbol.");
        }
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String source = C.getStubFile(id);
        String header = C.getHeaderFile(id);
        String iorHeader = IOR.getHeaderFile(id);
        this.d_writer.writeBanner(ext, source, false, "Client-side glue code for " + id.getFullName());
        this.d_writer.generateInclude(header, false);
        this.d_writer.generateInclude(iorHeader, false);
        this.d_writer.generateInclude("SIDL_interface_IOR.h", true);
        this.d_writer.printlnUnformatted("#include <stddef.h>");
        if (!iorHeader.equals("SIDL_BaseInterface_IOR.h")) {
            this.d_writer.generateInclude("SIDL_BaseInterface_IOR.h", false);
        }
        if (!BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.printlnUnformatted("#include \"babel_config.h\"");
            this.d_writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            this.d_writer.printlnUnformatted("#include <stdio.h>");
            this.d_writer.printlnUnformatted("#include <stdlib.h>");
            this.d_writer.printlnUnformatted("#include \"SIDL_Loader.h\"");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.println();
        if (!ext.isInterface()) {
            this.generateGetIOR(id);
        }
        if (ext.hasStaticMethod(true)) {
            this.generateGetStaticEPV(id);
        }
        this.generateMethodStubs(ext);
        ArrayMethods ar = new ArrayMethods(id, false);
        ar.generateStub(this.d_writer);
    }

    private void generateEnum(Symbol enm) throws CodeGenerationException {
        SymbolID id = enm.getSymbolID();
        String source = C.getStubFile(id);
        String header = C.getHeaderFile(id);
        this.d_writer.writeBanner(enm, source, false, "Client-side glue code for " + id.getFullName());
        this.d_writer.generateInclude(header, false);
        this.d_writer.generateInclude("SIDL_int_IOR.h", true);
        this.d_writer.printlnUnformatted("#include <stddef.h>");
        this.d_writer.println();
        ArrayMethods ar = new ArrayMethods(id, true);
        ar.generateStub(this.d_writer);
    }

    private void generateMethodStubs(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String self = C.getSymbolName(id) + " self";
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("Constructor function for the class.", false);
            this.d_writer.println(C.getSymbolName(id));
            this.d_writer.println(C.getFullMethodName(id, "_create") + "()");
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("return (*(_getIOR()->createObject))();");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        Collection methods = ext.getMethods(true);
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateMethodSignature(self, ext.isInterface(), id, method);
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            if (C.getReturnString(method.getReturnType()) != "void") {
                this.d_writer.print("return ");
            }
            if (3 == method.getDefinitionModifier()) {
                this.d_writer.print("(_getSEPV()");
            } else {
                this.d_writer.print("(*self->d_epv");
            }
            this.d_writer.print("->");
            this.d_writer.print(IOR.getVectorEntry(method.getLongMethodName()));
            this.d_writer.println(")(");
            this.d_writer.increaseTabLevel();
            this.generateArgumentList(self, ext.isInterface(), id, method, false);
            this.d_writer.println(");");
            this.d_writer.decreaseTabLevel();
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        Method castMethod = IOR.getBuiltinMethod(0, id);
        this.d_writer.writeComment("Cast method for interface and class type conversions.", false);
        this.d_writer.println(C.getSymbolName(id));
        this.d_writer.println(C.getFullMethodName(id, "_cast") + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("void* obj)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println(C.getSymbolName(id) + " cast = NULL;");
        this.d_writer.println();
        this.d_writer.println("if (obj != NULL) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("SIDL_BaseInterface base = (SIDL_BaseInterface) obj;");
        this.d_writer.println("cast = (" + C.getSymbolName(id) + ") (*base->d_epv->" + IOR.getVectorEntry(castMethod.getLongMethodName()) + ")(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("base->d_object,");
        this.d_writer.println("\"" + id.getFullName() + "\");");
        this.d_writer.decreaseTabLevel();
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("String cast method for interface and class type conversions.", false);
        this.d_writer.println("void*");
        this.d_writer.println(C.getFullMethodName(id, "_cast2") + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("void* obj,");
        this.d_writer.println("const char* type)");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("void* cast = NULL;");
        this.d_writer.println();
        this.d_writer.println("if (obj != NULL) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("SIDL_BaseInterface base = (SIDL_BaseInterface) obj;");
        this.d_writer.println("cast = (*base->d_epv->" + IOR.getVectorEntry(castMethod.getLongMethodName()) + ")(base->d_object, type);");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.println("return cast;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateMethodSignature(String self, boolean is_interface, SymbolID id, Method method) throws CodeGenerationException {
        this.d_writer.writeComment(method, false);
        this.d_writer.println(C.getReturnString(method.getReturnType()));
        this.d_writer.print(C.getFullMethodName(id, method));
        this.d_writer.println("(");
        this.d_writer.increaseTabLevel();
        this.generateArgumentList(self, is_interface, id, method, true);
        this.d_writer.println(")");
        this.d_writer.decreaseTabLevel();
    }

    private void generateArgumentList(String self, boolean is_interface, SymbolID id, Method method, boolean in_signature) throws CodeGenerationException {
        boolean has_throws = !method.getThrows().isEmpty();
        ArrayList args = method.getArgumentList();
        if (!method.isStatic()) {
            if (in_signature) {
                this.d_writer.print(self);
            } else if (is_interface) {
                this.d_writer.print("self->d_object");
            } else {
                this.d_writer.print("self");
            }
            if (args.size() > 0 || has_throws) {
                this.d_writer.println(",");
            }
        } else if (args.size() == 0 && !has_throws && in_signature) {
            this.d_writer.print("void");
        }
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            if (in_signature) {
                this.d_writer.print(C.getArgumentWithFormal(arg));
            } else {
                this.d_writer.print(arg.getFormalName());
            }
            if (!a.hasNext() && !has_throws) continue;
            this.d_writer.println(",");
        }
        if (has_throws) {
            if (in_signature) {
                this.d_writer.print("SIDL_BaseException *_ex");
            } else {
                this.d_writer.print("_ex");
            }
        }
    }

    private void generateGetIOR(SymbolID id) {
        String ext_name = IOR.getExternalName(id);
        this.d_writer.writeComment("Hold pointer to IOR functions.", false);
        this.d_writer.println("static const " + ext_name + " *_ior = NULL;");
        this.d_writer.writeComment("Lookup the symbol to get the IOR functions.", false);
        this.d_writer.println("static const " + ext_name + "* _loadIOR(void)");
        this.d_writer.writeComment("Return pointer to internal IOR functions.", false);
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        if (BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.println("_ior = " + IOR.getExternalFunc(id) + "();");
        } else {
            this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
            this.d_writer.println("_ior = " + IOR.getExternalFunc(id) + "();");
            this.d_writer.printlnUnformatted("#else");
            this.d_writer.println("const " + ext_name + "*(*dll_f)(void) =");
            this.d_writer.increaseTabLevel();
            this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
            this.d_writer.println("SIDL_Loader_lookupSymbol(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("\"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.decreaseTabLevel();
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("_ior = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.println("if (!_ior) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.disableLineBreak();
            this.d_writer.println("fputs(\"Babel: unable to load the implementation for " + id.getFullName() + "; please set SIDL_DLL_PATH\\n\", stderr);");
            this.d_writer.enableLineBreak();
            this.d_writer.println("exit(-1);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.println("return _ior;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.printlnUnformatted("#define _getIOR() (_ior ? _ior : _loadIOR())");
        this.d_writer.println();
    }

    private void generateGetStaticEPV(SymbolID id) {
        String sepv_name = IOR.getSEPVName(id);
        this.d_writer.writeComment("Hold pointer to static entry point vector", false);
        this.d_writer.println("static const " + sepv_name + " *_sepv = NULL;");
        this.d_writer.writeComment("Return pointer to static functions.", false);
        this.d_writer.printlnUnformatted("#define _getSEPV() (_sepv ? _sepv : (_sepv = (*(_getIOR()->getStaticEPV))()))");
        this.d_writer.println();
    }
}

