/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.fortran.FortArrayMethods;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.StubDoc;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StubSource {
    public static final String s_self = "self";
    public static final String s_return = "retval";
    public static final String s_exception = "exception";
    public static final String s_charCheck;
    private static final String s_proxy = "_proxy_";
    private static final String s_proxyTwo = "_alt_";
    private static final String s_epv = "_epv";
    private static final String s_exceptionType;
    private LanguageWriter d_writer;

    public StubSource(LanguageWriter writer) {
        this.d_writer = writer;
    }

    public static boolean comma(LanguageWriter writer, boolean needComma) {
        if (needComma) {
            writer.println(",");
        }
        return false;
    }

    public static boolean declareArgument(LanguageWriter writer, String argName, Type argType, boolean needComma) throws CodeGenerationException {
        switch (argType.getDetailedType()) {
            case 0: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                writer.print(Fortran.getFortranTypeInC(argType) + " *" + argName);
                needComma = true;
                break;
            }
            case 10: {
                writer.println(Fortran.getFortranPrefix() + "_String " + argName);
                writer.print(Fortran.getFortranPrefix() + "_STR_NEAR_LEN_DECL(" + argName + ")");
                needComma = true;
                break;
            }
            case 2: {
                writer.printlnUnformatted(s_charCheck);
                writer.println(Fortran.getFortranPrefix() + "_String " + argName);
                writer.println(Fortran.getFortranPrefix() + "_STR_NEAR_LEN_DECL(" + argName + ")");
                writer.printlnUnformatted("#else");
                writer.println("char *" + argName);
                writer.printlnUnformatted("#endif");
                needComma = true;
                break;
            }
            default: {
                throw new CodeGenerationException("Unsupported Fortran argument type: " + argType.getTypeString() + " " + argName);
            }
        }
        return needComma;
    }

    private static void generateMethodSymbol(LanguageWriter writer, String methodName) {
        writer.println("void");
        writer.disableLineBreak();
        writer.println(Fortran.getFortranSymbol() + "(" + methodName.toLowerCase() + ',' + methodName.toUpperCase() + ',' + methodName + ")");
        writer.println("(");
    }

    private static boolean declareNormalArguments(LanguageWriter writer, Iterator i) throws CodeGenerationException {
        boolean needComma = false;
        while (i.hasNext()) {
            needComma = StubSource.comma(writer, needComma);
            Argument a = (Argument)i.next();
            needComma = StubSource.declareArgument(writer, a.getFormalName(), a.getType(), needComma);
        }
        return needComma;
    }

    private static boolean declareExtraArguments(LanguageWriter writer, Iterator i, boolean needComma) {
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            int t = a.getType().getDetailedType();
            if (10 != t && 2 != t) continue;
            if (needComma) {
                writer.println();
                needComma = false;
            }
            if (2 == t) {
                writer.printlnUnformatted(s_charCheck);
            }
            writer.println(Fortran.getFortranPrefix() + "_STR_FAR_LEN_DECL(" + a.getFormalName() + ")");
            if (2 != t) continue;
            writer.printlnUnformatted("#endif");
        }
        return needComma;
    }

    public static void generateSignature(LanguageWriter writer, String methodName, List arguments) throws CodeGenerationException {
        StubSource.generateMethodSymbol(writer, methodName);
        if (arguments.isEmpty()) {
            writer.print("void");
        } else {
            writer.increaseTabLevel();
            boolean needComma = StubSource.declareNormalArguments(writer, arguments.iterator());
            needComma = StubSource.declareExtraArguments(writer, arguments.iterator(), needComma);
            if (needComma) {
                writer.println();
            }
            writer.decreaseTabLevel();
        }
        writer.print(")");
        writer.enableLineBreak();
    }

    public static boolean hasProxy(Type t) {
        switch (t.getDetailedType()) {
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPointer(Type t) {
        switch (t.getDetailedType()) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private void declareProxies(List arguments) throws CodeGenerationException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            String name = a.getFormalName();
            if (!StubSource.hasProxy(t)) continue;
            this.d_writer.print(IOR.getReturnString(t) + " " + s_proxy + name);
            if (StubSource.isPointer(t)) {
                this.d_writer.println(" = NULL;");
                continue;
            }
            this.d_writer.println(";");
        }
    }

    private void copyIncomingValues(List arguments) throws CodeGenerationException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (2 == a.getMode()) continue;
            Type t = a.getType();
            String name = a.getFormalName();
            switch (t.getDetailedType()) {
                case 1: {
                    this.d_writer.println(s_proxy + name + " = ((*" + name + " == " + Fortran.getFortranPrefix() + "_TRUE) ? TRUE : FALSE);");
                    break;
                }
                case 2: {
                    this.d_writer.printlnUnformatted(s_charCheck);
                    this.d_writer.println(s_proxy + name + " = *" + Fortran.getFortranPrefix() + "_STR(" + name + ");");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println(s_proxy + name + " = *" + name + ";");
                    this.d_writer.printlnUnformatted("#endif");
                    break;
                }
                case 10: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("SIDL_copy_fortran_str(" + Fortran.getFortranPrefix() + "_STR(" + name + "),");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LEN(" + name + "));");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.decreaseTabLevel();
                    break;
                }
                case 11: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("(" + IOR.getEnumName(t.getSymbolID()) + ")");
                    this.d_writer.println(name + ";");
                    this.d_writer.decreaseTabLevel();
                    break;
                }
                case 16: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("(" + IOR.getReturnString(t) + ")");
                    if (Fortran.isFortran90()) {
                        this.d_writer.println("(ptrdiff_t)(" + name + "->d_ior);");
                    } else {
                        this.d_writer.println("(ptrdiff_t)(*" + name + ");");
                    }
                    this.d_writer.decreaseTabLevel();
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    this.d_writer.println(s_proxy + name + " =");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("(" + IOR.getReturnString(t) + ")");
                    this.d_writer.println("(ptrdiff_t)(*" + name + ");");
                    this.d_writer.decreaseTabLevel();
                }
            }
        }
    }

    private void copyOutgoingValues(List arguments) throws CodeGenerationException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            String name = a.getFormalName();
            if (0 == a.getMode() || name.equals(s_exception)) continue;
            Type t = a.getType();
            switch (t.getDetailedType()) {
                case 1: {
                    this.d_writer.println("*" + name + " = ((" + s_proxy + name + " == TRUE) ? " + Fortran.getFortranPrefix() + "_TRUE : " + Fortran.getFortranPrefix() + "_FALSE);");
                    break;
                }
                case 16: {
                    if (Fortran.isFortran90()) {
                        if (Fortran.hasDirectAccess(t)) {
                            Type dataType = t.getArrayType();
                            this.d_writer.println("if (SIDL_" + dataType.getTypeString() + "__array_convert2f90(" + s_proxy + name + ", " + t.getArrayDimension() + ", " + name + ")) {");
                            this.d_writer.increaseTabLevel();
                            this.d_writer.writeCommentLine("Copy to contiguous column-order");
                            this.d_writer.println(IOR.getReturnString(t) + " " + s_proxyTwo + name + " =");
                            this.d_writer.increaseTabLevel();
                            this.d_writer.print(Fortran.getEnsureArray(dataType));
                            this.d_writer.println(s_proxy + name + ", " + t.getArrayDimension() + ",");
                            this.d_writer.increaseTabLevel();
                            this.d_writer.println("SIDL_column_major_order);");
                            this.d_writer.decreaseTabLevel();
                            this.d_writer.decreaseTabLevel();
                            this.d_writer.println(Fortran.getDelRefArray(dataType) + s_proxy + name + ");");
                            this.d_writer.println("if (SIDL_" + dataType.getTypeString() + "__array_convert2f90(" + s_proxyTwo + name + ", " + t.getArrayDimension() + ", " + name + ")) {");
                            this.d_writer.increaseTabLevel();
                            this.d_writer.writeCommentLine("We're S.O.L.");
                            this.d_writer.println("fprintf(stderr, \"convert2f90 failed: %p %d\\n\", (void*)_alt_" + name + ", " + t.getArrayDimension() + ");");
                            this.d_writer.println("exit(1); /*NOTREACHED*/");
                            this.d_writer.decreaseTabLevel();
                            this.d_writer.println("}");
                            this.d_writer.decreaseTabLevel();
                            this.d_writer.println("}");
                            break;
                        }
                        this.d_writer.println(name + "->d_ior = (ptrdiff_t)" + s_proxy + name + ";");
                        break;
                    }
                    this.d_writer.println("*" + name + " = (ptrdiff_t)" + s_proxy + name + ";");
                    break;
                }
                case 9: 
                case 12: 
                case 13: {
                    this.d_writer.println("*" + name + " = (ptrdiff_t)" + s_proxy + name + ";");
                    break;
                }
                case 2: {
                    this.d_writer.printlnUnformatted(s_charCheck);
                    this.d_writer.println("*" + Fortran.getFortranPrefix() + "_STR(" + name + ") = " + s_proxy + name + ";");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println("*" + name + " = " + s_proxy + name + ";");
                    this.d_writer.printlnUnformatted("#endif");
                    break;
                }
                case 10: {
                    this.d_writer.println("SIDL_copy_c_str(");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR(" + name + "),");
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LEN(" + name + "),");
                    this.d_writer.println(s_proxy + name + ");");
                    this.d_writer.decreaseTabLevel();
                    break;
                }
                case 11: {
                    this.d_writer.println("*" + name + " = (int)");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println(s_proxy + name + ";");
                    this.d_writer.decreaseTabLevel();
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("Unsupported Type: " + t.getTypeString());
                }
            }
        }
    }

    private void freeResources(List arguments) {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (10 != a.getType().getDetailedType()) continue;
            String name = a.getFormalName();
            this.d_writer.println("free((void *)_proxy_" + name + ");");
        }
    }

    private void declareEntryPointVector(boolean isStatic, SymbolID id) {
        if (isStatic) {
            this.d_writer.println("const " + IOR.getSEPVName(id) + " *" + s_epv + " = _getSEPV();");
        } else {
            this.d_writer.println(IOR.getEPVName(id) + " *" + s_epv + " = NULL;");
        }
    }

    private void generateGetIOR(SymbolID id) {
        String ext_name = IOR.getExternalName(id);
        this.d_writer.writeComment("Return pointer to internal IOR functions.", false);
        this.d_writer.println("static const " + ext_name + "* _getIOR(void)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("static const " + ext_name + " *_ior = NULL;");
        this.d_writer.println("if (!_ior) {");
        this.d_writer.increaseTabLevel();
        if (BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.println("_ior = " + IOR.getExternalFunc(id) + "();");
        } else {
            this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
            this.d_writer.println("_ior = " + IOR.getExternalFunc(id) + "();");
            this.d_writer.printlnUnformatted("#else");
            this.d_writer.println("const " + ext_name + "*(*dll_f)(void) =");
            this.d_writer.increaseTabLevel();
            this.d_writer.print("(const " + ext_name + "*(*)(void)) ");
            this.d_writer.println("SIDL_Loader_lookupSymbol(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("\"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.decreaseTabLevel();
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("_ior = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.println("if (!_ior) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.disableLineBreak();
            this.d_writer.println("fputs(\"Unable to find the implementation for " + id.getFullName() + "; please set SIDL_DLL_PATH\\n\", stderr);");
            this.d_writer.enableLineBreak();
            this.d_writer.println("exit(-1);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println("return _ior;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateGetStaticEPV(SymbolID id) {
        String sepv_name = IOR.getSEPVName(id);
        this.d_writer.writeComment("Return pointer to static functions.", false);
        this.d_writer.println("static const " + sepv_name + "* _getSEPV(void)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("static const " + sepv_name + " *_sepv = NULL;");
        this.d_writer.println("if (!_sepv) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("_sepv = (*(_getIOR()->getStaticEPV))();");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println("return _sepv;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void getEntryPointVector(boolean isStatic, SymbolID id) {
        if (!isStatic) {
            this.d_writer.println("_epv = _proxy_self->d_epv;");
        }
    }

    private boolean passArgument(Argument a, boolean isInterface, boolean needComma) {
        String varName = a.getFormalName();
        if (!s_return.equals(varName)) {
            needComma = StubSource.comma(this.d_writer, needComma);
            if (StubSource.hasProxy(a.getType())) {
                if (0 != a.getMode()) {
                    this.d_writer.print("&");
                }
                this.d_writer.print(s_proxy + varName);
                if (isInterface && s_self.equals(varName)) {
                    this.d_writer.print("->d_object");
                }
            } else {
                if (0 == a.getMode()) {
                    this.d_writer.print("*");
                }
                this.d_writer.print(varName);
            }
            needComma = true;
        }
        return needComma;
    }

    private void makeMethodCall(List arguments, Method m, boolean isInterface) throws CodeGenerationException {
        Type returnType = m.getReturnType();
        Iterator i = arguments.iterator();
        boolean needComma = false;
        if (0 != returnType.getDetailedType()) {
            if (StubSource.hasProxy(returnType)) {
                this.d_writer.print(s_proxy);
            } else {
                this.d_writer.print("*");
            }
            this.d_writer.println("retval = ");
            this.d_writer.increaseTabLevel();
        }
        this.d_writer.println("(*(_epv->" + IOR.getVectorEntry(m.getLongMethodName()) + "))(");
        this.d_writer.increaseTabLevel();
        while (i.hasNext()) {
            needComma = this.passArgument((Argument)i.next(), isInterface, needComma);
        }
        this.d_writer.println();
        this.d_writer.decreaseTabLevel();
        this.d_writer.println(");");
        if (0 != returnType.getDetailedType()) {
            this.d_writer.decreaseTabLevel();
        }
    }

    private void checkExceptionBlock(Method m) {
        if (!m.getThrows().isEmpty()) {
            this.d_writer.println("if (_proxy_exception) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("*exception = (ptrdiff_t)_proxy_exception;");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println("else {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("*exception = (ptrdiff_t)NULL;");
        }
    }

    private void endExceptionBlock(Method m) {
        if (!m.getThrows().isEmpty()) {
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        }
    }

    private void generateMethod(String name, List arguments, Method m, SymbolID id, boolean isInterface) throws CodeGenerationException {
        this.d_writer.writeComment(m, false);
        StubSource.generateSignature(this.d_writer, name, arguments);
        this.d_writer.println();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.declareEntryPointVector(m.isStatic(), id);
        this.declareProxies(arguments);
        this.copyIncomingValues(arguments);
        this.getEntryPointVector(m.isStatic(), id);
        this.makeMethodCall(arguments, m, isInterface);
        this.checkExceptionBlock(m);
        this.copyOutgoingValues(arguments);
        this.endExceptionBlock(m);
        this.freeResources(arguments);
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    public static List extendArgs(SymbolID selfId, Method m) throws CodeGenerationException {
        ArrayList origArgs = m.getArgumentList();
        ArrayList<Argument> result = new ArrayList<Argument>(origArgs.size() + 3);
        if (3 != m.getDefinitionModifier()) {
            result.add(new Argument(false, 0, new Type(selfId), s_self));
        }
        result.addAll(origArgs);
        if (0 != m.getReturnType().getDetailedType()) {
            result.add(new Argument(false, 2, m.getReturnType(), s_return));
        }
        if (!m.getThrows().isEmpty()) {
            Symbol ex = Utilities.lookupSymbol(s_exceptionType);
            result.add(new Argument(false, 2, new Type(ex.getSymbolID()), s_exception));
        }
        return result;
    }

    public static Set extendedReferences(Extendable ext) throws CodeGenerationException {
        HashSet<SymbolID> result = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            result.addAll(method.getSymbolReferences());
            if (method.getThrows().isEmpty()) continue;
            Symbol symbol = Utilities.lookupSymbol(s_exceptionType);
            result.add(symbol.getSymbolID());
        }
        return result;
    }

    public static void generateIncludes(LanguageWriterForC writer, Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        writer.printlnUnformatted("#include <stddef.h>");
        writer.printlnUnformatted("#include <stdlib.h>");
        writer.generateInclude("SIDLfortran.h", false);
        writer.generateInclude("SIDLf90array.h", true);
        writer.generateInclude("SIDL_header.h", false);
        writer.generateInclude("SIDL_interface_IOR.h", true);
        writer.printlnUnformatted("#include <stdio.h>");
        if (!BabelConfiguration.isSIDLBaseClass(id)) {
            writer.printlnUnformatted("#include \"babel_config.h\"");
            writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            writer.generateInclude("SIDL_Loader.h", false);
            writer.printlnUnformatted("#endif");
        }
        writer.generateInclude(IOR.getHeaderFile(id), false);
        if ("f90".equals(BabelConfiguration.getInstance().getTargetLanguage())) {
            writer.generateInclude(Fortran.getStubNameFile(id), false);
        }
        Set includes = StubSource.extendedReferences(ext);
        includes.remove(id);
        Iterator i = includes.iterator();
        while (i.hasNext()) {
            writer.generateInclude(IOR.getHeaderFile((SymbolID)i.next()), false);
        }
    }

    private void extendAndGenerate(Method m, SymbolID id, boolean isInterface) throws CodeGenerationException {
        String name = Fortran.getMethodStubName(id, m);
        List extendedArgs = StubSource.extendArgs(id, m);
        this.generateMethod(name, extendedArgs, m, id, isInterface);
    }

    private void generateCreateMethod(SymbolID id) throws CodeGenerationException {
        String methodName = "f90".equals(BabelConfiguration.getInstance().getTargetLanguage()) ? id.getFullName().replace('.', '_') + "_new" + Fortran.getMethodSuffix() : id.getFullName().replace('.', '_') + "__create" + Fortran.getMethodSuffix();
        this.d_writer.writeComment("Constructor for the class.", false);
        this.d_writer.println("void");
        this.d_writer.disableLineBreak();
        this.d_writer.println(Fortran.getFortranSymbol() + "(" + methodName.toLowerCase() + ',' + methodName.toUpperCase() + ',' + methodName + ")");
        this.d_writer.enableLineBreak();
        this.d_writer.println("(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("int64_t *self");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println(")");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("*self = (ptrdiff_t) (*(_getIOR()->createObject))();");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCast(SymbolID id) throws CodeGenerationException {
        Method m = StubDoc.createCast(id);
        List extendedArgs = StubSource.extendArgs(id, m);
        String name = Fortran.getMethodStubName(id, m);
        this.d_writer.writeComment(m, false);
        StubSource.generateSignature(this.d_writer, name, extendedArgs);
        this.d_writer.println();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("struct SIDL_BaseInterface__object  *_base =");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("(struct SIDL_BaseInterface__object *)(ptrdiff_t)*ref;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("if (_base) {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("*retval = (ptrdiff_t)(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("*_base->d_epv->" + IOR.getVectorEntry(IOR.getBuiltinName(0)) + ")(");
        this.d_writer.println("_base->d_object,");
        this.d_writer.println("\"" + id.getFullName() + "\");");
        this.d_writer.decreaseTabLevel();
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println("else {");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("*retval = 0;");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCastTwo(SymbolID id, boolean isInterface) throws CodeGenerationException {
        Method m = IOR.getBuiltinMethod(0, id);
        this.generateMethod(Fortran.getMethodStubName(id, StubDoc.createCastTwo(id)), StubSource.extendArgs(id, m), m, id, isInterface);
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        Iterator i = ext.getMethods(true).iterator();
        SymbolID id = ext.getSymbolID();
        boolean isInterface = ext.isInterface();
        this.d_writer.writeBanner(ext, Fortran.getStubFile(id), false, "Client-side glue code for " + id.getFullName());
        this.d_writer.writeComment(ext, false);
        StubSource.generateIncludes((LanguageWriterForC)this.d_writer, ext);
        this.d_writer.println();
        if (!ext.isInterface()) {
            this.generateGetIOR(id);
        }
        if (ext.hasStaticMethod(true)) {
            this.generateGetStaticEPV(id);
        }
        if (!ext.isAbstract()) {
            this.generateCreateMethod(id);
        }
        this.generateCast(id);
        this.generateCastTwo(id, isInterface);
        while (i.hasNext()) {
            this.d_writer.println();
            this.extendAndGenerate((Method)i.next(), id, isInterface);
        }
        this.d_writer.println();
        FortArrayMethods fam = new FortArrayMethods(id, false);
        fam.generateStub(this.d_writer);
    }

    public void generateEnum(Enumeration enm) throws CodeGenerationException {
        SymbolID id = enm.getSymbolID();
        if (this.d_writer instanceof LanguageWriterForFortran) {
            this.d_writer.writeBanner(enm, Fortran.getEnumStubFile(id), false, "Client-side glue code for " + id.getFullName());
            this.d_writer.println();
            this.d_writer.writeComment(enm, false);
            this.d_writer.println();
            Iterator i = enm.getEnumerators().iterator();
            while (i.hasNext()) {
                String sym = (String)i.next();
                Comment cmt = enm.getEnumeratorComment(sym);
                this.d_writer.writeComment(cmt, true);
                this.d_writer.print(Fortran.getReturnString(new Type(id)));
                if ("f90".equals(BabelConfiguration.getInstance().getTargetLanguage())) {
                    this.d_writer.print(" :: ");
                } else {
                    this.d_writer.print(" ");
                }
                this.d_writer.println(sym);
                this.d_writer.println("parameter (" + sym + " = " + enm.getEnumeratorValue(sym) + ")");
                if (cmt == null) continue;
                this.d_writer.println();
            }
        } else {
            this.d_writer.writeBanner(enm, Fortran.getEnumStubImpl(id), false, "Client-side glue code for " + id.getFullName());
            ((LanguageWriterForC)this.d_writer).generateInclude("SIDL_int_IOR.h", true);
            ((LanguageWriterForC)this.d_writer).generateInclude("SIDLfortran.h", true);
            this.d_writer.printlnUnformatted("#include <stddef.h>");
            FortArrayMethods fam = new FortArrayMethods(id, true);
            fam.generateStub(this.d_writer);
        }
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        switch (symbol.getSymbolType()) {
            case 12: 
            case 13: {
                if (this.d_writer instanceof LanguageWriterForC) {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
                throw new CodeGenerationException("Extendable stub requires C language writer.");
            }
            case 11: {
                this.generateEnum((Enumeration)symbol);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new CodeGenerationException("Unsupported symbol type.");
            }
        }
    }

    public static void generateCode(Symbol ext, LanguageWriter writer) throws CodeGenerationException {
        StubSource source = new StubSource(writer);
        source.generateCode(ext);
    }

    static {
        s_self = s_self;
        s_return = s_return;
        s_exception = s_exception;
        s_charCheck = "#ifdef " + Fortran.getFortranPrefix() + "_CHAR_AS_STRING";
        s_proxy = s_proxy;
        s_proxyTwo = s_proxyTwo;
        s_epv = s_epv;
        s_exceptionType = BabelConfiguration.getBaseException();
    }
}

