/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;

public class TypeModule {
    private static final int s_maxArray = BabelConfiguration.getMaximumArray();
    private LanguageWriterForFortran d_lw;
    private Symbol d_sym;

    public TypeModule(LanguageWriterForFortran writer, Symbol sym) {
        this.d_lw = writer;
        this.d_sym = sym;
    }

    private void describeFile() {
        this.d_lw.beginBlockComment(false);
        this.d_lw.println("This file contains a FORTRAN 90 derived type for the");
        this.d_lw.println("SIDL type " + this.d_sym.getFullName() + ".");
        this.d_lw.endBlockComment(false);
    }

    static void writeArrayType(LanguageWriter lw, SymbolID id, String implDataType) {
        int i = 1;
        while (i <= s_maxArray) {
            lw.println("type " + Fortran.getArrayName(id, i));
            lw.increaseTabLevel();
            lw.println("sequence");
            lw.println("integer (selected_int_kind(18)) :: d_array");
            if (implDataType != null) {
                lw.println(implDataType + ", pointer, &");
                lw.increaseTabLevel();
                lw.print("dimension(:");
                int j = 1;
                while (j < i) {
                    lw.print(",:");
                    ++j;
                }
                lw.println(") :: d_data");
                lw.decreaseTabLevel();
            }
            lw.decreaseTabLevel();
            lw.println("end type " + Fortran.getArrayName(id, i));
            lw.println();
            ++i;
        }
    }

    private void writeModule() {
        SymbolID id = this.d_sym.getSymbolID();
        this.d_lw.println("module " + Fortran.getTypeModule(id));
        this.d_lw.increaseTabLevel();
        if (this.d_sym instanceof Extendable) {
            this.d_lw.println("type " + Fortran.getTypeName(id));
            this.d_lw.increaseTabLevel();
            this.d_lw.println("sequence");
            this.d_lw.println("integer (selected_int_kind(18)) :: d_ior");
            this.d_lw.decreaseTabLevel();
            this.d_lw.println("end type " + Fortran.getTypeName(id));
            this.d_lw.println();
        }
        TypeModule.writeArrayType(this.d_lw, id, null);
        this.d_lw.decreaseTabLevel();
        this.d_lw.println("end module " + Fortran.getTypeModule(id));
    }

    public void generateCode() {
        SymbolID id = this.d_sym.getSymbolID();
        this.d_lw.writeBanner(this.d_sym, Fortran.getTypeFile(id), false, "Client-side module for " + id.getFullName());
        this.d_lw.disableLineBreak();
        this.d_lw.printlnUnformatted("#include \"" + Fortran.getStubNameFile(id) + "\"");
        this.d_lw.enableLineBreak();
        this.d_lw.println();
        this.describeFile();
        this.writeModule();
    }

    public static void generateCode(Symbol sym, LanguageWriterForFortran writer) throws CodeGenerationException {
        TypeModule tm = new TypeModule(writer, sym);
        tm.generateCode();
    }
}

