/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ior;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.ior.IORHeader;
import gov.llnl.babel.backend.ior.IORSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateIOR
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            Symbol symbol;
            SymbolID id = (SymbolID)s.next();
            if (BabelConfiguration.isSIDLBaseClass(id) && !BabelConfiguration.getInstance().generateStdlib() || (symbol = SymbolTable.getInstance().lookupSymbol(id)) == null) continue;
            this.generateHeader(symbol);
            this.generateSource(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHeader(Symbol symbol) throws CodeGenerationException {
        int type = symbol.getSymbolType();
        SymbolID id = symbol.getSymbolID();
        PrintWriter pw = null;
        try {
            String f = IOR.getHeaderFile(id);
            pw = FileManager.getInstance().createFile(id, type, "IORHDRS", f);
            LanguageWriterForC writer = new LanguageWriterForC(pw);
            IORHeader.generateCode(symbol, writer);
            Object var8_7 = null;
            if (pw != null) {
                pw.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (pw != null) {
                pw.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSource(Symbol symbol) throws CodeGenerationException {
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        if (type == 13 || type == 12 || type == 11) {
            PrintWriter pw = null;
            try {
                String f = IOR.getSourceFile(id);
                pw = FileManager.getInstance().createFile(id, type, "IORSRCS", f);
                LanguageWriterForC writer = new LanguageWriterForC(pw);
                IORSource.generateCode(symbol, writer);
                Object var8_7 = null;
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (pw != null) {
                    pw.close();
                }
                throw throwable;
            }
        }
    }

    public String getType() {
        return "ior";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("ior");
        return result;
    }
}

