/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.jdk.JavaImplSource;
import gov.llnl.babel.backend.jdk.ServerJNI;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateServerJava
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
            if (symbol == null) continue;
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.generateJava((Extendable)symbol);
                    this.generateJNI(symbol);
                    break;
                }
            }
        }
    }

    private void generateJava(Extendable extendable) throws CodeGenerationException {
        int type = extendable.getSymbolType();
        SymbolID id = extendable.getSymbolID();
        if (type != 14) {
            JavaImplSource.generateCode(extendable);
        }
    }

    private void generateJNI(Symbol symbol) throws CodeGenerationException {
        int type = symbol.getSymbolType();
        SymbolID id = symbol.getSymbolID();
        if (symbol instanceof Extendable) {
            ServerJNI.generateCode((Extendable)symbol);
        }
    }

    public String getType() {
        return "skel";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("java");
        return result;
    }
}

