/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.writers.LanguageWriter;
import java.io.PrintWriter;

public class LanguageWriterForFortran
extends LanguageWriter
implements CodeConstants {
    public LanguageWriterForFortran(PrintWriter writer) {
        super(writer);
        if (BabelConfiguration.getInstance().getTargetLanguage().equals("f90")) {
            this.enableLineBreak(78, null, " &");
            this.defineBlockComment("", "! ");
        } else {
            this.setFirstTabStop(8);
            this.setTabSpacing(3);
            this.enableLineBreak(72, "     &", null);
            this.defineBlockComment("C", null);
        }
    }

    public void beginBlockComment(boolean is_doc) {
        this.enableBlockComment();
        this.println();
    }

    public void endBlockComment(boolean is_doc) {
        this.println();
        this.disableBlockComment();
        this.println();
    }

    public void writeCommentLine(String comment) {
        if (comment != null) {
            this.enableBlockComment();
            this.println(comment);
            this.disableBlockComment();
        }
    }
}

